/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.apps.transfer.DataField;
import org.aspcfs.apps.transfer.DataRecord;

public class ObjectUtils {
    public static boolean setParam(Object target, String param, Object value) {
        try {
            if (value != null) {
                param = param.substring(0, 1).toUpperCase() + param.substring(1);
                Class[] argTypes = new Class[]{value.getClass()};
                Method method = target.getClass().getMethod("set" + param, argTypes);
                method.invoke(target, value);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean setParam(Object target, String param, double value) {
        try {
            param = param.substring(0, 1).toUpperCase() + param.substring(1);
            Class[] argTypes = new Class[]{Double.TYPE};
            Method method = target.getClass().getMethod("set" + param, argTypes);
            method.invoke(target, new Double(value));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean setParam(Object target, String param, boolean value) {
        try {
            param = param.substring(0, 1).toUpperCase() + param.substring(1);
            Class[] argTypes = new Class[]{Boolean.TYPE};
            Method method = target.getClass().getMethod("set" + param, argTypes);
            method.invoke(target, new Boolean(value));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getParam(Object target, String param) {
        try {
            int dotPos = param.indexOf(".");
            if (dotPos < 1) {
                dotPos = param.indexOf("_");
            }
            if (dotPos > 0) {
                Object innerObject = ObjectUtils.getObject(target, param.substring(0, dotPos));
                return ObjectUtils.getParam(innerObject, param.substring(dotPos + 1));
            }
            param = param.substring(0, 1).toUpperCase() + param.substring(1);
            Object result = null;
            if (param.indexOf("(") > -1) {
                if (param.indexOf("\"") > -1) {
                    String value = param.substring(param.indexOf("\"") + 1, param.lastIndexOf("\""));
                    Class[] argTypes = new Class[]{String.class};
                    Method method = target.getClass().getMethod("get" + param, argTypes);
                    result = method.invoke(target, value);
                } else {
                    String value = param.substring(param.indexOf("(") + 1, param.indexOf(")"));
                    Class[] argTypes = new Class[]{Integer.TYPE};
                    Method method = target.getClass().getMethod("get" + param, argTypes);
                    result = method.invoke(target, value);
                }
            } else {
                Method method = target.getClass().getMethod("get" + param, null);
                result = method.invoke(target, (Object[])null);
            }
            if (result == null) {
                return null;
            }
            if (result instanceof String) {
                return (String)result;
            }
            return String.valueOf(result);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean invokeMethod(Object target, String thisMethod, Object value) {
        try {
            if (value != null) {
                Class[] argTypes = new Class[]{value.getClass()};
                Method method = target.getClass().getMethod(thisMethod, argTypes);
                method.invoke(target, value);
            }
        }
        catch (Exception e) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ObjectUtils-> invokeMethod Exception");
            }
            return false;
        }
        return true;
    }

    public static Object getObject(Object target, String param) {
        try {
            param = param.substring(0, 1).toUpperCase() + param.substring(1);
            Method method = target.getClass().getMethod("get" + param, null);
            Object result = method.invoke(target, (Object[])null);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object constructObject(Class theClass) {
        try {
            Class<?>[] paramClass = null;
            Constructor constructor = theClass.getConstructor(paramClass);
            Object[] paramObject = null;
            return constructor.newInstance(paramObject);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object constructObject(Class theClass, Object parameter, Connection db) {
        try {
            Class[] paramClass = new Class[]{parameter.getClass(), Class.forName("java.sql.Connection")};
            Constructor constructor = theClass.getConstructor(paramClass);
            Object[] paramObject = new Object[]{parameter, db};
            return constructor.newInstance(paramObject);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object constructObject(Class theClass, Connection db, int objectId) {
        try {
            Class[] paramClass = new Class[]{Class.forName("java.sql.Connection"), Integer.TYPE};
            Constructor constructor = theClass.getConstructor(paramClass);
            Object[] paramObject = new Object[]{db, new Integer(objectId)};
            return constructor.newInstance(paramObject);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object constructObject(Class theClass, Connection db, int objectId, String tableName) {
        try {
            Class[] paramClass = new Class[]{Class.forName("java.sql.Connection"), Integer.TYPE, Class.forName("java.lang.String")};
            Constructor constructor = theClass.getConstructor(paramClass);
            Object[] paramObject = new Object[]{db, new Integer(objectId), tableName};
            return constructor.newInstance(paramObject);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object constructObject(Class theClass, Connection db, int objectId, String tableName, String uniqueField) {
        try {
            Class[] paramClass = new Class[]{Class.forName("java.sql.Connection"), Integer.TYPE, Class.forName("java.lang.String"), Class.forName("java.lang.String")};
            Constructor constructor = theClass.getConstructor(paramClass);
            Object[] paramObject = new Object[]{db, new Integer(objectId), tableName, uniqueField};
            return constructor.newInstance(paramObject);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] toByteArray(Object object) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
        objOut.writeObject(object);
        objOut.flush();
        byte[] tmpArray = byteOut.toByteArray();
        objOut.close();
        return tmpArray;
    }

    public static Object toObject(byte[] byteArray) throws Exception {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteArray);
        ObjectInputStream objIn = new ObjectInputStream(byteIn);
        Object tmpObj = objIn.readObject();
        objIn.close();
        return tmpObj;
    }

    public static HashMap populateObject(Object target, DataRecord record) {
        if (target != null && record != null) {
            HashMap<String, String> ignoredProperties = new HashMap<String, String>();
            for (DataField field : record) {
                String displayParam;
                String param = field.getName();
                String value = field.getValue();
                if (field.hasAlias()) {
                    param = field.getAlias();
                }
                if (ObjectUtils.setParam(target, param, value)) {
                    String lookup;
                    if (System.getProperty("DEBUG") != null) {
                        displayParam = param.substring(0, 1).toUpperCase() + param.substring(1);
                        System.out.println("ObjectUtils-> set" + displayParam + "(" + value + ")");
                    }
                    if ((lookup = field.getValueLookup()) != null) {
                        ignoredProperties.put(param + "^" + lookup + "Guid", value);
                        continue;
                    }
                    if (value == null || value.indexOf("$C{") <= -1) continue;
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ObjectUtils-> set" + param + "(" + value + ") **CONTEXT");
                    }
                    ignoredProperties.put(param, value);
                    continue;
                }
                if (System.getProperty("DEBUG") != null) {
                    displayParam = param.substring(0, 1).toUpperCase() + param.substring(1);
                    System.out.println("ObjectUtils-> set" + displayParam + "(" + value + ") **IGNORED");
                }
                ignoredProperties.put(param, value);
            }
            return ignoredProperties;
        }
        return null;
    }
}

