/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class PasswordHash {
    private static Random random = new Random();

    public static String encrypt(String inString) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] output = md.digest(inString.getBytes());
            StringBuffer sb = new StringBuffer(2 * output.length);
            for (int i = 0; i < output.length; ++i) {
                int k = output[i] & 0xFF;
                if (k < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(k));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static void main(String[] args) {
        PasswordHash hasher = new PasswordHash();
        try {
            if (args.length == 0) {
                System.out.print("Password: ");
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                String text = in.readLine();
                System.out.println("Hash: " + PasswordHash.encrypt(text));
            } else {
                String text = args[0];
                System.out.println(PasswordHash.encrypt(text));
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public static String getRandomString(int lo, int hi) {
        int n = PasswordHash.rand(lo, hi);
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)PasswordHash.rand(97, 122);
        }
        return new String(b);
    }

    public static int rand(int lo, int hi) {
        int n = hi - lo + 1;
        int i = random.nextInt() % n;
        if (i < 0) {
            i = -i;
        }
        return lo + i;
    }
}

