/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.aspcfs.utils.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PrivateString {
    private Key key = null;

    public PrivateString() {
    }

    public PrivateString(String file) {
        this.key = PrivateString.generateEncodedKeyFile(file);
    }

    public void setKey(Key tmp) {
        this.key = tmp;
    }

    public void setKeyFromHexEncoding(String hex) throws Exception {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        DESKeySpec keySpec = new DESKeySpec(Hex.decodeHex((char[])hex.toCharArray()));
        this.key = keyFactory.generateSecret(keySpec);
    }

    public Key getKey() {
        return this.key;
    }

    public String getKeyAsHexEncoding() {
        return new String(Hex.encodeHex((byte[])this.key.getEncoded()));
    }

    public static synchronized Key generateEncodedKeyFile(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                KeyGenerator generator = KeyGenerator.getInstance("DES");
                generator.init(56, new SecureRandom());
                SecretKey key = generator.generateKey();
                String hex = new String(Hex.encodeHex((byte[])key.getEncoded()));
                StringUtils.saveText(filename, hex);
            }
            return PrivateString.loadEncodedKey(filename);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public static Key loadEncodedKey(String keyFilename) throws IOException {
        File file = new File(keyFilename);
        return PrivateString.loadEncodedKey(file);
    }

    public static Key loadEncodedKey(File keyFilename) throws IOException {
        String hex = StringUtils.loadText(keyFilename);
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            DESKeySpec keySpec = new DESKeySpec(Hex.decodeHex((char[])hex.toCharArray()));
            return keyFactory.generateSecret(keySpec);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static Key loadSerializedKey(String keyFilename) throws IOException {
        File file = new File(keyFilename);
        return PrivateString.loadSerializedKey(file);
    }

    public static Key loadSerializedKey(File keyFile) throws IOException {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(keyFile));
            Key key = (Key)in.readObject();
            in.close();
            return key;
        }
        catch (Exception e) {
            System.out.println("PrivateString-> Error loading key at: " + keyFile);
            throw new IOException(e.getMessage());
        }
    }

    public static String encrypt(Key key, String inString) {
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(1, key);
            byte[] inputBytes = inString.getBytes("UTF8");
            byte[] outputBytes = cipher.doFinal(inputBytes);
            return new String(Base64.encodeBase64((byte[])outputBytes, (boolean)true));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decrypt(Key key, String inString) {
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(2, key);
            byte[] inputBytes = Base64.decodeBase64((byte[])inString.getBytes("UTF8"));
            byte[] outputBytes = cipher.doFinal(inputBytes);
            return new String(outputBytes, "UTF8");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
    }

    public static String encryptAsymmetric(String keyFilename, String inString) throws IOException {
        Key key = PrivateString.loadSerializedKey(keyFilename);
        return PrivateString.encryptAsymmetric(key, inString);
    }

    public static String encryptAsymmetric(File keyFile, String inString) throws IOException {
        Key key = PrivateString.loadSerializedKey(keyFile);
        return PrivateString.encryptAsymmetric(key, inString);
    }

    public static String encryptAsymmetric(Key publicKey, String inString) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("RSA/None/OAEPPadding", "BC");
            cipher.init(1, publicKey);
            byte[] inputBytes = inString.getBytes("UTF8");
            byte[] outputBytes = cipher.doFinal(inputBytes);
            return new String(Base64.encodeBase64((byte[])outputBytes, (boolean)true));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decryptAsymmetric(String keyFilename, String inString) throws IOException {
        Key key = PrivateString.loadSerializedKey(keyFilename);
        return PrivateString.decryptAsymmetric(key, inString);
    }

    public static String decryptAsymmetric(Key privateKey, String inString) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("RSA/None/OAEPPadding", "BC");
            cipher.init(2, privateKey);
            byte[] inputBytes = Base64.decodeBase64((byte[])inString.getBytes("UTF8"));
            byte[] outputBytes = cipher.doFinal(inputBytes);
            return new String(outputBytes, "UTF8");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                System.out.println("[encrypt or decrypt] [key] [string]");
            } else {
                String method = args[0];
                String keyFile = args[1];
                String text = args[2];
                File thisFile = new File(keyFile);
                Key key = null;
                key = !thisFile.exists() ? PrivateString.generateEncodedKeyFile(keyFile) : PrivateString.loadEncodedKey(keyFile);
                if ("encrypt".equals(method)) {
                    System.out.println(PrivateString.encrypt(key, text));
                } else {
                    System.out.println(PrivateString.decrypt(key, text));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }
}

