/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.aspcfs.utils.ByteArrayDataSource;
import org.aspcfs.utils.HTMLUtils;

public class SMTPMessage {
    private String host = "";
    private String from = "";
    private ArrayList to = new ArrayList();
    private ArrayList cc = new ArrayList();
    private ArrayList bcc = new ArrayList();
    private String subject = "";
    private String body = "";
    private String type = "text";
    private String errorMsg = "";
    private HashMap replyTo = new HashMap();
    private FileItemList attachments = null;
    private ArrayList byteArrayAttachments = null;
    private HashMap images = new HashMap();

    public void setHost(String tmp) {
        this.host = tmp;
    }

    public void setFrom(String tmp) {
        this.from = tmp;
    }

    public void setTo(String tmp) {
        this.to.clear();
        if (tmp.indexOf(",") > -1) {
            this.addMultiple(this.to, tmp);
        } else {
            this.addTo(tmp);
        }
    }

    public void setCc(String tmp) {
        this.cc.clear();
        if (tmp.indexOf(",") > -1) {
            this.addMultiple(this.cc, tmp);
        } else {
            this.addCc(tmp);
        }
    }

    public void setBcc(String tmp) {
        this.bcc.clear();
        if (tmp.indexOf(",") > -1) {
            this.addMultiple(this.bcc, tmp);
        } else {
            this.addBcc(tmp);
        }
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setBody(String tmp) {
        this.body = tmp;
    }

    public HashMap getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(HashMap replyTo) {
        this.replyTo = replyTo;
    }

    public void setAttachments(FileItemList tmp) {
        this.attachments = tmp;
    }

    public void setType(String tmp) {
        this.type = tmp;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void addTo(String tmp) {
        this.to.add(tmp);
    }

    public void addReplyTo(String address) {
        this.replyTo.put(address, "");
    }

    public void addReplyTo(String address, String personal) {
        this.replyTo.put(address, personal);
    }

    public void addCc(String tmp) {
        this.cc.add(tmp);
    }

    public void addBcc(String tmp) {
        this.bcc.add(tmp);
    }

    public void addFileAttachment(FileItem tmp) {
        if (this.attachments == null) {
            this.attachments = new FileItemList();
        }
        this.attachments.add((Object)tmp);
    }

    public void addFileAttachment(String fullFilePath, String clientFileName) {
        if (this.attachments == null) {
            this.attachments = new FileItemList();
        }
        FileItem fileItem = new FileItem();
        fileItem.setFilename(fullFilePath);
        fileItem.setClientFilename(clientFileName);
        this.attachments.add((Object)fileItem);
    }

    public void addByteArrayAttachment(String fileName, String data, String mimeType) {
        ByteArrayDataSource attachment = new ByteArrayDataSource(fileName, data, mimeType);
        if (this.byteArrayAttachments == null) {
            this.byteArrayAttachments = new ArrayList();
        }
        this.byteArrayAttachments.add(attachment);
    }

    public void addByteArrayAttachment(String fileName, byte[] data, String mimeType) {
        ByteArrayDataSource attachment = new ByteArrayDataSource(fileName, data, mimeType);
        if (this.byteArrayAttachments == null) {
            this.byteArrayAttachments = new ArrayList();
        }
        this.byteArrayAttachments.add(attachment);
    }

    public void addImage(String contentId, String urlImageLocation) {
        this.images.put(contentId, urlImageLocation);
    }

    public int send() {
        if (this.host == null || this.host.equals("")) {
            this.errorMsg = "Host not specified";
        }
        if (this.from == null || this.from.equals("")) {
            this.errorMsg = "Reply to address not specified";
        }
        if (this.to.size() == 0) {
            this.errorMsg = "Recipients not specified";
        }
        if (this.errorMsg != null && !this.errorMsg.equals("")) {
            return 1;
        }
        Properties props = System.getProperties();
        if (!this.host.equals("")) {
            props.put("mail.smtp.host", this.host);
        }
        Session session = Session.getInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(session);
        try {
            int i;
            message.setSentDate(Calendar.getInstance().getTime());
            message.setFrom((Address)new InternetAddress(this.from));
            if (this.replyTo.size() > 0) {
                InternetAddress[] tempReply = new InternetAddress[this.replyTo.size()];
                Iterator i2 = this.replyTo.keySet().iterator();
                int count = 0;
                while (i2.hasNext()) {
                    String address = (String)i2.next();
                    String personal = (String)this.replyTo.get(address);
                    tempReply[count] = personal != null && !"".equals(personal) ? new InternetAddress(address, personal) : new InternetAddress(address);
                    ++count;
                }
                message.setReplyTo((Address[])tempReply);
            }
            for (i = 0; i < this.to.size(); ++i) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress((String)this.to.get(i)));
            }
            for (i = 0; i < this.cc.size(); ++i) {
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress((String)this.cc.get(i)));
            }
            for (i = 0; i < this.bcc.size(); ++i) {
                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress((String)this.bcc.get(i)));
            }
            message.setSubject(this.subject);
            if ("text".equals(this.type) || "text/plain".equals(this.type)) {
                if (this.attachments != null || this.byteArrayAttachments != null) {
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setText(this.body);
                    MimeMultipart multipart = new MimeMultipart();
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                    this.addFileAttachments(multipart);
                    this.addByteArrayFileAttachments(multipart);
                    message.setContent((Multipart)multipart);
                } else {
                    message.setText(this.body);
                }
            } else if (!"text/html".equals(this.type)) {
                message.setContent((Object)this.body, this.type);
            } else {
                MimeMultipart mpRoot = new MimeMultipart("mixed");
                MimeBodyPart contentPartRoot = new MimeBodyPart();
                MimeMultipart mpContent = new MimeMultipart("alternative");
                contentPartRoot.setContent((Multipart)mpContent);
                mpRoot.addBodyPart((BodyPart)contentPartRoot);
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setText(HTMLUtils.htmlToText(this.body));
                textPart.setContent((Object)HTMLUtils.htmlToText(this.body), "text/plain");
                mpContent.addBodyPart((BodyPart)textPart);
                MimeMultipart multipart = new MimeMultipart("related");
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Object)this.body, "text/html");
                multipart.addBodyPart((BodyPart)messageBodyPart);
                if (this.images.size() > 0) {
                    for (String contentId : this.images.keySet()) {
                        String urlImageLocation = (String)this.images.get(contentId);
                        MimeBodyPart embeddedBodyPart = new MimeBodyPart();
                        URLDataSource fds = new URLDataSource(new URL(urlImageLocation));
                        embeddedBodyPart.setDataHandler(new DataHandler((DataSource)fds));
                        embeddedBodyPart.setHeader("Content-ID", "<" + contentId + ">");
                        multipart.addBodyPart((BodyPart)embeddedBodyPart);
                    }
                }
                MimeBodyPart mbp = new MimeBodyPart();
                mbp.setContent((Multipart)multipart);
                mpContent.addBodyPart((BodyPart)mbp);
                this.addFileAttachments(mpRoot);
                this.addByteArrayFileAttachments(mpRoot);
                message.setContent((Multipart)mpRoot);
            }
            Transport.send((Message)message);
            return 0;
        }
        catch (MessagingException me) {
            this.errorMsg = me.toString();
            return 2;
        }
        catch (MalformedURLException mu) {
            this.errorMsg = mu.toString();
            return 2;
        }
        catch (UnsupportedEncodingException ue) {
            this.errorMsg = ue.toString();
            return 2;
        }
    }

    private void addFileAttachments(MimeMultipart root) throws MessagingException {
        if (this.attachments != null) {
            for (FileItem fileItem : this.attachments) {
                MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(fileItem.getFullFilePath());
                attachmentBodyPart.setDisposition("attachment");
                attachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
                attachmentBodyPart.setFileName(fileItem.getClientFilename());
                root.addBodyPart((BodyPart)attachmentBodyPart);
            }
        }
    }

    private void addByteArrayFileAttachments(MimeMultipart root) throws MessagingException {
        if (this.byteArrayAttachments != null) {
            for (DataSource attachment : this.byteArrayAttachments) {
                MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                attachmentBodyPart.setDisposition("attachment");
                attachmentBodyPart.setDataHandler(new DataHandler(attachment));
                attachmentBodyPart.setFileName(attachment.getName());
                root.addBodyPart((BodyPart)attachmentBodyPart);
            }
        }
    }

    private void addMultiple(ArrayList list, String emails) {
        StringTokenizer st = new StringTokenizer(emails, ",");
        while (st.hasMoreTokens()) {
            String email = st.nextToken();
            list.add(email.trim());
        }
    }
}

