/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLMessage {
    private String url = null;
    private int port = -1;
    private String message = null;
    private String keystoreAlias = "aspcfs";
    private String keystoreLocation = null;
    private String keystorePassword = null;
    private StringBuffer response = null;

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setPort(int tmp) {
        this.port = tmp;
    }

    public void setKeystoreAlias(String tmp) {
        this.keystoreAlias = tmp;
    }

    public void setKeystoreLocation(String tmp) {
        this.keystoreLocation = tmp;
    }

    public void setKeystorePassword(String tmp) {
        this.keystorePassword = tmp;
    }

    public void setMessage(String tmp) {
        this.message = tmp;
    }

    public String getKeystoreLocation() {
        return this.keystoreLocation;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getResponse() {
        return this.response.toString();
    }

    public int send() throws Exception {
        if (this.url == null || this.port < 0 || this.message == null) {
            return 1;
        }
        Socket socket = null;
        try {
            String inputLine;
            SSLSocketFactory factory;
            if (this.keystoreLocation != null && this.keystorePassword != null) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("SSLMessage-> Keystore: " + this.keystoreLocation + ":" + this.keystorePassword);
                }
                char[] passphrase = this.keystorePassword.toCharArray();
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(new FileInputStream(this.keystoreLocation), passphrase);
                if (!keyStore.containsAlias(this.keystoreAlias)) {
                    System.out.println("Cannot locate identity: local private key not found.");
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(keyStore, passphrase);
                KeyManager[] arKeyManager = keyManagerFactory.getKeyManagers();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init(keyStore);
                TrustManager[] arTrustManager = trustManagerFactory.getTrustManagers();
                SSLContext sslContext = SSLContext.getInstance("SSL");
                SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                sslContext.init(arKeyManager, arTrustManager, secureRandom);
                factory = sslContext.getSocketFactory();
            } else {
                factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("SSLMessage-> Opening SSLSocket");
            }
            socket = (SSLSocket)factory.createSocket(this.url, this.port);
            socket.setSoTimeout(30000);
            ((SSLSocket)socket).startHandshake();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("SSLMessage-> Sending Data");
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())));
            out.println(this.message);
            out.println();
            out.flush();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("SSLMessage-> Receiving Data");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                this.appendResponseLine(inputLine);
            }
            socket.close();
            return 0;
        }
        catch (SocketTimeoutException toe) {
            if (socket != null) {
                socket.close();
            }
            return 0;
        }
        catch (IOException io) {
            io.printStackTrace(System.out);
            return 1;
        }
    }

    private void appendResponseLine(String in) {
        if (this.response == null) {
            this.response = new StringBuffer();
        }
        this.response.append(in + System.getProperty("line.separator"));
    }
}

