/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import com.darkhorseventures.framework.actions.ActionContext;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SVGOMTSpanElement;
import org.apache.batik.dom.svg.SVGOMTextElement;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.DynamicRenderer;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.aspcfs.utils.DateUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGMatrix;

public class SVGUtils {
    private static final String ADOBE_ENCODING = "adobe_illustrator_pgf";
    private static final String POINT_TEXT = "pointText";
    private static final String AREA_TEXT = "areaText";
    private static final String ls = System.getProperty("line.separator", "\n");
    private static final String fs = System.getProperty("file.separator");
    private DynamicRenderer renderer = null;
    private UserAgent userAgent = null;
    private DocumentLoader loader = null;
    private BridgeContext ctx = null;
    private Document svgDoc = null;
    private GVTBuilder builder = null;
    private GraphicsNode gvtRoot = null;
    private SVGElement textElement = null;
    private Vector textItems = null;
    private NodeList textElements = null;
    private SVGElement textLayer = null;

    public void setTextElements(NodeList tmp) {
        this.textElements = tmp;
    }

    public void setTextLayer(SVGElement tmp) {
        this.textLayer = tmp;
    }

    public NodeList getTextElements() {
        return this.textElements;
    }

    public SVGElement getTextLayer() {
        return this.textLayer;
    }

    public void setTextItems(Vector tmp) {
        this.textItems = tmp;
    }

    public Vector getTextItems() {
        return this.textItems;
    }

    public void setRenderer(DynamicRenderer tmp) {
        this.renderer = tmp;
    }

    public void setUserAgent(UserAgent tmp) {
        this.userAgent = tmp;
    }

    public void setLoader(DocumentLoader tmp) {
        this.loader = tmp;
    }

    public void setCtx(BridgeContext tmp) {
        this.ctx = tmp;
    }

    public void setSvgDoc(Document tmp) {
        this.svgDoc = tmp;
    }

    public void setBuilder(GVTBuilder tmp) {
        this.builder = tmp;
    }

    public void setGvtRoot(GraphicsNode tmp) {
        this.gvtRoot = tmp;
    }

    public void setTextElement(SVGElement tmp) {
        this.textElement = tmp;
    }

    public DynamicRenderer getRenderer() {
        return this.renderer;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public DocumentLoader getLoader() {
        return this.loader;
    }

    public BridgeContext getCtx() {
        return this.ctx;
    }

    public Document getSvgDoc() {
        return this.svgDoc;
    }

    public GVTBuilder getBuilder() {
        return this.builder;
    }

    public GraphicsNode getGvtRoot() {
        return this.gvtRoot;
    }

    public SVGElement getTextElement() {
        return this.textElement;
    }

    public SVGUtils() {
    }

    public SVGUtils(String svgFileName) throws Exception {
        this.buildSVGDOM(svgFileName);
        this.textItems = new Vector();
    }

    public void buildSVGDOM(String svgFileName) throws Exception {
        try {
            this.renderer = new DynamicRenderer();
            this.userAgent = new UserAgentAdapter();
            this.loader = new DocumentLoader(this.userAgent);
            this.ctx = new BridgeContext(this.userAgent, this.loader);
            this.builder = new GVTBuilder();
            this.ctx.setDynamic(true);
            this.svgDoc = this.loader.loadDocument(svgFileName);
            this.gvtRoot = this.builder.build(this.ctx, this.svgDoc);
            this.renderer.setTree(this.gvtRoot);
            this.textElements = this.svgDoc.getElementsByTagNameNS("http://www.w3.org/2000/svg", "text");
            if (this.textElements.getLength() > 0) {
                this.textElement = (SVGElement)this.textElements.item(0);
            }
            this.textLayer = (SVGElement)this.svgDoc.getElementById("TEXT");
            if (this.textLayer == null) {
                this.textLayer = (SVGElement)this.svgDoc.getElementById("text");
            }
            if (this.textLayer != null) {
                this.textElements = this.textLayer.getElementsByTagNameNS("http://www.w3.org/2000/svg", "text");
            }
        }
        catch (Exception e) {
            System.err.println("EXCEPTION: SVGTextHandler-> " + e.getMessage());
        }
    }

    public boolean processSvgFile(File svgFile) throws Exception {
        boolean saveFile = false;
        Vector<Element> textElementsWithNoTspans = new Vector<Element>();
        if (this.removeBlankTextElements()) {
            saveFile = true;
        }
        for (int i = 0; i < this.textElements.getLength(); ++i) {
            Element textElement = (Element)this.textElements.item(i);
            if (this.isTextElementBroken(textElement)) {
                this.fixTextElementTspans(textElement);
                saveFile = true;
                continue;
            }
            NodeList tspans = textElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "tspan");
            if (tspans.getLength() != 0) continue;
            textElementsWithNoTspans.add(textElement);
            saveFile = true;
        }
        if (textElementsWithNoTspans.size() > 0) {
            this.fixTextElements(textElementsWithNoTspans);
        }
        if (saveFile) {
            this.saveAsSVG(svgFile, false);
        }
        return saveFile;
    }

    public boolean removeBlankTextElements() {
        boolean discardTextElement = false;
        this.textElements = this.textLayer.getElementsByTagNameNS("http://www.w3.org/2000/svg", "text");
        for (int i = 0; i < this.textElements.getLength(); ++i) {
            Element textElement = (Element)this.textElements.item(i);
            NodeList tspans = textElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "tspan");
            if (tspans.getLength() == 0) {
                NodeList textNodes = textElement.getChildNodes();
                boolean textExists = false;
                for (int j = 0; j < textNodes.getLength(); ++j) {
                    Node thisNode = textNodes.item(j);
                    if (thisNode.getNodeType() != 3 || "".equals(thisNode.getNodeValue().trim())) continue;
                    textExists = true;
                    break;
                }
                if (textExists) continue;
                discardTextElement = true;
                this.removeElement(textElement);
                continue;
            }
            for (int j = 0; j < tspans.getLength(); ++j) {
                Element tspan = (Element)tspans.item(j);
                if (!"".equals(this.getText(tspan).trim())) continue;
                discardTextElement = true;
                this.removeElement(tspan);
            }
        }
        this.textElements = this.textLayer.getElementsByTagNameNS("http://www.w3.org/2000/svg", "text");
        return discardTextElement;
    }

    public void removeElement(Element element) {
        Element parent = (Element)element.getParentNode();
        parent.removeChild(element);
    }

    protected void fixTextElements(Vector textElementsWithNoTspans) {
        for (int j = 0; j < textElementsWithNoTspans.size(); ++j) {
            int i;
            SVGOMTextElement textElement = (SVGOMTextElement)textElementsWithNoTspans.elementAt(j);
            Node text = textElement.getFirstChild();
            if (text == null) continue;
            Element tspan = this.svgDoc.createElementNS("SVGDOMImplementation.SVG_NAMESPACE_URI", "tspan");
            tspan.appendChild(textElement.removeChild(text));
            tspan.setAttribute("x", "0");
            tspan.setAttribute("y", "0");
            NamedNodeMap attrs = textElement.getAttributes();
            Vector<Attr> removeAttrs = new Vector<Attr>();
            for (i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                if ("transform".equals(attr.getName())) continue;
                tspan.setAttributeNode(attr);
                removeAttrs.add(attr);
            }
            for (i = 0; i < removeAttrs.size(); ++i) {
                textElement.removeAttributeNode((Attr)removeAttrs.elementAt(i));
            }
            textElement.appendChild((Node)tspan);
        }
        int index = 0;
        block3: while (index < textElementsWithNoTspans.size() - 1) {
            for (int i = index; i < textElementsWithNoTspans.size() - 1; ++i) {
                NamedNodeMap attrs2;
                SVGOMTextElement textElement2;
                SVGOMTextElement textElement1 = (SVGOMTextElement)textElementsWithNoTspans.elementAt(i);
                if (!this.determineYAttributeMatch(textElement1, textElement2 = (SVGOMTextElement)textElementsWithNoTspans.elementAt(i + 1))) continue;
                Element tspan1 = (Element)textElement1.getFirstChild();
                Element tspan2 = (Element)textElement2.getFirstChild();
                NamedNodeMap attrs1 = tspan1.getAttributes();
                if (this.attributesMatch(attrs1, attrs2 = tspan2.getAttributes())) {
                    this.mergeTspans(tspan1, tspan2);
                    textElement2.getParentNode().removeChild((Node)textElement2);
                    textElementsWithNoTspans.remove(textElement2);
                    index = i;
                    continue block3;
                }
                tspan2.removeAttribute("x");
                textElement1.appendChild((Node)tspan2);
                textElement2.getParentNode().removeChild((Node)textElement2);
                textElementsWithNoTspans.remove(textElement2);
                index = i + 1;
                continue block3;
            }
        }
    }

    protected float determineTextLength(SVGOMTextElement textElement) {
        float length = 0.0f;
        for (int i = 0; i < textElement.getNumberOfChars(); ++i) {
            length += textElement.getExtentOfChar(i).getWidth();
        }
        return length;
    }

    public void displayTextElements(Vector textElementsWithNoTspans) {
        for (int i = 0; i < textElementsWithNoTspans.size(); ++i) {
            SVGOMTextElement textElement = (SVGOMTextElement)textElementsWithNoTspans.elementAt(i);
            int size = textElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "tspan").getLength();
        }
    }

    protected boolean determineYAttributeMatch(SVGOMTextElement textElement1, SVGOMTextElement textElement2) {
        SVGOMTextElement locate1 = textElement1;
        SVGOMTextElement locate2 = textElement2;
        SVGMatrix matrix1 = locate1.getCTM();
        SVGMatrix matrix2 = locate2.getCTM();
        return String.valueOf(matrix1.getF()).equals(String.valueOf(matrix2.getF()));
    }

    protected boolean multipleTspansExist(Element textElement) {
        NodeList tspans = textElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "tspan");
        return tspans.getLength() > 1;
    }

    protected boolean isTextElementBroken(Element textElement) {
        return this.multipleTspansExist(textElement);
    }

    protected void fixTextElementTspans(Element textElement) {
        NodeList tspans = textElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "tspan");
        int index = 0;
        while (index < tspans.getLength() - 1) {
            NamedNodeMap attrs2;
            int i = index;
            if (i >= tspans.getLength() - 1) continue;
            Element tspan1 = (Element)tspans.item(i);
            Element tspan2 = (Element)tspans.item(i + 1);
            NamedNodeMap attrs1 = tspan1.getAttributes();
            if (this.attributesMatch(attrs1, attrs2 = tspan2.getAttributes())) {
                this.mergeTspans(tspan1, tspan2);
                tspans = textElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "tspan");
                index = i;
                continue;
            }
            index = i + 1;
        }
    }

    protected boolean attributesMatch(NamedNodeMap attrs1, NamedNodeMap attrs2) {
        if (attrs1.getLength() != attrs1.getLength()) {
            return false;
        }
        for (int i = 0; i < attrs1.getLength(); ++i) {
            Node attr = attrs1.item(i);
            String attrName = attr.getNodeName();
            String attrValue = attr.getNodeValue();
            if (attrName.toLowerCase().equals("x") || attrs2.getNamedItem(attrName) == null || attrValue.equals(attrs2.getNamedItem(attrName).getNodeValue())) continue;
            return false;
        }
        return true;
    }

    protected void mergeTspans(Element tspan1, Element tspan2) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getText(tspan1).trim() + " " + this.getText(tspan2).trim());
        this.setNodeText(tspan1, sb.toString());
        Element parent = (Element)tspan2.getParentNode();
        parent.removeChild(tspan2);
    }

    public String getText(Element element) {
        if (element == null) {
            return null;
        }
        NodeList childList = element.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node thisNode = childList.item(i);
            if (thisNode.getNodeType() != 3 && thisNode.getNodeType() != 4) continue;
            return thisNode.getNodeValue();
        }
        return null;
    }

    public void setText(String replace) {
        if (this.textElement != null) {
            NodeList textChildNodes = this.textElement.getChildNodes();
            for (int i = 0; i < textChildNodes.getLength(); ++i) {
                Node childNode = textChildNodes.item(i);
                if (!childNode.hasChildNodes()) continue;
                this.setNodeText(childNode, replace);
            }
        }
    }

    public void setNodeText(Node node, String replace) {
        if (node.hasChildNodes()) {
            NodeList textNodes = node.getChildNodes();
            for (int j = 0; j < textNodes.getLength(); ++j) {
                Node textNode = textNodes.item(j);
                if (textNode.getNodeType() != 3 && textNode.getNodeType() != 4) continue;
                textNode.setNodeValue(replace);
                break;
            }
        }
    }

    public void setAllTextElements(Vector replace) throws Exception {
        if (this.textLayer != null) {
            int index = 0;
            Vector textElems = this.sortTextItems();
            for (int i = 0; i < textElems.size(); ++i) {
                SVGOMTextElement textElement = (SVGOMTextElement)textElems.elementAt(i);
                String textType = this.determineTextType(textElement);
                if (textType.equals(POINT_TEXT)) {
                    float oldWidth = textElement.getComputedTextLength();
                    NodeList tspans = textElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "tspan");
                    for (int j = 0; j < tspans.getLength(); ++j) {
                        Node tspan = tspans.item(j);
                        if (j == 0) {
                            this.setNodeText(tspan, ((String)replace.elementAt(index)).trim());
                        } else {
                            this.setNodeText(tspan, " " + ((String)replace.elementAt(index)).trim());
                        }
                        ++index;
                    }
                    float newWidth = textElement.getComputedTextLength();
                    this.fixTspanPositions(textElement);
                    if (newWidth == oldWidth) continue;
                    this.fixTextAlignment(textElement, oldWidth, newWidth);
                    continue;
                }
                if (!textType.equals(AREA_TEXT)) continue;
                SVGMatrix matrix = textElement.getTransform().getBaseVal().consolidate().getMatrix();
                float width = this.determineTextWidth(textElement);
                float height = this.determineTextHeight(textElement);
                float incrY = this.determineLineSpacing(textElement);
                String str = (String)replace.elementAt(index);
                String textAlign = this.getTextAlignment(textElement);
                this.flowText(textElement, width, height, incrY, str, textAlign);
                ++index;
            }
        }
    }

    protected float determineTextWidth(SVGOMTextElement textElement) {
        float width = 0.0f;
        NodeList tspans = textElement.getChildNodes();
        for (int i = 0; i < tspans.getLength(); ++i) {
            SVGOMTSpanElement tspan = (SVGOMTSpanElement)tspans.item(i);
            if (!(tspan.getComputedTextLength() > width)) continue;
            width = tspan.getComputedTextLength();
        }
        return width;
    }

    protected float determineTextHeight(SVGOMTextElement textElement) {
        float height = 0.0f;
        NodeList tspans = textElement.getChildNodes();
        for (int i = 0; i < tspans.getLength(); ++i) {
            SVGOMTSpanElement tspan = (SVGOMTSpanElement)tspans.item(i);
            if (!tspan.hasAttribute("y")) continue;
            height = new Float(tspan.getAttribute("y")).floatValue();
        }
        return height;
    }

    protected float determineLineSpacing(SVGOMTextElement textElement) {
        float spacing = 0.0f;
        NodeList tspans = textElement.getChildNodes();
        for (int i = 0; i < tspans.getLength(); ++i) {
            SVGOMTSpanElement tspan1 = (SVGOMTSpanElement)tspans.item(i);
            SVGOMTSpanElement tspan2 = (SVGOMTSpanElement)tspans.item(i + 1);
            if (!tspan1.hasAttribute("y") || !tspan2.hasAttribute("y")) continue;
            float y1 = new Float(tspan1.getAttribute("y")).floatValue();
            float y2 = new Float(tspan2.getAttribute("y")).floatValue();
            spacing = y2 - y1;
            break;
        }
        return spacing;
    }

    protected void flowText(SVGOMTextElement textElement, float width, float height, float incrY, String replace, String textAlign) {
        boolean cursorX = false;
        int cursorY = 0;
        float anchorWidth = width;
        if ("center".equals(textAlign)) {
            SVGOMTSpanElement t = (SVGOMTSpanElement)textElement.getFirstChild();
            anchorWidth = t.getComputedTextLength();
        }
        SVGOMTSpanElement oldtspan = (SVGOMTSpanElement)textElement.getFirstChild();
        while (textElement.hasChildNodes()) {
            textElement.removeChild(textElement.getFirstChild());
        }
        int item = 0;
        String[] tokens = replace.split("\\s");
        while ((float)cursorY <= height && item < tokens.length) {
            SVGOMTSpanElement newtspan = (SVGOMTSpanElement)oldtspan.cloneNode(true);
            textElement.appendChild((Node)newtspan);
            StringBuffer sb = new StringBuffer();
            block2: for (int i = item; i < tokens.length; ++i) {
                boolean splitToken = false;
                this.setNodeText((Node)newtspan, tokens[i]);
                if (newtspan.getComputedTextLength() > width) {
                    splitToken = true;
                }
                sb.append(tokens[i]);
                this.setNodeText((Node)newtspan, sb.toString());
                if (newtspan.getComputedTextLength() > width) {
                    sb = sb.delete(sb.length() - tokens[i].length(), sb.length());
                    this.setNodeText((Node)newtspan, sb.toString());
                    if (!splitToken) break;
                    StringBuffer sb2 = new StringBuffer();
                    for (int j = 0; j < tokens[i].length(); ++j) {
                        sb2.append(tokens[i].charAt(j));
                        this.setNodeText((Node)newtspan, sb.toString() + sb2.toString());
                        if (!(newtspan.getComputedTextLength() > width)) continue;
                        sb2 = sb2.delete(sb2.length() - 1, sb2.length());
                        this.setNodeText((Node)newtspan, sb.toString() + sb2.toString());
                        tokens[i] = tokens[i].substring(sb2.length());
                        splitToken = false;
                        break block2;
                    }
                    break;
                }
                if (i < tokens.length - 1) {
                    this.setNodeText((Node)newtspan, sb.append(" ").toString());
                }
                item = i + 1;
            }
            this.fixTextAlignment(newtspan, anchorWidth, textAlign);
            newtspan.setAttribute("y", String.valueOf(cursorY));
            cursorY = (int)((float)cursorY + incrY);
        }
    }

    protected String determineTextType(SVGOMTextElement textElement) {
        NodeList tspans = textElement.getChildNodes();
        if (tspans.getLength() > 1) {
            for (int i = 0; i < tspans.getLength() - 1; ++i) {
                Element tspan1 = (Element)tspans.item(i);
                Element tspan2 = (Element)tspans.item(i + 1);
                if (!tspan1.hasAttribute("y") || !tspan2.hasAttribute("y") || tspan1.getAttribute("y").equals(tspan2.getAttribute("y"))) continue;
                return AREA_TEXT;
            }
        }
        return POINT_TEXT;
    }

    public float determineWidth(SVGOMTextElement textElement) {
        float width = 0.0f;
        for (int i = 0; i < textElement.getNumberOfChars(); ++i) {
            width += textElement.getExtentOfChar(i).getWidth();
        }
        return width;
    }

    public void fixTspanPositions(SVGOMTextElement textElement) {
        if (this.isTextElementBroken((Element)textElement)) {
            NodeList tspans = textElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "tspan");
            for (int j = 0; j < tspans.getLength(); ++j) {
                SVGOMTSpanElement tspan = (SVGOMTSpanElement)tspans.item(j);
                tspan.removeAttribute("x");
            }
        }
    }

    public String getTextAlignment(SVGOMTextElement textElement) {
        String textAlign;
        block5: {
            textAlign = "left";
            Element switchElm = (Element)textElement.getParentNode();
            Element rootElm = this.svgDoc.getDocumentElement();
            boolean switchExists = false;
            while (!"switch".equals(switchElm.getNodeName()) || !switchElm.equals(rootElm)) {
                if (!"switch".equals((switchElm = (Element)switchElm.getParentNode()).getNodeName())) continue;
                switchExists = true;
                break;
            }
            if (!switchExists) break block5;
            NodeList list = switchElm.getElementsByTagName("flow");
            if (list.getLength() > 0) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Element flow = (Element)list.item(i);
                    if (!flow.hasAttribute("text-align")) continue;
                    textAlign = flow.getAttribute("text-align");
                    break;
                }
            } else {
                list = switchElm.getElementsByTagName("p");
                for (int i = 0; i < list.getLength(); ++i) {
                    Element p = (Element)list.item(i);
                    if (!p.hasAttribute("text-align")) continue;
                    textAlign = p.getAttribute("text-align");
                    break;
                }
            }
        }
        return textAlign;
    }

    public void fixTextAlignment(SVGOMTextElement textElement, float oldWidth, float newWidth) {
        String textAlign = this.getTextAlignment(textElement);
        if (!"left".equals(textAlign)) {
            Element tspan = (Element)textElement.getFirstChild();
            float anchor = 0.0f;
            if (tspan != null && !tspan.hasAttribute("text-anchor")) {
                if (textAlign.equals("center")) {
                    anchor = oldWidth / 2.0f;
                    tspan.setAttribute("text-anchor", "middle");
                } else if (textAlign.equals("right")) {
                    anchor = oldWidth;
                    tspan.setAttribute("text-anchor", "end");
                }
                tspan.setAttribute("x", String.valueOf(anchor));
            }
        }
    }

    public void fixTextAlignment(SVGOMTSpanElement tspanElement, float width, String textAlign) {
        if (!"left".equals(textAlign)) {
            float anchor = 0.0f;
            if (tspanElement != null && !tspanElement.hasAttribute("text-anchor")) {
                if (textAlign.equals("center")) {
                    anchor = width / 2.0f;
                    tspanElement.setAttribute("text-anchor", "middle");
                } else if (textAlign.equals("right")) {
                    anchor = width;
                    tspanElement.setAttribute("text-anchor", "end");
                }
                tspanElement.setAttribute("x", String.valueOf(anchor));
            }
        }
    }

    public Vector getTextValues() {
        if (this.textLayer != null) {
            Vector textElems = this.sortTextItems();
            for (int i = 0; i < textElems.size(); ++i) {
                SVGOMTextElement textElement = (SVGOMTextElement)textElems.elementAt(i);
                NodeList childNodes = textElement.getChildNodes();
                String textType = this.determineTextType(textElement);
                if (textType.equals(POINT_TEXT)) {
                    for (int j = 0; j < childNodes.getLength(); ++j) {
                        Node childNode = childNodes.item(j);
                        if (childNode.hasChildNodes()) {
                            NodeList textNodes = childNode.getChildNodes();
                            for (int k = 0; k < textNodes.getLength(); ++k) {
                                Node textNode = textNodes.item(k);
                                if (textNode.getNodeType() != 3) continue;
                                this.textItems.add("P" + textNode.getNodeValue());
                            }
                            continue;
                        }
                        if (childNode.getNodeType() != 3) continue;
                        this.textItems.add(childNode.getNodeValue());
                    }
                    continue;
                }
                if (!textType.equals(AREA_TEXT)) continue;
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node childNode = childNodes.item(j);
                    NodeList textNodes = childNode.getChildNodes();
                    for (int k = 0; k < textNodes.getLength(); ++k) {
                        Node textNode = textNodes.item(k);
                        if (textNode.getNodeType() != 3) continue;
                        sb.append(" " + textNode.getNodeValue().trim());
                    }
                }
                this.textItems.add("A" + sb.toString().trim());
            }
        }
        return this.textItems;
    }

    protected float determineX(SVGOMTextElement textElement) {
        SVGMatrix matrix = textElement.getTransform().getBaseVal().consolidate().getMatrix();
        return matrix.getE();
    }

    protected float determineY(SVGOMTextElement textElement) {
        SVGMatrix matrix = textElement.getTransform().getBaseVal().consolidate().getMatrix();
        return matrix.getF();
    }

    protected Vector sortTextItems() {
        int i;
        Vector<Node> textElems = new Vector<Node>();
        for (i = 0; i < this.textElements.getLength(); ++i) {
            textElems.add(this.textElements.item(i));
        }
        for (i = 0; i < textElems.size(); ++i) {
            for (int j = 0; j < textElems.size(); ++j) {
                SVGOMTextElement textElement1 = (SVGOMTextElement)textElems.elementAt(i);
                SVGOMTextElement textElement2 = (SVGOMTextElement)textElems.elementAt(j);
                if (!(this.determineY(textElement1) < this.determineY(textElement2))) continue;
                SVGOMTextElement tmp = (SVGOMTextElement)textElems.elementAt(i);
                textElems.setElementAt((Node)textElems.elementAt(j), i);
                textElems.setElementAt((Node)tmp, j);
            }
        }
        return textElems;
    }

    public void saveAsJPEG(File out) throws Exception {
        JPEGTranscoder t = new JPEGTranscoder();
        t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(1.0f));
        TranscoderInput input = new TranscoderInput(this.svgDoc);
        FileOutputStream ostream = new FileOutputStream(out);
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        t.transcode(input, output);
        ostream.flush();
        ((OutputStream)ostream).close();
    }

    public void saveAsJPEG(File originalFile, File thumbnailFile, float maxWidth, float maxHeight) throws Exception {
        BufferedImage originalImage = ImageIO.read(originalFile);
        float ratio = maxWidth;
        JPEGTranscoder t = new JPEGTranscoder();
        t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(1.0f));
        t.addTranscodingHint(JPEGTranscoder.KEY_WIDTH, (Object)new Float(ratio));
        TranscoderInput input = new TranscoderInput(this.svgDoc);
        FileOutputStream ostream = new FileOutputStream(thumbnailFile);
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        t.transcode(input, output);
        ostream.flush();
        ((OutputStream)ostream).close();
    }

    public void saveAsJPEG(ActionContext context) throws Exception {
        try {
            context.getResponse().setContentType("image/jpeg");
            JPEGTranscoder t = new JPEGTranscoder();
            t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(1.0f));
            TranscoderInput input = new TranscoderInput(this.svgDoc);
            ServletOutputStream ostream = context.getResponse().getOutputStream();
            TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
            t.transcode(input, output);
            ostream.flush();
            ostream.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static String getFilePath(String base, int id) {
        String path = base + DateUtils.getDatePath(new Date());
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        path = path + SVGUtils.getFileName(id);
        return path;
    }

    public static String getFileName(int id) {
        return DateUtils.getFilename() + "-" + id;
    }

    public void saveAsSVG(File svgFile, boolean removeEncoding) throws Exception {
        if (removeEncoding) {
            this.removeIllustratorEncoding();
            this.removeBlankTextElements();
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        FileOutputStream ostream = new FileOutputStream(svgFile);
        transformer.transform(new DOMSource(this.svgDoc), new StreamResult(ostream));
    }

    private void removeIllustratorEncoding() throws Exception {
        Element encodedInfo = this.svgDoc.getElementById(ADOBE_ENCODING);
        if (encodedInfo != null) {
            Element root = this.svgDoc.getDocumentElement();
            root.removeChild(encodedInfo);
        }
    }
}

