/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.PrivateString;
import org.aspcfs.utils.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SecurityKey {
    public static void generateKeyPair(String publicFilename, String privateFilename) throws NoSuchAlgorithmException, FileNotFoundException, IOException, NoSuchProviderException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGen.initialize(1024, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(publicFilename));
        out.writeObject(publicKey);
        out.close();
        out = new ObjectOutputStream(new FileOutputStream(privateFilename));
        out.writeObject(privateKey);
        out.close();
    }

    public static void encryptKey(String unencodedFilename, String encodedFilename, String password) throws NoSuchAlgorithmException, FileNotFoundException, InvalidKeySpecException, InvalidKeyException, Exception, IllegalBlockSizeException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
        int count = 20;
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
        PrivateKey key = (PrivateKey)PrivateString.loadSerializedKey(unencodedFilename);
        byte[] cleartext = ObjectUtils.toByteArray(key);
        byte[] ciphertext = pbeCipher.doFinal(cleartext);
        String base64 = new String(Base64.encodeBase64((byte[])ciphertext, (boolean)true));
        StringUtils.saveText(encodedFilename, base64);
    }

    public static String useEncodedKey(String encodedFilename, String password, String base64) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, IOException, Exception {
        if (encodedFilename == null || password == null || base64 == null) {
            return null;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
        int count = 20;
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
        String base64Text = StringUtils.loadText(encodedFilename);
        byte[] ciphertext = Base64.decodeBase64((byte[])base64Text.getBytes("UTF8"));
        byte[] cleartext = null;
        try {
            cleartext = pbeCipher.doFinal(ciphertext);
        }
        catch (Exception e) {
            throw new Exception("Incorrect password");
        }
        Key key = (Key)ObjectUtils.toObject(cleartext);
        return PrivateString.decryptAsymmetric(key, base64);
    }
}

