/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import java.util.Map;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.utils.DatabaseUtils;

public class SiteUtils {
    public static SiteList getSiteList(ApplicationPrefs prefs, ConnectionPool cp) {
        return SiteUtils.getSiteList(prefs.getPrefs(), cp);
    }

    public static SiteList getSiteList(ApplicationPrefs prefs, ConnectionPool cp, String vhost) {
        return SiteUtils.getSiteList(prefs.getPrefs(), cp, vhost);
    }

    public static SiteList getSiteList(Map config) {
        return SiteUtils.getSiteList(config, null);
    }

    public static SiteList getSiteList(Map config, ConnectionPool cp) {
        return SiteUtils.getSiteList(config, cp, (String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SiteList getSiteList(Map config, ConnectionPool cp, String vhost) {
        Connection dbSites = null;
        SiteList siteList = new SiteList();
        String appCode = (String)config.get("GATEKEEPER.APPCODE");
        String baseName = (String)config.get("GATEKEEPER.URL");
        String dbUser = (String)config.get("GATEKEEPER.USER");
        String dbPass = (String)config.get("GATEKEEPER.PASSWORD");
        String driver = (String)config.get("GATEKEEPER.DRIVER");
        try {
            if ("true".equals((String)config.get("WEBSERVER.ASPMODE"))) {
                if (cp != null) {
                    ConnectionElement ce = new ConnectionElement(baseName, dbUser, dbPass);
                    ce.setDriver(driver);
                    dbSites = cp.getConnection(ce);
                } else {
                    Class.forName(driver);
                    dbSites = DatabaseUtils.getConnection(baseName, dbUser, dbPass);
                }
                siteList.setSiteCode(appCode);
                siteList.setEnabled(1);
                siteList.setVirtualHost(vhost);
                siteList.buildList(dbSites);
                if (cp == null) {
                    dbSites.close();
                }
            } else {
                Site thisSite = new Site();
                thisSite.setDatabaseDriver((String)config.get("GATEKEEPER.DRIVER"));
                thisSite.setDatabaseUrl((String)config.get("GATEKEEPER.URL"));
                thisSite.setDatabaseName((String)config.get("GATEKEEPER.DATABASE"));
                thisSite.setDatabaseUsername((String)config.get("GATEKEEPER.USER"));
                thisSite.setDatabasePassword((String)config.get("GATEKEEPER.PASSWORD"));
                thisSite.setSiteCode((String)config.get("GATEKEEPER.APPCODE"));
                thisSite.setVirtualHost((String)config.get("WEBSERVER.URL"));
                thisSite.setLanguage((String)config.get("SYSTEM.LANGUAGE"));
                siteList.add(thisSite);
            }
            if (cp == null) return siteList;
        }
        catch (Exception e) {
            SiteList siteList2 = null;
            return siteList2;
        }
        finally {
            if (cp != null) {
                cp.free(dbSites);
            }
        }
        cp.free(dbSites);
        return siteList;
    }

    public static SiteList getSiteList(ApplicationPrefs prefs, ConnectionPool cp, ConnectionElement ce) {
        return SiteUtils.getSiteList(prefs.getPrefs(), cp, ce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SiteList getSiteList(Map config, ConnectionPool cp, ConnectionElement ceToCompare) {
        Connection dbSites = null;
        SiteList siteList = new SiteList();
        String appCode = (String)config.get("GATEKEEPER.APPCODE");
        String baseName = (String)config.get("GATEKEEPER.URL");
        String dbUser = (String)config.get("GATEKEEPER.USER");
        String dbPass = (String)config.get("GATEKEEPER.PASSWORD");
        String driver = (String)config.get("GATEKEEPER.DRIVER");
        try {
            if ("true".equals((String)config.get("WEBSERVER.ASPMODE"))) {
                if (cp != null) {
                    ConnectionElement ce = new ConnectionElement(baseName, dbUser, dbPass);
                    ce.setDriver(driver);
                    dbSites = cp.getConnection(ce);
                } else {
                    Class.forName(driver);
                    dbSites = DatabaseUtils.getConnection(baseName, dbUser, dbPass);
                }
                siteList.setSiteCode(appCode);
                siteList.setDbHost(ceToCompare.getUrl());
                siteList.setEnabled(1);
                siteList.buildList(dbSites);
                if (cp == null) {
                    dbSites.close();
                }
            } else {
                Site thisSite = new Site();
                thisSite.setDatabaseDriver((String)config.get("GATEKEEPER.DRIVER"));
                thisSite.setDatabaseUrl((String)config.get("GATEKEEPER.URL"));
                thisSite.setDatabaseName((String)config.get("GATEKEEPER.DATABASE"));
                thisSite.setDatabaseUsername((String)config.get("GATEKEEPER.USER"));
                thisSite.setDatabasePassword((String)config.get("GATEKEEPER.PASSWORD"));
                thisSite.setSiteCode((String)config.get("GATEKEEPER.APPCODE"));
                thisSite.setVirtualHost((String)config.get("WEBSERVER.URL"));
                thisSite.setLanguage((String)config.get("SYSTEM.LANGUAGE"));
                siteList.add(thisSite);
            }
            if (cp == null) return siteList;
        }
        catch (Exception e) {
            SiteList siteList2 = null;
            return siteList2;
        }
        finally {
            if (cp != null) {
                cp.free(dbSites);
            }
        }
        cp.free(dbSites);
        return siteList;
    }
}

