/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static String allowed = "-0123456789.";
    private static Random rn = new Random();

    public static int getIntegerNumber(String in) {
        return Integer.parseInt(StringUtils.getNumber(in));
    }

    public static double getDoubleNumber(String in) {
        return Double.parseDouble(StringUtils.getNumber(in));
    }

    public static String replace(String str, String o, String n) {
        boolean all = true;
        if (str != null && o != null && o.length() > 0 && n != null) {
            int pos;
            StringBuffer result = null;
            int oldpos = 0;
            while ((pos = str.indexOf(o, oldpos)) >= 0) {
                if (result == null) {
                    result = new StringBuffer();
                }
                result.append(str.substring(oldpos, pos));
                result.append(n);
                oldpos = pos += o.length();
                if (all) continue;
            }
            if (oldpos == 0) {
                return str;
            }
            result.append(str.substring(oldpos));
            return result.toString();
        }
        return str;
    }

    public static String toString(String s) {
        if (s != null) {
            return s;
        }
        return "";
    }

    public static String toHtml(String s) {
        if (s != null) {
            if (s.trim().equals("")) {
                return "&nbsp;";
            }
            return StringUtils.toHtmlValue(s);
        }
        return "&nbsp;";
    }

    public static String toHtmlValue(String s) {
        if (s != null) {
            String htmlReady = s.trim();
            htmlReady = StringUtils.replace(htmlReady, "&", "&amp;");
            htmlReady = StringUtils.replace(htmlReady, "\"", "&quot;");
            htmlReady = StringUtils.replace(htmlReady, "<", "&lt;");
            htmlReady = StringUtils.replace(htmlReady, ">", "&gt;");
            htmlReady = StringUtils.replace(htmlReady, "\r\n", "<br>");
            htmlReady = StringUtils.replace(htmlReady, "\n\r", "<br>");
            htmlReady = StringUtils.replace(htmlReady, "\n", "<br>");
            htmlReady = StringUtils.replace(htmlReady, "\r", "<br>");
            htmlReady = StringUtils.replace(htmlReady, "//lt;", "<");
            htmlReady = StringUtils.replace(htmlReady, "//gt;", ">");
            htmlReady = StringUtils.replace(htmlReady, "&lt;br&gt;", "<br>");
            htmlReady = StringUtils.toHtmlChars(htmlReady);
            return htmlReady;
        }
        return "";
    }

    public static String toHtmlChars(String htmlReady) {
        if (htmlReady != null) {
            htmlReady = StringUtils.replace(htmlReady, "\u00a1", "&iexcl;");
            htmlReady = StringUtils.replace(htmlReady, "\u00a2", "&cent;");
            htmlReady = StringUtils.replace(htmlReady, "\u00a3", "&pound;");
            htmlReady = StringUtils.replace(htmlReady, "\u00a4", "&curren;");
            htmlReady = StringUtils.replace(htmlReady, "\u00a5", "&yen;");
            htmlReady = StringUtils.replace(htmlReady, "\u00a6", "&brvbar;");
            htmlReady = StringUtils.replace(htmlReady, "\u00a7", "&sect;");
            htmlReady = StringUtils.replace(htmlReady, "\u00a8", "&uml;");
            htmlReady = StringUtils.replace(htmlReady, "\u00a9", "&copy;");
            htmlReady = StringUtils.replace(htmlReady, "\u00aa", "&ordf;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ab", "&laquo;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ac", "&not;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ad", "&shy;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ae", "&reg;");
            htmlReady = StringUtils.replace(htmlReady, "\u00af", "&macr;");
            htmlReady = StringUtils.replace(htmlReady, "\u00b0", "&deg;");
            htmlReady = StringUtils.replace(htmlReady, "\u00b1", "&plusmn;");
            htmlReady = StringUtils.replace(htmlReady, "\u00b2", "&sup2;");
            htmlReady = StringUtils.replace(htmlReady, "\u00b3", "&sup3;");
            htmlReady = StringUtils.replace(htmlReady, "\u00b4", "&acute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00b5", "&micro;");
            htmlReady = StringUtils.replace(htmlReady, "\u00b6", "&para;");
            htmlReady = StringUtils.replace(htmlReady, "\u00b7", "&middot;");
            htmlReady = StringUtils.replace(htmlReady, "\u00b8", "&cedil;");
            htmlReady = StringUtils.replace(htmlReady, "\u00b9", "&sup1;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ba", "&ordm;");
            htmlReady = StringUtils.replace(htmlReady, "\u00bb", "&raquo;");
            htmlReady = StringUtils.replace(htmlReady, "\u00bc", "&frac14;");
            htmlReady = StringUtils.replace(htmlReady, "\u00bd", "&frac12;");
            htmlReady = StringUtils.replace(htmlReady, "\u00be", "&frac34;");
            htmlReady = StringUtils.replace(htmlReady, "\u00bf", "&iquest;");
            htmlReady = StringUtils.replace(htmlReady, "\u00c0", "&Agrave;");
            htmlReady = StringUtils.replace(htmlReady, "\u00c1", "&Aacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00c2", "&Acirc;");
            htmlReady = StringUtils.replace(htmlReady, "\u00c3", "&Atilde;");
            htmlReady = StringUtils.replace(htmlReady, "\u00c4", "&Auml;");
            htmlReady = StringUtils.replace(htmlReady, "\u00c5", "&Aring;");
            htmlReady = StringUtils.replace(htmlReady, "\u00c6", "&AElig;");
            htmlReady = StringUtils.replace(htmlReady, "\u00c7", "&Ccedil;");
            htmlReady = StringUtils.replace(htmlReady, "\u00c8", "&Egrave;");
            htmlReady = StringUtils.replace(htmlReady, "\u00c9", "&Eacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ca", "&Ecirc;");
            htmlReady = StringUtils.replace(htmlReady, "\u00cb", "&Euml;");
            htmlReady = StringUtils.replace(htmlReady, "\u00cc", "&Igrave;");
            htmlReady = StringUtils.replace(htmlReady, "\u00cd", "&Iacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ce", "&Icirc;");
            htmlReady = StringUtils.replace(htmlReady, "\u00cf", "&Iuml;");
            htmlReady = StringUtils.replace(htmlReady, "\u00d0", "&ETH;");
            htmlReady = StringUtils.replace(htmlReady, "\u00d1", "&Ntilde;");
            htmlReady = StringUtils.replace(htmlReady, "\u00d2", "&Ograve;");
            htmlReady = StringUtils.replace(htmlReady, "\u00d3", "&Oacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00d4", "&Ocirc;");
            htmlReady = StringUtils.replace(htmlReady, "\u00d5", "&Otilde;");
            htmlReady = StringUtils.replace(htmlReady, "\u00d6", "&Ouml;");
            htmlReady = StringUtils.replace(htmlReady, "\u00d7", "&times;");
            htmlReady = StringUtils.replace(htmlReady, "\u00d8", "&Oslash;");
            htmlReady = StringUtils.replace(htmlReady, "\u00d9", "&Ugrave;");
            htmlReady = StringUtils.replace(htmlReady, "\u00da", "&Uacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00db", "&Ucirc;");
            htmlReady = StringUtils.replace(htmlReady, "\u00dc", "&Uuml;");
            htmlReady = StringUtils.replace(htmlReady, "\u00dd", "&Yacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00de", "&THORN;");
            htmlReady = StringUtils.replace(htmlReady, "\u00df", "&szlig;");
            htmlReady = StringUtils.replace(htmlReady, "\u00e0", "&agrave;");
            htmlReady = StringUtils.replace(htmlReady, "\u00e1", "&aacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00e2", "&acirc;");
            htmlReady = StringUtils.replace(htmlReady, "\u00e3", "&atilde;");
            htmlReady = StringUtils.replace(htmlReady, "\u00e4", "&auml;");
            htmlReady = StringUtils.replace(htmlReady, "\u00e5", "&aring;");
            htmlReady = StringUtils.replace(htmlReady, "\u00e6", "&aelig;");
            htmlReady = StringUtils.replace(htmlReady, "\u00e7", "&ccedil;");
            htmlReady = StringUtils.replace(htmlReady, "\u00e8", "&egrave;");
            htmlReady = StringUtils.replace(htmlReady, "\u00e9", "&eacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ea", "&ecirc;");
            htmlReady = StringUtils.replace(htmlReady, "\u00eb", "&euml;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ec", "&igrave;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ed", "&iacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ee", "&icirc;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ef", "&iuml;");
            htmlReady = StringUtils.replace(htmlReady, "\u00f0", "&eth;");
            htmlReady = StringUtils.replace(htmlReady, "\u00f1", "&ntilde;");
            htmlReady = StringUtils.replace(htmlReady, "\u00f2", "&ograve;");
            htmlReady = StringUtils.replace(htmlReady, "\u00f3", "&oacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00f4", "&ocirc;");
            htmlReady = StringUtils.replace(htmlReady, "\u00f5", "&otilde;");
            htmlReady = StringUtils.replace(htmlReady, "\u00f6", "&ouml;");
            htmlReady = StringUtils.replace(htmlReady, "\u00f7", "&divide;");
            htmlReady = StringUtils.replace(htmlReady, "\u00f8", "&oslash;");
            htmlReady = StringUtils.replace(htmlReady, "\u00f9", "&ugrave;");
            htmlReady = StringUtils.replace(htmlReady, "\u00fa", "&uacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00fb", "&ucirc;");
            htmlReady = StringUtils.replace(htmlReady, "\u00fc", "&uuml;");
            htmlReady = StringUtils.replace(htmlReady, "\u00fd", "&yacute;");
            htmlReady = StringUtils.replace(htmlReady, "\u00fe", "&thorn;");
            htmlReady = StringUtils.replace(htmlReady, "\u00ff", "&yuml;");
            htmlReady = StringUtils.replace(htmlReady, "\u20ac", "&euro;");
            return htmlReady;
        }
        return "";
    }

    public static String toPseudoHtmlValue(String s) {
        String htmlReady = StringUtils.toHtmlValue(s);
        htmlReady = StringUtils.replace(htmlReady, "<br>", "\r\n");
        return htmlReady;
    }

    public static String fromHtmlValue(String s) {
        if (s != null) {
            String htmlReady = s.trim();
            htmlReady = StringUtils.replace(htmlReady, "&quot;", "\"");
            htmlReady = StringUtils.replace(htmlReady, "&lt;", "<");
            htmlReady = StringUtils.replace(htmlReady, "&gt;", ">");
            htmlReady = StringUtils.replace(htmlReady, "&nbsp;", " ");
            htmlReady = StringUtils.replace(htmlReady, "<br>", "\r\n");
            htmlReady = StringUtils.replace(htmlReady, "<br />", "\r\n");
            return htmlReady;
        }
        return "";
    }

    public static String toHtmlText(String s) {
        s = StringUtils.replace(s, "<br>\r\n", "<br>");
        s = StringUtils.replace(s, "\r\n", "<br>");
        return s;
    }

    public static String toHtmlTextValue(String s) {
        s = StringUtils.replace(s, "<br>\r\n", "\r\n");
        s = StringUtils.replace(s, "<br />\r\n", "\r\n");
        s = StringUtils.replace(s, "<br>", "\r\n");
        s = StringUtils.replace(s, "<br />", "\r\n");
        return s;
    }

    public static String toHtmlTextBlank(String s) {
        String htmlReady = StringUtils.replace(s, "<br>", "");
        return htmlReady;
    }

    public static String toDateTimeString(Timestamp inDate) {
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(inDate);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static String toDateTimeString(java.util.Date inDate) {
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(inDate);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static String toDateString(Timestamp inDate) {
        try {
            return DateFormat.getDateInstance(3).format(inDate);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static String toDateString(Date inDate) {
        try {
            return DateFormat.getDateInstance(3).format(inDate);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static String toLongDateString(java.util.Date inDate) {
        try {
            return DateFormat.getDateInstance(1).format(inDate);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static String toFullDateString(java.util.Date inDate) {
        try {
            return DateFormat.getDateInstance(0).format(inDate);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static String sqlReplace(String s) {
        String newString = "";
        char[] input = s.toCharArray();
        int arraySize = input.length;
        for (int i = 0; i < arraySize; ++i) {
            newString = input[i] == '\'' ? newString + "\\'" : (input[i] == '\\' ? newString + "\\\\" : newString + input[i]);
        }
        return newString;
    }

    public static boolean hasText(String in) {
        return in != null && !"".equals(in.trim()) && !"null".equals(in);
    }

    private static String getNumber(String in) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            if (allowed.indexOf(in.charAt(i)) <= -1) continue;
            sb.append(in.charAt(i));
        }
        return sb.toString();
    }

    public static String getNumbersOnly(String in) {
        String allowed = "0123456789";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            if (allowed.indexOf(in.charAt(i)) <= -1) continue;
            sb.append(in.charAt(i));
        }
        return sb.toString();
    }

    public static String loadText(File file) throws IOException {
        String ls = System.getProperty("line.separator");
        StringBuffer text = new StringBuffer();
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = null;
        boolean hasLine = false;
        while ((line = in.readLine()) != null) {
            if (hasLine) {
                text.append(ls);
            }
            text.append(line);
            hasLine = true;
        }
        in.close();
        return text.toString();
    }

    public static String loadText(String filename) throws IOException {
        String ls = System.getProperty("line.separator");
        StringBuffer text = new StringBuffer();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = null;
        boolean hasLine = false;
        while ((line = in.readLine()) != null) {
            if (hasLine) {
                text.append(ls);
            }
            text.append(line);
            hasLine = true;
        }
        in.close();
        return text.toString();
    }

    public static void loadText(String filename, ArrayList lines, boolean ignoreComments) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = null;
        while ((line = in.readLine()) != null) {
            if (ignoreComments && (!ignoreComments || line.startsWith("#") || "".equals(line.trim()))) continue;
            lines.add(line);
        }
        in.close();
    }

    public static void saveText(String filename, String data) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        out.write(data);
        out.close();
    }

    public static String addS(long count) {
        if (count == 1L) {
            return "";
        }
        return "s";
    }

    public static String addES(long count) {
        if (count == 1L) {
            return "";
        }
        return "es";
    }

    public static int parseInt(String tmp, int defaultValue) {
        try {
            return Integer.parseInt(tmp);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double parseDouble(String tmp, double defaultValue) {
        try {
            return Double.parseDouble(tmp);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static ArrayList parseExcelCSVLine(String line) {
        if (line == null) {
            return null;
        }
        ArrayList<String> thisRecord = new ArrayList<String>();
        boolean quote = false;
        boolean completeField = false;
        StringBuffer value = new StringBuffer("");
        for (int i = 0; i < line.length(); ++i) {
            char thisChar = line.charAt(i);
            if (thisChar == ',') {
                if (!quote) {
                    completeField = true;
                } else {
                    value.append(thisChar);
                }
            } else if (thisChar == '\"') {
                quote = !quote;
            } else {
                value.append(thisChar);
            }
            if (i == line.length() - 1) {
                completeField = true;
            }
            if (!completeField) continue;
            thisRecord.add(value.toString());
            value = new StringBuffer("");
            quote = false;
            completeField = false;
        }
        return thisRecord;
    }

    public static ArrayList toArrayList(String str, String tokenizer) {
        ArrayList<String> convertedList = null;
        StringTokenizer tokens = new StringTokenizer(str, tokenizer);
        while (tokens.hasMoreTokens()) {
            if (convertedList == null) {
                convertedList = new ArrayList<String>();
            }
            convertedList.add(tokens.nextToken());
        }
        return convertedList;
    }

    public static String replacePattern(String source, String thisPattern, String replacement) {
        Pattern pattern = Pattern.compile(thisPattern);
        Matcher match = pattern.matcher(source);
        if (match.find()) {
            return match.replaceAll(replacement);
        }
        return source;
    }

    public static String randomString(int lo, int hi) {
        int n = StringUtils.rand(lo, hi);
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)StringUtils.rand(97, 122);
        }
        return new String(b);
    }

    public static int rand(int lo, int hi) {
        int n = hi - lo + 1;
        int i = rn.nextInt() % n;
        if (i < 0) {
            i = -i;
        }
        return lo + i;
    }

    public static String jsEscape(String s) {
        if (s != null) {
            String jsReady = s.trim();
            jsReady = StringUtils.replace(jsReady, "%", "%25");
            jsReady = StringUtils.replace(jsReady, "\r\n", "%0A");
            jsReady = StringUtils.replace(jsReady, "\r", "%0A");
            jsReady = StringUtils.replace(jsReady, "\n", "%0A");
            jsReady = StringUtils.replace(jsReady, "\"", "%22");
            jsReady = StringUtils.replace(jsReady, "\\", "%5C");
            jsReady = StringUtils.replace(jsReady, "!", "%21");
            jsReady = StringUtils.replace(jsReady, "@", "%40");
            jsReady = StringUtils.replace(jsReady, "#", "%23");
            jsReady = StringUtils.replace(jsReady, "$", "%24");
            jsReady = StringUtils.replace(jsReady, "^", "%5E");
            jsReady = StringUtils.replace(jsReady, "&", "%26");
            jsReady = StringUtils.replace(jsReady, "'", "%27");
            jsReady = StringUtils.replace(jsReady, "(", "%28");
            jsReady = StringUtils.replace(jsReady, ")", "%29");
            jsReady = StringUtils.replace(jsReady, "=", "%3D");
            jsReady = StringUtils.replace(jsReady, " ", "%20");
            jsReady = StringUtils.replace(jsReady, "|", "%7C");
            jsReady = StringUtils.replace(jsReady, ",", "%2C");
            jsReady = StringUtils.replace(jsReady, ":", "%3A");
            jsReady = StringUtils.replace(jsReady, ";", "%3B");
            jsReady = StringUtils.replace(jsReady, "<", "%3C");
            jsReady = StringUtils.replace(jsReady, ">", "%3E");
            jsReady = StringUtils.replace(jsReady, "?", "%3F");
            jsReady = StringUtils.replace(jsReady, "[", "%5B");
            jsReady = StringUtils.replace(jsReady, "]", "%5D");
            jsReady = StringUtils.replace(jsReady, "{", "%7B");
            jsReady = StringUtils.replace(jsReady, "}", "%7D");
            jsReady = StringUtils.replace(jsReady, "`", "%60");
            jsReady = StringUtils.replace(jsReady, "~", "%7E");
            return jsReady;
        }
        return "";
    }

    public static String jsStringEscape(String s) {
        if (s != null) {
            String jsReady = s.trim();
            jsReady = StringUtils.replace(jsReady, "\"", "\\\"");
            jsReady = StringUtils.replace(jsReady, "\\", "\\\\");
            jsReady = StringUtils.replace(jsReady, "\r", "\\r");
            jsReady = StringUtils.replace(jsReady, "\n", "\\n");
            jsReady = StringUtils.replace(jsReady, "\t", "\\t");
            jsReady = StringUtils.replace(jsReady, "'", "\\'");
            return jsReady;
        }
        return "";
    }

    public static String trimToSize(String text, int size) {
        if (text != null && text.length() > size) {
            return text.substring(0, size - 1) + "...";
        }
        return text;
    }

    public static String trimToSizeNoDots(String text, int size) {
        if (text != null && text.length() > size) {
            return text.substring(0, size);
        }
        return text;
    }

    public static String parseToDbString(String str) {
        return StringUtils.parseToDbString(str, ",");
    }

    public static String parseToDbString(String str, String delimiters) {
        StringBuffer result = new StringBuffer("");
        StringTokenizer tokenizer = new StringTokenizer(str, delimiters);
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (i > 0) {
                result.append(", ");
            }
            result.append("'" + token.trim() + "'");
            ++i;
        }
        return result.toString();
    }

    public static String getLineSeparated(ArrayList displayList) {
        return StringUtils.getSeparatedBy(displayList, "\r\n");
    }

    public static String getCommaSeparated(ArrayList displayList) {
        return StringUtils.getSeparatedBy(displayList, ",");
    }

    public static String getSeparatedBy(ArrayList displayList, String separator) {
        StringBuffer sb = new StringBuffer();
        try {
            Iterator j = displayList.iterator();
            while (j.hasNext()) {
                String display = (String)j.next();
                if (j.hasNext()) {
                    sb.append(display + separator);
                    continue;
                }
                sb.append(display);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString().trim();
    }

    public static String valueOf(boolean tmp) {
        if (tmp) {
            return "true";
        }
        return "false";
    }

    public static String[] getFirstLastNames(String name) {
        boolean lastFirstFormat;
        String[] result = new String[2];
        String nameFirst = null;
        String nameLast = null;
        boolean bl = lastFirstFormat = name.indexOf(",") != -1;
        if (lastFirstFormat) {
            StringTokenizer str = new StringTokenizer(name, ",");
            nameLast = str.nextToken().trim();
            if (str.hasMoreTokens() && "".equals((nameFirst = str.nextToken().trim()).trim())) {
                nameFirst = null;
            }
        } else {
            StringTokenizer str = new StringTokenizer(name);
            nameFirst = str.nextToken().trim();
            if (str.hasMoreTokens()) {
                nameLast = str.nextToken().trim();
            } else {
                nameLast = nameFirst;
                nameFirst = null;
            }
        }
        result[0] = nameFirst;
        result[1] = nameLast;
        return result;
    }

    public static boolean isTrue(String tmp) {
        if (tmp != null) {
            return "true".equals(tmp.trim());
        }
        return false;
    }
}

