/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.HTTPUtils;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.XMLUtils;

public class Template {
    public static final int HTMLEncoding = 1;
    public static final int XMLEncoding = 2;
    private HashMap parseElements = null;
    private String text = null;
    private int valueEncoding = -1;

    public Template() {
    }

    public Template(String theText) {
        this.text = theText;
    }

    public void setValueEncoding(int tmp) {
        this.valueEncoding = tmp;
    }

    public int getValueEncoding() {
        return this.valueEncoding;
    }

    public void setParseElements(HashMap tmp) {
        this.parseElements = tmp;
    }

    public void setText(String tmp) {
        this.text = tmp;
    }

    public HashMap getParseElements() {
        return this.parseElements;
    }

    public String getText() {
        return this.text;
    }

    public String getParsedText() {
        if (this.parseElements != null) {
            for (String key : this.parseElements.keySet()) {
                String value = (String)this.parseElements.get(key);
                if (this.valueEncoding == 1) {
                    value = HTTPUtils.toHtmlValue(value);
                } else if (this.valueEncoding == 2) {
                    value = XMLUtils.toXMLValue(value);
                }
                this.text = StringUtils.replace(this.text, key, value);
            }
        }
        return this.text;
    }

    public void addParseElement(String key, int value) {
        this.addParseElement(key, String.valueOf(value));
    }

    public void addParseElement(String key, String value) {
        if (this.parseElements == null) {
            this.parseElements = new HashMap();
        }
        if (value != null) {
            this.parseElements.put(key, value);
        }
    }

    public String getValue(String key) {
        String value = null;
        int keyIndex = this.text.indexOf("${" + key + "=");
        if (keyIndex > -1) {
            StringBuffer parsedValue = new StringBuffer();
            boolean start = false;
            boolean end = false;
            while (keyIndex < this.text.length() && !end) {
                String val = this.text.substring(keyIndex++, keyIndex);
                if (!start && "=".equals(val)) {
                    start = true;
                    continue;
                }
                if (!start) continue;
                if ("}".equals(val)) {
                    end = true;
                    continue;
                }
                parsedValue.append(val);
            }
            if (parsedValue.length() > 0) {
                value = parsedValue.toString();
            }
        }
        return value;
    }

    public ArrayList getVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        if (this.text != null) {
            int posCount = 0;
            int loc = -1;
            while ((loc = this.text.indexOf("${", posCount)) > -1) {
                int endLoc = this.text.indexOf("}", loc);
                String variable = this.text.substring(loc + 2, endLoc);
                variables.add(variable);
                posCount = endLoc;
            }
        }
        return variables;
    }

    public boolean hasVariable(String input) {
        ArrayList variables = this.getVariables();
        for (String variable : variables) {
            if (!variable.equals(input)) continue;
            return true;
        }
        return false;
    }

    public HashMap getKeyValuePairs() {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        String key = "";
        String value = "";
        if (this.text != null) {
            int posCount = 0;
            int loc = -1;
            while ((loc = this.text.indexOf("${", posCount)) > -1) {
                int endLoc = this.text.indexOf("}", loc);
                if (this.text.substring(loc + 2, endLoc).indexOf("=") > 0) {
                    key = this.text.substring(loc + 2, endLoc).split("=")[0];
                    value = this.text.substring(loc + 2, endLoc).split("=")[1];
                    keyValues.put(key, value);
                } else {
                    keyValues.put(key, "");
                }
                posCount = endLoc;
            }
        }
        return keyValues;
    }

    public void populateVariables(Object object) {
        ArrayList variables = this.getVariables();
        for (String variableName : variables) {
            String value;
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Template-> populateVariables: " + variableName);
            }
            if ((value = ObjectUtils.getParam(object, variableName)) == null) {
                value = "";
            }
            this.addParseElement("${" + variableName + "}", value);
        }
    }

    public void populateSystemVariables(SystemStatus thisSystem) {
        ArrayList variables = this.getVariables();
        for (String variableName : variables) {
            String value = thisSystem.getLabel(variableName);
            if (value == null) {
                value = "";
            }
            this.addParseElement("${" + variableName + "}", value);
        }
    }
}

