/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLUtils {
    private Document document = null;
    private StringBuffer XMLString = null;
    private boolean cacheXML = false;

    public XMLUtils(String info, boolean parseXML) throws Exception {
        if (parseXML) {
            this.parseXML(info);
        } else {
            this.document = XMLUtils.createDocument(info);
        }
    }

    public static Document createDocument(String name) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = document.createElement(name);
        document.appendChild(rootElement);
        return document;
    }

    public XMLUtils(String xmlData) throws Exception {
        this.parseXML(xmlData);
    }

    public XMLUtils(File xmlFile) throws Exception {
        this.parseXML(xmlFile);
    }

    public static Element getFirstChild(Document document, String name) {
        Element element = document.getDocumentElement();
        return XMLUtils.getFirstChild(element, name);
    }

    public static Element getFirstChild(Element e, String name) {
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n == null || n.getNodeType() != 1 || !((Element)n).getTagName().equals(name)) continue;
            return (Element)n;
        }
        return null;
    }

    public static void getAllChildren(Element e, AbstractList elementList) {
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            elementList.add((Element)n);
        }
    }

    public static void getAllChildren(Element e, String name, AbstractList elementList) {
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !((Element)n).getTagName().equals(name)) continue;
            elementList.add((Element)n);
        }
    }

    public static void getAllChildrenText(Element e, String name, AbstractList textList) {
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String nodeText;
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !((Element)n).getTagName().equals(name) || (nodeText = XMLUtils.getNodeText((Element)n)) == null) continue;
            textList.add(nodeText);
        }
    }

    public static Element getFirstElement(Element e, String name) {
        NodeList nl = e.getElementsByTagName(name);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !((Element)n).getTagName().equals(name)) continue;
            return (Element)n;
        }
        return null;
    }

    public static ArrayList getElements(Element e, String name) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nl = e.getElementsByTagName(name);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !((Element)n).getTagName().equals(name)) continue;
            list.add((Element)n);
        }
        return list;
    }

    public static String getNodeText(Node element) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node thisNode = nodeList.item(i);
            if (thisNode.getNodeType() != 3 && thisNode.getNodeType() != 4) continue;
            return thisNode.getNodeValue();
        }
        return null;
    }

    public static HashMap populateObject(Object target, Element element) {
        if (target != null && element != null) {
            HashMap<String, String> ignoredProperties = new HashMap<String, String>();
            NodeList objectElements = element.getChildNodes();
            for (int j = 0; j < objectElements.getLength(); ++j) {
                String displayParam;
                String value;
                Node theObject = objectElements.item(j);
                if (theObject.getNodeType() != 1) continue;
                String param = theObject.getNodeName();
                if (ObjectUtils.setParam(target, param, value = XMLUtils.getNodeText(theObject))) {
                    String lookup;
                    if (System.getProperty("DEBUG") != null) {
                        displayParam = param.substring(0, 1).toUpperCase() + param.substring(1);
                        System.out.println("XMLUtils-> set" + displayParam + "(" + value + ")");
                    }
                    if ((lookup = ((Element)theObject).getAttribute("lookup")) != null) {
                        ignoredProperties.put(param + "^" + lookup + "Guid", value);
                        continue;
                    }
                    if (value == null || value.indexOf("$C{") <= -1) continue;
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("XMLUtils-> set" + param + "(" + value + ") **CONTEXT");
                    }
                    ignoredProperties.put(param, value);
                    continue;
                }
                if (System.getProperty("DEBUG") != null) {
                    displayParam = param.substring(0, 1).toUpperCase() + param.substring(1);
                    System.out.println("XMLUtils-> set" + displayParam + "(" + value + ") **IGNORED");
                }
                ignoredProperties.put(param, value);
            }
            return ignoredProperties;
        }
        return null;
    }

    public static String toXMLValue(String s) {
        if (s != null) {
            String xmlReady = s.trim();
            xmlReady = StringUtils.replace(xmlReady, "\"", "&quot;");
            xmlReady = StringUtils.replace(xmlReady, "<", "&lt;");
            xmlReady = StringUtils.replace(xmlReady, ">", "&gt;");
            return xmlReady;
        }
        return "";
    }

    public static String toString(String xml) {
        if (xml != null) {
            String stringReady = xml.trim();
            stringReady = StringUtils.replace(stringReady, "&quot;", "\"");
            stringReady = StringUtils.replace(stringReady, "&lt;", "<");
            stringReady = StringUtils.replace(stringReady, "&gt;", ">");
            return stringReady;
        }
        return "";
    }

    public static String toString(Node node) {
        return XMLUtils.toString(node, "UTF-8");
    }

    public static String toString(Node node, String encoding) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", encoding);
            transformer.setOutputProperty("method", "xml");
            DOMSource source = new DOMSource(node);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public static boolean debug(Node node) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(System.out);
            transformer.transform(source, result);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public void setCacheXML(boolean tmp) {
        this.cacheXML = tmp;
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    public String getXMLString() {
        if (this.XMLString == null) {
            return null;
        }
        return this.XMLString.toString();
    }

    public Element getFirstChild(String name) {
        return XMLUtils.getFirstChild(this.document, name);
    }

    public Element getFirstElement(String name) {
        return XMLUtils.getFirstElement(this.getDocumentElement(), name);
    }

    public static Element getElement(Element mappings, String nodeName, String attributeName, String attributeValue) {
        ArrayList elementList = new ArrayList();
        XMLUtils.getAllChildren(mappings, nodeName, elementList);
        for (Element element : elementList) {
            if (!attributeValue.equals(element.getAttribute(attributeName))) continue;
            return element;
        }
        return null;
    }

    public String toString() {
        return XMLUtils.toString(this.document);
    }

    private void parseXML(String xmlToParse) throws Exception {
        StringReader strXML = new StringReader(xmlToParse);
        InputSource isXML = new InputSource(strXML);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(isXML);
    }

    private void parseXML(File xmlFileToParse) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(xmlFileToParse);
    }
}

