/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

public class XMPPManager {
    public static XMPPConnection verifyConnection(SystemStatus systemStatus, ApplicationPrefs prefs) {
        Object xmppConnection = systemStatus.getXmppConnection();
        if (xmppConnection == null || !xmppConnection.isConnected()) {
            try {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("XMPPManager-> Connecting to XMPP Server: " + prefs.get("XMPP.CONNECTION.URL"));
                }
                xmppConnection = "true".equals(prefs.get("XMPP.CONNECTION.SSL")) ? new SSLXMPPConnection(prefs.get("XMPP.CONNECTION.URL"), Integer.parseInt(prefs.get("XMPP.CONNECTION.PORT"))) : new XMPPConnection(prefs.get("XMPP.CONNECTION.URL"), Integer.parseInt(prefs.get("XMPP.CONNECTION.PORT")));
                xmppConnection.login(prefs.get("XMPP.MANAGER.USERNAME"), prefs.get("XMPP.MANAGER.PASSWORD"));
                xmppConnection.getRoster().setSubscriptionMode(0);
                Presence presence = new Presence(Presence.Type.UNAVAILABLE);
                presence.setMode(Presence.Mode.AWAY);
                presence.setStatus("Monitoring Centric CRM");
                xmppConnection.sendPacket((Packet)presence);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                System.out.println("XMPPManager-> XMPP Error: " + e.getMessage());
            }
        }
        return xmppConnection;
    }

    public static void removeConnection(SystemStatus systemStatus) {
        XMPPConnection xmppConnection = systemStatus.getXmppConnection();
        if (xmppConnection != null) {
            if (xmppConnection.isConnected()) {
                xmppConnection.close();
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("XMPPManager-> XMPP Logged out");
                }
            }
            xmppConnection = null;
        }
    }
}

