/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.StringUtils;

public class ZipUtils {
    public static void addTextEntry(ZipOutputStream zip, String fileName, String data) throws ZipException, IOException {
        int bytesRead;
        StringReader file = new StringReader(data);
        ZipEntry entry = new ZipEntry(fileName);
        zip.putNextEntry(entry);
        while ((bytesRead = file.read()) != -1) {
            zip.write(bytesRead);
        }
    }

    public static void extract(File zipFile, String destination) throws IOException {
        ZipInputStream zip = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry entry = null;
        byte[] buffer = new byte[1024];
        while ((entry = zip.getNextEntry()) != null) {
            int count;
            if (entry.isDirectory()) {
                File directory = new File(destination + entry.getName());
                directory.mkdirs();
                continue;
            }
            FileOutputStream file = new FileOutputStream(destination + entry.getName());
            while ((count = zip.read(buffer)) != -1) {
                file.write(buffer, 0, count);
            }
            file.close();
        }
        zip.close();
    }

    public static void extract(ZipFile zipFile, String entry, String destination) throws IOException {
        ZipEntry zipEntry = zipFile.getEntry(entry);
        if (zipEntry == null) {
            zipEntry = zipFile.getEntry(StringUtils.replace(entry, "/", "\\"));
        }
        if (zipEntry == null) {
            zipEntry = zipFile.getEntry(StringUtils.replace(entry, "\\", "/"));
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        byte[] buffer = new byte[inputStream.available()];
        if (zipEntry != null && !zipEntry.isDirectory()) {
            int numRead = 0;
            for (int offset = 0; offset < buffer.length && (numRead = inputStream.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
            }
            FileUtils.copyBytesToFile(buffer, new File(destination), true);
        }
        inputStream.close();
    }
}

