/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.formatter;

import java.util.Locale;
import org.aspcfs.modules.base.PhoneNumber;

public class PhoneNumberFormatter {
    private static final String validChars = "[]/0123456789()-., ";

    public void config() {
    }

    public static void format(PhoneNumber thisNumber, Locale locale) {
        if (locale != null) {
            if (locale == Locale.US || locale == Locale.CANADA) {
                PhoneNumberFormatter.format(thisNumber);
            } else {
                PhoneNumberFormatter.formatInternational(thisNumber);
            }
        }
    }

    public static void format(PhoneNumber thisNumber) {
        String[] number = new String[]{thisNumber.getNumber(), null};
        if (number[0] != null && number[0].length() > 0) {
            number[0] = number[0].trim();
            PhoneNumberFormatter.extractExtension(number, "ext.");
            PhoneNumberFormatter.extractExtension(number, "ext");
            PhoneNumberFormatter.extractExtension(number, "x");
            if (number[1] != null && !"".equals(number[1])) {
                thisNumber.setExtension(number[1]);
            }
            if (number[0].charAt(0) != '+' && PhoneNumberFormatter.isMostlyNumbers(number[0])) {
                number[0] = PhoneNumberFormatter.formatNumber(number[0]);
            }
            thisNumber.setNumber(number[0]);
        }
    }

    private static String formatNumber(String number) {
        String tmpNum = PhoneNumberFormatter.extractNumbers(number);
        if (tmpNum.length() == 11 && tmpNum.charAt(0) == '1') {
            tmpNum = tmpNum.substring(1);
        }
        if (tmpNum.length() == 10) {
            if (tmpNum.charAt(0) == '1' || tmpNum.charAt(0) == '0') {
                return "+" + number;
            }
            StringBuffer result = new StringBuffer();
            result.append("(");
            result.append(tmpNum.substring(0, 3));
            result.append(") ");
            result.append(tmpNum.substring(3, 6));
            result.append("-");
            result.append(tmpNum.substring(6, 10));
            return result.toString();
        }
        if (tmpNum.charAt(0) == '0') {
            return "+" + number;
        }
        return number;
    }

    public static void formatInternational(PhoneNumber thisNumber) {
        String[] number = new String[]{thisNumber.getNumber(), null};
        if (number[0] != null && number[0].length() > 0) {
            number[0] = number[0].trim();
            PhoneNumberFormatter.extractExtension(number, "ext.");
            PhoneNumberFormatter.extractExtension(number, "ext");
            PhoneNumberFormatter.extractExtension(number, "x");
            thisNumber.setExtension(number[1]);
            if (number[0].indexOf("+") == -1 && PhoneNumberFormatter.isMostlyNumbers(number[0])) {
                number[0] = "+" + number[0];
            }
            thisNumber.setNumber(number[0]);
        }
    }

    private static boolean isMostlyNumbers(String number) {
        boolean result = true;
        for (int i = 0; i < number.length(); ++i) {
            if (validChars.indexOf(number.charAt(i)) != -1) continue;
            result = false;
        }
        return result;
    }

    public static final String extractNumbers(String tmp) {
        StringBuffer sb = new StringBuffer();
        String allowed = "0123456789";
        for (int i = 0; i < tmp.length(); ++i) {
            char theChar = tmp.charAt(i);
            if (allowed.indexOf(theChar) <= -1) continue;
            sb.append(theChar);
        }
        return sb.toString();
    }

    private static void extractExtension(String[] number, String check) {
        if (number[0].toLowerCase().indexOf(check) > -1) {
            number[1] = number[0].substring(number[0].toLowerCase().indexOf(check) + check.length()).trim();
            number[0] = number[0].substring(0, number[0].toLowerCase().indexOf(check)).trim();
        }
    }
}

