/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import com.darkhorseventures.framework.actions.ActionContext;
import java.lang.reflect.Array;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.mycfs.base.CalendarEvent;
import org.aspcfs.modules.mycfs.base.CalendarEventList;
import org.aspcfs.modules.mycfs.beans.CalendarBean;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.holidays.CAHolidays;
import org.aspcfs.utils.holidays.DEHolidays;
import org.aspcfs.utils.holidays.UKHolidays;
import org.aspcfs.utils.holidays.USHolidays;

public class CalendarView {
    protected String[] monthNames = null;
    protected String[] shortMonthNames = null;
    protected DateFormatSymbols symbols = null;
    protected Calendar cal = null;
    protected int today = -1;
    protected int day = -1;
    protected int month = -1;
    protected int year = -1;
    protected Calendar calPrev = null;
    protected Calendar calNext = null;
    protected Locale locale = null;
    protected boolean headerSpace = false;
    protected boolean monthArrows = false;
    protected boolean smallView = false;
    protected boolean frontPageView = false;
    protected boolean popup = false;
    protected boolean showSubject = true;
    protected String borderSize = "";
    protected String cellPadding = "";
    protected String cellSpacing = "";
    protected int numberOfCells = 42;
    protected HashMap eventList = new HashMap();
    protected boolean sortEvents = false;
    public static final int[] DAYSINMONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String[] MONTHS = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
    private int synchFrameCounter = 1;
    CalendarBean calendarInfo = null;
    TimeZone timeZone = null;
    SystemStatus systemStatus = null;

    public CalendarView() {
        this("en", "US");
    }

    public CalendarView(HttpServletRequest request) {
        String year = request.getParameter("year");
        String month = request.getParameter("month");
        String day = request.getParameter("day");
        String timeZone = request.getParameter("timeZone");
        String language = request.getParameter("language");
        String country = request.getParameter("country");
        this.setLocale(language, country);
        if (month != null) {
            try {
                int monthTmp = Integer.parseInt(month);
                if (request.getParameter("next.x") != null) {
                    ++monthTmp;
                }
                if (request.getParameter("prev.x") != null) {
                    --monthTmp;
                }
                month = String.valueOf(monthTmp);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (timeZone != null && !"".equals(timeZone)) {
            this.cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
    }

    public CalendarView(CalendarBean calendarInfo, Locale locale) {
        this.calendarInfo = calendarInfo;
        this.setLocale(locale);
        this.setTimeZone(calendarInfo.getTimeZone());
        this.cal.setTimeZone(this.timeZone);
        this.calPrev.setTimeZone(this.timeZone);
        this.calNext.setTimeZone(this.timeZone);
        this.setYear(calendarInfo.getPrimaryYear());
        this.setMonth(calendarInfo.getPrimaryMonth());
        this.setDay(calendarInfo.getDaySelected());
    }

    public CalendarView(String language, String region) {
        Locale theLocale = new Locale(language, region);
        this.setLocale(theLocale);
    }

    public CalendarView(Locale theLocale) {
        this.setLocale(theLocale);
    }

    public void setNumberOfCells(int numberOfCells) {
        this.numberOfCells = numberOfCells;
    }

    public void setCalendarInfo(CalendarBean calendarInfo) {
        this.calendarInfo = calendarInfo;
    }

    public void setMonth(String monthArg) {
        if (monthArg != null && !monthArg.equals("")) {
            try {
                this.month = Integer.parseInt(monthArg) - 1;
                this.update();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setDate(Date tmp) {
        this.cal.setTime(tmp);
        this.year = this.cal.get(1);
        this.month = this.cal.get(2);
        this.day = this.cal.get(5);
        this.update();
    }

    public void setFrontPageView(boolean frontPageView) {
        this.frontPageView = frontPageView;
    }

    public void setDay(String dayArg) {
        if (dayArg != null && !dayArg.equals("")) {
            try {
                this.day = Integer.parseInt(dayArg);
                this.update();
            }
            catch (Exception exception) {}
        } else {
            this.day = 1;
            this.update();
        }
    }

    public void setDay(int dayArg) {
        if (dayArg != -1 && dayArg != 0) {
            try {
                this.day = dayArg;
                this.update();
            }
            catch (Exception exception) {}
        } else {
            this.day = 1;
            this.update();
        }
    }

    public void setShowSubject(boolean showSubject) {
        this.showSubject = showSubject;
    }

    public void setYear(String yearArg) {
        if (yearArg != null && !yearArg.equals("")) {
            try {
                this.year = Integer.parseInt(yearArg);
                if (yearArg.length() == 2) {
                    this.year = yearArg.startsWith("9") ? Integer.parseInt("19" + yearArg) : Integer.parseInt("20" + yearArg);
                }
                this.update();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setMonth(int monthArg) {
        this.month = monthArg - 1;
        this.update();
    }

    public void setYear(int yearArg) {
        this.year = yearArg;
        this.update();
    }

    public void setSortEvents(boolean tmp) {
        this.sortEvents = tmp;
    }

    public void setMonthArrows(boolean tmp) {
        this.monthArrows = tmp;
    }

    public void setSmallView(boolean tmp) {
        this.smallView = tmp;
    }

    public void setPopup(boolean tmp) {
        this.popup = tmp;
        if (this.popup) {
            this.setMonthArrows(true);
            this.setSmallView(true);
        }
    }

    public void setCellPadding(int tmp) {
        this.cellPadding = " cellpadding='" + tmp + "'";
    }

    public void setCellSpacing(int tmp) {
        this.cellSpacing = " cellspacing='" + tmp + "'";
    }

    public void setBorderSize(int tmp) {
        this.borderSize = "border=" + tmp + " ";
    }

    public void setHeaderSpace(boolean tmp) {
        this.headerSpace = tmp;
    }

    public void setLocale(Locale theLocale) {
        if (this.locale == null) {
            this.symbols = new DateFormatSymbols(theLocale);
            this.monthNames = this.symbols.getMonths();
            this.shortMonthNames = this.symbols.getShortMonths();
            this.locale = theLocale;
            this.cal = Calendar.getInstance(this.locale);
            this.today = this.cal.get(5);
            this.day = this.cal.get(5);
            this.month = this.cal.get(2);
            this.year = this.cal.get(1);
            this.calPrev = Calendar.getInstance(this.locale);
            this.calNext = Calendar.getInstance(this.locale);
            this.update();
        }
    }

    public void setLocale(String language, String country) {
        if (language == null) {
            language = "en";
            country = "US";
        }
        Locale theLocale = new Locale(language, country);
        this.setLocale(theLocale);
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public CalendarBean getCalendarInfo() {
        return this.calendarInfo;
    }

    public boolean getShowSubject() {
        return this.showSubject;
    }

    public int getNumberOfCells() {
        return this.numberOfCells;
    }

    public boolean getFrontPageView() {
        return this.frontPageView;
    }

    public CalendarEventList getEvents(String tmp1, String tmp2, String tmp3) {
        String key = tmp1 + "/" + tmp2 + "/" + tmp3;
        if (this.eventList.containsKey(key)) {
            return (CalendarEventList)this.eventList.get(key);
        }
        return new CalendarEventList();
    }

    public ArrayList getEvents(String tmp1, String tmp2, String tmp3, String eventType) {
        String key = tmp1 + "/" + tmp2 + "/" + tmp3;
        if (this.eventList.containsKey(key)) {
            CalendarEventList daysEvents = (CalendarEventList)this.eventList.get(key);
            return (ArrayList)daysEvents.getEvents(eventType);
        }
        return new ArrayList();
    }

    public CalendarEventList getEventList(String tmp1, String tmp2, String tmp3) {
        String key = tmp1 + "/" + tmp2 + "/" + tmp3;
        if (this.eventList.containsKey(key)) {
            return (CalendarEventList)this.eventList.get(key);
        }
        return new CalendarEventList();
    }

    public void setEventList(String key, Object thisEventList) {
        this.eventList.put(key, thisEventList);
    }

    public HashMap getEventList() {
        return this.eventList;
    }

    public CalendarEventList getEventList(String key) {
        if (this.eventList.containsKey(key)) {
            return (CalendarEventList)this.eventList.get(key);
        }
        return new CalendarEventList();
    }

    public int getEventCount(int tmp1, int tmp2, int tmp3, String eventType) {
        String key = tmp1 + "/" + tmp2 + "/" + tmp3;
        return ((ArrayList)this.getEventList(key).getEvents(eventType)).size();
    }

    public int getEndCell(Calendar tmp) {
        int endCell = DAYSINMONTH[tmp.get(2)] + this.getStartCell(tmp) - 1;
        if (tmp.get(2) == 1 && ((GregorianCalendar)tmp).isLeapYear(tmp.get(1))) {
            ++endCell;
        }
        return endCell;
    }

    public int getYear(Calendar tmp) {
        return tmp.get(1);
    }

    public String getDay() {
        return String.valueOf(this.cal.get(5));
    }

    public String getMonth() {
        return String.valueOf(this.cal.get(2) + 1);
    }

    public String getYear() {
        return String.valueOf(this.cal.get(1));
    }

    public String getMonthName(Calendar tmp) {
        return this.monthNames[tmp.get(2)];
    }

    public String getShortMonthName(Calendar tmp) {
        return this.shortMonthNames[tmp.get(2)];
    }

    public int getStartCell(Calendar tmp) {
        Calendar beginOfMonth = Calendar.getInstance(this.locale);
        beginOfMonth.set(tmp.get(1), tmp.get(2), 0);
        int baseDay = beginOfMonth.get(7) - tmp.getFirstDayOfWeek() + 1;
        if (baseDay < 1) {
            baseDay = 7 + baseDay;
        }
        return baseDay;
    }

    public String getCalendarStartDate(ActionContext context) {
        int displayMonth = 0;
        int displayDay = 0;
        int displayYear = 0;
        String source = context.getRequest().getParameter("source");
        if (source != null) {
            if (this.calendarInfo.isAgendaView() && source.equalsIgnoreCase("calendarDetails")) {
                Calendar today = Calendar.getInstance(this.timeZone, this.locale);
                displayMonth = today.get(2) + 1;
                displayDay = today.get(5);
                displayYear = today.get(1);
            } else if (!source.equalsIgnoreCase("Calendar")) {
                if (this.calendarInfo.getCalendarView().equalsIgnoreCase("day")) {
                    displayMonth = this.calendarInfo.getMonthSelected();
                    displayDay = this.calendarInfo.getDaySelected();
                    displayYear = this.calendarInfo.getYearSelected();
                } else if (this.calendarInfo.getCalendarView().equalsIgnoreCase("week")) {
                    displayMonth = this.calendarInfo.getStartMonthOfWeek();
                    displayDay = this.calendarInfo.getStartDayOfWeek();
                    displayYear = this.calendarInfo.getYearSelected();
                } else {
                    displayMonth = this.calPrev.get(2) + 1;
                    displayDay = this.getEndCell(this.calPrev) - this.getStartCell(this.cal) + 2 - this.getStartCell(this.calPrev);
                    displayYear = this.calPrev.get(1);
                }
            } else {
                displayMonth = this.calPrev.get(2) + 1;
                displayDay = this.getEndCell(this.calPrev) - this.getStartCell(this.cal) + 2 - this.getStartCell(this.calPrev);
                displayYear = this.calPrev.get(1);
            }
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CalendarView-> Start Day: " + displayMonth + "/" + displayDay + "/" + displayYear);
        }
        return displayMonth + "/" + displayDay + "/" + displayYear;
    }

    public String getCalendarEndDate(ActionContext context) {
        int displayMonth = 0;
        int displayDay = 0;
        int displayYear = 0;
        String source = context.getRequest().getParameter("source");
        if (source != null) {
            if (this.calendarInfo.isAgendaView() && source.equalsIgnoreCase("calendarDetails")) {
                Calendar today = Calendar.getInstance(this.timeZone, this.locale);
                today.add(5, 7);
                displayMonth = today.get(2) + 1;
                displayDay = today.get(5);
                displayYear = today.get(1);
            } else if (!source.equalsIgnoreCase("Calendar")) {
                if (this.calendarInfo.getCalendarView().equalsIgnoreCase("day")) {
                    Calendar tmpCal = Calendar.getInstance(this.locale);
                    tmpCal.set(this.calendarInfo.getYearSelected(), this.calendarInfo.getMonthSelected() - 1, this.calendarInfo.getDaySelected());
                    tmpCal.add(5, 1);
                    displayMonth = tmpCal.get(2) + 1;
                    displayDay = tmpCal.get(5);
                    displayYear = tmpCal.get(1);
                } else if (this.calendarInfo.getCalendarView().equalsIgnoreCase("week")) {
                    Calendar newDate = Calendar.getInstance(this.timeZone, this.locale);
                    newDate.set(this.calendarInfo.getYearSelected(), this.calendarInfo.getStartMonthOfWeek() - 1, this.calendarInfo.getStartDayOfWeek());
                    newDate.add(5, 7);
                    displayMonth = newDate.get(2) + 1;
                    displayDay = newDate.get(5);
                    displayYear = newDate.get(1);
                } else {
                    displayMonth = this.calNext.get(2) + 1;
                    displayYear = this.calNext.get(1);
                    displayDay = this.numberOfCells - this.getEndCell(this.cal) - 1;
                }
            } else {
                Calendar tmpCal = Calendar.getInstance(this.locale);
                tmpCal.set(this.calNext.get(1), this.calNext.get(2), this.numberOfCells - this.getEndCell(this.cal) - 1);
                tmpCal.add(5, 1);
                displayMonth = tmpCal.get(2) + 1;
                displayDay = tmpCal.get(5);
                displayYear = tmpCal.get(1);
            }
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CalendarView-> End Day: " + displayMonth + "/" + displayDay + "/" + displayYear);
        }
        return displayMonth + "/" + displayDay + "/" + displayYear;
    }

    public boolean isCurrentDay(Calendar tmp, int indate) {
        Calendar thisMonth = Calendar.getInstance(this.locale);
        if (this.timeZone != null) {
            thisMonth.setTimeZone(this.timeZone);
        }
        return indate == thisMonth.get(5) && tmp.get(2) == thisMonth.get(2) && tmp.get(1) == thisMonth.get(1);
    }

    public String getDayName(int day, boolean longFormat) {
        if (day > 7) {
            day -= 7;
        }
        if (longFormat) {
            return this.symbols.getShortWeekdays()[day];
        }
        return this.symbols.getWeekdays()[day];
    }

    public String getToday() {
        Calendar today = Calendar.getInstance(this.locale);
        if (this.timeZone != null) {
            today.setTimeZone(this.timeZone);
        }
        if (this.locale != null) {
            SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance(1, this.locale);
            return formatter.format(today.getTime());
        }
        return this.getMonthName(today) + " " + today.get(5) + ", " + today.get(1);
    }

    public int getSynchFrameCounter() {
        return this.synchFrameCounter;
    }

    public synchronized void decrementSynchFrameCounter() {
        --this.synchFrameCounter;
    }

    public CalendarEventList getDaysEvents(int m, int d, int y) {
        int displayMonth = m + 1;
        int displayYear = y;
        int displayDay = d;
        return this.getEvents("" + displayMonth, "" + displayDay, "" + displayYear);
    }

    public String getHtml() {
        int firstDayOfWeek;
        StringBuffer html = new StringBuffer();
        html.append("<table width='98%' valign='top' cellspacing='0' cellpadding='0' border='0' bgcolor='#ffffff'><tr><td>");
        if (this.headerSpace) {
            html.append("<table width=100% align=center cellspacing=0 cellpadding=0 border=0><tr><td>&nbsp;</td></tr></table>");
        }
        String monthArrowPrev = "";
        String monthArrowNext = "";
        if (this.monthArrows) {
            monthArrowPrev = "<INPUT TYPE=\"IMAGE\" NAME=\"prev\" ALIGN=\"MIDDLE\" SRC=\"images/prev.gif\">";
            monthArrowNext = "<INPUT TYPE=\"IMAGE\" NAME=\"next\" ALIGN=\"MIDDLE\" SRC=\"images/next.gif\">";
        }
        String tableWidth = "100%";
        String pre = "";
        if (this.popup) {
            pre = "small";
            tableWidth = "155";
        } else if (this.frontPageView) {
            tableWidth = "300";
        }
        html.append("<center><table height=\"100%\" width='" + tableWidth + "' " + this.borderSize + this.cellSpacing + this.cellPadding + " class='" + pre + "calendar' id='calendarTable'>" + "<tr height=\"4%\">");
        if (this.popup) {
            if (this.monthArrows) {
                html.append("<th class='" + pre + "monthArrowPrev'>" + monthArrowPrev + "</th>");
            }
            if (this.monthArrows) {
                html.append("<th colspan='5' ");
            } else {
                html.append("<th colspan='7' ");
            }
            html.append("class='" + pre + "monthName'");
            html.append("><B>" + StringUtils.toHtml(this.getMonthName(this.cal)) + " " + this.getYear(this.cal) + "</B></th>");
            if (this.monthArrows) {
                html.append("<th class='" + pre + "monthArrowNext'>" + monthArrowNext + "</th>");
            }
        } else {
            html.append("<th colspan=\"8\">");
            html.append(this.getHtmlMonthSelect());
            html.append("&nbsp;");
            html.append(this.getHtmlYearSelect());
            html.append("&nbsp;");
            Calendar tmp = Calendar.getInstance(this.locale);
            if (this.timeZone != null) {
                tmp.setTimeZone(this.timeZone);
            }
            if (this.systemStatus != null) {
                html.append("<a href=\"javascript:showToDaysEvents('" + (tmp.get(2) + 1) + "','" + tmp.get(5) + "','" + tmp.get(1) + "');\">" + this.systemStatus.getLabel("calendar.Today") + "</a>");
            } else {
                html.append("<a href=\"javascript:showToDaysEvents('" + (tmp.get(2) + 1) + "','" + tmp.get(5) + "','" + tmp.get(1) + "');\">Today</a>");
            }
            html.append("</th>");
        }
        html.append("</tr>");
        html.append("<tr height=\"4%\">");
        if (!this.popup) {
            html.append("<td width=\"4\" class=\"row1\"><font style=\"visibility:hidden\">n</font></td>");
        }
        for (int i = firstDayOfWeek = this.cal.getFirstDayOfWeek(); i < firstDayOfWeek + 7; ++i) {
            html.append("<td width=\"14%\" class='" + pre + "weekName'>");
            if (this.popup || this.frontPageView) {
                html.append(StringUtils.toHtml(this.getDayName(i, true)));
            } else {
                html.append(StringUtils.toHtml(this.getDayName(i, false)));
            }
            html.append("</td>");
        }
        html.append("</tr>");
        int startCellPrev = this.getStartCell(this.calPrev);
        int endCellPrev = this.getEndCell(this.calPrev);
        int startCell = this.getStartCell(this.cal);
        int endCell = this.getEndCell(this.cal);
        int thisDay = 1;
        String tdClass = "";
        for (int cellNo = 0; cellNo < this.getNumberOfCells(); ++cellNo) {
            boolean prevMonth = false;
            boolean nextMonth = false;
            boolean mainMonth = false;
            int displayDay = 0;
            int displayMonth = 0;
            int displayYear = 0;
            if (cellNo < startCell) {
                displayMonth = this.calPrev.get(2) + 1;
                displayYear = this.calPrev.get(1);
                displayDay = endCellPrev - startCell + 2 + cellNo - startCellPrev;
                prevMonth = true;
            } else if (cellNo > endCell) {
                displayMonth = this.calNext.get(2) + 1;
                displayYear = this.calNext.get(1);
                if (endCell + 1 == cellNo) {
                    thisDay = 1;
                }
                displayDay = thisDay++;
                nextMonth = true;
            } else {
                mainMonth = true;
                displayMonth = this.cal.get(2) + 1;
                displayYear = this.cal.get(1);
                displayDay = thisDay++;
            }
            if (cellNo % 7 == 0) {
                tdClass = "";
                html.append("<tr");
                if (!this.popup && this.calendarInfo.getCalendarView().equalsIgnoreCase("week") && displayMonth == this.calendarInfo.getStartMonthOfWeek() && displayDay == this.calendarInfo.getStartDayOfWeek()) {
                    html.append(" class=\"selectedWeek\" ");
                    tdClass = "selectedDay";
                }
                html.append(">");
            }
            if (!this.popup && cellNo % 7 == 0) {
                html.append("<td valign='top' width=\"4\" class=\"weekSelector\" name=\"weekSelector\">");
                String weekSelectedArrow = "<a href=\"javascript:showWeekEvents('" + displayYear + "','" + displayMonth + "','" + displayDay + "')\">" + "<img ALIGN=\"MIDDLE\" src=\"images/next.gif\" border=\"0\" onclick=\"javascript:switchTableClass(this,'selectedWeek','row');\"></a>";
                html.append(weekSelectedArrow);
                html.append("</td>");
            }
            html.append("<td valign='top'");
            if (!this.smallView) {
                if (!this.frontPageView) {
                    html.append(" height='70'");
                } else {
                    html.append(" height='45'");
                }
            }
            if (!this.popup) {
                html.append(" onclick=\"javascript:showDayEvents('" + displayYear + "','" + displayMonth + "','" + displayDay + "');javascript:switchTableClass(this,'selectedDay','cell');\"");
                if (this.calendarInfo.getCalendarView().equalsIgnoreCase("day")) {
                    tdClass = "";
                    if (displayMonth == this.calendarInfo.getMonthSelected() && displayDay == this.calendarInfo.getDaySelected()) {
                        tdClass = "selectedDay";
                    }
                }
            }
            if (prevMonth) {
                if (this.isCurrentDay(this.calPrev, displayDay)) {
                    html.append(" id='today' class='" + (tdClass.equalsIgnoreCase("") ? pre + "today'" : tdClass + "'") + " name='" + pre + "today' >");
                } else {
                    html.append(" class='" + (tdClass.equalsIgnoreCase("") ? pre + "noday'" : tdClass + "'") + " name='" + pre + "noday' >");
                }
            } else if (nextMonth) {
                if (this.isCurrentDay(this.calNext, displayDay)) {
                    html.append(" id='today' class='" + (tdClass.equalsIgnoreCase("") ? pre + "today'" : tdClass + "'") + " name='" + pre + "today' >");
                } else {
                    html.append(" class='" + (tdClass.equalsIgnoreCase("") ? pre + "noday'" : tdClass + "'") + " name='" + pre + "noday' >");
                }
            } else if (this.isCurrentDay(this.cal, displayDay)) {
                html.append(" id='today' class='" + (tdClass.equalsIgnoreCase("") ? pre + "today'" : tdClass + "'") + " name='" + pre + "today' >");
            } else {
                html.append(" class='" + (tdClass.equalsIgnoreCase("") ? pre + "day'" : tdClass + "'") + " name='" + pre + "day' >");
            }
            if (this.popup) {
                String tmpEvent = (String)this.eventList.get(displayMonth + "/" + displayDay + "/" + displayYear);
                String dateColor = "" + displayDay;
                if ("highlight".equals(tmpEvent)) {
                    dateColor = "<font color=#FF0000>" + displayDay + "</font>";
                } else if (!mainMonth) {
                    dateColor = "<font color=#888888>" + displayDay + "</font>";
                }
                html.append("<a href=\"javascript:returnDate(" + displayDay + ", " + displayMonth + ", " + displayYear + ");\"" + ">" + dateColor + "</a>");
            } else {
                CalendarEventList events;
                String dateColor = "" + displayDay;
                if (!mainMonth) {
                    dateColor = "<font color=#888888>" + displayDay + "</font>";
                }
                html.append("<a href=\"javascript:showDayEvents('" + displayYear + "','" + displayMonth + "','" + displayDay + "');\">" + dateColor + "</a>");
                if (this.isHoliday(String.valueOf(displayMonth), String.valueOf(displayDay), String.valueOf(displayYear))) {
                    html.append(CalendarEvent.getIcon("holiday", this.systemStatus) + "<font color=\"blue\"><br />");
                }
                if ((events = this.getEventList(String.valueOf(displayMonth), String.valueOf(displayDay), String.valueOf(displayYear))).size() > 0) {
                    html.append("<table width=\"12%\" align=\"center\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" class=\"dayIcon\">");
                    for (int i = 0; i < Array.getLength(CalendarEventList.EVENT_TYPES); ++i) {
                        String eventType = CalendarEventList.EVENT_TYPES[i];
                        if (!events.containsKey(eventType) || eventType.equals(CalendarEventList.EVENT_TYPES[7])) continue;
                        Object eventObj = events.get(eventType);
                        String eventSize = (String)ObjectUtils.getObject(eventObj, "sizeString");
                        html.append("<tr><td>" + CalendarEvent.getIcon(eventType, this.systemStatus) + "</td><td> " + eventSize + "</td></tr>");
                    }
                    html.append("</table>");
                }
            }
            html.append("</td>");
            if ((cellNo + 1) % 7 != 0) continue;
            html.append("</tr>");
        }
        html.append("</table></center></td></tr>");
        html.append("</table>");
        if (this.popup) {
            Calendar tmp = Calendar.getInstance(this.locale);
            if (this.timeZone != null) {
                tmp.setTimeZone(this.timeZone);
            }
            int displayMonth = tmp.get(2) + 1;
            int displayYear = tmp.get(1);
            int displayDay = tmp.get(5);
            if (this.systemStatus != null) {
                html.append("<p class=\"smallfooter\">" + StringUtils.toHtml(this.systemStatus.getLabel("calendar.Today")) + ": " + "<a href=\"javascript:returnDate(" + displayDay + ", " + displayMonth + ", " + displayYear + ");\"" + ">" + StringUtils.toHtml(this.getToday()) + "</p>");
            } else {
                html.append("<p class=\"smallfooter\">Today: <a href=\"javascript:returnDate(" + displayDay + ", " + displayMonth + ", " + displayYear + ");\"" + ">" + this.getToday() + "</p>");
            }
            html.append("<input type=\"hidden\" name=\"year\" value=\"" + this.cal.get(1) + "\">");
            html.append("<input type=\"hidden\" name=\"month\" value=\"" + (this.cal.get(2) + 1) + "\">");
        }
        html.append("<input type=\"hidden\" name=\"day\" value=\"" + this.cal.get(5) + "\">");
        return html.toString();
    }

    private String getHtmlMonthSelect() {
        StringBuffer html = new StringBuffer();
        html.append("<select size=\"1\" name=\"primaryMonth\" onChange=\"document.monthBean.submit();\">");
        for (int monthInt = 1; monthInt <= 12; ++monthInt) {
            String selected = this.getMonth().equals(String.valueOf(monthInt)) ? " selected" : "";
            html.append("<option value=\"" + monthInt + "\"" + selected + ">" + StringUtils.toHtml(this.monthNames[monthInt - 1]) + "</option>");
        }
        html.append("</select>");
        return html.toString();
    }

    private String getHtmlYearSelect() {
        StringBuffer html = new StringBuffer();
        html.append("<select size=\"1\" name=\"primaryYear\" onChange=\"document.monthBean.submit();\">");
        for (int yearInt = this.cal.get(1) - 5; yearInt <= this.cal.get(1) + 5; ++yearInt) {
            String selected = this.getYear().equals(String.valueOf(yearInt)) ? " selected" : "";
            html.append("<option value=\"" + yearInt + "\"" + selected + ">" + yearInt + "</option>");
        }
        html.append("</select>");
        return html.toString();
    }

    public ArrayList getEvents(int max) {
        ArrayList<CalendarEventList> allDays = new ArrayList<CalendarEventList>();
        int count = 0;
        int loopCount = 0;
        int dayCount = 0;
        Calendar tmpCal = Calendar.getInstance(this.timeZone, this.locale);
        if (this.calendarInfo != null) {
            if (this.calendarInfo.isAgendaView()) {
                dayCount = 7;
            } else if (this.calendarInfo.getCalendarView().equalsIgnoreCase("day")) {
                dayCount = 1;
                tmpCal.set(this.calendarInfo.getYearSelected(), this.calendarInfo.getMonthSelected() - 1, this.calendarInfo.getDaySelected());
            } else if (this.calendarInfo.getCalendarView().equalsIgnoreCase("week")) {
                dayCount = 7;
                tmpCal.set(this.calendarInfo.getYearSelected(), this.calendarInfo.getStartMonthOfWeek() - 1, this.calendarInfo.getStartDayOfWeek());
            }
        }
        while (count < max && loopCount < dayCount) {
            CalendarEventList thisEventList = this.getDaysEvents(tmpCal.get(2), tmpCal.get(5), tmpCal.get(1));
            if (thisEventList.size() > 0) {
                thisEventList.setDate(DateUtils.getDate(tmpCal));
                allDays.add(thisEventList);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("CalendarView-> Day added ");
                }
            }
            tmpCal.add(5, 1);
            ++loopCount;
            ++count;
        }
        return allDays;
    }

    public void update() {
        this.cal.set(this.year, this.month, this.day);
        this.calPrev.set(this.cal.get(1), this.cal.get(2), 1);
        this.calPrev.add(2, -1);
        this.calNext.set(this.cal.get(1), this.cal.get(2), 1);
        this.calNext.add(2, 1);
    }

    public void addEvents(String eventDate, String eventType, Object events) {
        CalendarEventList dailyEvents = null;
        dailyEvents = this.eventList.containsKey(eventDate) ? (CalendarEventList)this.eventList.get(eventDate) : new CalendarEventList();
        dailyEvents.put(eventType, events);
        this.eventList.put(eventDate, dailyEvents);
    }

    public void addEvent(String eventDate, String eventType, Object event) {
        CalendarEventList dailyEvents = null;
        dailyEvents = this.eventList.containsKey(eventDate) ? (CalendarEventList)this.eventList.get(eventDate) : new CalendarEventList();
        dailyEvents.addEvent(eventType, event);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CalendarView-> Event Type: " + eventType + " added on " + eventDate);
        }
        this.eventList.put(eventDate, dailyEvents);
    }

    public void addEventCount(String eventDate, String eventType, Object eventCount) {
        CalendarEventList dailyEvents = null;
        dailyEvents = this.eventList.containsKey(eventDate) ? (CalendarEventList)this.eventList.get(eventDate) : new CalendarEventList();
        dailyEvents.addEventCount(eventType, eventCount);
        this.eventList.put(eventDate, dailyEvents);
    }

    public Object getEventList(String eventDate, String eventType) {
        CalendarEventList dailyEvents = this.getEventList(eventDate);
        Object thisEventList = dailyEvents.getEvents(eventType);
        this.eventList.put(eventDate, dailyEvents);
        return thisEventList;
    }

    public void addHolidays() {
        int maxYear;
        int minYear = this.calPrev.get(1);
        if (minYear != (maxYear = this.calNext.get(1))) {
            this.addHolidays(minYear);
        }
        this.addHolidays(maxYear);
    }

    public void addHolidays(int theYear) {
        if (this.locale != null) {
            if ("US".equals(this.locale.getCountry())) {
                USHolidays.addTo(this, theYear);
            } else if ("CA".equals(this.locale.getCountry())) {
                CAHolidays.addTo(this, theYear);
            } else if ("DE".equals(this.locale.getCountry())) {
                DEHolidays.addTo(this, theYear);
            } else if ("UK".equals(this.locale.getCountry())) {
                UKHolidays.addTo(this, theYear);
            }
        }
    }

    public boolean eventExists(String tmpMonth, String tmpDay, String tmpYear) {
        return this.eventList.containsKey(tmpMonth + "/" + tmpDay + "/" + tmpYear);
    }

    public boolean isHoliday(String tmp1, String tmp2, String tmp3) {
        ArrayList tmpEvents;
        return this.eventList.containsKey(tmp1 + "/" + tmp2 + "/" + tmp3) && (tmpEvents = this.getEvents(tmp1, tmp2, tmp3, CalendarEventList.EVENT_TYPES[7])).size() > 0;
    }

    class ComparatorEvent
    implements Comparator {
        ComparatorEvent() {
        }

        public int compare(Object left, Object right) {
            if (((CalendarEvent)left).isHoliday() || ((CalendarEvent)right).isHoliday()) {
                String a = ((CalendarEvent)left).isHoliday() ? "A" : "B";
                String b = ((CalendarEvent)right).isHoliday() ? "A" : "B";
                return a.compareTo(b);
            }
            return ((CalendarEvent)left).getCategory().compareTo(((CalendarEvent)right).getCategory());
        }
    }
}

