/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;

public class ClientType
implements Serializable {
    public static final String allowed = "0123456789.";
    public static final int NETSCAPE = 1;
    public static final int IE = 2;
    public static final int POCKETIE = 3;
    public static final int OPERA = 4;
    public static final int MOZILLA = 5;
    public static final int APPLEWEBKIT = 6;
    public static final int HTML_BROWSER = 1;
    public static final int WAP_BROWSER = 2;
    public static final int WINDOWS = 1;
    public static final int MAC = 2;
    public static final int LINUX = 3;
    private int type = -1;
    private int id = -1;
    private double version = -1.0;
    private int os = 1;
    static final long serialVersionUID = 8345658414124283569L;

    public ClientType() {
    }

    public ClientType(HttpServletRequest request) {
        this.setParameters(request);
    }

    public void setParameters(HttpServletRequest request) {
        String header;
        this.type = 1;
        String wapCheck = request.getHeader("x-up-subno");
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ClientType-> WAP String: " + wapCheck);
        }
        if (wapCheck != null) {
            this.type = 2;
        }
        if ((header = request.getHeader("USER-AGENT")) == null) {
            header = request.getHeader("User-Agent");
        }
        if (header == null) {
            header = request.getHeader("user-agent");
        }
        if (header != null) {
            header = header.toLowerCase();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ClientType-> Header String: " + header);
            }
            if (header.indexOf("linux") > -1) {
                this.os = 3;
            } else if (header.indexOf("mac_powerpc") > -1) {
                this.os = 2;
            } else if (header.indexOf("macintosh") > -1) {
                this.os = 2;
            }
            if (header.indexOf("msie") > -1) {
                this.id = 2;
                this.version = this.parseVersion(header.substring(header.indexOf("msie ") + 5, header.indexOf(";", header.indexOf("msie "))));
            } else if (header.indexOf("applewebkit") > -1) {
                this.id = 6;
                this.version = this.parseVersion(header.substring(header.indexOf("applewebkit") + 12, header.indexOf("(khtml")));
            } else if (header.indexOf("opera") > -1) {
                this.id = 4;
                this.version = this.parseVersion(header.substring(header.indexOf("opera") + 5, header.indexOf("[", header.indexOf("opera"))).trim());
            } else if (header.indexOf("mozilla") > -1) {
                if (header.indexOf("gecko/") > -1 && header.indexOf("rv:") > -1) {
                    this.id = 5;
                    this.version = this.parseVersion(header.substring(header.indexOf("rv:") + 3, header.indexOf(") gecko")));
                } else if (header.indexOf("gecko") > -1) {
                    this.id = 1;
                    this.version = 6.0;
                } else {
                    this.id = 1;
                    this.version = 4.0;
                }
            } else {
                this.id = 1;
                this.version = 4.0;
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ClientType-> Browser Id: " + this.getBrowserId());
                System.out.println("ClientType-> Browser Version: " + this.getBrowserVersion());
                System.out.println("ClientType-> Browser O/S: " + this.getOsString());
            }
        }
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setVersion(double tmp) {
        this.version = tmp;
    }

    public void setOs(int tmp) {
        this.os = tmp;
    }

    public int getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public double getVersion() {
        return this.version;
    }

    public int getOs() {
        return this.os;
    }

    public String getBrowserId() {
        String thisId = null;
        switch (this.id) {
            case 2: {
                thisId = "ie";
                break;
            }
            case 5: {
                thisId = "moz";
                break;
            }
            case 1: {
                thisId = "ns";
                break;
            }
            case 3: {
                thisId = "pie";
                break;
            }
            case 4: {
                thisId = "opera";
                break;
            }
            case 6: {
                thisId = "applewebkit";
                break;
            }
            default: {
                thisId = "moz";
            }
        }
        return thisId;
    }

    public double getBrowserVersion() {
        return this.version;
    }

    public String getOsString() {
        switch (this.os) {
            case 3: {
                return "linux";
            }
            case 2: {
                return "mac";
            }
            case 1: {
                return "win";
            }
        }
        return "win";
    }

    public double parseVersion(String versionText) {
        try {
            return Double.parseDouble(versionText);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            boolean hasPoint = false;
            for (int i = 0; i < versionText.length(); ++i) {
                char c = versionText.charAt(i);
                if (allowed.indexOf(c) <= -1) continue;
                if (c == '.') {
                    if (hasPoint) break;
                    hasPoint = true;
                }
                sb.append(c);
            }
            return Double.parseDouble(sb.toString());
        }
    }

    public boolean showApplet() {
        return this.id == 6 || this.id == 2 && this.version >= 5.0 && this.version < 5.5;
    }
}

