/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.web.CustomColumn;
import org.aspcfs.utils.web.CustomFormGroup;
import org.aspcfs.utils.web.CustomFormTab;
import org.aspcfs.utils.web.CustomRow;

public class CustomForm
extends CustomFieldCategory {
    private String action = null;
    private String cancel = null;
    private boolean reset = false;
    private String selectedTabName = "";
    private int selectedTabId = 0;
    private StringBuffer jScripts = new StringBuffer();
    private StringBuffer jsTabCheck = new StringBuffer();
    private LinkedHashMap buttonList = new LinkedHashMap();
    private ActionContext context = null;

    public void setAction(String action) {
        this.action = action;
    }

    public void setSelectedTabId(int selectedTabId) {
        this.selectedTabId = selectedTabId;
    }

    public void setSelectedTabId(String selectedTabId) {
        this.selectedTabId = Integer.parseInt(selectedTabId);
    }

    public void setCancel(String cancel) {
        this.cancel = cancel;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public void setSelectedTabName(String selectedTabName) {
        this.selectedTabName = selectedTabName;
    }

    public void setButtonList(LinkedHashMap tmp) {
        this.buttonList = tmp;
    }

    public void setJScripts(StringBuffer jScripts) {
        this.jScripts = jScripts;
    }

    public void addJScripts(String scripts) {
        StringTokenizer st = new StringTokenizer(scripts, "^");
        if (st.hasMoreTokens()) {
            while (st.hasMoreTokens()) {
                this.jScripts.append("<script language=\"JavaScript\" TYPE=\"text/javascript\" SRC=\"javascript/" + st.nextToken() + "\"></script>");
            }
        }
    }

    public void setContext(ActionContext context) {
        this.context = context;
    }

    public ActionContext getContext() {
        return this.context;
    }

    public String getJScripts() {
        return this.jScripts.toString();
    }

    public String getAction() {
        return this.action;
    }

    public String getCancel() {
        return this.cancel;
    }

    public int getSelectedTabId() {
        return this.selectedTabId;
    }

    public boolean getReset() {
        return this.reset;
    }

    public String getSelectedTabName() {
        return this.selectedTabName;
    }

    public String getJsTabCheck() {
        return this.jsTabCheck.toString();
    }

    public boolean hasJsTabCheck() {
        return this.getJsTabCheck() != null && !"".equals(this.getJsTabCheck());
    }

    public boolean hasCancel() {
        return this.getCancel() != null && !"".equals(this.getCancel());
    }

    public boolean hasAction() {
        return this.getAction() != null && !"".equals(this.getAction());
    }

    public LinkedHashMap getButtonList() {
        return this.buttonList;
    }

    public void buildJsTabCheck(CustomField thisField) {
        if (thisField.getRequired()) {
            if (this.jsTabCheck.length() == 0) {
                this.jsTabCheck.append("function checkTab(form) {\n");
                this.jsTabCheck.append("    formTest = true;\n");
                this.jsTabCheck.append("    message = \"\";\n");
                this.jsTabCheck.append("    if (form.clickFrom.value=\"back\"){ \n");
                this.jsTabCheck.append("       return true;\n");
                this.jsTabCheck.append("    }\n");
            }
            CustomForm.appendJsField(thisField, this.jsTabCheck);
        }
    }

    public static void appendJsField(CustomField thisField, StringBuffer jsCheckInfo) {
        if (thisField.getType() == 1) {
            jsCheckInfo.append("    if (form." + thisField.getName() + ".value == \"\") {\n");
            jsCheckInfo.append("        message += \"- " + thisField.getDisplay() + "\\r\\n\";\n");
            jsCheckInfo.append("        formTest = false;\n");
            jsCheckInfo.append("    }\n");
        } else if (thisField.getType() == 2) {
            jsCheckInfo.append("    if (form." + thisField.getName() + ".selectedIndex ==0) {\n");
            jsCheckInfo.append("        message += \"- " + thisField.getDisplay() + "\\r\\n\";\n");
            jsCheckInfo.append("        formTest = false;\n");
            jsCheckInfo.append("    }\n");
        } else if (thisField.getType() == 16) {
            for (int rowListCount = 1; rowListCount <= thisField.getMaxRowItems(); ++rowListCount) {
                jsCheckInfo.append("    if (form." + thisField.getName() + rowListCount + "text.value == \"\") {\n");
                jsCheckInfo.append("        message += \"- " + thisField.getDisplay() + rowListCount + "\\r\\n\";\n");
                jsCheckInfo.append("        formTest = false;\n");
                jsCheckInfo.append("    }\n");
            }
        }
    }

    public String displayButtons() {
        StringBuffer result = new StringBuffer();
        String thisName2 = null;
        String thisLink = null;
        for (String thisName2 : this.getButtonList().keySet()) {
            thisLink = (String)this.buttonList.get(thisName2);
            if (thisName2 == null || thisName2.equals("") || thisLink.equals("") || thisLink == null) continue;
            result.append("<input type=\"submit\" value=\"" + thisName2 + "\" onClick=\"javascript:this.form.action='" + thisLink + "';this.form.clickFrom.value='" + thisName2.toLowerCase() + "'\">\n");
        }
        if (this.hasCancel()) {
            result.append("<input type=\"button\" value=\"Cancel\" onClick=\"javascript:this.form.action='" + this.getCancel() + "';this.form.submit()\">");
        }
        return result.toString();
    }

    public int populate(Connection db, Object tmp) throws SQLException {
        int updatedFields = 0;
        this.jsTabCheck = new StringBuffer();
        for (CustomFormTab thisTab : this) {
            Iterator groups = thisTab.iterator();
            while (groups.hasNext()) {
                Object dynamicRows = null;
                CustomFormGroup thisGroup = (CustomFormGroup)groups.next();
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("CustomForm-> Populating Group " + thisGroup.getName() + " Size:" + thisGroup.size());
                }
                ListIterator rows = thisGroup.listIterator();
                while (rows.hasNext()) {
                    CustomRow thisRow = (CustomRow)rows.next();
                    if (!thisRow.getMultiple()) {
                        for (CustomColumn thisColumn : thisRow) {
                            for (CustomField thisField : thisColumn) {
                                Object item;
                                if (!thisField.getIsStatic()) {
                                    if (!thisField.getListName().equals("")) {
                                        item = ObjectUtils.getObject(ObjectUtils.getObject(tmp, thisField.getListName()), thisField.getListItemName());
                                        thisField.setEnteredValue(ObjectUtils.getParam(item, thisField.getName()));
                                        if (System.getProperty("DEBUG") != null) {
                                            System.out.println("CustomForm-> SetList field: " + thisField.getName() + " " + ObjectUtils.getParam(item, thisField.getName()) + " = " + thisField.getEnteredValue());
                                        }
                                    } else {
                                        thisField.setEnteredValue(ObjectUtils.getParam(tmp, thisField.getName()));
                                        if (System.getProperty("DEBUG") != null) {
                                            System.out.println("CustomForm-> Set field: " + thisField.getName() + " " + ObjectUtils.getParam(tmp, thisField.getName()) + " = " + thisField.getEnteredValue());
                                        }
                                    }
                                }
                                if (thisField.getType() == 2 || thisField.getType() == 4) {
                                    if (!thisField.getListName().equals("")) {
                                        item = ObjectUtils.getObject(ObjectUtils.getObject(tmp, thisField.getListName()), thisField.getListItemName());
                                        thisField.setSelectedItemId(ObjectUtils.getParam(item, thisField.getName()));
                                    } else {
                                        thisField.setSelectedItemId(ObjectUtils.getParam(tmp, thisField.getName()));
                                    }
                                    thisField.buildLookupList(db, this.getContext());
                                }
                                if (this.getSelectedTabId() == thisTab.getId()) {
                                    this.buildJsTabCheck(thisField);
                                }
                                ++updatedFields;
                            }
                        }
                        continue;
                    }
                    thisRow.setListObject(ObjectUtils.getObject(tmp, thisRow.getListName()));
                }
            }
            if (System.getProperty("DEBUG") == null) continue;
            System.out.println("CustomForm-> populate Done");
        }
        if (this.jsTabCheck.length() != 0) {
            this.jsTabCheck.append("    if (formTest == false) {\n");
            this.jsTabCheck.append("        alert(\"Please check the following fields:\\r\\n\\r\\n\" + message);\n");
            this.jsTabCheck.append("        return false;\n");
            this.jsTabCheck.append("    } else {\n");
            this.jsTabCheck.append("        return true;\n");
            this.jsTabCheck.append("    }\n");
            this.jsTabCheck.append("}\n");
        }
        return updatedFields;
    }

    public String getJsFormOnLoad() {
        for (CustomFormTab thisTab : this) {
            if (thisTab.getId() != this.selectedTabId || !thisTab.hasDefaultField()) continue;
            return "window.onload = function () {document." + this.getName() + "." + thisTab.getDefaultField() + ".focus();" + thisTab.getOnLoadEvent() + "}";
        }
        return "";
    }
}

