/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.utils.XMLUtils;
import org.aspcfs.utils.web.CustomColumn;
import org.aspcfs.utils.web.CustomForm;
import org.aspcfs.utils.web.CustomFormGroup;
import org.aspcfs.utils.web.CustomFormTab;
import org.aspcfs.utils.web.CustomRow;
import org.aspcfs.utils.web.HtmlButton;
import org.w3c.dom.Element;

public class CustomFormList
extends HashMap {
    public CustomFormList() {
    }

    public CustomFormList(ServletContext context, String fn) {
        this.loadXML(context, fn);
    }

    private LinkedHashMap loadXML(ServletContext context, String file) {
        LinkedHashMap form = new LinkedHashMap();
        try {
            XMLUtils xml = new XMLUtils(new File(context.getRealPath("/WEB-INF/" + file)));
            LinkedList formList = new LinkedList();
            XMLUtils.getAllChildren(xml.getDocumentElement(), "form", formList);
            for (Element f : formList) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("CustomFormList-> Form Added: " + f.getAttribute("name"));
                }
                CustomForm newForm = this.buildForm(f);
                this.put(newForm.getName(), newForm);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return form;
    }

    private CustomForm buildForm(Element container) {
        CustomForm thisForm = new CustomForm();
        thisForm.setName(container.getAttribute("name"));
        thisForm.setAction(container.getAttribute("action"));
        thisForm.addJScripts(container.getAttribute("scripts"));
        LinkedList buttonElements = new LinkedList();
        XMLUtils.getAllChildren(container, "button", buttonElements);
        for (Element button : buttonElements) {
            thisForm.getButtonList().put(button.getAttribute("text"), button.getAttribute("link"));
        }
        LinkedList tabList = new LinkedList();
        XMLUtils.getAllChildren(container, "tab", tabList);
        for (Element tab : tabList) {
            CustomFormTab thisTab = new CustomFormTab();
            thisTab.setName(tab.getAttribute("name"));
            thisTab.setId(tab.getAttribute("id"));
            thisTab.setDefaultField(tab.getAttribute("defaultField"));
            thisTab.setOnLoadEvent(tab.getAttribute("onLoad"));
            thisTab.setReturnLinkText(tab.getAttribute("returnLinkText"));
            LinkedList buttonList = new LinkedList();
            XMLUtils.getAllChildren(tab, "buttonGroup", buttonList);
            for (Element buttonGroup : buttonList) {
                LinkedList TabButtons = new LinkedList();
                XMLUtils.getAllChildren(buttonGroup, "button", TabButtons);
                for (Element button : TabButtons) {
                    thisTab.addButton(new HtmlButton(button).toString());
                }
            }
            LinkedList groupList = new LinkedList();
            XMLUtils.getAllChildren(tab, "group", groupList);
            for (Element group : groupList) {
                CustomFormGroup thisGroup = new CustomFormGroup();
                thisGroup.setName(group.getAttribute("name"));
                LinkedList rowList = new LinkedList();
                XMLUtils.getAllChildren(group, "row", rowList);
                for (Element row : rowList) {
                    CustomRow thisRow = new CustomRow(row);
                    LinkedList columnList = new LinkedList();
                    XMLUtils.getAllChildren(row, "column", columnList);
                    for (Element column : columnList) {
                        CustomColumn thisColumn = new CustomColumn(column);
                        LinkedList fieldList = new LinkedList();
                        XMLUtils.getAllChildren(column, "field", fieldList);
                        for (Element field : fieldList) {
                            CustomField thisField = new CustomField();
                            this.processField(field, thisField);
                            thisColumn.add(thisField);
                        }
                        thisRow.add(thisColumn);
                    }
                    thisGroup.add(thisRow);
                }
                thisTab.add(thisGroup);
            }
            thisForm.add(thisTab);
        }
        return thisForm;
    }

    private void processField(Element field, CustomField thisField) {
        thisField.setName(field.getAttribute("name"));
        thisField.setDisplay(field.getAttribute("display"));
        thisField.setType(field.getAttribute("type"));
        thisField.setLengthVar(field.getAttribute("lengthVar"));
        thisField.setOnChange(field.getAttribute("onChange"));
        thisField.setJsEvent(field.getAttribute("jsEvent"));
        thisField.setListName(field.getAttribute("listName"));
        thisField.setListItemName(field.getAttribute("listItemName"));
        thisField.setDelimiter("^");
        thisField.setTextAsCode(field.getAttribute("textAsCode"));
        thisField.setLookupList(field.getAttribute("lookupList"));
        StringTokenizer st = new StringTokenizer(field.getAttribute("parameters"), "^");
        if (st.hasMoreTokens()) {
            while (st.hasMoreTokens()) {
                StringTokenizer b = new StringTokenizer(st.nextToken(), "=");
                if (!b.hasMoreTokens()) continue;
                while (b.hasMoreTokens()) {
                    thisField.setParameter(b.nextToken(), b.nextToken());
                }
            }
        }
        thisField.setRequired(field.getAttribute("required"));
    }
}

