/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.CustomLookupColumn;

public class CustomLookupElement
extends HashMap {
    protected int id = -1;
    protected String tableName = null;
    protected String uniqueField = null;
    protected String currentField = null;
    protected String currentValue = null;
    protected String currentType = null;
    protected Timestamp entered = null;
    protected Timestamp modified = null;

    public CustomLookupElement() {
    }

    public CustomLookupElement(ResultSet rs) throws SQLException {
        this.build(rs);
    }

    public CustomLookupElement(Connection db, int code, String tableName, String uniqueField) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CustomLookupElement-> Retrieving ID: " + code + " from table: " + tableName);
        }
        String sql = "SELECT " + uniqueField + " " + "FROM " + DatabaseUtils.getTableName(db, tableName) + " " + "WHERE " + uniqueField + " = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, code);
        ResultSet rs = pst.executeQuery();
        if (!rs.next()) {
            throw new SQLException("ID not found");
        }
        this.build(rs);
        rs.close();
        pst.close();
    }

    public void build(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        if (meta.getColumnCount() == 1) {
            this.id = rs.getInt(1);
        } else {
            for (int i = 1; i < meta.getColumnCount() + 1; ++i) {
                String columnName = meta.getColumnName(i);
                int columnType = meta.getColumnType(i);
                String data = null;
                if (columnType == 2005 || columnType == 2004) {
                    data = rs.getString(i);
                    columnType = 12;
                } else {
                    Object obj = rs.getObject(i);
                    if (obj != null) {
                        data = String.valueOf(obj);
                    }
                }
                CustomLookupColumn thisColumn = new CustomLookupColumn(columnName, data, columnType);
                this.put(columnName, thisColumn);
            }
        }
    }

    public void addField(String fieldName, String value, int type) {
        CustomLookupColumn thisColumn = new CustomLookupColumn(fieldName, value, type);
        this.put(fieldName, thisColumn);
    }

    public void setTableName(String tmp) {
        this.tableName = tmp;
    }

    public void setUniqueField(String tmp) {
        this.uniqueField = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setField(String tmp) {
        this.currentField = tmp;
    }

    public void setData(String tmp) {
        this.currentValue = tmp;
    }

    public String getCurrentType() {
        return this.currentType;
    }

    public void setType(String tmp) {
        this.currentType = tmp;
        this.addProperty();
    }

    private void addProperty() {
        if (!"code".equals(this.currentField) && !"guid".equals(this.currentField) && this.currentField != null && this.currentValue != null && this.currentType != null) {
            CustomLookupColumn thisColumn = new CustomLookupColumn(this.currentField, this.currentValue, Integer.parseInt(this.currentType));
            this.put(new String(this.currentField), thisColumn);
        }
        this.currentField = null;
        this.currentValue = null;
        this.currentType = null;
    }

    public void setServerMapId(String value) {
        String field = value.substring(0, value.indexOf("="));
        String recordId = value.substring(value.indexOf("=") + 1);
        CustomLookupColumn thisColumn = (CustomLookupColumn)this.get(field);
        if (thisColumn != null) {
            thisColumn.setValue(recordId);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getUniqueField() {
        return this.uniqueField;
    }

    public String getValue(String tmp) {
        CustomLookupColumn thisColumn = (CustomLookupColumn)this.get(tmp);
        if (thisColumn != null) {
            return thisColumn.getValue();
        }
        return null;
    }

    public int getType(String tmp) {
        CustomLookupColumn thisColumn = (CustomLookupColumn)this.get(tmp);
        if (thisColumn != null) {
            return thisColumn.getType();
        }
        return -1;
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.tableName == null) {
            throw new SQLException("Table name not specified");
        }
        if (this.size() == 0) {
            throw new SQLException("Fields not specified");
        }
        String seqName = null;
        if (this.getUniqueField() != null && !"".equals(this.getUniqueField().trim())) {
            seqName = this.getPostgresSeqName(this.tableName, this.getUniqueField());
            this.id = DatabaseUtils.getNextSeq(db, seqName);
        }
        this.tableName = DatabaseUtils.getTableName(db, this.tableName);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + this.tableName + " ");
        sql.append("(");
        if (this.getUniqueField() != null && this.id > -1) {
            sql.append(this.getUniqueField() + ", ");
        }
        Iterator fields = this.keySet().iterator();
        while (fields.hasNext()) {
            sql.append(DatabaseUtils.parseReservedWord(db, (String)fields.next()));
            if (!fields.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") VALUES (");
        if (this.getUniqueField() != null && this.id > -1) {
            sql.append("?, ");
        }
        for (int i = 0; i < this.size(); ++i) {
            sql.append("?");
            if (i >= this.size() - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int paramCount = 0;
        if (this.getUniqueField() != null && this.id > -1) {
            pst.setInt(++paramCount, this.id);
        }
        for (String paramName : this.keySet()) {
            CustomLookupColumn thisColumn = (CustomLookupColumn)this.get(paramName);
            if (thisColumn.getType() == 1 || thisColumn.getType() == 12) {
                pst.setString(++paramCount, thisColumn.getValue());
                continue;
            }
            if (thisColumn.getType() == 4) {
                if ("saved_criteriaelement".equals(this.getTableName()) && "source".equals(paramName)) {
                    pst.setInt(++paramCount, StringUtils.hasText(thisColumn.getValue()) ? Integer.parseInt(thisColumn.getValue()) : -1);
                    continue;
                }
                DatabaseUtils.setInt(pst, ++paramCount, StringUtils.hasText(thisColumn.getValue()) ? Integer.parseInt(thisColumn.getValue()) : -1);
                continue;
            }
            if (thisColumn.getType() == 8) {
                DatabaseUtils.setDouble(pst, ++paramCount, StringUtils.hasText(thisColumn.getValue()) ? Double.parseDouble(thisColumn.getValue()) : -1.0);
                continue;
            }
            if (thisColumn.getType() == 16 || thisColumn.getType() == -7) {
                pst.setBoolean(++paramCount, StringUtils.hasText(thisColumn.getValue()) ? DatabaseUtils.parseBoolean(thisColumn.getValue()) : false);
                continue;
            }
            if (thisColumn.getType() != 93) continue;
            DatabaseUtils.setTimestamp(pst, ++paramCount, StringUtils.hasText(thisColumn.getValue()) ? DateUtils.parseTimestampString(thisColumn.getValue()) : null);
        }
        pst.execute();
        pst.close();
        if (this.getUniqueField() != null && !"".equals(this.getUniqueField().trim())) {
            this.id = DatabaseUtils.getCurrVal(db, seqName, this.id);
        }
        return true;
    }

    private String getPostgresSeqName(String tableName, String uniqueField) {
        String seqName = null;
        seqName = "module_field_categorylink".equals(tableName) ? "module_field_categorylin_" + uniqueField + "_seq" : ("lookup_document_store_permission_category".equals(tableName) ? "lookup_document_store_permission_category_" + uniqueField + "_seq" : ("lookup_document_store_role".equals(tableName) ? "lookup_document_store_role_" + uniqueField + "_seq" : ("lookup_document_store_permission".equals(tableName) ? "lookup_document_store_permission_" + uniqueField + "_seq" : ("document_store_permissions".equals(tableName) ? "document_store_permissions_" + uniqueField + "_seq" : ("active_survey".equals(tableName) ? "active_survey_active_survey_seq" : ("active_survey_answer_avg".equals(tableName) ? "active_survey_answer_avg_id_seq" : ("product_catalog_category_map".equals(tableName) ? "product_catalog_category_map_id_seq" : (tableName.length() > 22 ? tableName.substring(0, 22) + "_" + uniqueField + "_seq" : tableName + "_" + uniqueField + "_seq"))))))));
        return seqName;
    }
}

