/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import org.w3c.dom.Element;

public class HtmlButton {
    private String name = null;
    private String value = null;
    private String onClick = null;
    private String jsEvent = null;
    private boolean enabled = true;
    private int type = 1;

    public HtmlButton() {
    }

    public HtmlButton(Element button) {
        this.processXMLButton(button);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public void setJsEvent(String jsEvent) {
        this.jsEvent = jsEvent;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.type == 1) {
            return "button";
        }
        return "submit";
    }

    public void processXMLButton(Element button) {
        if (button != null) {
            this.setName(button.getAttribute("name"));
            this.setValue(button.getAttribute("display"));
            this.setOnClick(button.getAttribute("onClick") != null ? button.getAttribute("onclick") : "");
            this.setType(Integer.parseInt(button.getAttribute("type")));
            this.setEnabled(!button.getAttribute("enabled").equalsIgnoreCase("no"));
        }
    }

    public String toString() {
        return "<input type=\"" + this.getTypeString() + "\" name=\"" + this.getName() + "\" value=\"" + this.getValue() + "\" onClick=\"" + this.getOnClick() + "\"" + (this.getEnabled() ? "" : " disabled") + ">";
    }
}

