/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class HtmlDialog {
    static final int TOP = 1;
    static final int MIDDLE = 2;
    static final int BOTTOM = 3;
    private int height = 90;
    private int width = 218;
    private int synchFrameCounter = 3;
    private String text = "";
    private String title = "";
    private String header = "";
    private String deleteUrl = "";
    private LinkedHashMap links = new LinkedHashMap();
    private StringBuffer message = null;
    private LinkedHashMap buttons = new LinkedHashMap();
    boolean showAndConfirm = true;

    public void setText(String tmp) {
        this.text = tmp;
    }

    public void setButtons(LinkedHashMap tmp) {
        this.buttons = tmp;
    }

    public void setShowAndConfirm(boolean tmp) {
        this.showAndConfirm = tmp;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setLinks(LinkedHashMap links) {
        this.links = links;
    }

    public void setSize(int height, int width) {
        this.height = height;
        this.width = width;
    }

    public void setDeleteUrl(String deleteUrl) {
        this.deleteUrl = deleteUrl;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(StringBuffer message) {
        this.message = message;
    }

    public StringBuffer getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDeleteUrl() {
        return this.deleteUrl;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public LinkedHashMap getLinks() {
        return this.links;
    }

    public String getHeader() {
        return this.header;
    }

    public String getText() {
        return this.text;
    }

    public LinkedHashMap getButtons() {
        return this.buttons;
    }

    public boolean getShowAndConfirm() {
        return this.showAndConfirm;
    }

    public int getSynchFrameCounter() {
        return this.synchFrameCounter;
    }

    public void addMessage(String msg) {
        if (this.message == null) {
            this.message = new StringBuffer();
        }
        this.message.append(msg);
    }

    public String getButtonString() {
        StringBuffer buttonString = new StringBuffer();
        try {
            Set s = this.buttons.keySet();
            Iterator i = s.iterator();
            buttonString.append("&nbsp;");
            while (i.hasNext()) {
                Object id = i.next();
                Object st = this.buttons.get(id);
                buttonString.append("<input type=\"button\" name=\"" + id.toString() + "\" value=\"" + id.toString() + "\" onClick=\"" + st.toString() + "\" />");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buttonString.toString();
    }

    public String getLinkString() {
        Set s = this.links.keySet();
        Iterator i = s.iterator();
        StringBuffer linkString = new StringBuffer();
        linkString.append("<br>");
        while (i.hasNext()) {
            Object name = i.next();
            linkString.append("- ");
            linkString.append(name + " (" + this.links.get(name) + ")");
            linkString.append("<br />");
        }
        return linkString.toString();
    }

    public void addButton(String displayName, String action) {
        this.buttons.put(displayName, action);
    }

    public String getFrameHtml(int frameId) {
        StringBuffer htmlString = new StringBuffer();
        switch (frameId) {
            case 1: {
                htmlString.append("<strong>" + this.getHeader() + "</strong>");
                break;
            }
            case 2: {
                if (this.getMessage() == null) break;
                htmlString.append("<table align=\"center\" cellpadding=\"2\" cellspacing=\"0\" border=\"0\" width=\"94%\"");
                htmlString.append("<tr><td valign=\"center\">");
                htmlString.append(this.getMessage().toString());
                htmlString.append("</td></tr></table>");
                break;
            }
            case 3: {
                htmlString.append("<center>" + this.getButtonString() + "</center>");
            }
        }
        this.decrementSynchFrameCounter();
        return htmlString.toString();
    }

    private synchronized void decrementSynchFrameCounter() {
        --this.synchFrameCounter;
    }
}

