/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.HtmlOption;
import org.aspcfs.utils.web.LookupList;

public class HtmlSelect
extends ArrayList {
    protected String selectName = "";
    protected int selectSize = 1;
    protected String selectStyle = null;
    protected String firstEntry = "";
    protected String firstKey = "";
    protected String defaultKey = "";
    protected String defaultValue = "";
    protected String jsEvent = null;
    protected boolean multiple = false;
    protected boolean disabled = false;
    protected int processedRowCount = 0;
    protected boolean checkboxOutput = false;
    protected StringBuffer rowList = new StringBuffer();
    protected boolean built = false;
    protected LookupList multipleSelects = null;
    protected String idName = null;
    protected HashMap attributeList = new HashMap();

    public HtmlSelect() {
    }

    public HtmlSelect(ArrayList itemsToAdd) {
        for (String thisItem : itemsToAdd) {
            this.addItem(thisItem);
        }
    }

    public HtmlSelect(Map itemsToAdd) {
        Iterator keys = itemsToAdd.keySet().iterator();
        Iterator values = itemsToAdd.values().iterator();
        while (keys.hasNext() && values.hasNext()) {
            Integer key = (Integer)keys.next();
            String value = (String)values.next();
            this.addItem(key, value);
        }
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean tmp) {
        this.disabled = tmp;
    }

    public void setSelectName(String tmp) {
        this.selectName = tmp;
    }

    public void setDefaultValue(String tmp) {
        if (tmp != null && !tmp.equals(this.defaultValue)) {
            this.built = false;
        }
        this.defaultValue = tmp == null ? "" : tmp;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setDefaultValue(int tmp) {
        this.defaultValue = "" + tmp;
    }

    public void setDefaultKey(String tmp) {
        if (tmp != null) {
            if (!tmp.equals(this.defaultKey)) {
                this.built = false;
            }
            this.defaultKey = this.defaultKey != null ? tmp : "";
        }
    }

    public void setDefaultKey(int tmp) {
        this.setDefaultKey(String.valueOf(tmp));
    }

    public void setSelectSize(int tmp) {
        this.selectSize = tmp;
    }

    public void setSelectStyle(String tmp) {
        this.selectStyle = tmp;
    }

    public int getSelectSize() {
        return this.selectSize;
    }

    public void setBuilt(boolean built) {
        this.built = built;
    }

    public boolean getBuilt() {
        return this.built;
    }

    public String getIdName() {
        return this.idName;
    }

    public void setIdName(String idName) {
        this.idName = idName;
    }

    public void setFirstEntry(String tmp) {
        this.firstEntry = tmp;
    }

    public void setFirstEntry(String tmp1, String tmp2) {
        this.firstKey = tmp1;
        this.firstEntry = tmp2;
    }

    public void setCheckboxOutput(boolean tmp) {
        this.checkboxOutput = tmp;
    }

    public void setTypeHours() {
        this.addItem("12");
        this.addItem("1");
        this.addItem("2");
        this.addItem("3");
        this.addItem("4");
        this.addItem("5");
        this.addItem("6");
        this.addItem("7");
        this.addItem("8");
        this.addItem("9");
        this.addItem("10");
        this.addItem("11");
    }

    public void setTypeLocale() {
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (locales[i].getCountry().length() <= 0) continue;
            this.addItem(i, locales[i].getDisplayName());
        }
    }

    public LookupList getMultipleSelects() {
        return this.multipleSelects;
    }

    public void setMultipleSelects(LookupList multipleSelects) {
        this.multipleSelects = multipleSelects;
    }

    public void setTypeTimeZone() {
        String[] timeZones = TimeZone.getAvailableIDs();
        for (int i = 0; i < timeZones.length; ++i) {
            TimeZone tz = TimeZone.getTimeZone(timeZones[i]);
            int rawOffset = tz.getRawOffset();
            double gmt = rawOffset / 1000 / 60 / 60;
            int gmtInt = rawOffset / 1000 / 60 / 60;
            if (gmt != (double)Math.round(gmt)) {
                System.out.println("HtmlSelect-> GMT Offset: " + gmt);
            }
            int fraction = 0;
            if (gmt != (double)gmtInt) {
                fraction = (int)((Math.abs(gmt) - (double)Math.abs(gmtInt)) * 60.0);
            }
            String gmtId = tz.getID();
            String gmtString = "(GMT" + (gmtInt < 0 ? "-" : "+") + (Math.abs(gmtInt) > 9 ? "" : "0") + Math.abs(gmtInt) + ":" + (fraction != 0 ? "" + fraction : "00") + ") ";
            String timeZone = gmtString + tz.getDisplayName();
            if (tz.getDisplayName().startsWith("GMT")) continue;
            this.addItem(gmtId, timeZone + " (" + gmtId + ")");
        }
    }

    public void setTypeMinutesQuarterly() {
        this.addItem("00");
        this.addItem("15");
        this.addItem("30");
        this.addItem("45");
    }

    public void setTypeAMPM() {
        this.addItem("AM");
        this.addItem("PM");
    }

    public void setTypeUSMonths() {
        this.addItem(1, "January");
        this.addItem(2, "February");
        this.addItem(3, "March");
        this.addItem(4, "April");
        this.addItem(5, "May");
        this.addItem(6, "June");
        this.addItem(7, "July");
        this.addItem(8, "August");
        this.addItem(9, "September");
        this.addItem(10, "October");
        this.addItem(11, "November");
        this.addItem(12, "December");
    }

    public void setTypeYears(int bottomLimitYear) {
        Date d = new Date();
        Calendar iteratorDate = Calendar.getInstance();
        for (int counter = iteratorDate.get(1); counter >= bottomLimitYear; --counter) {
            this.addItem("" + counter);
        }
        this.setDefaultValue("" + iteratorDate.get(1));
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public void addAttribute(String attrName, String attrValue) {
        this.attributeList.put(attrName, attrValue);
    }

    public boolean getMultiple() {
        return this.multiple;
    }

    public String getAttributeList() {
        StringBuffer tmpList = new StringBuffer();
        Set s = this.attributeList.keySet();
        Iterator i = s.iterator();
        tmpList.append(" ");
        while (i.hasNext()) {
            Object name = i.next();
            tmpList.append(name.toString() + "=\"" + this.attributeList.get(name).toString() + "\" ");
        }
        return tmpList.toString();
    }

    public String getHtml(String thisSelectName) {
        this.selectName = thisSelectName;
        if (!this.built) {
            this.build();
        }
        return this.getHtml();
    }

    public String getHtml(String thisSelectName, String thisDefaultValue) {
        this.selectName = thisSelectName;
        this.setDefaultValue(thisDefaultValue);
        if (!this.built) {
            this.build();
        }
        return this.getHtml();
    }

    public String getHtml(String thisSelectName, int thisDefaultKey) {
        this.selectName = thisSelectName;
        this.setDefaultKey(thisDefaultKey);
        if (!this.built) {
            this.build();
        }
        return this.getHtml();
    }

    public String getHtml() {
        if (!this.built) {
            this.build();
        }
        StringBuffer outputHtml = new StringBuffer();
        if (!this.checkboxOutput) {
            outputHtml.append("<select size='" + this.selectSize + "' " + (this.selectStyle == null ? "" : "style='" + this.selectStyle + "' ") + "name='" + this.selectName + "'" + (this.jsEvent != null ? " " + this.jsEvent : "") + (this.idName != null ? " id='" + this.idName + "' " : "") + (this.multiple ? " multiple " : "") + (this.disabled ? " disabled " : "") + this.getAttributeList() + ">");
        }
        outputHtml.append(this.rowList.toString());
        if (!this.checkboxOutput) {
            outputHtml.append("</select>");
        }
        return outputHtml.toString();
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public String toString() {
        return this.getHtml();
    }

    public void addGroup(String category) {
        HtmlOption thisGroup = new HtmlOption();
        thisGroup.setGroup(true);
        thisGroup.setText(category);
        this.add(thisGroup);
    }

    protected void addItem(String tmp1, String tmp2, int position) {
        this.add(position, new HtmlOption(tmp1, tmp2));
    }

    public void addItem(int tmp1, String tmp2, HashMap attributes) {
        this.add(new HtmlOption(String.valueOf(tmp1), tmp2, attributes));
    }

    public void addItem(int tmp1, String tmp2, HashMap attributes, boolean enabled) {
        this.add(new HtmlOption(String.valueOf(tmp1), tmp2, attributes, enabled));
    }

    public void addItem(String tmp1, String tmp2) {
        this.add(new HtmlOption(String.valueOf(tmp1), tmp2));
    }

    public void addItem(String tmp) {
        this.add(new HtmlOption(String.valueOf(tmp), String.valueOf(tmp)));
    }

    public void addItem(int tmp1, String tmp2) {
        this.add(new HtmlOption(String.valueOf(tmp1), tmp2));
    }

    public void addItems(HtmlSelect items) {
        for (HtmlOption thisItem : items) {
            this.add(thisItem);
        }
    }

    public void addItem(int tmp1, String tmp2, int position) {
        this.add(position, new HtmlOption(String.valueOf(tmp1), tmp2));
    }

    public void addItems(ResultSet rs, String valueField, String valueType, String displayField, String displayType) throws SQLException {
        while (rs.next()) {
            ++this.processedRowCount;
            String tmp1 = this.getColumn(rs, valueField, valueType);
            String tmp2 = this.getColumn(rs, displayField, displayType);
            this.addItem(tmp1, tmp2);
        }
    }

    public void build() {
        this.rowList.setLength(0);
        this.built = true;
        int rowSelect = -1;
        if (this.defaultValue.equals("") && this.defaultKey.equals("")) {
            rowSelect = 1;
        }
        if (!this.firstEntry.equals("")) {
            if (this.defaultValue.equals("") && this.defaultKey.equals("") || this.defaultValue.equals(this.firstEntry) || this.defaultKey.equals(this.firstKey)) {
                rowSelect = -1;
                if (!this.checkboxOutput) {
                    this.rowList.append("<option selected value='0'>" + this.firstEntry + "</option>");
                } else {
                    this.rowList.append("<input type='radio' checked>" + this.firstEntry + "&nbsp;");
                }
            } else if (!this.checkboxOutput) {
                this.rowList.append("<option value='0'>" + this.firstEntry + "</option>");
            } else {
                this.rowList.append("<input type='radio'>" + this.firstEntry + "&nbsp;");
            }
        }
        boolean groupOpen = false;
        for (int i = 0; i < this.size(); ++i) {
            ++this.processedRowCount;
            HtmlOption thisOption = (HtmlOption)this.get(i);
            String tmp1 = thisOption.getValue();
            String tmp2 = thisOption.getText();
            String attributes = thisOption.getAttributes();
            if (thisOption.isGroup()) {
                if (groupOpen) {
                    this.rowList.append("</optgroup>");
                }
                this.rowList.append("<optgroup label=\"" + tmp2 + "\">");
                continue;
            }
            String optionChecked = "";
            String optionSelected = "";
            if (this.multipleSelects != null && this.multipleSelects.containsKey(Integer.parseInt(tmp1))) {
                optionSelected = "selected ";
                optionChecked = " checked";
            } else if (this.multipleSelects == null && (tmp2.equals(this.defaultValue) || tmp1.equals(this.defaultValue) || rowSelect == this.processedRowCount || tmp1.equals(this.defaultKey))) {
                optionSelected = "selected ";
                optionChecked = " checked";
            }
            if (!this.checkboxOutput) {
                this.rowList.append("<option " + optionSelected + "value='" + tmp1 + "' " + attributes + ">" + HtmlSelect.toHtml(tmp2) + "</option>");
                continue;
            }
            this.rowList.append("<input type='radio'" + optionChecked + ">" + HtmlSelect.toHtml(tmp2) + "&nbsp;");
        }
        if (groupOpen) {
            this.rowList.append("</optgroup>");
        }
    }

    public void build(ResultSet rs, String valueField, String valueType, String displayField, String displayType) {
        this.built = true;
        int rowSelect = -1;
        if (this.defaultValue.equals("") && this.defaultKey.equals("")) {
            rowSelect = 1;
        }
        if (!this.firstEntry.equals("")) {
            if (this.defaultValue.equals("") && this.defaultKey.equals("") || this.defaultValue.equals(this.firstEntry) || this.defaultKey.equals(this.firstKey)) {
                rowSelect = -1;
                if (!this.checkboxOutput) {
                    this.rowList.append("<option selected value='0'>" + this.firstEntry + "</option>");
                } else {
                    this.rowList.append("<input type='radio' checked>" + this.firstEntry + "&nbsp;");
                }
            } else if (!this.checkboxOutput) {
                this.rowList.append("<option value='0'>" + this.firstEntry + "</option>");
            } else {
                this.rowList.append("<input type='radio'>" + this.firstEntry + "&nbsp;");
            }
        }
        try {
            while (rs.next()) {
                ++this.processedRowCount;
                String tmp1 = this.getColumn(rs, valueField, valueType);
                String tmp2 = this.getColumn(rs, displayField, displayType);
                String optionSelected = "";
                String optionChecked = "";
                if (tmp2.equals(this.defaultValue) || rowSelect == this.processedRowCount || tmp1.equals(this.defaultKey)) {
                    optionSelected = "selected ";
                    optionChecked = " checked";
                }
                if (!this.checkboxOutput) {
                    this.rowList.append("<option " + optionSelected + "value='" + tmp1 + "'>" + HtmlSelect.toHtml(tmp2) + "</option>");
                    continue;
                }
                this.rowList.append("<input type='radio'" + optionChecked + ">" + HtmlSelect.toHtml(tmp2) + "&nbsp;");
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    private String getColumn(ResultSet thisRS, String thisField, String thisFieldType) {
        String returnValue = "not found";
        try {
            if (thisFieldType.toUpperCase().equals("STRING")) {
                returnValue = thisRS.getString(thisField);
            } else if (thisFieldType.toUpperCase().equals("BOOLEAN")) {
                boolean tmp = thisRS.getBoolean(thisField);
                returnValue = !tmp ? "No" : "Yes";
            } else if (thisFieldType.toUpperCase().equals("INT") || thisFieldType.toUpperCase().equals("INTEGER")) {
                int tmp = thisRS.getInt(thisField);
                returnValue = "" + tmp;
            } else if (thisFieldType.toUpperCase().equals("TIMESTAMP")) {
                Timestamp tmp = thisRS.getTimestamp(thisField);
                returnValue = tmp.toString();
            } else if (thisFieldType.toUpperCase().equals("DATE")) {
                java.sql.Date tmp = thisRS.getDate(thisField);
                returnValue = tmp.toString();
            } else {
                returnValue = "Field type not supported";
            }
        }
        catch (SQLException e) {
            returnValue = "Field error";
        }
        return returnValue;
    }

    private static String replace(String str, String o, String n) {
        boolean all = true;
        if (str != null && o != null && o.length() > 0 && n != null) {
            int pos;
            StringBuffer result = null;
            int oldpos = 0;
            while ((pos = str.indexOf(o, oldpos)) >= 0) {
                if (result == null) {
                    result = new StringBuffer();
                }
                result.append(str.substring(oldpos, pos));
                result.append(n);
                oldpos = pos += o.length();
                if (all) continue;
            }
            if (oldpos == 0) {
                return str;
            }
            result.append(str.substring(oldpos));
            return result.toString();
        }
        return str;
    }

    private static String toHtml(String s) {
        return StringUtils.toHtmlValue(s);
    }

    public String getSelectedValue(int selectedId) {
        try {
            return this.getSelectedValue(String.valueOf(selectedId));
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getSelectedValue(String selectedId) {
        return this.getValueFromId(selectedId);
    }

    public String getValueFromId(int selectedId) {
        try {
            return this.getValueFromId(String.valueOf(selectedId));
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getValueFromId(String key) {
        for (HtmlOption thisOption : this) {
            if (!key.equals(thisOption.getValue())) continue;
            return thisOption.getText();
        }
        return key;
    }

    public boolean hasKey(String key) {
        for (HtmlOption thisOption : this) {
            if (!key.equals(thisOption.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean hasText(String text) {
        for (HtmlOption thisOption : this) {
            if (!text.equals(thisOption.getText())) continue;
            return true;
        }
        return false;
    }
}

