/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.aspcfs.utils.DatabaseUtils;

public class LookupElement
implements Serializable {
    protected String tableName = null;
    protected int code = 0;
    protected String description = "";
    protected boolean defaultItem = false;
    protected int level = 0;
    protected boolean enabled = true;
    protected Timestamp entered = null;
    protected Timestamp modified = null;
    protected int fieldId = -1;
    protected int constantId = -1;
    protected boolean group = false;

    public LookupElement() {
    }

    public LookupElement(Connection db, int code, String tableName) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("LookupElement-> Retrieving ID: " + code + " from table: " + tableName);
        }
        String sql = "SELECT code, description, default_item, " + DatabaseUtils.addQuotes(db, "level") + ", enabled " + "FROM " + DatabaseUtils.getTableName(db, tableName) + " " + "WHERE code = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, code);
        ResultSet rs = pst.executeQuery();
        if (!rs.next()) {
            rs.close();
            pst.close();
            throw new SQLException("ID not found");
        }
        this.build(rs);
        rs.close();
        pst.close();
    }

    private LookupElement(Connection db, String description, String tableName) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("LookupElement-> Retrieving Description: " + description + " from table: " + tableName);
        }
        String sql = (DatabaseUtils.getType(db) == 3 ? "SELECT * FROM ( " : "") + "SELECT " + (DatabaseUtils.getType(db) == 2 ? "TOP 1 " : "") + (DatabaseUtils.getType(db) == 5 ? "TOP (1) " : "") + (DatabaseUtils.getType(db) == 4 ? "FIRST 1 " : "") + "code, description, default_item, " + DatabaseUtils.addQuotes(db, "level") + ", enabled " + "FROM " + DatabaseUtils.getTableName(db, tableName) + " " + "WHERE description = ? " + (DatabaseUtils.getType(db) == 1 ? "LIMIT 1 " : "") + (DatabaseUtils.getType(db) == 7 ? "LIMIT 1 " : "") + (DatabaseUtils.getType(db) == 6 ? "FETCH FIRST 1 ROWS ONLY " : "") + (DatabaseUtils.getType(db) == 3 ? ") WHERE ROWNUM <= 1 " : "");
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setString(1, description);
        DatabaseUtils.doManualLimit(db, pst, 1);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.build(rs);
        } else {
            this.code = -1;
        }
        rs.close();
        pst.close();
    }

    public LookupElement(ResultSet rs) throws SQLException {
        this.build(rs);
    }

    public void build(ResultSet rs) throws SQLException {
        this.code = rs.getInt("code");
        this.description = rs.getString("description");
        this.defaultItem = rs.getBoolean("default_item");
        this.level = rs.getInt("level");
        this.enabled = rs.getBoolean("enabled");
        if (!this.getEnabled()) {
            this.description = this.description + " (X)";
        }
    }

    public void setTableName(String tmp) {
        this.tableName = tmp;
    }

    public int setNewOrder(Connection db, String tableName) throws SQLException {
        int resultCount = 0;
        if (this.getCode() == 0) {
            throw new SQLException("Element Code not specified.");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + DatabaseUtils.getTableName(db, tableName) + " " + "SET " + DatabaseUtils.addQuotes(db, "level") + " = ? " + "WHERE code = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getLevel());
        pst.setInt(++i, this.getCode());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int setNewDescription(Connection db, String tableName) throws SQLException {
        int resultCount = 0;
        if (this.getCode() == 0) {
            throw new SQLException("Element Code not specified.");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + DatabaseUtils.getTableName(db, tableName) + " " + "SET description = ? " + "WHERE code = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getDescription());
        pst.setInt(++i, this.getCode());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public void setCode(int tmp) {
        this.code = tmp;
    }

    public void setCode(String tmp) {
        this.code = Integer.parseInt(tmp);
    }

    public void setId(int tmp) {
        this.code = tmp;
    }

    public void setId(String tmp) {
        this.code = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setDefaultItem(boolean tmp) {
        this.defaultItem = tmp;
    }

    public void setDefaultItem(String tmp) {
        this.defaultItem = DatabaseUtils.parseBoolean(tmp);
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setFieldId(int tmp) {
        this.fieldId = tmp;
    }

    public void setFieldId(String tmp) {
        this.fieldId = Integer.parseInt(tmp);
    }

    public void setConstantId(int constantId) {
        this.constantId = constantId;
    }

    public void setConstantId(String constantId) {
        this.constantId = Integer.parseInt(constantId);
    }

    public void setGroup(boolean tmp) {
        this.group = tmp;
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public void setModified(Timestamp modified) {
        this.modified = modified;
    }

    public void setGroup(String tmp) {
        this.group = DatabaseUtils.parseBoolean(tmp);
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeString() {
        return String.valueOf(this.code);
    }

    public int getId() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getDefaultItem() {
        return this.defaultItem;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Timestamp getModified() {
        if (this.modified == null) {
            return new Timestamp(new Date().getTime());
        }
        return this.modified;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public int getConstantId() {
        return this.constantId;
    }

    public boolean isGroup() {
        return this.group;
    }

    public boolean getGroup() {
        return this.group;
    }

    public boolean isDefaultItem() {
        return this.defaultItem;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int disableElement(Connection db, String tableName) throws SQLException {
        int resultCount = 0;
        if (this.getCode() == 0) {
            throw new SQLException("Element Code not specified.");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + DatabaseUtils.getTableName(db, tableName) + " " + "SET enabled = ? " + "WHERE code = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setBoolean(++i, false);
        pst.setInt(++i, this.getCode());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int enableElement(Connection db, String tableName) throws SQLException {
        int resultCount = 0;
        if (this.getCode() == 0) {
            throw new SQLException("Element Code not specified.");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + DatabaseUtils.getTableName(db, tableName) + " " + "SET enabled = ? " + "WHERE code = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setBoolean(++i, true);
        pst.setInt(++i, this.getCode());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int isDisabled(Connection db, String tableName) throws SQLException {
        if (this.getDescription() == null) {
            throw new SQLException("Element description not specified");
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        int tmpCode = -1;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM " + DatabaseUtils.getTableName(db, tableName) + " " + "WHERE description = ? " + "AND enabled = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.description);
        pst.setBoolean(++i, false);
        rs = pst.executeQuery();
        if (rs.next()) {
            tmpCode = rs.getInt("code");
        }
        rs.close();
        pst.close();
        return tmpCode;
    }

    public boolean insertElement(Connection db, String tableName) throws SQLException {
        return this.insertElement(db, tableName, -1);
    }

    public boolean insertElement(Connection db, String tableName, int fieldId) throws SQLException {
        this.tableName = tableName;
        this.fieldId = fieldId;
        return this.insert(db);
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        String seqName = null;
        seqName = this.tableName.length() > 22 ? this.tableName.substring(0, 22) : this.tableName;
        int id = DatabaseUtils.getNextSeq(db, seqName + "_code_seq");
        sql.append("INSERT INTO " + DatabaseUtils.getTableName(db, this.tableName) + " " + "(" + (id > -1 ? "code, " : "") + "description, " + DatabaseUtils.addQuotes(db, "level") + ", enabled" + (this.fieldId > -1 ? ", field_id" : "") + (this.constantId > -1 ? ", constant_id" : "") + ") " + "VALUES (" + (id > -1 ? "?, " : "") + "?, ?, ?" + (this.fieldId > -1 ? ", ?" : "") + (this.constantId > -1 ? ", ?" : "") + ") ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (id > -1) {
            pst.setInt(++i, id);
        }
        pst.setString(++i, this.getDescription());
        pst.setInt(++i, this.getLevel());
        pst.setBoolean(++i, true);
        if (this.fieldId > -1) {
            pst.setInt(++i, this.fieldId);
        }
        if (this.constantId > -1) {
            pst.setInt(++i, this.constantId);
        }
        pst.execute();
        pst.close();
        this.code = DatabaseUtils.getCurrVal(db, seqName + "_code_seq", id);
        return true;
    }

    public static int retrieveMaxLevel(Connection db, String tableName) throws SQLException {
        int maxLevel = 0;
        PreparedStatement pst = db.prepareStatement("SELECT MAX(" + DatabaseUtils.addQuotes(db, "level") + ") AS max_level " + "FROM " + DatabaseUtils.getTableName(db, tableName) + " ");
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            maxLevel = rs.getInt("max_level");
        }
        rs.close();
        pst.close();
        return maxLevel;
    }

    public void delete(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM " + this.tableName + " " + "WHERE code = ? ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.code);
        pst.execute();
        pst.close();
    }

    public String toString() {
        return String.valueOf(this.code + "-" + this.description);
    }

    public static int getCodeByDescription(Connection db, String description, String tableName) throws SQLException {
        LookupElement lookupElement = new LookupElement(db, description, tableName);
        return lookupElement.getCode();
    }
}

