/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.PagedListInfo;

public class LookupList
extends HtmlSelect
implements SyncableList {
    public static String uniqueField = "code";
    public String tableName = null;
    protected String jsEvent = null;
    protected int selectSize = 1;
    protected String selectStyle = null;
    protected boolean multiple = false;
    protected Timestamp lastAnchor = null;
    protected Timestamp nextAnchor = null;
    protected int syncType = -1;
    protected boolean showDisabledFlag = true;
    protected PagedListInfo pagedListInfo = null;
    protected HashMap selectedItems = null;
    protected boolean excludeDisabledIfUnselected = false;

    public LookupList() {
    }

    public LookupList(Connection db, String thisTable) throws SQLException {
        this.tableName = thisTable;
        this.buildList(db);
    }

    public LookupList(Connection db, int moduleId, int lookupId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT lll.table_name AS tableName FROM lookup_lists_lookup lll WHERE lll.category_id = ? AND lll.lookup_id = ? ");
        pst.setInt(1, moduleId);
        pst.setInt(2, lookupId);
        ResultSet rs = null;
        rs = pst.executeQuery();
        if (!rs.next()) {
            rs.close();
            pst.close();
            throw new SQLException("No lookup table found");
        }
        this.setTableName(rs.getString("tableName"));
        rs.close();
        pst.close();
    }

    public LookupList(String[] vals, String[] names) throws SQLException {
        for (int i = 0; i < vals.length; ++i) {
            LookupElement thisElement = new LookupElement();
            thisElement.setDescription(names[i]);
            if (!vals[i].startsWith("*")) {
                thisElement.setCode(Integer.parseInt(vals[i]));
            }
            thisElement.setLevel(i);
            this.add(thisElement);
        }
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public HashMap getSelectedItems() {
        return this.selectedItems;
    }

    public void setSelectedItems(HashMap tmp) {
        this.selectedItems = tmp;
    }

    public boolean getExcludeDisabledIfUnselected() {
        return this.excludeDisabledIfUnselected;
    }

    public void setExcludeDisabledIfUnselected(boolean tmp) {
        this.excludeDisabledIfUnselected = tmp;
    }

    public void setExcludeDisabledIfUnselected(String tmp) {
        this.excludeDisabledIfUnselected = DatabaseUtils.parseBoolean(tmp);
    }

    public LookupList(Connection db, String table, int fieldId) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("LookupList-> " + table + ": " + fieldId);
        }
        Statement st = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM " + table + " " + "WHERE field_id = " + fieldId + " " + "AND CURRENT_TIMESTAMP > start_date " + "AND (CURRENT_TIMESTAMP < end_date OR end_date IS NULL) " + "ORDER BY " + DatabaseUtils.addQuotes(db, "level") + ", description ");
        st = db.createStatement();
        rs = st.executeQuery(sql.toString());
        while (rs.next()) {
            LookupElement thisElement = new LookupElement(rs);
            this.add(thisElement);
        }
        rs.close();
        st.close();
    }

    public void setShowDisabledFlag(boolean showDisabledFlag) {
        this.showDisabledFlag = showDisabledFlag;
    }

    public boolean getShowDisabledFlag() {
        return this.showDisabledFlag;
    }

    public void setTable(String tmp) {
        this.tableName = tmp;
    }

    public void setTableName(String tmp) {
        this.tableName = tmp;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public void setSelectSize(int tmp) {
        this.selectSize = tmp;
    }

    public void setSelectStyle(String tmp) {
        this.selectStyle = tmp;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public String getTable() {
        return this.tableName;
    }

    public boolean getMultiple() {
        return this.multiple;
    }

    public String getHtmlSelectDefaultNone(SystemStatus thisSystem, String selectName) {
        HtmlSelect thisSelect = new HtmlSelect();
        thisSelect.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        for (LookupElement thisElement : this) {
            if (thisElement.isGroup()) {
                thisSelect.addGroup(thisElement.getDescription());
                continue;
            }
            thisSelect.addItem(thisElement.getCode(), thisElement.getDescription());
        }
        return thisSelect.getHtml(selectName);
    }

    public int getEnabledElementCount() {
        int count = 0;
        for (LookupElement thisElement : this) {
            if (!thisElement.getEnabled() || thisElement.getGroup()) continue;
            ++count;
        }
        return count;
    }

    public int getFirstEnabledElement() {
        int code = -1;
        for (LookupElement thisElement : this) {
            if (!thisElement.getEnabled() || thisElement.getGroup()) continue;
            code = thisElement.getCode();
            break;
        }
        return code;
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        return this.getHtmlSelect(selectName, defaultKey, false);
    }

    public String getHtmlSelect(String selectName, int defaultKey, boolean disabled) {
        HtmlSelect thisSelect = new HtmlSelect();
        thisSelect.setSelectSize(this.selectSize);
        thisSelect.setSelectStyle(this.selectStyle);
        thisSelect.setMultiple(this.multiple);
        thisSelect.setDisabled(disabled);
        thisSelect.setJsEvent(this.jsEvent);
        Iterator i = this.iterator();
        boolean keyFound = false;
        int lookupDefault = defaultKey;
        while (i.hasNext()) {
            LookupElement thisElement = (LookupElement)i.next();
            if (thisElement.isGroup()) {
                thisSelect.addGroup(thisElement.getDescription());
                continue;
            }
            if (thisElement.getEnabled() || !this.showDisabledFlag) {
                thisSelect.addItem(thisElement.getCode(), thisElement.getDescription());
                if (thisElement.getDefaultItem()) {
                    lookupDefault = thisElement.getCode();
                }
            } else if (thisElement.getCode() == defaultKey) {
                thisSelect.addItem(thisElement.getCode(), thisElement.getDescription());
            }
            if (thisElement.getCode() != defaultKey || defaultKey <= -1) continue;
            keyFound = true;
        }
        if (keyFound) {
            return thisSelect.getHtml(selectName, defaultKey);
        }
        return thisSelect.getHtml(selectName, lookupDefault);
    }

    public HtmlSelect getHtmlSelectObj(int defaultKey) {
        HtmlSelect thisSelect = new HtmlSelect();
        thisSelect.setSelectSize(this.selectSize);
        thisSelect.setMultiple(this.multiple);
        thisSelect.setJsEvent(this.jsEvent);
        Iterator i = this.iterator();
        boolean keyFound = false;
        int lookupDefault = defaultKey;
        while (i.hasNext()) {
            LookupElement thisElement = (LookupElement)i.next();
            if (thisElement.isGroup()) {
                thisSelect.addGroup(thisElement.getDescription());
                continue;
            }
            if (thisElement.getEnabled() || !this.showDisabledFlag) {
                thisSelect.addItem(thisElement.getCode(), thisElement.getDescription());
                if (thisElement.getDefaultItem()) {
                    lookupDefault = thisElement.getCode();
                }
            } else if (thisElement.getCode() == defaultKey) {
                thisSelect.addItem(thisElement.getCode(), thisElement.getDescription());
            }
            if (thisElement.getCode() != defaultKey) continue;
            keyFound = true;
        }
        if (keyFound) {
            thisSelect.setDefaultKey(defaultKey);
        } else {
            thisSelect.setDefaultKey(lookupDefault);
        }
        return thisSelect;
    }

    public String getHtmlSelect(String selectName, String defaultValue) {
        return this.getHtmlSelect(selectName, defaultValue, false);
    }

    public String getHtmlSelect(String selectName, String defaultValue, boolean disabled) {
        HtmlSelect thisSelect = new HtmlSelect();
        thisSelect.setSelectSize(this.selectSize);
        thisSelect.setSelectStyle(this.selectStyle);
        thisSelect.setJsEvent(this.jsEvent);
        thisSelect.setDisabled(disabled);
        Iterator i = this.iterator();
        boolean keyFound = false;
        String lookupDefault = null;
        while (i.hasNext()) {
            LookupElement thisElement = (LookupElement)i.next();
            if (thisElement.isGroup()) {
                thisSelect.addGroup(thisElement.getDescription());
                continue;
            }
            if (thisElement.getEnabled()) {
                thisSelect.addItem(thisElement.getCode(), thisElement.getDescription());
            } else if (thisElement.getDescription().equals(defaultValue)) {
                keyFound = true;
                thisSelect.addItem(thisElement.getCode(), thisElement.getDescription());
            }
            if (thisElement.getDescription().equals(defaultValue)) {
                keyFound = true;
            }
            if (!thisElement.getDefaultItem()) continue;
            lookupDefault = thisElement.getDescription();
        }
        return thisSelect.getHtml(selectName, defaultValue);
    }

    public String getHtmlSelect(String selectName, LookupList ms) {
        HtmlSelect thisSelect = new HtmlSelect();
        thisSelect.setSelectSize(this.selectSize);
        thisSelect.setSelectStyle(this.selectStyle);
        thisSelect.setJsEvent(this.jsEvent);
        thisSelect.setMultiple(this.multiple);
        thisSelect.setMultipleSelects(ms);
        Iterator i = this.iterator();
        boolean keyFound = false;
        String lookupDefault = null;
        while (i.hasNext()) {
            LookupElement thisElement = (LookupElement)i.next();
            if (thisElement.isGroup()) {
                thisSelect.addGroup(thisElement.getDescription());
                continue;
            }
            if (thisElement.getEnabled()) {
                thisSelect.addItem(thisElement.getCode(), thisElement.getDescription());
            }
            if (!thisElement.getDefaultItem()) continue;
            lookupDefault = thisElement.getDescription();
        }
        return thisSelect.getHtml(selectName);
    }

    public int getSelectedKey() {
        Iterator i = this.iterator();
        LookupElement keyFound = null;
        int x = 0;
        while (i.hasNext()) {
            LookupElement thisElement = (LookupElement)i.next();
            if (++x == 1) {
                keyFound = thisElement;
            }
            try {
                if (thisElement.getCode() == Integer.parseInt(this.defaultKey)) {
                    return thisElement.getCode();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!thisElement.getDefaultItem()) continue;
            keyFound = thisElement;
        }
        if (keyFound != null) {
            return keyFound.getCode();
        }
        return -1;
    }

    public String getSelectedValue(int selectedId) {
        Iterator i = this.iterator();
        LookupElement keyFound = null;
        while (i.hasNext()) {
            LookupElement thisElement = (LookupElement)i.next();
            if (thisElement.getCode() == selectedId) {
                return thisElement.getDescription();
            }
            if (!thisElement.getDefaultItem()) continue;
            keyFound = thisElement;
        }
        if (keyFound != null) {
            return keyFound.getDescription();
        }
        return "";
    }

    public String getSelectedValue(String selectedId) {
        try {
            return this.getSelectedValue(Integer.parseInt(selectedId));
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getValueFromId(int selectedId) {
        return this.getSelectedValue(selectedId);
    }

    public String getValueFromId(String selectedId) {
        return this.getSelectedValue(selectedId);
    }

    public LookupElement getObject(ResultSet rs) throws SQLException {
        LookupElement thisElement = new LookupElement(rs);
        return thisElement;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            LookupElement thisElement = this.getObject(rs);
            if (!thisElement.getEnabled() && this.showDisabledFlag && !this.hasItem(thisElement.getCode())) continue;
            this.add(thisElement);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlSelect = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM " + DatabaseUtils.getTableName(db, this.tableName) + " " + "WHERE code > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            this.pagedListInfo.doManualOffset(db, pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND description < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                if (this.pagedListInfo != null) {
                    this.pagedListInfo.doManualOffset(db, pst);
                }
                if ((rs = pst.executeQuery()).next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            if (this.pagedListInfo.getColumnToSortBy() == null || "".equals(this.pagedListInfo.getColumnToSortBy())) {
                this.pagedListInfo.setDefaultSort("enabled DESC," + DatabaseUtils.addQuotes(db, "level") + ",description", null);
            }
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY enabled DESC," + DatabaseUtils.addQuotes(db, "level") + ",description ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("lt.* FROM " + DatabaseUtils.getTableName(db, this.tableName) + " lt " + "WHERE code > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    public boolean containsKey(int key) {
        Iterator i = this.iterator();
        boolean keyFound = false;
        while (i.hasNext()) {
            LookupElement thisElement = (LookupElement)i.next();
            if (!thisElement.getEnabled() || thisElement.getCode() != key) continue;
            keyFound = true;
        }
        return keyFound;
    }

    public String valuesAsString() {
        Iterator i = this.iterator();
        String result = "";
        int count = 0;
        while (i.hasNext()) {
            LookupElement thisElement = (LookupElement)i.next();
            result = count > 0 ? result + ", " + thisElement.getDescription() : result + thisElement.getDescription();
            ++count;
        }
        return result;
    }

    public int getIdFromLevel(int level) {
        for (LookupElement thisElement : this) {
            if (thisElement.getLevel() != level) continue;
            return thisElement.getId();
        }
        return -1;
    }

    public int getIdFromValue(String value) {
        for (LookupElement thisElement : this) {
            if (!value.equals(thisElement.getDescription())) continue;
            return thisElement.getId();
        }
        return -1;
    }

    public int getLevelFromId(int id) {
        for (LookupElement thisElement : this) {
            if (thisElement.getCode() != id) continue;
            return thisElement.getLevel();
        }
        return -1;
    }

    public LookupElement get(String value) {
        for (LookupElement thisElement : this) {
            if (!value.equals(thisElement.getDescription())) continue;
            return thisElement;
        }
        return null;
    }

    public void printVals() {
        for (LookupElement thisElement : this) {
            System.out.println("Level: " + thisElement.getLevel() + ", Desc: " + thisElement.getDescription() + ", Code: " + thisElement.getCode());
        }
    }

    public void addItem(int tmp1, String tmp2) {
        if (!this.exists(tmp1)) {
            LookupElement thisElement = new LookupElement();
            thisElement.setCode(tmp1);
            thisElement.setDescription(tmp2);
            if (this.size() > 0) {
                this.add(0, thisElement);
            } else {
                this.add(thisElement);
            }
        }
    }

    public boolean exists(int tmp1) {
        for (LookupElement thisElement : this) {
            if (thisElement.getCode() != tmp1) continue;
            return true;
        }
        return false;
    }

    public void appendItem(int tmp1, String tmp2) {
        LookupElement thisElement = new LookupElement();
        thisElement.setCode(tmp1);
        thisElement.setDescription(tmp2);
        if (this.size() <= 0) {
            this.add(0, thisElement);
        } else {
            this.add(this.size(), thisElement);
        }
    }

    public void addGroup(String category) {
        LookupElement thisElement = new LookupElement();
        thisElement.setDescription(category);
        thisElement.setGroup(true);
        this.add(thisElement);
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND entered > ? ");
            }
            sqlFilter.append("AND entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND modified > ? ");
            sqlFilter.append("AND entered < ? ");
            sqlFilter.append("AND modified < ? ");
        }
        if (this.selectedItems != null) {
            if (this.selectedItems.size() > 0) {
                sqlFilter.append("AND (enabled = ? OR code IN (" + this.getItemsAsList() + ")) ");
            } else {
                sqlFilter.append("AND enabled = ? ");
            }
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.selectedItems != null) {
            pst.setBoolean(++i, true);
        }
        return i;
    }

    public boolean hasItem(int code) {
        return this.selectedItems == null || this.selectedItems.containsKey(new Integer(code));
    }

    private String getItemsAsList() {
        StringBuffer sb = new StringBuffer();
        if (this.selectedItems != null) {
            Iterator i = this.selectedItems.keySet().iterator();
            while (i.hasNext()) {
                sb.append(String.valueOf((Integer)i.next()));
                if (!i.hasNext()) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public int getDefaultElementCode() {
        int result = -1;
        for (LookupElement thisElement : this) {
            if (thisElement.getDefaultItem()) {
                return thisElement.getCode();
            }
            if (result != -1) continue;
            result = thisElement.getCode();
        }
        return result;
    }

    public int removeElementByLevel(int level) {
        int result = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            LookupElement thisElement = (LookupElement)i.next();
            if (thisElement.getLevel() != level) continue;
            i.remove();
            ++result;
        }
        return result;
    }

    public boolean hasCode(int code) {
        for (LookupElement thisElement : this) {
            if (thisElement.getCode() != code) continue;
            return true;
        }
        return false;
    }

    public static int retrieveMaxLevel(Connection db, int tmpCategoryId) throws SQLException {
        int maxLevel = 0;
        PreparedStatement pst = db.prepareStatement("SELECT MAX(" + DatabaseUtils.addQuotes(db, "level") + ") AS max_level " + "FROM lookup_lists_lookup " + "WHERE module_id = ? ");
        pst.setInt(1, tmpCategoryId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            maxLevel = rs.getInt("max_level");
        }
        rs.close();
        pst.close();
        return maxLevel;
    }
}

