/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.contacts.base.ContactTypeList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.LookupList;

public class LookupListElement {
    protected int id = -1;
    protected int moduleId = -1;
    protected int categoryId = -1;
    protected int lookupId = -1;
    protected String tableName = null;
    protected String className = null;
    protected int level = 0;
    protected String description = "";
    protected Timestamp entered = null;
    protected LookupList lookupList = null;

    public LookupListElement(Connection db, int moduleId, int lookupId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM lookup_lists_lookup WHERE module_id = ? AND lookup_id = ? ");
        pst.setInt(1, moduleId);
        pst.setInt(2, lookupId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public LookupListElement(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public LookupListElement() {
    }

    public int getId() {
        return this.id;
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    public void setCategoryId(int categoryId) {
        this.categoryId = categoryId;
    }

    public void setLookupId(int lookupId) {
        this.lookupId = lookupId;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public void setLookupList(LookupList lookupList) {
        this.lookupList = lookupList;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public LookupList getLookupList() {
        return this.lookupList;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public int getLookupId() {
        return this.lookupId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDescription() {
        return this.description;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void buildLookupList(SystemStatus thisSystem, Connection db, int userId) throws SQLException {
        if (this.className.equals("lookupList")) {
            this.setLookupList(new LookupList(db, this.getTableName()));
        } else if (this.className.equals("contactType")) {
            ContactTypeList contactTypeList = new ContactTypeList();
            contactTypeList.setIncludeDefinedByUser(userId);
            contactTypeList.setCategory(this.categoryId == 1 ? 1 : 0);
            contactTypeList.buildList(db);
            this.setLookupList(contactTypeList.getLookupList(thisSystem, "list", 0));
        } else {
            throw new SQLException("LookupListElement class name not found: " + this.className);
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.moduleId = rs.getInt("module_id");
        this.lookupId = rs.getInt("lookup_id");
        this.className = rs.getString("class_name");
        this.tableName = rs.getString("table_name");
        this.level = rs.getInt("level");
        this.description = rs.getString("description");
        this.entered = rs.getTimestamp("entered");
        this.categoryId = rs.getInt("category_id");
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "lookup_lists_lookup_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO lookup_lists_lookup (" + (this.id > -1 ? "id, " : "") + "module_id, lookup_id, class_name, table_name, " + DatabaseUtils.addQuotes(db, "level") + ", description, category_id) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.moduleId);
        pst.setInt(++i, this.lookupId);
        pst.setString(++i, this.className);
        pst.setString(++i, this.tableName);
        pst.setInt(++i, this.level);
        pst.setString(++i, this.description);
        pst.setInt(++i, this.categoryId);
        pst.executeUpdate();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "lookup_lists_lookup_id_seq", this.id);
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM lookup_lists_lookup WHERE id = ? ");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
    }
}

