/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupListElement;

public class LookupListList
extends HtmlSelect {
    protected int moduleId = -1;
    protected int userId;

    public LookupListList() {
    }

    public LookupListList(SystemStatus thisSystem, Connection db, int moduleId) throws SQLException {
        this.moduleId = moduleId;
        this.buildList(thisSystem, db);
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public void buildList(SystemStatus thisSystem, Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT * FROM lookup_lists_lookup WHERE module_id = ? ORDER BY " + DatabaseUtils.addQuotes(db, "level") + " ");
        pst.setInt(1, this.moduleId);
        rs = pst.executeQuery();
        while (rs.next()) {
            LookupListElement thisElement = new LookupListElement(rs);
            this.add(thisElement);
        }
        rs.close();
        pst.close();
        for (LookupListElement thisLookup : this) {
            thisLookup.buildLookupList(thisSystem, db, this.userId);
        }
    }

    public void removeList(int categoryId, int lookupId) {
        for (LookupListElement thisLookup : this) {
            if (thisLookup.getCategoryId() != categoryId || thisLookup.getLookupId() != lookupId) continue;
            this.remove(thisLookup);
            break;
        }
    }
}

