/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.UserUtils;
import org.aspcfs.utils.web.HtmlSelect;

public class PagedListInfo
implements Serializable {
    public static String allowed = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.,0123456789_";
    public String[] lettersArray = new String[]{"0", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public static final int DEFAULT_ITEMS_PER_PAGE = 10;
    public static final int LIST_VIEW = 1;
    public static final int DETAILS_VIEW = 2;
    private int mode = 1;
    private String link = "";
    private String id = null;
    private String columnToSortBy = null;
    private String sortOrder = null;
    private String orderByStatement = null;
    private int itemsPerPage = 10;
    private int maxRecords = 0;
    private String currentLetter = "";
    private int currentOffset = 0;
    private int previousOffset = 0;
    private String listView = null;
    private HashMap listFilters = new HashMap();
    private boolean enableJScript = false;
    private boolean showForm = true;
    private boolean resetList = true;
    private String alternateSort = null;
    private HashMap savedCriteria = new HashMap();
    private String parentFieldType = "";
    private String parentFormName = "";
    private boolean expandedSelection = false;
    private boolean scrollReload = false;
    private boolean isValid = false;
    private String namespace = "";
    private HashMap renderParameters = null;

    public int getMode() {
        return this.mode;
    }

    public void setMode(int tmp) {
        if (this.mode == 1 && tmp == 2) {
            this.previousOffset = this.currentOffset;
        }
        if (this.mode == 2 && tmp == 1) {
            this.currentOffset = this.previousOffset;
        }
        this.mode = tmp;
    }

    public void setColumnToSortBy(String tmp) {
        this.columnToSortBy = tmp;
    }

    public void setEnableJScript(boolean enableJScript) {
        this.enableJScript = enableJScript;
    }

    public void setSortOrder(String tmp) {
        this.sortOrder = tmp;
    }

    public void setShowForm(boolean showForm) {
        this.showForm = showForm;
    }

    public void setResetList(boolean resetList) {
        this.resetList = resetList;
    }

    public void setIsValid(boolean tmp) {
        this.isValid = tmp;
    }

    public void setIsValid(String tmp) {
        this.isValid = DatabaseUtils.parseBoolean(tmp);
    }

    public void setLettersArray(String[] tmp) {
        this.lettersArray = tmp;
    }

    public String[] getLettersArray() {
        return this.lettersArray;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public boolean getExpandedSelection() {
        return this.expandedSelection;
    }

    public void setExpandedSelection(boolean expandedSelection) {
        this.expandedSelection = expandedSelection;
        this.setItemsPerPage(10);
    }

    public boolean getScrollReload() {
        return this.scrollReload;
    }

    public void setScrollReload(boolean tmp) {
        this.scrollReload = tmp;
    }

    public void setItemsPerPage(int tmp) {
        if (tmp > this.itemsPerPage || tmp == -1) {
            this.resetList();
        }
        this.itemsPerPage = tmp;
    }

    public HashMap getSavedCriteria() {
        return this.savedCriteria;
    }

    public void setSavedCriteria(HashMap savedCriteria) {
        this.savedCriteria = savedCriteria;
    }

    public void setParentFieldType(String parentFieldType) {
        this.parentFieldType = parentFieldType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParentFormName(String parentFormName) {
        this.parentFormName = parentFormName;
    }

    public String getParentFormName() {
        return this.parentFormName;
    }

    public String getParentFieldType() {
        return this.parentFieldType;
    }

    public String getAlternateSort() {
        return this.alternateSort;
    }

    public void setAlternateSort(String alternateSort) {
        this.alternateSort = alternateSort;
    }

    public void setItemsPerPage(String tmp) {
        try {
            this.setItemsPerPage(Integer.parseInt(tmp));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLink(String tmp) {
        this.link = tmp;
    }

    public String getLink() {
        return this.link;
    }

    public void setMaxRecords(int tmp) {
        this.maxRecords = tmp;
        if (System.getProperty("DEBUG") != null) {
            System.out.println("PagedListInfo-> Records in table: " + this.maxRecords);
        }
        if (this.maxRecords <= this.currentOffset && this.maxRecords > 0 && this.getItemsPerPage() != -1) {
            this.currentOffset = this.maxRecords;
            while (this.currentOffset % this.getItemsPerPage() > 0 && this.currentOffset > 0) {
                --this.currentOffset;
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("PagedListInfo-> Offset reduced to: " + this.currentOffset);
            }
            if (this.currentOffset == this.maxRecords) {
                this.currentOffset -= this.getItemsPerPage();
            }
        }
    }

    public void setCurrentLetter(String tmp) {
        this.currentLetter = tmp;
    }

    public void setCurrentOffset(int tmp) {
        this.currentOffset = tmp < 0 ? 0 : tmp;
    }

    public void setCurrentOffset(String tmp) {
        try {
            this.setCurrentOffset(Integer.parseInt(tmp));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setListView(String tmp) {
        this.listView = tmp;
    }

    public void setDefaultListView(String tmp) {
        if (this.listView == null) {
            this.listView = tmp;
        }
    }

    public boolean setParameters(ActionContext context) {
        return this.setParameters(context.getRequest());
    }

    public boolean setParameters(HttpServletRequest request) {
        String thisFilter;
        String tmpListView;
        String tmpCurrentLetter;
        String tmpItemsPerPage;
        String tmpCurrentPage;
        String tmpColumnToSortBy;
        if (!(request.getParameter("pagedListInfoId") == null || request.getParameter("pagedListInfoId").equals("") || this.getId() == null || "".equals(this.getId().trim()) || request.getParameter("pagedListInfoId").equals("null") || request.getParameter("pagedListInfoId").equals(this.getId()))) {
            return false;
        }
        Enumeration parameters = request.getParameterNames();
        boolean reset = false;
        String tmpSortOrder = request.getParameter("order");
        if (tmpSortOrder != null && PagedListInfo.checkAllowed(tmpSortOrder)) {
            this.setSortOrder(tmpSortOrder);
        }
        if ((tmpColumnToSortBy = request.getParameter("column")) != null) {
            if (this.columnToSortBy != null) {
                if (tmpColumnToSortBy.equals(this.columnToSortBy)) {
                    if (this.sortOrder == null) {
                        this.setSortOrder("desc");
                    } else {
                        this.setSortOrder(null);
                    }
                } else if (this.sortOrder != null && this.sortOrder.equals("desc")) {
                    this.setSortOrder(null);
                }
            }
            if (PagedListInfo.checkAllowed(tmpColumnToSortBy)) {
                this.setColumnToSortBy(tmpColumnToSortBy);
            }
        }
        if ((tmpCurrentPage = request.getParameter("page")) != null) {
            try {
                if (this.getItemsPerPage() == -1) {
                    throw new NumberFormatException("All records in one page");
                }
                this.setCurrentOffset((Integer.parseInt(tmpCurrentPage) - 1) * this.getItemsPerPage());
            }
            catch (NumberFormatException e) {
                this.setCurrentOffset(0);
            }
        }
        if ((tmpItemsPerPage = request.getParameter("items")) != null) {
            this.setItemsPerPage(tmpItemsPerPage);
        }
        if ((tmpCurrentLetter = request.getParameter("letter")) != null) {
            this.setCurrentLetter(tmpCurrentLetter);
            this.setColumnToSortBy(null);
            this.setSortOrder(null);
        } else {
            this.setCurrentLetter("");
        }
        String tmpCurrentOffset = request.getParameter("offset");
        if (tmpCurrentOffset != null) {
            this.setCurrentOffset(tmpCurrentOffset);
        }
        if ((tmpListView = request.getParameter("listView")) != null) {
            if (this.listView != null && !this.listView.equals(tmpListView)) {
                this.resetList();
            }
            this.setListView(tmpListView);
        }
        int filter = 0;
        while (request.getParameter("listFilter" + ++filter) != null) {
            String tmpListFilter = request.getParameter("listFilter" + filter);
            this.addFilter(filter, tmpListFilter);
        }
        if (request.getParameter("listFilter2") != null && filter < 2) {
            thisFilter = request.getParameter("listFilter2");
            this.addFilter(2, thisFilter);
        }
        if (request.getParameter("listFilter1") != null && this.resetList) {
            thisFilter = request.getParameter("listFilter1");
            if (this.listFilters.get("listFilter1") != null && !thisFilter.equals(this.listFilters.get("listFilter1"))) {
                this.resetList();
            }
        }
        while (parameters.hasMoreElements()) {
            String param = (String)parameters.nextElement();
            if (!param.startsWith("search")) continue;
            if (!reset) {
                this.getSavedCriteria().clear();
                reset = true;
            }
            this.getSavedCriteria().put(param, request.getParameter(param));
        }
        return true;
    }

    public boolean setSearchCriteria(Object obj, ActionContext context) {
        SystemStatus systemStatus = null;
        ConnectionElement ce = null;
        if (context != null) {
            ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        }
        if (ce != null) {
            systemStatus = (SystemStatus)((Hashtable)context.getSession().getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        }
        return this.setSearchCriteria(obj, context.getRequest(), systemStatus);
    }

    public boolean setSearchCriteria(Object obj, HttpServletRequest request, SystemStatus systemStatus) {
        return this.setSearchCriteria(obj, request, systemStatus, UserUtils.getUserLocale(request));
    }

    public boolean setSearchCriteria(Object obj, HttpServletRequest request, SystemStatus systemStatus, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!this.getSavedCriteria().isEmpty()) {
            for (String tempKey : this.getSavedCriteria().keySet()) {
                boolean modified;
                Timestamp tmpTimestamp;
                if (this.getCriteriaValue(tempKey) == null || this.getCriteriaValue(tempKey).trim().equals("")) continue;
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("PagedListInfo-> Setting: " + tempKey + "=" + this.getCriteriaValue(tempKey));
                }
                if (tempKey.startsWith("searchcode")) {
                    ObjectUtils.setParam(obj, tempKey.substring(10), this.getCriteriaValue(tempKey));
                    continue;
                }
                if (tempKey.startsWith("searchdate")) {
                    tmpTimestamp = DateUtils.getUserToServerDateTime(null, 3, 1, this.getCriteriaValue(tempKey), locale);
                    if (tmpTimestamp != null) {
                        modified = false;
                        Date tmpDate = new Date(tmpTimestamp.getTime());
                        modified = ObjectUtils.setParam(obj, tempKey.substring(10), tmpDate);
                        if (!modified && this.getCriteriaValue(tempKey) != null && !"".equals(this.getCriteriaValue(tempKey))) {
                            this.isValid = false;
                            PagedListInfo.addError(obj, "getErrors", tempKey, systemStatus);
                        }
                    }
                    if (tmpTimestamp != null || this.getCriteriaValue(tempKey) == null || "".equals(this.getCriteriaValue(tempKey))) continue;
                    this.isValid = false;
                    PagedListInfo.addError(obj, "getErrors", tempKey, systemStatus);
                    continue;
                }
                if (tempKey.startsWith("searchtimestamp")) {
                    tmpTimestamp = DateUtils.getUserToServerDateTime(null, 3, 1, this.getCriteriaValue(tempKey), locale);
                    if (tmpTimestamp != null) {
                        modified = false;
                        modified = ObjectUtils.setParam(obj, tempKey.substring(15), tmpTimestamp);
                        if (!modified && this.getCriteriaValue(tempKey) != null && !"".equals(this.getCriteriaValue(tempKey))) {
                            this.isValid = false;
                            PagedListInfo.addError(obj, "getErrors", tempKey, systemStatus);
                        }
                    }
                    if (tmpTimestamp != null || this.getCriteriaValue(tempKey) == null || "".equals(this.getCriteriaValue(tempKey))) continue;
                    this.isValid = false;
                    PagedListInfo.addError(obj, "getErrors", tempKey, systemStatus);
                    continue;
                }
                if (tempKey.startsWith("searchgroup")) {
                    String[] words = this.getCriteriaValue(tempKey).split(",");
                    for (int i = 0; i < words.length; ++i) {
                        words[i] = "%" + words[i] + "%";
                    }
                    ObjectUtils.setParam(obj, tempKey.substring(11), words);
                    continue;
                }
                ObjectUtils.setParam(obj, tempKey.substring(6), "%" + this.getCriteriaValue(tempKey) + "%");
            }
        }
        return true;
    }

    private static void addError(Object obj, String param, String field, SystemStatus systemStatus) {
        try {
            Method method = obj.getClass().getMethod(param, null);
            if (systemStatus == null) {
                ((HashMap)method.invoke(obj, (Object[])null)).put(field.substring(0, 1).toLowerCase() + field.substring(1) + "Error", "Invalid Date");
            } else {
                ((HashMap)method.invoke(obj, (Object[])null)).put(field.substring(0, 1).toLowerCase() + field.substring(1) + "Error", systemStatus.getLabel("object.validation.incorrectDateFormat"));
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("PagedListInfo-> Adding an error: " + field + "Error");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSearchOptionValue(String field) {
        if (this.getSavedCriteria() != null && this.getSavedCriteria().get(field) != null) {
            return (String)this.savedCriteria.get(field);
        }
        return "";
    }

    public int getSearchOptionValueAsInt(String field) {
        if (this.getSavedCriteria() != null && this.getSavedCriteria().get(field) != null) {
            return Integer.parseInt((String)this.savedCriteria.get(field));
        }
        return -1;
    }

    public void setDefaultSort(String column, String order) {
        if (!this.hasSortConfigured()) {
            this.setColumnToSortBy(column);
            this.setSortOrder(order);
        }
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setRenderParameters(HashMap renderParameters) {
        this.renderParameters = renderParameters;
    }

    public String getColumnToSortBy() {
        return this.columnToSortBy;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public int getItemsPerPage() {
        if (this.mode == 2) {
            return 1;
        }
        return this.itemsPerPage;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public String getCurrentLetter() {
        return this.currentLetter;
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public boolean getEnableJScript() {
        return this.enableJScript;
    }

    public String getNumericalPageLinks() {
        int numPages = this.getNumberOfPages();
        StringBuffer links = new StringBuffer();
        links.append(numPages + " page" + (numPages == 1 ? "" : "s") + " in this view ");
        if (numPages > 1) {
            links.append("[");
            for (int i = 1; i < numPages + 1; ++i) {
                if ((i - 1) * this.getItemsPerPage() == this.currentOffset) {
                    links.append(" <b>" + i + "</b> ");
                    continue;
                }
                links.append("<a href=\"" + this.link + "&offset=" + (i - 1) * this.getItemsPerPage() + "\"> " + i + " </a>");
            }
            links.append("]");
        }
        return links.toString();
    }

    public String getListPropertiesHeader(String formName) {
        if (this.showForm) {
            if (this.expandedSelection) {
                this.link = this.link + "&pagedListSectionId=" + this.id;
            }
            return "<form name=\"" + formName + "\" action=\"" + this.link + "\" method=\"post\">";
        }
        return "";
    }

    public String getListPropertiesFooter() {
        if (this.showForm) {
            return "</form>";
        }
        return "";
    }

    public String getNumericalPageEntry() {
        return "<input type=\"text\" name=\"page\" value=\"" + (this.getItemsPerPage() != -1 ? this.currentOffset / this.getItemsPerPage() + 1 : 1) + "\" size=\"3\">";
    }

    public String getItemsPerPageEntry(String allLabel) {
        HtmlSelect itemSelect = new HtmlSelect();
        itemSelect.addItem("6");
        itemSelect.addItem("10");
        itemSelect.addItem("12");
        itemSelect.addItem("20");
        itemSelect.addItem("30");
        itemSelect.addItem("50");
        itemSelect.addItem("100");
        itemSelect.addItem("-1", allLabel);
        itemSelect.setJsEvent("onChange='submit();'");
        return itemSelect.getHtml("items", this.getItemsPerPage());
    }

    public int getNumberOfPages() {
        if (this.getItemsPerPage() != -1) {
            return (int)Math.ceil((double)this.maxRecords / (double)this.getItemsPerPage());
        }
        return 1;
    }

    public String getAlphabeticalPageLinks() {
        StringBuffer links = new StringBuffer();
        for (int i = 0; i < this.lettersArray.length; ++i) {
            String thisLetter = this.lettersArray[i];
            if (thisLetter.equals(this.currentLetter)) {
                links.append(" <b>" + thisLetter + "</b> ");
                continue;
            }
            links.append("<a href='" + this.link + "&letter=" + thisLetter + "'> " + thisLetter + " </a>");
        }
        return links.toString();
    }

    public String getAlphabeticalPageLinks(String javaScript, String formName) {
        StringBuffer links = new StringBuffer();
        for (int i = 0; i < this.lettersArray.length; ++i) {
            String thisLetter = this.lettersArray[i];
            if (thisLetter.equals(this.currentLetter)) {
                links.append(" <b>" + thisLetter + "</b> ");
                continue;
            }
            links.append("<a href=\"javascript:" + javaScript + "('letter','" + thisLetter + "','" + formName + "');\"> " + thisLetter + " </a>");
        }
        return links.toString();
    }

    public String getPreviousPageLink() {
        return this.getPreviousPageLink("&laquo;");
    }

    public String getPreviousPageLink(String linkInfo) {
        return this.getPreviousPageLink(linkInfo, linkInfo);
    }

    public String getPreviousPageLink(String linkOn, String linkOff) {
        return this.getPreviousPageLink(linkOn, linkOff, "0");
    }

    public String getPreviousPageLink(String linkOn, String linkOff, String formName) {
        return this.getPreviousPageLink(linkOn, linkOff, "0", null);
    }

    public String getPreviousPageLink(String linkOn, String linkOff, String formName, RenderResponse response) {
        StringBuffer result = new StringBuffer();
        if (this.currentOffset > 0 && this.getItemsPerPage() != -1) {
            int newOffset = this.currentOffset - this.getItemsPerPage();
            String scrollStart = "";
            String scrollEnd = "";
            if (this.scrollReload) {
                scrollStart = "javascript:scrollReload('";
                scrollEnd = "');";
            }
            if (!this.getEnableJScript()) {
                String thisLink = null;
                if (response == null) {
                    thisLink = this.link + "&pagedListInfoId=" + this.getId() + (this.getExpandedSelection() ? "&pagedListSectionId=" + this.getId() : "") + "&offset=" + (newOffset > 0 ? newOffset : 0);
                } else {
                    PortletURL renderURL = response.createRenderURL();
                    HashMap params = (HashMap)this.renderParameters.clone();
                    params.put("pagedListInfoId", new String[]{this.getId()});
                    params.put("pagedListSectionId", new String[]{this.getId()});
                    params.put("offset", new String[]{String.valueOf(newOffset > 0 ? newOffset : 0)});
                    params.put("page", new String[]{String.valueOf(newOffset > 0 ? newOffset % 10 : 0)});
                    renderURL.setParameters((Map)params);
                    thisLink = renderURL.toString();
                }
                result.append("<a href=\"" + scrollStart + thisLink + scrollEnd + "\">" + linkOn + "</a>");
                return result.toString();
            }
            result.append("<a href=\"javascript:offsetsubmit('" + formName + "','" + (newOffset > 0 ? newOffset : 0) + "');\">" + linkOn + "</a>");
            return result.toString();
        }
        return linkOff;
    }

    public String getNextPageLink() {
        return this.getNextPageLink("&raquo;");
    }

    public String getNextPageLink(String linkInfo) {
        return this.getNextPageLink(linkInfo, linkInfo);
    }

    public String getNextPageLink(String linkOn, String linkOff) {
        return this.getNextPageLink(linkOn, linkOff, "0");
    }

    public String getNextPageLink(String linkOn, String linkOff, String formName) {
        return this.getNextPageLink(linkOn, linkOff, "0", null);
    }

    public String getNextPageLink(String linkOn, String linkOff, String formName, RenderResponse response) {
        StringBuffer result = new StringBuffer();
        if (this.currentOffset + this.getItemsPerPage() < this.maxRecords && this.getItemsPerPage() != -1) {
            String scrollStart = "";
            String scrollEnd = "";
            if (this.scrollReload) {
                scrollStart = "javascript:scrollReload('";
                scrollEnd = "');";
            }
            if (!this.getEnableJScript()) {
                String thisLink = null;
                if (response == null) {
                    thisLink = this.link + "&pagedListInfoId=" + this.getId() + (this.getExpandedSelection() ? "&pagedListSectionId=" + this.getId() : "") + "&offset=" + (this.currentOffset + this.getItemsPerPage());
                } else {
                    PortletURL renderURL = response.createRenderURL();
                    HashMap params = (HashMap)this.renderParameters.clone();
                    params.put("pagedListInfoId", new String[]{this.getId()});
                    params.put("pagedListSectionId", new String[]{this.getId()});
                    params.put("offset", new String[]{String.valueOf(this.currentOffset + this.getItemsPerPage())});
                    renderURL.setParameters((Map)params);
                    thisLink = renderURL.toString();
                }
                result.append("<a href=\"" + scrollStart + thisLink + scrollEnd + "\">" + linkOn + "</a>");
                return result.toString();
            }
            result.append("<a href=\"javascript:offsetsubmit('" + formName + "','" + (this.currentOffset + this.getItemsPerPage()) + "');\">" + linkOn + "</a>");
            return result.toString();
        }
        return linkOff;
    }

    public String getExpandLink(String expandLink, String collapseLink) {
        if (!this.expandedSelection) {
            return "<a href=\"" + this.link + "&pagedListInfoId=" + this.getId() + "&pagedListSectionId=" + this.getId() + "\">" + expandLink + "</a>";
        }
        return "<a href=\"" + this.link + "&resetList=true&pagedListInfoId=" + this.getId() + "\">" + collapseLink + "</a>";
    }

    public String getExpandLink(String expandLink, String collapseLink, String tmpParams) {
        if (!this.expandedSelection) {
            return "<a href=\"" + this.link + "&pagedListInfoId=" + this.getId() + "&pagedListSectionId=" + this.getId() + tmpParams + "\">" + expandLink + "</a>";
        }
        return "<a href=\"" + this.link + "&resetList=true&pagedListInfoId=" + this.getId() + tmpParams + "\">" + collapseLink + "</a>";
    }

    public String getSortIcon(String columnName) {
        if (columnName.equals(this.columnToSortBy)) {
            if (this.sortOrder != null && this.sortOrder.indexOf("desc") > -1) {
                return "<img border=0 src=\"images/layout/sort-dn.gif\" align=\"bottom\" width=\"12\" height=\"10\" />";
            }
            return "<img border=0 src=\"images/layout/sort-up.gif\" align=\"bottom\" width=\"12\" height=\"10\" />";
        }
        return "";
    }

    public String getListView() {
        return this.listView;
    }

    public String getOptionValue(String tmp) {
        return "value=\"" + tmp + "\"" + (tmp.equals(this.listView) ? " selected" : "");
    }

    public String getFilterOption(String filterName, String tmp) {
        String current = (String)this.listFilters.get(filterName);
        return "value=\"" + tmp + "\"" + (tmp.equals(current) ? " selected" : "");
    }

    public String getFilterValue(String tmp) {
        return (String)this.listFilters.get(tmp);
    }

    public String getCriteriaValue(String tmp) {
        return (String)this.savedCriteria.get(tmp);
    }

    public int getFilterKey(String tmp) {
        try {
            return Integer.parseInt((String)this.listFilters.get(tmp));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getRefreshTag(String tmp) {
        return "<a href=\"" + this.link + "\"> " + tmp + " </a>";
    }

    public void addFilter(int param, String value) {
        this.listFilters.put("listFilter" + param, value);
    }

    public boolean hasLink() {
        return this.link != null && !"".equals(this.link.trim());
    }

    public boolean hasListFilters() {
        return this.listFilters.size() > 0;
    }

    public boolean hasSortConfigured() {
        return this.getColumnToSortBy() != null && !"".equals(this.getColumnToSortBy());
    }

    public boolean hasSortOrderConfigured() {
        return this.getSortOrder() != null && !"".equals(this.getSortOrder());
    }

    public void appendSqlSelectHead(Connection db, StringBuffer sqlStatement) {
        if (DatabaseUtils.getType(db) == 2 && this.getItemsPerPage() > 0) {
            int x = this.getItemsPerPage() + this.getCurrentOffset();
            sqlStatement.append("SELECT TOP " + x + " ");
        } else if (DatabaseUtils.getType(db) == 3 && this.getItemsPerPage() > 0) {
            sqlStatement.append("SELECT * FROM (SELECT ");
        } else if (DatabaseUtils.getType(db) == 6 && this.getItemsPerPage() > 0) {
            sqlStatement.append("SELECT * FROM (SELECT ROW_NUMBER() OVER (" + this.orderByStatement + ") AS db_row, ");
        } else if (DatabaseUtils.getType(db) == 4 && this.getItemsPerPage() > 0) {
            sqlStatement.append("SELECT FIRST " + this.getItemsPerPage() + " ");
            sqlStatement.append("SKIP " + this.getCurrentOffset() + " ");
        } else if (DatabaseUtils.getType(db) == 5 && this.getItemsPerPage() > 0) {
            int x = this.getItemsPerPage() + this.getCurrentOffset();
            sqlStatement.append("SELECT TOP (" + x + ") ");
        } else {
            sqlStatement.append("SELECT ");
        }
    }

    public void appendSqlTail(Connection db, StringBuffer appendedSqlStatement) {
        StringBuffer sqlStatement = new StringBuffer();
        sqlStatement.append("ORDER BY ");
        if (this.getColumnToSortBy().indexOf(",") > -1) {
            StringTokenizer st = new StringTokenizer(this.getColumnToSortBy(), ",");
            while (st.hasMoreTokens()) {
                String column = st.nextToken();
                sqlStatement.append(DatabaseUtils.parseReservedWord(db, column) + " ");
                if (this.hasSortOrderConfigured()) {
                    sqlStatement.append(this.getSortOrder() + " ");
                }
                if (!st.hasMoreTokens()) continue;
                sqlStatement.append(",");
            }
        } else {
            sqlStatement.append(DatabaseUtils.parseReservedWord(db, this.getColumnToSortBy()) + " ");
            if (this.hasSortOrderConfigured()) {
                sqlStatement.append(this.getSortOrder() + " ");
            }
        }
        this.orderByStatement = sqlStatement.toString();
        if (DatabaseUtils.getType(db) == 1) {
            if (this.getItemsPerPage() > 0) {
                sqlStatement.append("LIMIT " + this.getItemsPerPage() + " ");
            }
            sqlStatement.append("OFFSET " + this.getCurrentOffset() + " ");
        } else if (DatabaseUtils.getType(db) == 9 && this.getItemsPerPage() > 0) {
            sqlStatement.append(" ROWS " + this.getCurrentOffset() + " TO " + (this.getItemsPerPage() + this.getCurrentOffset()));
        } else if (DatabaseUtils.getType(db) == 3) {
            if (this.getItemsPerPage() > 0) {
                sqlStatement.append(") WHERE ROWNUM <= " + (this.getCurrentOffset() + this.getItemsPerPage()) + " ");
            }
        } else if (DatabaseUtils.getType(db) == 6) {
            if (this.getItemsPerPage() > 0) {
                sqlStatement.append("FETCH FIRST " + (this.getItemsPerPage() + this.getCurrentOffset()) + " ROWS ONLY) AS db_row_numbers " + "WHERE db_row > " + this.getCurrentOffset() + " AND db_row <= " + (this.getCurrentOffset() + this.getItemsPerPage()) + " ");
            }
        } else if (DatabaseUtils.getType(db) == 7 && this.getItemsPerPage() > 0) {
            sqlStatement.append("LIMIT " + this.getCurrentOffset() + "," + this.getItemsPerPage() + " ");
        }
        appendedSqlStatement.append(sqlStatement);
    }

    public void doManualOffset(Connection db, ResultSet rs) throws SQLException {
        if (this.getItemsPerPage() > 0) {
            DatabaseUtils.skipRowsManual(db, rs, this.getCurrentOffset());
        }
    }

    public void doManualOffset(Connection db, PreparedStatement pst) throws SQLException {
        if (this.getItemsPerPage() > 0) {
            DatabaseUtils.doManualLimit(db, pst, this.getCurrentOffset() + this.getItemsPerPage());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("===================================================\r\n");
        sb.append("Link: " + this.link + "\r\n");
        sb.append("Sort Column: " + this.columnToSortBy + "\r\n");
        sb.append("SOrt Order: " + this.sortOrder + "\r\n");
        sb.append("Items per page: " + this.getItemsPerPage() + "\r\n");
        sb.append("Total record count: " + this.maxRecords + "\r\n");
        sb.append("Current offset letter: " + this.currentLetter + "\r\n");
        sb.append("Current offset record: " + this.currentOffset + "\r\n");
        sb.append("List View: " + this.listView + "\r\n");
        return sb.toString();
    }

    private void resetList() {
        this.setCurrentLetter("");
        this.setCurrentOffset(0);
        this.previousOffset = 0;
    }

    public int getPageSize() {
        if (this.currentOffset + this.getItemsPerPage() < this.maxRecords && this.getItemsPerPage() != -1) {
            return this.currentOffset + this.getItemsPerPage();
        }
        return this.maxRecords;
    }

    private static boolean checkAllowed(String in) {
        if (in == null || in.length() == 0) {
            return true;
        }
        for (int i = 0; i < in.length(); ++i) {
            if (allowed.indexOf(in.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }
}

