/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils.web;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.CountrySelect;
import org.aspcfs.utils.web.HtmlSelect;

public class StateSelect
extends LinkedHashMap {
    SystemStatus systemStatus = null;
    public boolean buildAll = false;
    public String countries = null;
    public String jsEvent = null;
    public HashMap previousStates = new HashMap();

    public StateSelect() {
    }

    public StateSelect(boolean buildAll) {
        this.setBuildAll(buildAll);
        this.addStates();
    }

    public StateSelect(String countries) {
        if (countries != null) {
            this.setCountries(countries);
        } else {
            this.setCountries("");
        }
        this.addStates();
    }

    public StateSelect(SystemStatus systemStatus) {
        this.setSystemStatus(systemStatus);
    }

    public StateSelect(SystemStatus systemStatus, boolean buildAll) {
        this.setSystemStatus(systemStatus);
        this.setBuildAll(buildAll);
        this.addStates();
    }

    public StateSelect(SystemStatus systemStatus, String countries) {
        this.setSystemStatus(systemStatus);
        if (countries != null) {
            this.setCountries(countries);
        } else {
            this.setCountries("");
        }
        this.addStates();
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public boolean getBuildAll() {
        return this.buildAll;
    }

    public void setBuildAll(boolean tmp) {
        this.buildAll = tmp;
    }

    public void setBuildAll(String tmp) {
        this.buildAll = DatabaseUtils.parseBoolean(tmp);
    }

    public String getCountries() {
        return this.countries;
    }

    public void setCountries(String tmp) {
        this.countries = tmp;
    }

    public void addCountry(String tmp) {
        this.countries = new StringBuffer(this.countries + "," + tmp).toString();
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public HashMap getPreviousStates() {
        return this.previousStates;
    }

    public void setPreviousStates(HashMap tmp) {
        this.previousStates = tmp;
    }

    private void addStates() {
        LinkedHashMap states = new LinkedHashMap();
        if (CountrySelect.getCountryByAbbreviation(this.countries.trim().toUpperCase()).indexOf("UNITED STATES") != -1 || this.buildAll) {
            this.addUnitedStates(states);
            this.put("UNITED STATES", states);
        }
        if (CountrySelect.getCountryByAbbreviation(this.countries.trim().toUpperCase()).indexOf("CANADA") != -1 || this.buildAll) {
            states = new LinkedHashMap();
            this.addCanadianStates(states);
            this.put("CANADA", states);
        }
        if (CountrySelect.getCountryByAbbreviation(this.countries.trim().toUpperCase()).indexOf("INDIA") != -1 || this.buildAll) {
            states = new LinkedHashMap();
            this.addIndianStates(states);
            this.put("INDIA", states);
        }
        if (CountrySelect.getCountryByAbbreviation(this.countries.trim().toUpperCase()).indexOf("VENEZUELA") != -1 || this.buildAll) {
            states = new LinkedHashMap();
            this.addVenezuelanStates(states);
            this.put("VENEZUELA", states);
        }
        if (CountrySelect.getCountryByAbbreviation(this.countries.trim().toUpperCase()).indexOf("NETHERLANDS") != -1 || this.buildAll) {
            states = new LinkedHashMap();
            this.addNetherlandStates(states);
            this.put("NETHERLANDS", states);
        }
        if (CountrySelect.getCountryByAbbreviation(this.countries.trim().toUpperCase()).indexOf("AUSTRALIA") != -1 || this.buildAll) {
            states = new LinkedHashMap();
            this.addAustralianStates(states);
            this.put("AUSTRALIA", states);
        }
        if (CountrySelect.getCountryByAbbreviation(this.countries.trim().toUpperCase()).indexOf("BRAZIL") != -1 || this.buildAll) {
            states = new LinkedHashMap();
            this.addBrazilianStates(states);
            this.put("BRAZIL", states);
        }
    }

    public boolean hasCountry(String country) {
        return country != null && this.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())) != null;
    }

    public String getHtmlSelect(String selectName, String country) {
        return this.getHtmlSelect(selectName, country, "");
    }

    public String getHtmlSelect(String selectName, String country, String defaultKey) {
        HtmlSelect stateSelect = new HtmlSelect();
        stateSelect.setJsEvent(this.jsEvent);
        boolean hasPreviousStates = false;
        if (this.systemStatus != null) {
            stateSelect.addItem("-1", this.systemStatus.getLabel("calendar.none.4dashes"));
        } else {
            stateSelect.addItem("-1", "-- None --");
        }
        if (this.hasCountry(country)) {
            LinkedHashMap states = (LinkedHashMap)this.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase()));
            for (String stateCode : states.keySet()) {
                String stateName = (String)states.get(stateCode);
                stateSelect.addItem(stateCode, stateName);
                if (hasPreviousStates || this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())) == null || "".equals((String)this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())))) continue;
                hasPreviousStates = stateCode.equals((String)this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())));
            }
        }
        if (!hasPreviousStates && this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())) != null && !"".equals((String)this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())))) {
            stateSelect.addItem((String)this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())), (String)this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())) + " *");
        }
        stateSelect.setIdName(selectName);
        return stateSelect.getHtml(selectName, defaultKey);
    }

    public HtmlSelect getHtmlSelectObj(String country) {
        boolean hasPreviousStates = false;
        HtmlSelect stateSelect = new HtmlSelect();
        stateSelect.setJsEvent(this.jsEvent);
        if (this.hasCountry(country)) {
            LinkedHashMap states = (LinkedHashMap)this.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase()));
            for (String stateCode : states.keySet()) {
                String stateName = (String)states.get(stateCode);
                stateSelect.addItem(stateCode, stateName);
                if (hasPreviousStates || this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())) == null || "".equals((String)this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())))) continue;
                hasPreviousStates = stateCode.equals((String)this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())));
            }
        }
        if (!hasPreviousStates && this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())) != null && !"".equals((String)this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())))) {
            stateSelect.addItem((String)this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())), (String)this.previousStates.get(CountrySelect.getCountryByAbbreviation(country.trim().toUpperCase())));
        }
        return stateSelect;
    }

    public void addUnitedStates(LinkedHashMap states) {
        states.put("AL", "Alabama");
        states.put("AK", "Alaska");
        states.put("AS", "American Samoa");
        states.put("AZ", "Arizona");
        states.put("AR", "Arkansas");
        states.put("CA", "California");
        states.put("CO", "Colorado");
        states.put("CT", "Connecticut");
        states.put("DE", "Delaware");
        states.put("DC", "District of Columbia");
        states.put("FL", "Florida");
        states.put("GA", "Georgia");
        states.put("GU", "Guam");
        states.put("HI", "Hawaii");
        states.put("ID", "Idaho");
        states.put("IL", "Illinois");
        states.put("IN", "Indiana");
        states.put("IA", "Iowa");
        states.put("KS", "Kansas");
        states.put("KY", "Kentucky");
        states.put("LA", "Louisiana");
        states.put("ME", "Maine");
        states.put("MH", "Marshall Islands");
        states.put("MD", "Maryland");
        states.put("MA", "Massachusetts");
        states.put("MI", "Michigan");
        states.put("MN", "Minnesota");
        states.put("MS", "Mississippi");
        states.put("MO", "Missouri");
        states.put("MT", "Montana");
        states.put("NE", "Nebraska");
        states.put("NV", "Nevada");
        states.put("NH", "New Hampshire");
        states.put("NJ", "New Jersey");
        states.put("NM", "New Mexico");
        states.put("NY", "New York");
        states.put("NC", "North Carolina");
        states.put("ND", "North Dakota");
        states.put("MP", "Northern Mariana Islands");
        states.put("OH", "Ohio");
        states.put("OK", "Oklahoma");
        states.put("OR", "Oregon");
        states.put("PW", "Palau");
        states.put("PA", "Pennsylvania");
        states.put("PR", "Puerto Rico");
        states.put("RI", "Rhode Island");
        states.put("SC", "South Carolina");
        states.put("SD", "South Dakota");
        states.put("TN", "Tennessee");
        states.put("TX", "Texas");
        states.put("UT", "Utah");
        states.put("VT", "Vermont");
        states.put("VI", "Virgin Islands");
        states.put("VA", "Virginia");
        states.put("WA", "Washington");
        states.put("WV", "West Virginia");
        states.put("WI", "Wisconsin");
        states.put("WY", "Wyoming");
    }

    public void addCanadianStates(LinkedHashMap states) {
        states.put("AB", "Alberta");
        states.put("BC", "British Columbia");
        states.put("FM", "Federated States of Micronesia");
        states.put("MB", "Manitoba");
        states.put("NB", "New Brunswick");
        states.put("NL", "Newfoundland");
        states.put("NT", "Northwest Territories");
        states.put("NS", "Nova Scotia");
        states.put("NU", "Nunavut");
        states.put("ON", "Ontario");
        states.put("PE", "Prince Edward Island");
        states.put("QC", "Quebec");
        states.put("SK", "Saskatchewan");
        states.put("YT", "Yukon");
    }

    public void addIndianStates(LinkedHashMap states) {
        states.put("AN", "Andaman and Nicobar Islands");
        states.put("AP", "Andhra Pradesh");
        states.put("AR", "Arunachal Pradesh");
        states.put("AS", "Assam");
        states.put("BR", "Bihar");
        states.put("CH", "Chandigarh");
        states.put("CT", "Chhattisgarh");
        states.put("DN", "Dadra and Nagar Haveli");
        states.put("DD", "Daman and Diu");
        states.put("DL", "Delhi");
        states.put("GA", "Goa");
        states.put("GJ", "Gujarat");
        states.put("HR", "Haryana");
        states.put("HP", "Himachal Pradesh");
        states.put("JK", "Jammu and Kashmir");
        states.put("JH", "Jharkhand");
        states.put("KA", "Karnataka");
        states.put("KL", "Kerala");
        states.put("LD", "Lakshadweep");
        states.put("MP", "Madhya Pradesh");
        states.put("MH", "Maharashtra");
        states.put("MN", "Manipur");
        states.put("ML", "Meghalaya");
        states.put("MZ", "Mizoram");
        states.put("NL", "Nagaland");
        states.put("OR", "Orissa");
        states.put("PY", "Pondicherry");
        states.put("PB", "Punjab");
        states.put("RJ", "Rajasthan");
        states.put("SK", "Sikkim");
        states.put("TN", "Tamil Nadu");
        states.put("TR", "Tripura");
        states.put("UT", "Uttaranchal");
        states.put("UP", "Uttar Pradesh");
        states.put("WB", "West Bengal");
    }

    public void addVenezuelanStates(LinkedHashMap states) {
        states.put("ANZ", "Anzoategui");
        states.put("MON", "Monagas");
        states.put("DEL", "Delta Amacuro");
        states.put("BOL", "Bolivar");
        states.put("AMZ", "Amazonas");
        states.put("SUC", "Sucre");
        states.put("NVE", "Nueva Esparta");
        states.put("GUA", "Guarico");
        states.put("ARA", "Aragua");
        states.put("CBO", "Carabobo");
        states.put("DFE", "Distrito Federal");
        states.put("MIR", "Miranda");
        states.put("MER", "Merida");
        states.put("LAR", "Lara");
        states.put("YAR", "Yaracuy");
        states.put("FAL", "Falcon");
        states.put("BAR", "Barinas");
        states.put("COJ", "Cojedes");
        states.put("APU", "Apure");
        states.put("TAC", "Tachira");
        states.put("TRU", "Trujillo");
        states.put("ZUL", "Zulia");
        states.put("VAR", "Vargas");
        states.put("POR", "Portuguesa");
    }

    public void addNetherlandStates(LinkedHashMap states) {
        states.put("DR", "Drenthe");
        states.put("FL", "Flevoland");
        states.put("FR", "Friesland");
        states.put("GE", "Gelderland");
        states.put("GR", "Groningen");
        states.put("LI", "Limburg");
        states.put("NB", "Noord-Brabant");
        states.put("NH", "Noord-Holland");
        states.put("OV", "Overijssel");
        states.put("UT", "Utrecht");
        states.put("ZE", "Zeeland");
        states.put("ZH", "Zuid-Holland");
    }

    public void addAustralianStates(LinkedHashMap states) {
        states.put("CT", "Australian Capital Territory");
        states.put("NS", "New South Wales");
        states.put("NT", "Northern Territory");
        states.put("QL", "Queensland");
        states.put("SA", "South Australia");
        states.put("TS", "Tasmania");
        states.put("VI", "Victoria");
        states.put("WA", "Western Australia");
        states.put("AS", "Ashmore and Cartier Islands");
        states.put("CR", "Coral Sea Islands Territory");
    }

    public void addBrazilianStates(LinkedHashMap states) {
        states.put("AC", "Acre");
        states.put("AL", "Alagoas");
        states.put("AM", "Amazonas");
        states.put("AP", "Amap\u00e1");
        states.put("BA", "Bahia");
        states.put("CE", "Cear\u00e1");
        states.put("DF", "Distrito Federal");
        states.put("ES", "Esp\u00edrito Santo");
        states.put("GO", "Goi\u00e1s");
        states.put("MA", "Maranh\u00e3o");
        states.put("MG", "Minas Gerais");
        states.put("MS", "Mato Grosso do Sul");
        states.put("MT", "Mato Grosso");
        states.put("PA", "Par\u00e1");
        states.put("PB", "Para\u00edba");
        states.put("PE", "Pernambuco");
        states.put("PI", "Piau\u00ed");
        states.put("PR", "Paran\u00e1");
        states.put("RJ", "Rio de Janeiro");
        states.put("RN", "Rio Grande do Norte");
        states.put("RS", "Rio Grande do Sul");
        states.put("RO", "Rond\u00f4nia");
        states.put("RR", "Roraima");
        states.put("SC", "Santa Catarina");
        states.put("SP", "S\u00e3o Paulo");
        states.put("SE", "Sergipe");
        states.put("TO", "Tocantins");
    }
}

