/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.atlas.AtlasException;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.PropertiesUtil;
import org.apache.atlas.security.SecureClientUtils;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.json.InstanceSerialization;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasClient {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasClient.class);
    public static final String NAME = "name";
    public static final String GUID = "GUID";
    public static final String TYPENAME = "typeName";
    public static final String DEFINITION = "definition";
    public static final String ERROR = "error";
    public static final String STACKTRACE = "stackTrace";
    public static final String REQUEST_ID = "requestId";
    public static final String RESULTS = "results";
    public static final String COUNT = "count";
    public static final String ROWS = "rows";
    public static final String BASE_URI = "api/atlas/";
    public static final String TYPES = "types";
    public static final String URI_ENTITIES = "entities";
    public static final String URI_TRAITS = "traits";
    public static final String URI_SEARCH = "discovery/search";
    public static final String URI_LINEAGE = "lineage/hive/table";
    public static final String QUERY = "query";
    public static final String QUERY_TYPE = "queryType";
    public static final String ATTRIBUTE_NAME = "property";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String INFRASTRUCTURE_SUPER_TYPE = "Infrastructure";
    public static final String DATA_SET_SUPER_TYPE = "DataSet";
    public static final String PROCESS_SUPER_TYPE = "Process";
    public static final String JSON_MEDIA_TYPE = "application/json; charset=UTF-8";
    private WebResource service;

    public AtlasClient(String baseUrl) {
        DefaultClientConfig config = new DefaultClientConfig();
        PropertiesConfiguration clientConfig = null;
        try {
            clientConfig = this.getClientProperties();
            if (clientConfig.getBoolean("atlas.enableTLS", false)) {
                SecureClientUtils.persistSSLClientConfiguration(clientConfig);
            }
        }
        catch (Exception e) {
            LOG.info("Error processing client configuration.", (Throwable)e);
        }
        URLConnectionClientHandler handler = SecureClientUtils.getClientConnectionHandler(config, clientConfig);
        Client client = new Client((ClientHandler)handler, (ClientConfig)config);
        client.resource(UriBuilder.fromUri((String)baseUrl).build(new Object[0]));
        this.service = client.resource(UriBuilder.fromUri((String)baseUrl).build(new Object[0]));
    }

    protected PropertiesConfiguration getClientProperties() throws AtlasException {
        return PropertiesUtil.getClientProperties();
    }

    public JSONObject createType(String typeAsJson) throws AtlasServiceException {
        return this.callAPI(API.CREATE_TYPE, typeAsJson, new String[0]);
    }

    public List<String> listTypes() throws AtlasServiceException {
        try {
            JSONObject jsonObject = this.callAPI(API.LIST_TYPES, null, new String[0]);
            JSONArray list = jsonObject.getJSONArray(RESULTS);
            ArrayList<String> types = new ArrayList<String>();
            for (int index = 0; index < list.length(); ++index) {
                types.add(list.getString(index));
            }
            return types;
        }
        catch (JSONException e) {
            throw new AtlasServiceException(API.LIST_TYPES, (Exception)((Object)e));
        }
    }

    public String getType(String typeName) throws AtlasServiceException {
        WebResource resource = this.getResource(API.GET_TYPE, typeName);
        try {
            JSONObject response = this.callAPIWithResource(API.GET_TYPE, resource);
            return response.getString(DEFINITION);
        }
        catch (AtlasServiceException e) {
            if (e.getStatus() == ClientResponse.Status.NOT_FOUND) {
                return null;
            }
            throw e;
        }
        catch (JSONException e) {
            throw new AtlasServiceException((Exception)((Object)e));
        }
    }

    public JSONObject createEntity(String entityAsJson) throws AtlasServiceException {
        return this.callAPI(API.CREATE_ENTITY, entityAsJson, new String[0]);
    }

    public Referenceable getEntity(String guid) throws AtlasServiceException {
        JSONObject jsonResponse = this.callAPI(API.GET_ENTITY, null, guid);
        try {
            String entityInstanceDefinition = jsonResponse.getString(DEFINITION);
            return InstanceSerialization.fromJsonReferenceable((String)entityInstanceDefinition, (boolean)true);
        }
        catch (JSONException e) {
            throw new AtlasServiceException((Exception)((Object)e));
        }
    }

    public JSONObject updateEntity(String guid, String property, String value) throws AtlasServiceException {
        WebResource resource = this.getResource(API.UPDATE_ENTITY, guid);
        resource = resource.queryParam(ATTRIBUTE_NAME, property);
        resource = resource.queryParam(ATTRIBUTE_VALUE, value);
        return this.callAPIWithResource(API.UPDATE_ENTITY, resource);
    }

    public JSONObject searchEntity(String searchQuery) throws AtlasServiceException {
        WebResource resource = this.getResource(API.SEARCH, new String[0]);
        resource = resource.queryParam(QUERY, searchQuery);
        return this.callAPIWithResource(API.SEARCH, resource);
    }

    public JSONArray rawSearch(String typeName, String attributeName, Object attributeValue) throws AtlasServiceException {
        String dslQuery = String.format("%s where %s = \"%s\"", typeName, attributeName, attributeValue);
        return this.searchByDSL(dslQuery);
    }

    public JSONArray searchByDSL(String query) throws AtlasServiceException {
        LOG.debug("DSL query: {}", (Object)query);
        WebResource resource = this.getResource(API.SEARCH_DSL, new String[0]);
        resource = resource.queryParam(QUERY, query);
        JSONObject result = this.callAPIWithResource(API.SEARCH_DSL, resource);
        try {
            return result.getJSONObject(RESULTS).getJSONArray(ROWS);
        }
        catch (JSONException e) {
            throw new AtlasServiceException((Exception)((Object)e));
        }
    }

    public JSONObject searchByGremlin(String gremlinQuery) throws AtlasServiceException {
        LOG.debug("Gremlin query: " + gremlinQuery);
        WebResource resource = this.getResource(API.SEARCH_GREMLIN, new String[0]);
        resource = resource.queryParam(QUERY, gremlinQuery);
        return this.callAPIWithResource(API.SEARCH_GREMLIN, resource);
    }

    public JSONObject searchByFullText(String query) throws AtlasServiceException {
        WebResource resource = this.getResource(API.SEARCH_FULL_TEXT, new String[0]);
        resource = resource.queryParam(QUERY, query);
        return this.callAPIWithResource(API.SEARCH_FULL_TEXT, resource);
    }

    public JSONObject getInputGraph(String datasetName) throws AtlasServiceException {
        JSONObject response = this.callAPI(API.LINEAGE_INPUTS_GRAPH, null, datasetName, "/inputs/graph");
        try {
            return response.getJSONObject(RESULTS);
        }
        catch (JSONException e) {
            throw new AtlasServiceException((Exception)((Object)e));
        }
    }

    public JSONObject getOutputGraph(String datasetName) throws AtlasServiceException {
        JSONObject response = this.callAPI(API.LINEAGE_OUTPUTS_GRAPH, null, datasetName, "/outputs/graph");
        try {
            return response.getJSONObject(RESULTS);
        }
        catch (JSONException e) {
            throw new AtlasServiceException((Exception)((Object)e));
        }
    }

    public String getRequestId(JSONObject json) throws AtlasServiceException {
        try {
            return json.getString(REQUEST_ID);
        }
        catch (JSONException e) {
            throw new AtlasServiceException((Exception)((Object)e));
        }
    }

    private WebResource getResource(API api, String ... pathParams) {
        WebResource resource = this.service.path(api.getPath());
        if (pathParams != null) {
            for (String pathParam : pathParams) {
                resource = resource.path(pathParam);
            }
        }
        return resource;
    }

    private JSONObject callAPIWithResource(API api, WebResource resource) throws AtlasServiceException {
        return this.callAPIWithResource(api, resource, null);
    }

    private JSONObject callAPIWithResource(API api, WebResource resource, Object requestObject) throws AtlasServiceException {
        Response.Status expectedStatus;
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)resource.accept(new String[]{JSON_MEDIA_TYPE}).type(JSON_MEDIA_TYPE)).method(api.getMethod(), ClientResponse.class, requestObject);
        Response.Status status = expectedStatus = "POST".equals(api.getMethod()) ? Response.Status.CREATED : Response.Status.OK;
        if (clientResponse.getStatus() == expectedStatus.getStatusCode()) {
            String responseAsString = (String)clientResponse.getEntity(String.class);
            try {
                return new JSONObject(responseAsString);
            }
            catch (JSONException e) {
                throw new AtlasServiceException(api, (Exception)((Object)e));
            }
        }
        throw new AtlasServiceException(api, clientResponse);
    }

    private JSONObject callAPI(API api, Object requestObject, String ... pathParams) throws AtlasServiceException {
        WebResource resource = this.getResource(api, pathParams);
        return this.callAPIWithResource(api, resource, requestObject);
    }

    static enum API {
        CREATE_TYPE("api/atlas/types", "POST"),
        GET_TYPE("api/atlas/types", "GET"),
        LIST_TYPES("api/atlas/types", "GET"),
        LIST_TRAIT_TYPES("api/atlas/types?type=trait", "GET"),
        CREATE_ENTITY("api/atlas/entities", "POST"),
        GET_ENTITY("api/atlas/entities", "GET"),
        UPDATE_ENTITY("api/atlas/entities", "PUT"),
        LIST_ENTITY("api/atlas/entities", "GET"),
        ADD_TRAITS("api/atlas/traits", "POST"),
        DELETE_TRAITS("api/atlas/traits", "DELETE"),
        LIST_TRAITS("api/atlas/traits", "GET"),
        SEARCH("api/atlas/discovery/search", "GET"),
        SEARCH_DSL("api/atlas/discovery/search/dsl", "GET"),
        SEARCH_GREMLIN("api/atlas/discovery/search/gremlin", "GET"),
        SEARCH_FULL_TEXT("api/atlas/discovery/search/fulltext", "GET"),
        LINEAGE_INPUTS_GRAPH("api/atlas/lineage/hive/table", "GET"),
        LINEAGE_OUTPUTS_GRAPH("api/atlas/lineage/hive/table", "GET"),
        LINEAGE_SCHEMA("api/atlas/lineage/hive/table", "GET");

        private final String method;
        private final String path;

        private API(String path, String method) {
            this.path = path;
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }
    }
}

