/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.io.File;
import java.net.URL;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesUtil.class);
    private static final String APPLICATION_PROPERTIES = "application.properties";
    public static final String CLIENT_PROPERTIES = "client.properties";

    public static PropertiesConfiguration getApplicationProperties() throws AtlasException {
        return PropertiesUtil.getPropertiesConfiguration(APPLICATION_PROPERTIES);
    }

    public static PropertiesConfiguration getClientProperties() throws AtlasException {
        return PropertiesUtil.getPropertiesConfiguration(CLIENT_PROPERTIES);
    }

    private static PropertiesConfiguration getPropertiesConfiguration(String name) throws AtlasException {
        String confLocation = System.getProperty("atlas.conf");
        try {
            URL url = confLocation == null ? PropertiesUtil.class.getResource("/" + name) : new File(confLocation, name).toURI().toURL();
            LOG.info("Loading {} from {}", (Object)name, (Object)url);
            return new PropertiesConfiguration(url);
        }
        catch (Exception e) {
            throw new AtlasException("Failed to load application properties", (Throwable)e);
        }
    }
}

