/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.security;

import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.atlas.AtlasException;
import org.apache.atlas.PropertiesUtil;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureClientUtils {
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static final Logger LOG = LoggerFactory.getLogger(SecureClientUtils.class);
    private static final ConnectionConfigurator DEFAULT_TIMEOUT_CONN_CONFIGURATOR = new ConnectionConfigurator(){

        public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
            SecureClientUtils.setTimeouts(conn, 60000);
            return conn;
        }
    };

    public static URLConnectionClientHandler getClientConnectionHandler(DefaultClientConfig config, PropertiesConfiguration clientConfig) {
        config.getProperties().put("com.sun.jersey.client.property.httpUrlConnectionSetMethodWorkaround", true);
        Configuration conf = new Configuration(false);
        conf.addResource(conf.get("hadoop.ssl.client.conf", "ssl-client.xml"));
        String authType = "simple";
        if (clientConfig != null) {
            authType = clientConfig.getString("atlas.http.authentication.type", "simple");
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        final ConnectionConfigurator connConfigurator = SecureClientUtils.newConnConfigurator(conf);
        PseudoDelegationTokenAuthenticator authenticator = new PseudoDelegationTokenAuthenticator();
        if (!authType.equals("simple")) {
            authenticator = new KerberosDelegationTokenAuthenticator();
        }
        authenticator.setConnectionConfigurator(connConfigurator);
        final DelegationTokenAuthenticator finalAuthenticator = (DelegationTokenAuthenticator)authenticator;
        final DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
        HttpURLConnectionFactory httpURLConnectionFactory = new HttpURLConnectionFactory(){

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                try {
                    return new DelegationTokenAuthenticatedURL(finalAuthenticator, connConfigurator).openConnection(url, token, null);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
        return new URLConnectionClientHandler(httpURLConnectionFactory);
    }

    private static ConnectionConfigurator newConnConfigurator(Configuration conf) {
        try {
            return SecureClientUtils.newSslConnConfigurator(60000, conf);
        }
        catch (Exception e) {
            LOG.debug("Cannot load customized ssl related configuration. Fallback to system-generic settings.", (Throwable)e);
            return DEFAULT_TIMEOUT_CONN_CONFIGURATOR;
        }
    }

    private static ConnectionConfigurator newSslConnConfigurator(final int timeout, Configuration conf) throws IOException, GeneralSecurityException {
        SSLFactory factory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        factory.init();
        final SSLSocketFactory sf = factory.createSSLSocketFactory();
        final HostnameVerifier hv = factory.getHostnameVerifier();
        return new ConnectionConfigurator(){

            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection c = (HttpsURLConnection)conn;
                    c.setSSLSocketFactory(sf);
                    c.setHostnameVerifier(hv);
                }
                SecureClientUtils.setTimeouts(conn, timeout);
                return conn;
            }
        };
    }

    private static void setTimeouts(URLConnection connection, int socketTimeout) {
        connection.setConnectTimeout(socketTimeout);
        connection.setReadTimeout(socketTimeout);
    }

    private static File getSSLClientFile() throws AtlasException {
        File sslDir;
        String confLocation = System.getProperty("atlas.conf");
        try {
            if (confLocation == null) {
                String persistDir = null;
                URL resource = PropertiesUtil.class.getResource("/");
                if (resource != null) {
                    persistDir = resource.toURI().getPath();
                }
                assert (persistDir != null);
                sslDir = new File(persistDir);
            } else {
                sslDir = new File(confLocation);
            }
            LOG.info("ssl-client.xml will be created in {}", (Object)sslDir);
        }
        catch (Exception e) {
            throw new AtlasException("Failed to find client configuration directory", (Throwable)e);
        }
        return new File(sslDir, "ssl-client.xml");
    }

    public static void persistSSLClientConfiguration(PropertiesConfiguration clientConfig) throws AtlasException, IOException {
        Configuration configuration = new Configuration(false);
        File sslClientFile = SecureClientUtils.getSSLClientFile();
        if (!sslClientFile.exists()) {
            configuration.set("ssl.client.truststore.type", "jks");
            configuration.set("ssl.client.truststore.location", clientConfig.getString("truststore.file"));
            if (clientConfig.getBoolean("client.auth.enabled", false)) {
                configuration.set("ssl.client.keystore.location", clientConfig.getString("keystore.file"));
                configuration.set("ssl.client.keystore.type", "jks");
            }
            configuration.set("hadoop.security.credential.provider.path", clientConfig.getString("cert.stores.credential.provider.path"));
            String hostnameVerifier = clientConfig.getString("hadoop.ssl.hostname.verifier");
            if (hostnameVerifier != null) {
                configuration.set("hadoop.ssl.hostname.verifier", hostnameVerifier);
            }
            configuration.writeXml((Writer)new FileWriter(sslClientFile));
        }
    }
}

