/*
 * Decompiled with CFR 0.152.
 */
package com.iwombat.foundation;

import com.iwombat.foundation.Identifier;
import com.iwombat.util.HexStringUtil;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;

public final class ObjectId
implements Identifier,
Serializable {
    private static final short OID_LENGTH = 16;
    public byte[] binOid = new byte[16];
    private String id = null;
    private static final short BYTE_SHIFT = 8;
    private static final byte OneTwentySeven = 127;
    private static final short LOW_BYTE_MASK = 255;
    private static final short HIGH_NIBBLE_MASK = 240;
    private static final short LOW_NIBBLE_MASK = 15;
    private static final int MAX_SEQUENCE_NUMBER = 16384;
    private static int sequenceNumber = 0;
    private static byte[] MACAddr;
    private static short MACADDR_LENGTH;
    private static Random rand;
    private static long lastTimestamp;
    private static final long LOW_TIME_MASK = 0xFFFFFFFFL;
    private static final long MID_TIME_MASK = 0xFFFF00000000L;
    private static final long HIGH_TIME_MASK = 0xFFF000000000000L;
    private static final short MID_TIME_OFFSET = 32;
    private static final short HIGH_TIME_OFFSET = 48;
    private static final byte VERSION = 16;
    private static final byte VARIANT = -128;
    private static final long NANOSECONDS_PER_DAY = 711573504L;
    private static final long TIME_OFFSET = 100627167068160L;

    private static synchronized void incrementSequence() {
        ++sequenceNumber;
        sequenceNumber %= 16384;
    }

    private static synchronized void setTimeStamp(long l) {
        lastTimestamp = l;
    }

    private long getTime() {
        long l = 100627167068160L + 1000L * System.currentTimeMillis();
        if (l <= lastTimestamp) {
            ObjectId.incrementSequence();
        } else {
            ObjectId.setTimeStamp(l);
        }
        return l;
    }

    private void stuffOidWithLong(byte[] byArray, long l, int n, int n2) {
        int n3 = n + n2 - 1;
        do {
            byArray[n3] = (byte)(l & 0xFFL);
            l >>>= 8;
        } while (n3-- > n);
    }

    private static byte[] getDummyMACADDR() {
        byte[] byArray = new byte[6];
        rand.nextBytes(byArray);
        byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byte[] byArray2 = inetAddress.getAddress();
            if (127 != byArray2[0]) {
                byArray[byArray.length - 1] = byArray2[byArray2.length - 1];
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return byArray;
    }

    private byte[] createOid() {
        long l = 0L;
        byte[] byArray = new byte[16];
        long l2 = this.getTime();
        l = l2 & 0xFFFFFFFFL;
        this.stuffOidWithLong(byArray, l, 0, 4);
        l = (l2 & 0xFFFF00000000L) >>> 32;
        this.stuffOidWithLong(byArray, l, 4, 2);
        l = (l2 & 0xFFF000000000000L) >>> 48;
        this.stuffOidWithLong(byArray, l, 6, 2);
        l = sequenceNumber;
        this.stuffOidWithLong(byArray, l, 8, 2);
        System.arraycopy(MACAddr, 0, byArray, 10, MACADDR_LENGTH);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x10);
        byArray[8] = (byte)(byArray[8] & 0xF);
        byArray[8] = (byte)(byArray[8] | 0xFFFFFF80);
        return byArray;
    }

    public ObjectId() {
        this.setId(this.createOid());
    }

    public ObjectId(byte[] byArray) {
        this.setId(byArray);
    }

    public ObjectId(String string) {
        this.setId(string);
    }

    public byte[] getValue() {
        return this.binOid;
    }

    public void setId(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("argument null value");
        }
        this.setStringAndByteId(byArray, HexStringUtil.stringFromBytes(byArray));
    }

    public void setId(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument null value");
        }
        this.setStringAndByteId(HexStringUtil.bytesFromHexString(string), string);
    }

    private void setStringAndByteId(byte[] byArray, String string) {
        this.binOid = byArray;
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public String toHexString() {
        return this.getId();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectId)) {
            return false;
        }
        byte[] byArray = ((ObjectId)object).getValue();
        byte[] byArray2 = this.getValue();
        int n = 0;
        while (n < 16) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return this.toHexString().hashCode();
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + ": " + this.toHexString();
    }

    static {
        MACADDR_LENGTH = (short)6;
        rand = new Random(System.currentTimeMillis());
        lastTimestamp = 0L;
        String string = System.getProperty("MACADDR");
        try {
            MACAddr = HexStringUtil.bytesFromHexString(string);
        }
        catch (RuntimeException runtimeException) {
            MACAddr = ObjectId.getDummyMACADDR();
        }
        if (MACAddr.length < MACADDR_LENGTH) {
            System.err.println("StartupError: MACADDR not defined properly in System.properties");
            MACAddr = ObjectId.getDummyMACADDR();
        }
        sequenceNumber = rand.nextInt();
        sequenceNumber %= 16384;
    }
}

