/*
 * Decompiled with CFR 0.152.
 */
package com.iwombat.foundation.environment;

import com.iwombat.foundation.environment.Configuration;
import com.iwombat.foundation.environment.ConfigurationException;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ConfigurationMap {
    private String name;
    private HashMap configMap = new HashMap();

    protected ConfigurationMap() {
    }

    public ConfigurationMap(String string, URL uRL) {
        this.setName(string);
        this.read(uRL);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Configuration getConfiguration(String string) {
        return (Configuration)this.configMap.get(string);
    }

    public void setConfiguration(Configuration configuration) {
        this.configMap.put(configuration.getKey(), configuration);
    }

    public void setMap(HashMap hashMap) {
        this.configMap = hashMap;
    }

    public HashMap getMap() {
        return this.configMap;
    }

    private void read(URL uRL) {
        XMLDecoder xMLDecoder = null;
        this.configMap = new HashMap();
        String string = uRL.getPath().substring(2);
        try {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                xMLDecoder = new XMLDecoder(uRLConnection.getInputStream());
                while (true) {
                    Configuration configuration = (Configuration)xMLDecoder.readObject();
                    this.configMap.put(configuration.getKey(), configuration);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Object var8_8 = null;
                xMLDecoder.close();
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("Unable to locate URL:" + malformedURLException.getMessage());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Unable to read config URL:" + iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            xMLDecoder.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string) {
        XMLEncoder xMLEncoder = null;
        try {
            xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(string)));
        }
        catch (Exception exception) {
            throw new ConfigurationException("Can not write config to file:" + string + exception.getMessage(), exception);
        }
        Set set = this.configMap.keySet();
        Iterator iterator = set.iterator();
        try {
            while (iterator.hasNext()) {
                Configuration configuration = (Configuration)this.configMap.get(iterator.next());
                xMLEncoder.writeObject(configuration);
            }
            Object var7_7 = null;
            xMLEncoder.close();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            xMLEncoder.close();
            throw throwable;
        }
    }
}

