/*
 * Decompiled with CFR 0.152.
 */
package com.iwombat.util;

public final class HexStringUtil {
    private static final short BYTE_SHIFT = 8;
    private static final short LOW_BYTE_MASK = 255;
    private static final short HIGH_NIBBLE_MASK = 240;
    private static final int RADIX = 16;
    private static final String HEX_TOKEN = "0x";

    private HexStringUtil() {
    }

    public static byte[] bytesFromHexString(String string) {
        int n;
        if (string.startsWith(HEX_TOKEN)) {
            string = string.substring(HEX_TOKEN.length());
        }
        if (0 == (n = string.length() / 2)) {
            throw new IllegalArgumentException("zero length string");
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("odd length string");
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                String string2 = string.substring(n2 * 2, n2 * 2 + 2);
                char[] cArray = string2.toCharArray();
                int n3 = Character.digit(cArray[0], 16) * 16;
                byArray[n2] = (byte)(n3 += Character.digit(cArray[1], 16));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("improperly formed hex string");
            }
            ++n2;
        }
        return byArray;
    }

    public static String stringFromBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & 0xF0) > 0) {
                stringBuffer.append(Integer.toHexString(byArray[n] & 0xFF));
            } else {
                stringBuffer.append("0" + Integer.toHexString(byArray[n] & 0xFF));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String stringFromBytesWithToken(byte[] byArray) {
        return new String(HEX_TOKEN + HexStringUtil.stringFromBytes(byArray));
    }
}

