/*
 * Decompiled with CFR 0.152.
 */
package com.iwombat.util;

import com.iwombat.util.VariantEnum;
import com.iwombat.util.VariantIllegalTypeException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;

public class Variant
implements Cloneable,
Serializable {
    private VariantEnum type = null;
    private int intVal = 0;
    private long longVal = 0L;
    private float floatVal = 0.0f;
    private double doubleVal = 0.0;
    private boolean booleanVal = false;
    private byte[] byteArrayVal = null;
    private String stringVal = "";
    private Timestamp timestampVal = null;
    private transient Object objectVal = null;

    public Variant() {
    }

    public Variant(VariantEnum variantEnum) {
        this.type = variantEnum;
    }

    public Variant(boolean bl) {
        this.type = VariantEnum.BOOLEAN;
        this.setboolean(bl);
    }

    public Variant(char c) {
        this.type = VariantEnum.CHAR;
        this.setchar(c);
    }

    public Variant(byte by) {
        this.type = VariantEnum.BYTE;
        this.setbyte(by);
    }

    public Variant(short s) {
        this.type = VariantEnum.SHORT;
        this.setshort(s);
    }

    public Variant(int n) {
        this.type = VariantEnum.INT;
        this.setint(n);
    }

    public Variant(long l) {
        this.type = VariantEnum.LONG;
        this.setlong(l);
    }

    public Variant(float f) {
        this.type = VariantEnum.FLOAT;
        this.setfloat(f);
    }

    public Variant(double d) {
        this.type = VariantEnum.DOUBLE;
        this.setdouble(d);
    }

    public Variant(byte[] byArray) {
        this.type = VariantEnum.BYTE_ARRAY;
        this.setByteArray(byArray);
    }

    public Variant(String string) {
        this.type = VariantEnum.STRING;
        this.setString(string);
    }

    public Variant(Timestamp timestamp) {
        this.type = VariantEnum.SQL_TIMESTAMP;
        this.setJavaSqlTimestamp(timestamp);
    }

    public Variant(Integer n) {
        this.type = VariantEnum.INT;
        if (n != null) {
            this.setint(n);
        }
    }

    public Variant(Long l) {
        this.type = VariantEnum.LONG;
        if (l != null) {
            this.setlong(l);
        }
    }

    public Variant(Short s) {
        this.type = VariantEnum.SHORT;
        if (s != null) {
            this.setshort(s);
        }
    }

    public Variant(Double d) {
        this.type = VariantEnum.DOUBLE;
        if (d != null) {
            this.setdouble(d);
        }
    }

    public Variant(Float f) {
        this.type = VariantEnum.FLOAT;
        if (f != null) {
            this.setfloat(f.floatValue());
        }
    }

    public Variant(Byte by) {
        this.type = VariantEnum.BYTE;
        if (by != null) {
            this.setbyte(by);
        }
    }

    public Variant(Character c) {
        this.type = VariantEnum.CHAR;
        if (c != null) {
            this.setchar(c.charValue());
        }
    }

    public Variant(Boolean bl) {
        this.type = VariantEnum.BOOLEAN;
        if (bl != null) {
            this.setboolean(bl);
        }
    }

    public Variant(Object object) {
        this.type = VariantEnum.OBJECT;
        this.setObject(object);
    }

    public VariantEnum getVariantType() {
        if (this.type == null) {
            return VariantEnum.UNKNOWN;
        }
        return this.type;
    }

    public int typeId() {
        if (this.type == null) {
            return VariantEnum.UNKNOWN.getValue();
        }
        return this.type.getValue();
    }

    private void typeProblem(VariantEnum variantEnum, VariantEnum variantEnum2) {
        throw new VariantIllegalTypeException("Variant of type " + variantEnum2.toString() + " does not support translations to type " + variantEnum.toString());
    }

    public final Object get() {
        if (this.type == null) {
            return null;
        }
        if (this.type == VariantEnum.BOOLEAN) {
            return new Boolean(this.booleanVal);
        }
        if (this.type == VariantEnum.BYTE) {
            return new Byte((byte)this.intVal);
        }
        if (this.type == VariantEnum.BYTE_ARRAY) {
            return this.byteArrayVal;
        }
        if (this.type == VariantEnum.CHAR) {
            return new Character((char)this.intVal);
        }
        if (this.type == VariantEnum.DOUBLE) {
            return new Double(this.doubleVal);
        }
        if (this.type == VariantEnum.FLOAT) {
            return new Float(this.floatVal);
        }
        if (this.type == VariantEnum.INT) {
            return new Integer(this.intVal);
        }
        if (this.type == VariantEnum.LONG) {
            return new Long(this.longVal);
        }
        if (this.type == VariantEnum.OBJECT) {
            return this.objectVal;
        }
        if (this.type == VariantEnum.SHORT) {
            return new Short((short)this.intVal);
        }
        if (this.type == VariantEnum.SQL_TIMESTAMP) {
            return this.timestampVal;
        }
        if (this.type == VariantEnum.STRING) {
            return this.stringVal;
        }
        return null;
    }

    public final boolean getboolean() {
        if (this.type != VariantEnum.BOOLEAN) {
            this.typeProblem(this.type, VariantEnum.BOOLEAN);
        }
        return this.booleanVal;
    }

    public final char getchar() {
        if (this.type != VariantEnum.CHAR) {
            this.typeProblem(this.type, VariantEnum.CHAR);
        }
        return (char)this.intVal;
    }

    public final byte getbyte() {
        if (this.type != VariantEnum.BYTE) {
            this.typeProblem(this.type, VariantEnum.BYTE);
        }
        return (byte)this.intVal;
    }

    public final short getshort() {
        if (this.type != VariantEnum.SHORT) {
            this.typeProblem(this.type, VariantEnum.SHORT);
        }
        return (short)this.intVal;
    }

    public final int getint() {
        if (this.type != VariantEnum.INT) {
            this.typeProblem(this.type, VariantEnum.INT);
        }
        return this.intVal;
    }

    public final long getlong() {
        if (this.type != VariantEnum.LONG) {
            this.typeProblem(this.type, VariantEnum.LONG);
        }
        return this.longVal;
    }

    public final float getfloat() {
        if (this.type != VariantEnum.FLOAT) {
            this.typeProblem(this.type, VariantEnum.FLOAT);
        }
        return this.floatVal;
    }

    public final double getdouble() {
        if (this.type != VariantEnum.DOUBLE) {
            this.typeProblem(this.type, VariantEnum.DOUBLE);
        }
        return this.doubleVal;
    }

    public final byte[] getByteArray() {
        if (this.type != VariantEnum.BYTE_ARRAY) {
            this.typeProblem(this.type, VariantEnum.BYTE_ARRAY);
        }
        return this.byteArrayVal;
    }

    public final String getString() {
        if (this.type != VariantEnum.STRING) {
            this.typeProblem(this.type, VariantEnum.STRING);
        }
        return this.stringVal;
    }

    public final Timestamp getJavaSqlTimestamp() {
        if (this.type != VariantEnum.SQL_TIMESTAMP) {
            this.typeProblem(this.type, VariantEnum.SQL_TIMESTAMP);
        }
        return this.timestampVal;
    }

    public final Object getObject() {
        if (this.type != VariantEnum.OBJECT) {
            this.typeProblem(this.type, VariantEnum.OBJECT);
        }
        return this.objectVal;
    }

    public final Boolean getBoolean() {
        if (this.type != VariantEnum.BOOLEAN) {
            this.typeProblem(this.type, VariantEnum.BOOLEAN);
        }
        return new Boolean(this.booleanVal);
    }

    public final Character getCharacter() {
        if (this.type != VariantEnum.CHAR) {
            this.typeProblem(this.type, VariantEnum.CHAR);
        }
        return new Character((char)this.intVal);
    }

    public final Byte getByte() {
        if (this.type != VariantEnum.BYTE) {
            this.typeProblem(this.type, VariantEnum.BYTE);
        }
        return new Byte((byte)this.intVal);
    }

    public final Short getShort() {
        if (this.type != VariantEnum.SHORT) {
            this.typeProblem(this.type, VariantEnum.SHORT);
        }
        return new Short((short)this.intVal);
    }

    public final Integer getInteger() {
        if (this.type != VariantEnum.INT) {
            this.typeProblem(this.type, VariantEnum.INT);
        }
        return new Integer(this.intVal);
    }

    public final Long getLong() {
        if (this.type != VariantEnum.LONG) {
            this.typeProblem(this.type, VariantEnum.LONG);
        }
        return new Long(this.longVal);
    }

    public final Float getFloat() {
        if (this.type != VariantEnum.FLOAT) {
            this.typeProblem(this.type, VariantEnum.FLOAT);
        }
        return new Float(this.floatVal);
    }

    public final Double getDouble() {
        if (this.type != VariantEnum.DOUBLE) {
            this.typeProblem(this.type, VariantEnum.DOUBLE);
        }
        return new Double(this.doubleVal);
    }

    public final void set(boolean bl) {
        this.setboolean(bl);
    }

    public final void set(char c) {
        this.setchar(c);
    }

    public final void set(byte by) {
        this.setbyte(by);
    }

    public final void set(short s) {
        this.setshort(s);
    }

    public final void set(int n) {
        this.setint(n);
    }

    public final void set(long l) {
        this.setlong(l);
    }

    public final void set(float f) {
        this.setfloat(f);
    }

    public final void set(double d) {
        this.setdouble(d);
    }

    public final void set(byte[] byArray) {
        this.setByteArray(byArray);
    }

    public final void set(Boolean bl) {
        this.setboolean(bl);
    }

    public final void set(Character c) {
        this.setchar(c.charValue());
    }

    public final void set(Byte by) {
        this.setbyte(by);
    }

    public final void set(Short s) {
        this.setshort(s);
    }

    public final void set(Integer n) {
        this.setint(n);
    }

    public final void set(Long l) {
        this.setlong(l);
    }

    public final void set(Float f) {
        this.setfloat(f.floatValue());
    }

    public final void set(Double d) {
        this.setdouble(d);
    }

    public final void set(String string) {
        this.setString(string);
    }

    public final void set(Object object) {
        this.setObject(object);
    }

    public final void set(Timestamp timestamp) {
        this.setJavaSqlTimestamp(timestamp);
    }

    public final void setboolean(boolean bl) {
        if (this.type != null && this.type != VariantEnum.BOOLEAN) {
            this.typeProblem(this.type, VariantEnum.BOOLEAN);
        }
        this.type = VariantEnum.BOOLEAN;
        this.booleanVal = bl;
    }

    public final void setchar(char c) {
        if (this.type != null && this.type != VariantEnum.CHAR) {
            this.typeProblem(this.type, VariantEnum.CHAR);
        }
        this.type = VariantEnum.CHAR;
        this.intVal = c;
    }

    public final void setbyte(byte by) {
        if (this.type != null && this.type != VariantEnum.BYTE) {
            this.typeProblem(this.type, VariantEnum.BYTE);
        }
        this.type = VariantEnum.BYTE;
        this.intVal = by;
    }

    public final void setshort(short s) {
        if (this.type != null && this.type != VariantEnum.SHORT) {
            this.typeProblem(this.type, VariantEnum.SHORT);
        }
        this.type = VariantEnum.SHORT;
        this.intVal = s;
    }

    public final void setint(int n) {
        if (this.type != null && this.type != VariantEnum.INT) {
            this.typeProblem(this.type, VariantEnum.INT);
        }
        this.type = VariantEnum.INT;
        this.intVal = n;
    }

    public final void setlong(long l) {
        if (this.type != null && this.type != VariantEnum.LONG) {
            this.typeProblem(this.type, VariantEnum.LONG);
        }
        this.type = VariantEnum.LONG;
        this.longVal = l;
    }

    public final void setfloat(float f) {
        if (this.type != null && this.type != VariantEnum.FLOAT) {
            this.typeProblem(this.type, VariantEnum.FLOAT);
        }
        this.type = VariantEnum.FLOAT;
        this.floatVal = f;
    }

    public final void setdouble(double d) {
        if (this.type != null && this.type != VariantEnum.DOUBLE) {
            this.typeProblem(this.type, VariantEnum.DOUBLE);
        }
        this.type = VariantEnum.DOUBLE;
        this.doubleVal = d;
    }

    public final void setByteArray(byte[] byArray) {
        if (this.type != null && this.type != VariantEnum.BYTE_ARRAY) {
            this.typeProblem(this.type, VariantEnum.BYTE_ARRAY);
        }
        this.type = VariantEnum.BYTE_ARRAY;
        this.byteArrayVal = byArray;
    }

    public final void setString(String string) {
        if (this.type != null && this.type != VariantEnum.STRING) {
            this.typeProblem(this.type, VariantEnum.STRING);
        }
        this.type = VariantEnum.STRING;
        this.stringVal = null == string ? null : new String(string);
    }

    public final void setJavaSqlTimestamp(Timestamp timestamp) {
        if (this.type != null && this.type != VariantEnum.SQL_TIMESTAMP) {
            this.typeProblem(this.type, VariantEnum.SQL_TIMESTAMP);
        }
        this.type = VariantEnum.SQL_TIMESTAMP;
        this.timestampVal = null == timestamp ? null : new Timestamp(timestamp.getTime());
    }

    public final void setObject(Object object) {
        if (this.type != null && this.type != VariantEnum.OBJECT) {
            this.typeProblem(this.type, VariantEnum.OBJECT);
        }
        this.type = VariantEnum.OBJECT;
        this.objectVal = object;
    }

    public String toString() {
        if (this.type == null) {
            return VariantEnum.UNKNOWN.toString();
        }
        String string = "";
        if (this.type == VariantEnum.BOOLEAN) {
            string = this.booleanVal ? "true" : "false";
        } else if (this.type == VariantEnum.BYTE) {
            string = Byte.toString((byte)this.intVal);
        } else if (this.type == VariantEnum.BYTE_ARRAY) {
            string = this.byteArrayVal == null ? "" : new String(this.byteArrayVal);
        } else if (this.type == VariantEnum.CHAR) {
            char[] cArray = new char[]{(char)this.intVal};
            string = new String(cArray);
        } else if (this.type == VariantEnum.DOUBLE) {
            string = Double.toString(this.doubleVal);
        } else if (this.type == VariantEnum.FLOAT) {
            string = Float.toString(this.floatVal);
        } else if (this.type == VariantEnum.INT) {
            string = Integer.toString(this.intVal);
        } else if (this.type == VariantEnum.LONG) {
            string = Long.toString(this.longVal);
        } else if (this.type == VariantEnum.OBJECT) {
            string = this.objectVal == null ? "" : this.objectVal.toString();
        } else if (this.type == VariantEnum.SHORT) {
            string = Short.toString((short)this.intVal);
        } else if (this.type == VariantEnum.SQL_TIMESTAMP) {
            string = this.timestampVal == null ? "" : this.timestampVal.toString();
        } else if (this.type == VariantEnum.STRING) {
            string = this.stringVal == null ? "" : this.stringVal;
        }
        return string;
    }

    public Object clone() {
        Variant variant = new Variant(this.type);
        variant.type = this.type;
        variant.intVal = this.intVal;
        variant.longVal = this.longVal;
        variant.floatVal = this.floatVal;
        variant.doubleVal = this.doubleVal;
        variant.booleanVal = this.booleanVal;
        if (this.byteArrayVal != null) {
            variant.byteArrayVal = new byte[this.byteArrayVal.length];
            System.arraycopy(this.byteArrayVal, 0, variant.byteArrayVal, 0, this.byteArrayVal.length);
        } else {
            variant.byteArrayVal = null;
        }
        variant.stringVal = this.stringVal != null ? new String(this.stringVal) : null;
        variant.timestampVal = this.timestampVal != null ? new Timestamp(this.timestampVal.getTime()) : null;
        variant.objectVal = this.objectVal;
        return variant;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.objectVal instanceof Serializable) {
            objectOutputStream.writeObject(this.objectVal);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.objectVal = objectInputStream.readObject();
    }
}

