/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.building;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.bonita.util.Base64;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBuilder {
    public static final int BYTES_FRAGMENT_LENGTH = 65536;
    public static final String BYTES_FRAGMENT_SEPARATOR = "::";
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;
    private Document document;
    private Node rootNode;

    public XmlBuilder(DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
        this.transformerFactory = transformerFactory;
    }

    public byte[] done() throws Exception {
        this.document.appendChild(this.rootNode);
        DOMSource source = new DOMSource(this.document);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult resultat = new StreamResult(outputStream);
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(source, resultat);
        byte[] xmlContent = outputStream.toByteArray();
        outputStream.close();
        return xmlContent;
    }

    public XmlBuilder createDocument() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        return this;
    }

    public Node createRootNode(String name) throws DOMException, IOException, ClassNotFoundException {
        return this.internalNodeCreation(null, name, null, null);
    }

    public Node createRootNode(String name, Map<String, Serializable> attributes) throws DOMException, IOException, ClassNotFoundException {
        return this.internalNodeCreation(null, name, null, attributes);
    }

    public Node createRootNode(String name, Serializable value) throws DOMException, IOException, ClassNotFoundException {
        if (value != null) {
            return this.internalNodeCreation(null, name, value, null);
        }
        return null;
    }

    public Node createRootNode(String name, Serializable value, Map<String, Serializable> attributes) throws DOMException, IOException, ClassNotFoundException {
        if (value != null) {
            return this.internalNodeCreation(null, name, value, attributes);
        }
        return null;
    }

    public Node createNode(Node parentNode, String name) throws DOMException, IOException, ClassNotFoundException {
        return this.internalNodeCreation(parentNode, name, null, null);
    }

    public Node createNode(Node parentNode, String name, Map<String, Serializable> attributes) throws DOMException, IOException, ClassNotFoundException {
        return this.internalNodeCreation(parentNode, name, null, attributes);
    }

    public Node createNode(Node parentNode, String name, Serializable value) throws DOMException, IOException, ClassNotFoundException {
        if (value != null) {
            return this.internalNodeCreation(parentNode, name, value, null);
        }
        return null;
    }

    public Node createNode(Node parentNode, String name, Serializable value, Map<String, Serializable> attributes) throws DOMException, IOException, ClassNotFoundException {
        if (value != null) {
            return this.internalNodeCreation(parentNode, name, value, attributes);
        }
        return null;
    }

    public Node internalNodeCreation(Node parentNode, String name, Serializable value, Map<String, Serializable> attributes) throws DOMException, IOException, ClassNotFoundException {
        Element element = this.document.createElement(name);
        if (value != null) {
            if (value.getClass().isEnum()) {
                element.setTextContent(((Enum)((Object)value)).name());
            } else if (value instanceof byte[]) {
                element.setTextContent(this.fragmentAndEncode((byte[])value));
            } else if (value instanceof Date) {
                element.setTextContent(Long.toString(((Date)value).getTime()));
            } else {
                element.setTextContent(value.toString());
            }
        }
        if (attributes != null) {
            for (String attributeName : attributes.keySet()) {
                Serializable attributeValue = attributes.get(attributeName);
                if (attributeValue.getClass().isEnum()) {
                    element.setAttribute(attributeName, ((Enum)((Object)attributeValue)).name());
                    continue;
                }
                if (attributeValue instanceof byte[]) {
                    element.setAttribute(attributeName, this.fragmentAndEncode((byte[])attributeValue));
                    continue;
                }
                if (attributeValue instanceof Date) {
                    element.setAttribute(attributeName, Long.toString(((Date)attributeValue).getTime()));
                    continue;
                }
                element.setAttribute(attributeName, attributeValue.toString());
            }
        }
        if (parentNode == null) {
            this.rootNode = element;
            return element;
        }
        return parentNode.appendChild(element);
    }

    private String fragmentAndEncode(byte[] bytes) throws IOException {
        StringBuilder encodedString = new StringBuilder();
        int bytesFragmentLength = 65536;
        int nbFragment = bytes.length / bytesFragmentLength;
        int remainingBytes = bytes.length % bytesFragmentLength;
        if (remainingBytes > 0) {
            ++nbFragment;
        }
        int bytesPosition = 0;
        for (int nbFragmentsProcessed = 0; nbFragmentsProcessed < nbFragment; ++nbFragmentsProcessed) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (nbFragmentsProcessed + 1 < nbFragment) {
                byteArrayOutputStream = new ByteArrayOutputStream(bytesFragmentLength);
                byteArrayOutputStream.write(bytes, bytesPosition, bytesFragmentLength);
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream(remainingBytes);
                byteArrayOutputStream.write(bytes, bytesPosition, remainingBytes);
            }
            String stringFragment = Base64.encodeBytes(byteArrayOutputStream.toByteArray());
            if (bytesPosition != 0) {
                encodedString.append(BYTES_FRAGMENT_SEPARATOR);
            }
            encodedString.append(stringFragment);
            byteArrayOutputStream.close();
            bytesPosition += bytesFragmentLength;
        }
        return encodedString.toString();
    }
}

