/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.building;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.ow2.bonita.building.XmlBuilder;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.DeadlineDefinition;
import org.ow2.bonita.facade.def.element.FilterDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.IncomingEventDefinition;
import org.ow2.bonita.facade.def.element.MultiInstantiationDefinition;
import org.ow2.bonita.facade.def.element.OutgoingEventDefinition;
import org.ow2.bonita.facade.def.element.RoleMapperDefinition;
import org.ow2.bonita.facade.def.element.SubflowParameterDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ParticipantDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Misc;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDefExporter {
    private static final String PRODUCT_VERSION = "5.2";
    private static Logger LOGGER = Logger.getLogger(XmlDefExporter.class.getName());
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private TransformerFactory transformerFactory;
    private static XmlDefExporter INSTANCE = null;

    public static XmlDefExporter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new XmlDefExporter();
        }
        return INSTANCE;
    }

    private XmlDefExporter() {
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(true);
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        URL xsdURL = this.getClass().getResource("/XMLProcessDef_1_1.xsd");
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", xsdURL.toExternalForm());
        this.transformerFactory = TransformerFactory.newInstance();
    }

    public byte[] createProcessDefinition(ProcessDefinition processDefinition) {
        XmlBuilder xmlDefBuilder = new XmlBuilder(this.documentBuilderFactory, this.transformerFactory);
        try {
            xmlDefBuilder.createDocument();
            HashMap<String, Serializable> rootElementAttributes = new HashMap<String, Serializable>();
            rootElementAttributes.put("product-version", (Serializable)((Object)PRODUCT_VERSION));
            Node rootNode = xmlDefBuilder.createRootNode("process-definition", (Map<String, Serializable>)rootElementAttributes);
            this.createProcess(xmlDefBuilder, rootNode, processDefinition);
            return xmlDefBuilder.done();
        }
        catch (Exception e) {
            String errorMessage = "Unable to build the process definition XML";
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, errorMessage, e);
            }
            throw new BonitaRuntimeException(errorMessage, e);
        }
    }

    private Node createProcess(XmlBuilder xmlDefBuilder, Node parentNode, ProcessDefinition processDefinition) throws Exception {
        HashMap<String, Serializable> processElementAttributes = new HashMap<String, Serializable>();
        processElementAttributes.put("name", (Serializable)((Object)processDefinition.getName()));
        processElementAttributes.put("version", (Serializable)((Object)processDefinition.getVersion()));
        Node processNode = xmlDefBuilder.createNode(parentNode, "process", (Map<String, Serializable>)processElementAttributes);
        xmlDefBuilder.createNode(processNode, "label", (Serializable)((Object)processDefinition.getLabel()));
        xmlDefBuilder.createNode(processNode, "description", (Serializable)((Object)processDefinition.getDescription()));
        this.createParticipants(xmlDefBuilder, processNode, processDefinition.getParticipants());
        this.createDataFields(xmlDefBuilder, processNode, processDefinition.getDataFields());
        this.createAttachments(xmlDefBuilder, processNode, processDefinition.getAttachments());
        this.createActivities(xmlDefBuilder, processNode, processDefinition.getActivities());
        this.createTransitions(xmlDefBuilder, processNode, processDefinition.getTransitions());
        this.createConnectors(xmlDefBuilder, processNode, processDefinition.getConnectors());
        return processNode;
    }

    private void createActivities(XmlBuilder xmlDefBuilder, Node parentNode, Set<ActivityDefinition> activities) throws Exception {
        Node activitiesNode = xmlDefBuilder.createNode(parentNode, "activities");
        for (ActivityDefinition activityDefinition : activities) {
            HashMap<String, Serializable> activityElementAttributes = new HashMap<String, Serializable>();
            activityElementAttributes.put("name", (Serializable)((Object)activityDefinition.getName()));
            Node activityNode = xmlDefBuilder.createNode(activitiesNode, "activity", (Map<String, Serializable>)activityElementAttributes);
            xmlDefBuilder.createNode(activityNode, "label", (Serializable)((Object)activityDefinition.getLabel()));
            xmlDefBuilder.createNode(activityNode, "description", (Serializable)((Object)activityDefinition.getDescription()));
            xmlDefBuilder.createNode(activityNode, "dynamic-label", (Serializable)((Object)activityDefinition.getDynamicLabel()));
            xmlDefBuilder.createNode(activityNode, "dynamic-description", (Serializable)((Object)activityDefinition.getDynamicDescription()));
            xmlDefBuilder.createNode(activityNode, "priority", Integer.valueOf(activityDefinition.getPriority()));
            xmlDefBuilder.createNode(activityNode, "executing-time", Long.valueOf(activityDefinition.getExecutingTime()));
            xmlDefBuilder.createNode(activityNode, "split-type", (Serializable)((Object)activityDefinition.getSplitType()));
            xmlDefBuilder.createNode(activityNode, "join-type", (Serializable)((Object)activityDefinition.getJoinType()));
            xmlDefBuilder.createNode(activityNode, "subflow-process-name", (Serializable)((Object)activityDefinition.getSubflowProcessName()));
            xmlDefBuilder.createNode(activityNode, "subflow-process-version", (Serializable)((Object)activityDefinition.getSubflowProcessVersion()));
            xmlDefBuilder.createNode(activityNode, "timer-condition", (Serializable)((Object)activityDefinition.getTimerCondition()));
            xmlDefBuilder.createNode(activityNode, "type", (Serializable)((Object)activityDefinition.getType()));
            xmlDefBuilder.createNode(activityNode, "asynchronous", Boolean.valueOf(activityDefinition.isAsynchronous()));
            Node performersNode = xmlDefBuilder.createNode(activityNode, "performers");
            for (String performer : activityDefinition.getPerformers()) {
                xmlDefBuilder.createNode(performersNode, "performer", (Serializable)((Object)performer));
            }
            if (activityDefinition.isInALoop()) {
                xmlDefBuilder.createNode(activityNode, "loop-condition", (Serializable)((Object)activityDefinition.getLoopCondition()));
                xmlDefBuilder.createNode(activityNode, "before-execution", Boolean.valueOf(activityDefinition.evaluateLoopConditionBeforeExecution()));
                xmlDefBuilder.createNode(activityNode, "loop-maximum", (Serializable)((Object)activityDefinition.getLoopMaximum()));
            }
            this.createConnectors(xmlDefBuilder, activityNode, activityDefinition.getConnectors());
            this.createDataFields(xmlDefBuilder, activityNode, activityDefinition.getDataFields());
            this.createFilter(xmlDefBuilder, activityNode, activityDefinition.getFilter());
            this.createDeadlines(xmlDefBuilder, activityNode, activityDefinition.getDeadlines());
            this.createIncomingEvent(xmlDefBuilder, activityNode, activityDefinition.getIncomingEvent());
            this.createOutgoingEvents(xmlDefBuilder, activityNode, activityDefinition.getOutgoingEvents());
            this.createMultiInstantiationDefinition(xmlDefBuilder, activityNode, activityDefinition.getMultiInstantiationDefinition());
            this.createMultipleActivitiesInstantiator(xmlDefBuilder, activityNode, activityDefinition.getMultipleInstancesInstantiator());
            this.createMultipleActivitiesJoinChecker(xmlDefBuilder, activityNode, activityDefinition.getMultipleInstancesJoinChecker());
            this.createSubflowParameters(xmlDefBuilder, activityNode, activityDefinition.getSubflowInParameters(), "subflow-in-parameters", "subflow-in-parameter");
            this.createSubflowParameters(xmlDefBuilder, activityNode, activityDefinition.getSubflowOutParameters(), "subflow-out-parameters", "subflow-out-parameter");
        }
    }

    private void createSubflowParameters(XmlBuilder xmlDefBuilder, Node parentNode, Set<SubflowParameterDefinition> subflowParameters, String xmlGroupName, String xmlElementName) throws Exception {
        Node subflowParametersNode = xmlDefBuilder.createNode(parentNode, xmlGroupName);
        for (SubflowParameterDefinition subflowParameter : subflowParameters) {
            Node subflowParameterNode = xmlDefBuilder.createNode(subflowParametersNode, xmlElementName);
            xmlDefBuilder.createNode(subflowParameterNode, "source", (Serializable)((Object)subflowParameter.getSource()));
            xmlDefBuilder.createNode(subflowParameterNode, "destination", (Serializable)((Object)subflowParameter.getDestination()));
        }
    }

    private void createMultiInstantiationDefinition(XmlBuilder xmlDefBuilder, Node parentNode, MultiInstantiationDefinition multiInstantiationDefinition) throws Exception {
        if (multiInstantiationDefinition != null) {
            Node multiInstantiationNode = xmlDefBuilder.createNode(parentNode, "multi-instantiation");
            if (multiInstantiationDefinition != null) {
                xmlDefBuilder.createNode(multiInstantiationNode, "classname", (Serializable)((Object)multiInstantiationDefinition.getClassName()));
                xmlDefBuilder.createNode(multiInstantiationNode, "description", (Serializable)((Object)multiInstantiationDefinition.getDescription()));
                xmlDefBuilder.createNode(multiInstantiationNode, "variable-name", (Serializable)((Object)multiInstantiationDefinition.getVariableName()));
                Node parametersNode = xmlDefBuilder.createNode(multiInstantiationNode, "parameters");
                Map<String, Object[]> multiInstantiationParameters = multiInstantiationDefinition.getParameters();
                for (String key : multiInstantiationParameters.keySet()) {
                    HashMap<String, Serializable> multiInstantiationParameterAttributes = new HashMap<String, Serializable>();
                    multiInstantiationParameterAttributes.put("name", (Serializable)((Object)key));
                    xmlDefBuilder.createNode(parametersNode, "parameter", (Serializable)Misc.serialize((Serializable)multiInstantiationParameters.get(key)), multiInstantiationParameterAttributes);
                }
            }
        }
    }

    private void createOutgoingEvents(XmlBuilder xmlDefBuilder, Node parentNode, Set<OutgoingEventDefinition> outgoingEvents) throws Exception {
        Node outgoingEventsNode = xmlDefBuilder.createNode(parentNode, "outgoing-events");
        for (OutgoingEventDefinition outgoingEvent : outgoingEvents) {
            HashMap<String, Serializable> outgoingEventElementAttributes = new HashMap<String, Serializable>();
            outgoingEventElementAttributes.put("name", (Serializable)((Object)outgoingEvent.getName()));
            Node outgoingEventNode = xmlDefBuilder.createNode(outgoingEventsNode, "outgoing-event", (Map<String, Serializable>)outgoingEventElementAttributes);
            xmlDefBuilder.createNode(outgoingEventNode, "time-to-live", Long.valueOf(outgoingEvent.getTimeToLive()));
            xmlDefBuilder.createNode(outgoingEventNode, "to-activity", (Serializable)((Object)outgoingEvent.getToActivityName()));
            xmlDefBuilder.createNode(outgoingEventNode, "to-process", (Serializable)((Object)outgoingEvent.getToProcessName()));
            Node parametersNode = xmlDefBuilder.createNode(outgoingEventNode, "parameters");
            Map<String, Object> outgoingEventParameters = outgoingEvent.getParameters();
            for (String key : outgoingEventParameters.keySet()) {
                HashMap<String, Serializable> outgoingEventParameterAttributes = new HashMap<String, Serializable>();
                outgoingEventParameterAttributes.put("name", (Serializable)((Object)key));
                xmlDefBuilder.createNode(parametersNode, "parameter", (Serializable)Misc.serialize((Serializable)outgoingEventParameters.get(key)), outgoingEventParameterAttributes);
            }
        }
    }

    private void createIncomingEvent(XmlBuilder xmlDefBuilder, Node parentNode, IncomingEventDefinition incomingEvent) throws Exception {
        if (incomingEvent != null) {
            HashMap<String, Serializable> incomingEventElementAttributes = new HashMap<String, Serializable>();
            incomingEventElementAttributes.put("name", (Serializable)((Object)incomingEvent.getName()));
            Node incomingEventNode = xmlDefBuilder.createNode(parentNode, "incoming-event", (Map<String, Serializable>)incomingEventElementAttributes);
            xmlDefBuilder.createNode(incomingEventNode, "expression", (Serializable)((Object)incomingEvent.getExpression()));
        }
    }

    private void createDeadlines(XmlBuilder xmlDefBuilder, Node parentNode, Set<DeadlineDefinition> deadlines) throws Exception {
        Node deadlinesNode = xmlDefBuilder.createNode(parentNode, "deadlines");
        for (DeadlineDefinition deadline : deadlines) {
            Node deadlineNode = xmlDefBuilder.createNode(deadlinesNode, "deadline");
            xmlDefBuilder.createNode(deadlineNode, "classname", (Serializable)((Object)deadline.getClassName()));
            xmlDefBuilder.createNode(deadlineNode, "condition", (Serializable)((Object)deadline.getCondition()));
            xmlDefBuilder.createNode(deadlineNode, "description", (Serializable)((Object)deadline.getDescription()));
            Node parametersNode = xmlDefBuilder.createNode(deadlineNode, "parameters");
            Map<String, Object[]> deadlineParameters = deadline.getParameters();
            for (String key : deadlineParameters.keySet()) {
                HashMap<String, Serializable> deadlineParameterAttributes = new HashMap<String, Serializable>();
                deadlineParameterAttributes.put("name", (Serializable)((Object)key));
                xmlDefBuilder.createNode(parametersNode, "parameter", (Serializable)Misc.serialize((Serializable)deadlineParameters.get(key)), deadlineParameterAttributes);
            }
        }
    }

    private void createMultipleActivitiesInstantiator(XmlBuilder xmlDefBuilder, Node parentNode, MultiInstantiationDefinition instantiator) throws Exception {
        if (instantiator != null) {
            Node instantiatorNode = xmlDefBuilder.createNode(parentNode, "multiple-act-instantiator");
            xmlDefBuilder.createNode(instantiatorNode, "classname", (Serializable)((Object)instantiator.getClassName()));
            xmlDefBuilder.createNode(instantiatorNode, "description", (Serializable)((Object)instantiator.getDescription()));
            Node parametersNode = xmlDefBuilder.createNode(instantiatorNode, "parameters");
            Map<String, Object[]> instantiatorParameters = instantiator.getParameters();
            for (String key : instantiatorParameters.keySet()) {
                HashMap<String, Serializable> instantiatorParameterAttributes = new HashMap<String, Serializable>();
                instantiatorParameterAttributes.put("name", (Serializable)((Object)key));
                xmlDefBuilder.createNode(parametersNode, "parameter", (Serializable)Misc.serialize((Serializable)instantiatorParameters.get(key)), instantiatorParameterAttributes);
            }
        }
    }

    private void createMultipleActivitiesJoinChecker(XmlBuilder xmlDefBuilder, Node parentNode, MultiInstantiationDefinition joinChecker) throws Exception {
        if (joinChecker != null) {
            Node joinCheckerNode = xmlDefBuilder.createNode(parentNode, "multiple-act-joinchecker");
            xmlDefBuilder.createNode(joinCheckerNode, "classname", (Serializable)((Object)joinChecker.getClassName()));
            xmlDefBuilder.createNode(joinCheckerNode, "description", (Serializable)((Object)joinChecker.getDescription()));
            Node parametersNode = xmlDefBuilder.createNode(joinCheckerNode, "parameters");
            Map<String, Object[]> joinCheckerParameters = joinChecker.getParameters();
            for (String key : joinCheckerParameters.keySet()) {
                HashMap<String, Serializable> joinCheckerParameterAttributes = new HashMap<String, Serializable>();
                joinCheckerParameterAttributes.put("name", (Serializable)((Object)key));
                xmlDefBuilder.createNode(parametersNode, "parameter", (Serializable)Misc.serialize((Serializable)joinCheckerParameters.get(key)), joinCheckerParameterAttributes);
            }
        }
    }

    private void createFilter(XmlBuilder xmlDefBuilder, Node parentNode, FilterDefinition filter) throws Exception {
        if (filter != null) {
            Node filterNode = xmlDefBuilder.createNode(parentNode, "filter");
            xmlDefBuilder.createNode(filterNode, "classname", (Serializable)((Object)filter.getClassName()));
            xmlDefBuilder.createNode(filterNode, "description", (Serializable)((Object)filter.getDescription()));
            Node parametersNode = xmlDefBuilder.createNode(filterNode, "parameters");
            Map<String, Object[]> filterParameters = filter.getParameters();
            for (String key : filterParameters.keySet()) {
                HashMap<String, Serializable> filterParameterAttributes = new HashMap<String, Serializable>();
                filterParameterAttributes.put("name", (Serializable)((Object)key));
                xmlDefBuilder.createNode(parametersNode, "parameter", (Serializable)Misc.serialize((Serializable)filterParameters.get(key)), filterParameterAttributes);
            }
        }
    }

    private void createTransitions(XmlBuilder xmlDefBuilder, Node parentNode, Set<TransitionDefinition> transitions) throws Exception {
        Node transitionsNode = xmlDefBuilder.createNode(parentNode, "transitions");
        for (TransitionDefinition transitionDefinition : transitions) {
            HashMap<String, Serializable> transitionElementAttributes = new HashMap<String, Serializable>();
            transitionElementAttributes.put("name", (Serializable)((Object)transitionDefinition.getName()));
            Node transitionNode = xmlDefBuilder.createNode(transitionsNode, "transition", (Map<String, Serializable>)transitionElementAttributes);
            xmlDefBuilder.createNode(transitionNode, "label", (Serializable)((Object)transitionDefinition.getLabel()));
            xmlDefBuilder.createNode(transitionNode, "condition", (Serializable)((Object)transitionDefinition.getCondition()));
            xmlDefBuilder.createNode(transitionNode, "description", (Serializable)((Object)transitionDefinition.getDescription()));
            xmlDefBuilder.createNode(transitionNode, "from", (Serializable)((Object)transitionDefinition.getFrom()));
            xmlDefBuilder.createNode(transitionNode, "to", (Serializable)((Object)transitionDefinition.getTo()));
            xmlDefBuilder.createNode(transitionNode, "is-default", Boolean.valueOf(transitionDefinition.isDefault()));
        }
    }

    private void createDataFields(XmlBuilder xmlDefBuilder, Node parentNode, Set<DataFieldDefinition> dataFields) throws Exception {
        Node dataFieldsNode = xmlDefBuilder.createNode(parentNode, "data-fields");
        for (DataFieldDefinition dataFieldDefinition : dataFields) {
            HashMap<String, Serializable> dataFieldElementAttributes = new HashMap<String, Serializable>();
            dataFieldElementAttributes.put("name", (Serializable)((Object)dataFieldDefinition.getName()));
            Node dataFieldNode = xmlDefBuilder.createNode(dataFieldsNode, "data-field", (Map<String, Serializable>)dataFieldElementAttributes);
            xmlDefBuilder.createNode(dataFieldNode, "label", (Serializable)((Object)dataFieldDefinition.getLabel()));
            xmlDefBuilder.createNode(dataFieldNode, "value", (Serializable)Misc.serialize(dataFieldDefinition.getInitialValue()));
            xmlDefBuilder.createNode(dataFieldNode, "description", (Serializable)((Object)dataFieldDefinition.getDescription()));
            xmlDefBuilder.createNode(dataFieldNode, "datatype-classname", (Serializable)((Object)dataFieldDefinition.getDataTypeClassName()));
            xmlDefBuilder.createNode(dataFieldNode, "scripting-value", (Serializable)((Object)dataFieldDefinition.getScriptingValue()));
            Node enumerationValuesNode = xmlDefBuilder.createNode(dataFieldNode, "enumeration-values");
            for (String enumerationValue : dataFieldDefinition.getEnumerationValues()) {
                xmlDefBuilder.createNode(enumerationValuesNode, "enumeration-value", (Serializable)((Object)enumerationValue));
            }
        }
    }

    private void createAttachments(XmlBuilder xmlDefBuilder, Node parentNode, Map<String, AttachmentDefinition> attachments) throws Exception {
        Node attachmentsNode = xmlDefBuilder.createNode(parentNode, "attachments");
        for (AttachmentDefinition attachmentDefinition : attachments.values()) {
            HashMap<String, Serializable> attachmentElementAttributes = new HashMap<String, Serializable>();
            attachmentElementAttributes.put("name", (Serializable)((Object)attachmentDefinition.getName()));
            Node attachmentNode = xmlDefBuilder.createNode(attachmentsNode, "attachment", (Map<String, Serializable>)attachmentElementAttributes);
            xmlDefBuilder.createNode(attachmentNode, "label", (Serializable)((Object)attachmentDefinition.getLabel()));
            xmlDefBuilder.createNode(attachmentNode, "file-path", (Serializable)((Object)attachmentDefinition.getFilePath()));
            xmlDefBuilder.createNode(attachmentNode, "description", (Serializable)((Object)attachmentDefinition.getDescription()));
            xmlDefBuilder.createNode(attachmentNode, "file-name", (Serializable)((Object)attachmentDefinition.getFileName()));
        }
    }

    private void createParticipants(XmlBuilder xmlDefBuilder, Node parentNode, Set<ParticipantDefinition> participants) throws Exception {
        Node participantsNode = xmlDefBuilder.createNode(parentNode, "participants");
        for (ParticipantDefinition participantDefinition : participants) {
            HashMap<String, Serializable> participantElementAttributes = new HashMap<String, Serializable>();
            participantElementAttributes.put("name", (Serializable)((Object)participantDefinition.getName()));
            Node participantNode = xmlDefBuilder.createNode(participantsNode, "participant", (Map<String, Serializable>)participantElementAttributes);
            xmlDefBuilder.createNode(participantNode, "label", (Serializable)((Object)participantDefinition.getLabel()));
            xmlDefBuilder.createNode(participantNode, "description", (Serializable)((Object)participantDefinition.getDescription()));
            this.createRoleMapper(xmlDefBuilder, participantNode, participantDefinition.getRoleMapper());
        }
    }

    private void createRoleMapper(XmlBuilder xmlDefBuilder, Node parentNode, RoleMapperDefinition roleMapperDefinition) throws Exception {
        if (roleMapperDefinition != null) {
            Node roleMapperNode = xmlDefBuilder.createNode(parentNode, "role-mapper");
            if (roleMapperDefinition != null) {
                xmlDefBuilder.createNode(roleMapperNode, "classname", (Serializable)((Object)roleMapperDefinition.getClassName()));
                xmlDefBuilder.createNode(roleMapperNode, "description", (Serializable)((Object)roleMapperDefinition.getDescription()));
                Node parametersNode = xmlDefBuilder.createNode(roleMapperNode, "parameters");
                Map<String, Object[]> roleMapperParameters = roleMapperDefinition.getParameters();
                for (String key : roleMapperParameters.keySet()) {
                    HashMap<String, Serializable> roleMapperParameterAttributes = new HashMap<String, Serializable>();
                    roleMapperParameterAttributes.put("name", (Serializable)((Object)key));
                    xmlDefBuilder.createNode(parametersNode, "parameter", (Serializable)Misc.serialize((Serializable)roleMapperParameters.get(key)), roleMapperParameterAttributes);
                }
            }
        }
    }

    private void createConnectors(XmlBuilder xmlDefBuilder, Node parentNode, List<HookDefinition> hooks) throws Exception {
        Node connectorsNode = xmlDefBuilder.createNode(parentNode, "connectors");
        for (HookDefinition hook : hooks) {
            Node connectorNode = xmlDefBuilder.createNode(connectorsNode, "connector");
            xmlDefBuilder.createNode(connectorNode, "classname", (Serializable)((Object)hook.getClassName()));
            xmlDefBuilder.createNode(connectorNode, "description", (Serializable)((Object)hook.getDescription()));
            xmlDefBuilder.createNode(connectorNode, "event", (Serializable)((Object)hook.getEvent()));
            xmlDefBuilder.createNode(connectorNode, "throw-exception", Boolean.valueOf(hook.isThrowingException()));
            Node parametersNode = xmlDefBuilder.createNode(connectorNode, "parameters");
            Map<String, Object[]> hookParameters = hook.getParameters();
            for (String key : hookParameters.keySet()) {
                HashMap<String, Serializable> hookParametersAttributes = new HashMap<String, Serializable>();
                hookParametersAttributes.put("name", (Serializable)((Object)key));
                xmlDefBuilder.createNode(parametersNode, "parameter", (Serializable)Misc.serialize((Serializable)hookParameters.get(key)), hookParametersAttributes);
            }
        }
    }
}

