/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.connector.core;

import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.ow2.bonita.connector.core.Connector;
import org.ow2.bonita.connector.core.ConnectorDescription;
import org.ow2.bonita.connector.core.ConnectorException;
import org.ow2.bonita.connector.core.Filter;
import org.ow2.bonita.connector.core.Mapper;
import org.ow2.bonita.connector.core.MultiInstantiator;
import org.ow2.bonita.connector.core.MultipleInstancesInstantiator;
import org.ow2.bonita.connector.core.MultipleInstancesJoinChecker;
import org.ow2.bonita.connector.core.RoleResolver;
import org.ow2.bonita.connector.core.desc.Category;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorAPI {
    protected static final String OTHER_CATEGORY = "Other";
    protected static final String OTHER_ICON = "org/ow2/bonita/connector/core/other.png";
    public static Category other = new Category("Other", "org/ow2/bonita/connector/core/other.png", Thread.currentThread().getContextClassLoader());
    private List<ConnectorDescription> connectors;
    private Locale currentLocale;
    private ClassLoader classLoader;
    private Collection<ConnectorException> exceptions;

    public ConnectorAPI(ClassLoader classLoader, List<String> classNames) throws Exception {
        this(classLoader, classNames, Locale.getDefault());
    }

    public ConnectorAPI(ClassLoader classLoader, List<String> classNames, Locale locale) throws Exception {
        Misc.checkArgsNotNull(classLoader, classNames, locale);
        this.currentLocale = locale;
        this.connectors = new ArrayList<ConnectorDescription>();
        this.classLoader = classLoader;
        this.exceptions = new ArrayList<ConnectorException>();
        this.getConnectors(classNames);
    }

    private void getConnectors(List<String> classNames) throws Exception {
        for (String className : classNames) {
            Class<?> javaClass = this.getClass(className);
            if (javaClass == null) continue;
            this.addClass(javaClass);
        }
    }

    private Class<?> getClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (Throwable e) {
            ConnectorException exception = new ConnectorException(e, "Cannot load " + className, null);
            this.exceptions.add(exception);
            return null;
        }
    }

    private void addClass(Class<?> javaClass) {
        try {
            if (this.isAnInstanceOfConnector(javaClass)) {
                ConnectorDescription temp = new ConnectorDescription(javaClass, this.currentLocale);
                String id = temp.getId();
                if (this.idExists(id)) {
                    this.exceptions.add(new ConnectorException("Cannot load " + javaClass.getName() + " because a similar id exists", id, javaClass.getName(), null));
                }
                this.connectors.add(temp);
            }
        }
        catch (ConnectorException e) {
            this.exceptions.add(e);
        }
        catch (Throwable e) {
            String className = "null";
            if (javaClass != null) {
                className = javaClass.getName();
            }
            ConnectorException exception = new ConnectorException(e, className, null);
            this.exceptions.add(exception);
        }
    }

    private boolean idExists(String id) {
        boolean exists = false;
        for (ConnectorDescription connector : this.connectors) {
            if (!id.equals(connector.getId())) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public List<ConnectorDescription> getAllConnectors() {
        return this.connectors;
    }

    public List<ConnectorDescription> getJavaConnectors() {
        ArrayList<ConnectorDescription> javaconnectors = new ArrayList<ConnectorDescription>();
        for (ConnectorDescription connector : this.connectors) {
            Class<? extends Connector> clazz = connector.getConnectorClass();
            if (!this.isConnector(clazz) || this.isMapper(clazz) || this.isMultiInstantiator(clazz) || this.isInstantiator(clazz) || this.isJoinChecker(clazz)) continue;
            javaconnectors.add(connector);
        }
        return javaconnectors;
    }

    public List<ConnectorDescription> getRoleResolvers() {
        ArrayList<ConnectorDescription> roleResolvers = new ArrayList<ConnectorDescription>();
        for (ConnectorDescription connector : this.connectors) {
            Class<? extends Connector> clazz = connector.getConnectorClass();
            if (!this.isRoleResolver(clazz)) continue;
            roleResolvers.add(connector);
        }
        return roleResolvers;
    }

    public List<ConnectorDescription> getFilters() {
        ArrayList<ConnectorDescription> filters = new ArrayList<ConnectorDescription>();
        for (ConnectorDescription connector : this.connectors) {
            Class<? extends Connector> clazz = connector.getConnectorClass();
            if (!this.isFilter(clazz)) continue;
            filters.add(connector);
        }
        return filters;
    }

    @Deprecated
    public List<ConnectorDescription> getMultiInstantiators() {
        ArrayList<ConnectorDescription> multis = new ArrayList<ConnectorDescription>();
        for (ConnectorDescription connector : this.connectors) {
            Class<? extends Connector> clazz = connector.getConnectorClass();
            if (!this.isMultiInstantiator(clazz)) continue;
            multis.add(connector);
        }
        return multis;
    }

    public List<ConnectorDescription> getInstantiators() {
        ArrayList<ConnectorDescription> instantiators = new ArrayList<ConnectorDescription>();
        for (ConnectorDescription connector : this.connectors) {
            Class<? extends Connector> clazz = connector.getConnectorClass();
            if (!this.isInstantiator(clazz)) continue;
            instantiators.add(connector);
        }
        return instantiators;
    }

    public List<ConnectorDescription> getJoinCheckers() {
        ArrayList<ConnectorDescription> joinCheckers = new ArrayList<ConnectorDescription>();
        for (ConnectorDescription connector : this.connectors) {
            Class<? extends Connector> clazz = connector.getConnectorClass();
            if (!this.isJoinChecker(clazz)) continue;
            joinCheckers.add(connector);
        }
        return joinCheckers;
    }

    private boolean isConnector(Class<?> clazz) {
        try {
            Object connector = clazz.newInstance();
            return connector instanceof Connector;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean isMapper(Class<?> clazz) {
        try {
            Object connector = clazz.newInstance();
            return connector instanceof Mapper;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean isFilter(Class<?> clazz) {
        try {
            Object connector = clazz.newInstance();
            return connector instanceof Filter;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean isRoleResolver(Class<?> clazz) {
        try {
            Object connector = clazz.newInstance();
            return connector instanceof RoleResolver;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean isMultiInstantiator(Class<?> clazz) {
        try {
            Object connector = clazz.newInstance();
            return connector instanceof MultiInstantiator;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean isInstantiator(Class<?> clazz) {
        try {
            Object connector = clazz.newInstance();
            return connector instanceof MultipleInstancesInstantiator;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean isJoinChecker(Class<?> clazz) {
        try {
            Object connector = clazz.newInstance();
            return connector instanceof MultipleInstancesJoinChecker;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public List<ConnectorDescription> getAllConnectors(String categoryName) {
        return this.getConnectors(this.connectors, categoryName);
    }

    public List<ConnectorDescription> getJavaConnectors(String categoryName) {
        List<ConnectorDescription> javaConnectors = this.getJavaConnectors();
        return this.getConnectors(javaConnectors, categoryName);
    }

    public List<ConnectorDescription> getRoleResolverConnectors(String categoryName) {
        List<ConnectorDescription> roleMappers = this.getRoleResolvers();
        return this.getConnectors(roleMappers, categoryName);
    }

    public List<ConnectorDescription> getFilterConnectors(String categoryName) {
        List<ConnectorDescription> mappers = this.getFilters();
        return this.getConnectors(mappers, categoryName);
    }

    @Deprecated
    public List<ConnectorDescription> getMultiInstantiatorConnectors(String categoryName) {
        List<ConnectorDescription> multi = this.getMultiInstantiators();
        return this.getConnectors(multi, categoryName);
    }

    public List<ConnectorDescription> getInstantiatorConnectors(String categoryName) {
        List<ConnectorDescription> multi = this.getInstantiators();
        return this.getConnectors(multi, categoryName);
    }

    public List<ConnectorDescription> getJoinCheckerConnectors(String categoryName) {
        List<ConnectorDescription> multi = this.getJoinCheckers();
        return this.getConnectors(multi, categoryName);
    }

    private List<ConnectorDescription> getConnectors(List<ConnectorDescription> list, String categoryName) {
        ArrayList<ConnectorDescription> connectors = new ArrayList<ConnectorDescription>();
        for (ConnectorDescription connector : list) {
            List<Category> categories = connector.getCategories();
            for (Category category : categories) {
                String categ = this.getPropertyValue(connector.getConnectorClass(), category.getName());
                if (categ == null) {
                    categ = category.getName();
                }
                if (!categoryName.equals(categ)) continue;
                connectors.add(connector);
            }
        }
        return connectors;
    }

    public ConnectorDescription getConnector(String id) {
        return this.getConnector(this.connectors, id);
    }

    public ConnectorDescription getRoleResolverConnector(String id) {
        List<ConnectorDescription> roleMappers = this.getRoleResolvers();
        return this.getConnector(roleMappers, id);
    }

    public ConnectorDescription getJavaConnector(String id) {
        List<ConnectorDescription> javaConnectors = this.getJavaConnectors();
        return this.getConnector(javaConnectors, id);
    }

    public ConnectorDescription getFilterConnector(String id) {
        List<ConnectorDescription> mappers = this.getFilters();
        return this.getConnector(mappers, id);
    }

    private ConnectorDescription getConnector(List<ConnectorDescription> list, String id) {
        ConnectorDescription desc = null;
        int size = list.size();
        boolean found = false;
        for (int i = 0; i < size && !found; ++i) {
            ConnectorDescription temp = list.get(i);
            if (!id.equals(temp.getId())) continue;
            desc = temp;
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("The identifier " + id + " does not refer to a Connector");
        }
        return desc;
    }

    public List<Category> getAllCategories() {
        return this.getCategories(this.connectors);
    }

    public List<Category> getJavaConnectorsCategories() {
        List<ConnectorDescription> javaConnectors = this.getJavaConnectors();
        return this.getCategories(javaConnectors);
    }

    public List<Category> getRoleResolversCategories() {
        List<ConnectorDescription> roleMappers = this.getRoleResolvers();
        return this.getCategories(roleMappers);
    }

    public List<Category> getFiltersCategories() {
        List<ConnectorDescription> mappers = this.getFilters();
        return this.getCategories(mappers);
    }

    @Deprecated
    public List<Category> getMulitInstantiatorCategories() {
        List<ConnectorDescription> multis = this.getMultiInstantiators();
        return this.getCategories(multis);
    }

    public List<Category> getInstantiatorCategories() {
        List<ConnectorDescription> multis = this.getInstantiators();
        return this.getCategories(multis);
    }

    public List<Category> getJoinCheckerCategories() {
        List<ConnectorDescription> multis = this.getJoinCheckers();
        return this.getCategories(multis);
    }

    private Map<String, String> getCategoriesMap(List<ConnectorDescription> list) {
        HashMap<String, String> categories = new HashMap<String, String>();
        for (ConnectorDescription connector : list) {
            List<Category> connectorCategories = connector.getCategories();
            if (connectorCategories.isEmpty()) {
                connectorCategories.add(other);
            }
            for (Category category : connectorCategories) {
                String categoryId = category.getName();
                String categoryName = connector.getCategoryName(categoryId);
                if (categoryName == null) {
                    categoryName = categoryId;
                }
                if (!categories.containsKey(categoryName)) {
                    categories.put(categoryName, category.getIconPath());
                    continue;
                }
                String icon = (String)categories.get(categoryName);
                InputStream categoryIcon = category.getIcon();
                if (icon != null || categoryIcon == null) continue;
                categories.put(categoryName, category.getIconPath());
            }
        }
        return categories;
    }

    private List<Category> getCategories(List<ConnectorDescription> list) {
        Map<String, String> categoriesMap = this.getCategoriesMap(list);
        Set<String> categoryNames = categoriesMap.keySet();
        ArrayList<String> cat = new ArrayList<String>(categoryNames);
        Collections.sort(cat);
        ArrayList<Category> categories = new ArrayList<Category>();
        for (String categoryName : cat) {
            String icon = categoriesMap.get(categoryName);
            Category category = new Category(categoryName, icon, this.classLoader);
            categories.add(category);
        }
        return categories;
    }

    private String getPropertyValue(Class<? extends Connector> connectorClass, String property) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(connectorClass.getName(), this.currentLocale, connectorClass.getClassLoader());
            return bundle.getString(property);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isAnInstanceOfConnector(Class<?> c) {
        if (Modifier.isAbstract(c.getModifiers()) || c.equals(Connector.class)) {
            return false;
        }
        return this.isAConnector(c);
    }

    private boolean isAConnector(Class<?> c) {
        if (c.equals(Connector.class)) {
            return true;
        }
        Class<?> superClass = c.getSuperclass();
        if (superClass != null) {
            return this.isAConnector(superClass);
        }
        return false;
    }

    public void setCurrentLocale(Locale currentLocale) {
        this.currentLocale = currentLocale;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public Collection<ConnectorException> getExcpetions() {
        return this.exceptions;
    }
}

