/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.connector.core;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.InputStream;
import java.io.OutputStream;
import org.ow2.bonita.connector.core.Connector;
import org.ow2.bonita.connector.core.desc.Array;
import org.ow2.bonita.connector.core.desc.Category;
import org.ow2.bonita.connector.core.desc.Checkbox;
import org.ow2.bonita.connector.core.desc.CompositeWidget;
import org.ow2.bonita.connector.core.desc.ConnectorDescriptor;
import org.ow2.bonita.connector.core.desc.Enumeration;
import org.ow2.bonita.connector.core.desc.Getter;
import org.ow2.bonita.connector.core.desc.Group;
import org.ow2.bonita.connector.core.desc.Page;
import org.ow2.bonita.connector.core.desc.Password;
import org.ow2.bonita.connector.core.desc.Radio;
import org.ow2.bonita.connector.core.desc.Select;
import org.ow2.bonita.connector.core.desc.Setter;
import org.ow2.bonita.connector.core.desc.SimpleList;
import org.ow2.bonita.connector.core.desc.Text;
import org.ow2.bonita.connector.core.desc.Textarea;
import org.ow2.bonita.definition.PerformerAssign;
import org.ow2.bonita.parsing.connector.ConnectorDescriptorParser;
import org.ow2.bonita.util.xml.Parse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectorDescriptorAPI {
    private static XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());

    private ConnectorDescriptorAPI() {
    }

    public static final ConnectorDescriptor load(Class<? extends Connector> c) {
        String descriptorPath = c.getSimpleName() + ".xml";
        InputStream input = null;
        try {
            ConnectorDescriptorParser parser = new ConnectorDescriptorParser();
            Parse parse = parser.createParse();
            input = c.getResourceAsStream(descriptorPath);
            parse.setInputStream(input);
            parse.setClassLoader(c.getClassLoader());
            ConnectorDescriptor descriptor = (ConnectorDescriptor)parse.execute().getDocumentObject();
            return descriptor;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void save(ConnectorDescriptor descriptor, OutputStream output) {
        String version = descriptor.getVersion();
        if (!"5.0".equals(version)) {
            descriptor.setVersion("5.0");
        }
        xstream.toXML((Object)descriptor, output);
    }

    static {
        xstream.alias("connector", ConnectorDescriptor.class);
        xstream.alias("setter", Setter.class);
        xstream.alias("getter", Getter.class);
        xstream.alias("page", Page.class);
        xstream.alias("text", Text.class);
        xstream.alias("textarea", Textarea.class);
        xstream.alias("checkbox", Checkbox.class);
        xstream.alias("radio", Radio.class);
        xstream.alias("select", Select.class);
        xstream.alias("enumeration", Enumeration.class);
        xstream.alias("group", Group.class);
        xstream.alias("compositeWidget", CompositeWidget.class);
        xstream.alias("password", Password.class);
        xstream.alias("array", Array.class);
        xstream.alias("list", SimpleList.class);
        xstream.alias("perfomerAssign", PerformerAssign.class);
        xstream.alias("category", Category.class);
        xstream.omitField(Category.class, "classLoader");
        xstream.omitField(ConnectorDescriptor.class, "classLoader");
        xstream.setMode(1004);
    }
}

