/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.connector.core.desc;

import java.io.InputStream;

public class Category {
    private String name;
    private String icon;
    private ClassLoader classLoader;

    public Category(String name, String icon, ClassLoader classLoader) {
        this.name = name;
        this.icon = icon;
        this.classLoader = classLoader;
    }

    public String getName() {
        return this.name;
    }

    public String getIconPath() {
        return this.icon;
    }

    public InputStream getIcon() {
        if (this.icon != null && !"".equals(this.icon.trim())) {
            ClassLoader loader = this.classLoader;
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            return loader.getResourceAsStream(this.icon);
        }
        return null;
    }

    public boolean equals(Object object) {
        Category cat;
        if (object instanceof Category && this.name.equals((cat = (Category)object).getName())) {
            String path = cat.getIconPath();
            return path == null && this.icon == null || path != null && this.icon != null && path.equals(this.icon);
        }
        return false;
    }
}

