/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.connector.core.desc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ow2.bonita.connector.core.desc.Category;
import org.ow2.bonita.connector.core.desc.Getter;
import org.ow2.bonita.connector.core.desc.Page;
import org.ow2.bonita.connector.core.desc.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorDescriptor {
    private String connectorId;
    private String version;
    private String icon;
    private List<Category> categories;
    private List<Setter> inputs;
    private List<Getter> outputs;
    private List<Page> pages;
    private ClassLoader classLoader;

    protected ConnectorDescriptor() {
    }

    public ConnectorDescriptor(String connectorId, String version, ClassLoader classLoader) {
        this.connectorId = connectorId;
        this.version = version;
        this.classLoader = classLoader;
    }

    public void setIcon(String iconPath) {
        this.icon = iconPath;
    }

    public void addCategory(String name, String icon) {
        Category category;
        if (this.categories == null) {
            this.categories = new ArrayList<Category>();
        }
        if (!this.categories.contains(category = new Category(name, icon, this.classLoader))) {
            this.categories.add(category);
        }
    }

    public void removeCategory(Category category) {
        if (this.categories != null) {
            this.categories.remove(category);
        }
    }

    public void addSetter(Setter setter) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<Setter>();
        }
        if (!this.inputs.contains(setter)) {
            this.inputs.add(setter);
        }
    }

    public void addGetter(Getter getter) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<Getter>();
        }
        if (!this.outputs.contains(getter)) {
            this.outputs.add(getter);
        }
    }

    public void addPage(Page page) {
        if (this.pages == null) {
            this.pages = new ArrayList<Page>();
        }
        if (!this.pages.contains(page)) {
            this.pages.add(page);
        }
    }

    public ConnectorDescriptor(String connectorId, List<Category> categories, String icon, List<Setter> inputs, List<Getter> outputs, List<Page> pages) {
        this(connectorId, categories, icon, "1.0", inputs, outputs, pages);
    }

    public ConnectorDescriptor(String connectorId, List<Category> categories, String icon, String version, List<Setter> inputs, List<Getter> outputs, List<Page> pages) {
        this.connectorId = connectorId;
        this.categories = categories;
        this.icon = icon;
        this.inputs = inputs;
        this.outputs = outputs;
        this.pages = pages;
        this.version = version;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Setter> getInputs() {
        if (this.inputs == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Setter>(this.inputs);
    }

    public List<Getter> getOutputs() {
        return this.outputs;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

