/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.definition.MultiInstantiator;
import org.ow2.bonita.definition.MultiInstantiatorDescriptor;
import org.ow2.bonita.definition.activity.ActivityUtil;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.definition.activity.ExternalActivity;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.DeadlineDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.MultiInstantiationDefinition;
import org.ow2.bonita.facade.def.element.impl.IterationDescriptor;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.exception.BonitaWrapperException;
import org.ow2.bonita.facade.exception.MultiInstantiatorInvocationException;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.ClassDataLoader;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessUtil;
import org.ow2.bonita.util.VariableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActivity
implements ExternalActivity {
    private static final long serialVersionUID = -2731157748250833266L;
    static final Logger LOG = Logger.getLogger(AbstractActivity.class.getName());
    protected long dbid;
    protected String activityName;
    public static final String BODY_FINISHED = "bodyFinished";
    public static final String ACT_INSTANCE_FINISHED = "instFinished";
    public static final String DEADLINE_EVENT_SIGNAL = "timer";
    public static final String ASYNC_SIGNAL = "async";

    protected AbstractActivity() {
    }

    public AbstractActivity(String activityName) {
        this.activityName = activityName;
    }

    protected abstract boolean executeBusinessLogic(Execution var1);

    protected abstract boolean bodyStartAutomatically();

    @Override
    public void execute(Execution execution, boolean checkJoinType) {
        InternalActivityDefinition activity = execution.getNode();
        if (activity.isAsynchronous()) {
            Authentication.setUserId("SYSTEM");
        }
        if (execution.getInstance().getInstanceState().equals((Object)InstanceState.FINISHED)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Instance ended : " + execution.getInstance());
            }
            execution.end();
            Execution parent = execution.getParent();
            if (parent != null) {
                parent.removeExecution(execution);
            }
            return;
        }
        boolean joinOK = true;
        joinOK = ActivityUtil.isJoinOk(execution.getInstance(), execution.getNode());
        if (joinOK || !checkJoinType) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Join for activity " + this + " is OK.");
            }
            if (activity.getJoinType().equals((Object)ActivityDefinition.JoinType.XOR)) {
                this.cancelJoinXORIncomingTransitions(execution);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Creating a new iteration on activity : " + this);
            }
            ActivityUtil.createNewIteration(execution, activity);
            if (LOG.isLoggable(Level.FINE)) {
                String nodeName = activity.getName();
                LOG.fine("Executing node: " + nodeName + ", class = " + this.getClass().getSimpleName());
            }
            MultiInstantiationDefinition multiInstantiator = activity.getMultiInstantiationDefinition();
            MultiInstantiationDefinition instantiator = activity.getMultipleInstancesInstantiator();
            if (multiInstantiator != null || instantiator != null) {
                this.instantiateMultiInstanceActivity(execution);
            } else if (activity.isInALoop() && activity.evaluateLoopConditionBeforeExecution()) {
                if (ActivityUtil.evaluateLoopCondition(activity, execution)) {
                    Execution newExecution = execution.createChildExecution(execution.getNode().getName());
                    this.initializeActivityInstance(newExecution, null);
                    this.startActivityInstance(newExecution);
                } else {
                    this.terminateInstanceIfNoOutgoingTransitions(execution);
                    this.executeSplit(execution, false);
                }
            } else {
                Execution newExecution = execution.createChildExecution(execution.getNode().getName());
                this.initializeActivityInstance(newExecution, null);
                this.startActivityInstance(newExecution);
            }
        } else {
            execution.end();
            Execution parent = execution.getParent();
            if (parent != null) {
                parent.removeExecution(execution);
            }
        }
    }

    private void instantiateMultiInstanceActivity(Execution execution) {
        InternalActivityDefinition activity = execution.getNode();
        MultiInstantiationDefinition instantiator = activity.getMultipleInstancesInstantiator();
        if (instantiator != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("MultipleActivitiesInstantiation not null on activity " + this);
            }
            List<Object> contexts = new ArrayList();
            try {
                contexts = ConnectorExecutor.executeMultipleInstancesInstantiatior(instantiator, execution.getInstance().getUUID(), this.activityName, execution.getIterationId());
                if (contexts == null) {
                    String message = ExceptionManager.getInstance().getFullMessage("be_AA_8", activity.getName());
                    throw new BonitaRuntimeException(message);
                }
                if (contexts.isEmpty()) {
                    String message = ExceptionManager.getInstance().getFullMessage("be_AA_9", activity.getName());
                    throw new BonitaRuntimeException(message);
                }
            }
            catch (Exception e) {
                throw new BonitaRuntimeException(e.getMessage(), e);
            }
            execution.setWaitingForActivityInstanceNb(contexts.size());
            int childId = 0;
            ArrayList<Execution> activitiesToStart = new ArrayList<Execution>();
            for (Map map : contexts) {
                if (execution.getWaitingForActivityInstanceNb() <= 0) break;
                Execution childExec = execution.createChildExecution(execution.getName() + "/" + childId);
                childExec.setActivityInstanceId(Integer.toString(childId));
                HashSet<Variable> variables = new HashSet<Variable>();
                if (map != null) {
                    for (Map.Entry variable : map.entrySet()) {
                        Variable multiInstVar = VariableUtil.createVariable(activity.getProcessDefinitionUUID(), (String)variable.getKey(), variable.getValue());
                        variables.add(multiInstVar);
                    }
                }
                this.initializeActivityInstance(childExec, variables);
                activitiesToStart.add(childExec);
                ++childId;
            }
            for (Execution execution2 : activitiesToStart) {
                if (!execution2.isActive()) continue;
                this.startActivityInstance(execution2);
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("MultiInstantiation not null on activity " + this);
            }
            MultiInstantiatorDescriptor actInstDescr = null;
            MultiInstantiationDefinition multiDef = activity.getMultiInstantiationDefinition();
            MultiInstantiator actInstantiator = ClassDataLoader.getInstance(MultiInstantiator.class, execution.getInstance().getProcessDefinitionUUID(), multiDef);
            try {
                actInstDescr = ConnectorExecutor.executeMultiInstantiator(execution, activity.getName(), actInstantiator, multiDef.getParameters());
                if (actInstDescr == null) {
                    String message = ExceptionManager.getInstance().getFullMessage("be_AA_3", activity.getName());
                    throw new BonitaRuntimeException(message);
                }
            }
            catch (Exception e) {
                throw new BonitaWrapperException(new MultiInstantiatorInvocationException("be_AA_4", activity.getMultiInstantiationDefinition().getClassName().toString(), e));
            }
            execution.setWaitingForActivityInstanceNb(actInstDescr.getJoinNumber());
            int childId = 0;
            ArrayList<Execution> arrayList = new ArrayList<Execution>();
            for (Object value : actInstDescr.getVariableValues()) {
                if (execution.getWaitingForActivityInstanceNb() <= 0) break;
                Execution childExec = execution.createChildExecution(execution.getName() + "/" + childId);
                Variable multiInstVar = VariableUtil.createVariable(activity.getProcessDefinitionUUID(), activity.getMultiInstantiationDefinition().getVariableName(), value);
                childExec.setActivityInstanceId(Integer.toString(childId));
                HashSet<Variable> variables = new HashSet<Variable>();
                variables.add(multiInstVar);
                this.initializeActivityInstance(childExec, variables);
                arrayList.add(childExec);
                ++childId;
            }
            for (Execution childExec : arrayList) {
                if (!childExec.isActive()) continue;
                this.startActivityInstance(childExec);
            }
        }
    }

    private void cancelJoinXORIncomingTransitions(Execution execution) {
        InternalActivityDefinition currentNode = execution.getNode();
        InternalProcessInstance instance = execution.getInstance();
        this.cancelJoinXORIncomingTransitions(instance, currentNode, new HashSet<String>());
        for (TransitionDefinition t : currentNode.getIncomingTransitions()) {
            instance.setTransitionState(t.getName(), InternalProcessInstance.TransitionState.ABORTED);
        }
    }

    private void cancelJoinXORIncomingTransitions(InternalProcessInstance instance, InternalActivityDefinition currentNode, Set<String> checkedNodes) {
        Set<TransitionDefinition> incomingTransitions = currentNode.getIncomingTransitions();
        String currentNodeName = currentNode.getName();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Canceling other branches of the join XOR : " + currentNodeName);
        }
        checkedNodes.add(currentNodeName);
        for (TransitionDefinition incomingTransition : incomingTransitions) {
            String sourceNodeName = incomingTransition.getFrom();
            InternalProcessInstance.TransitionState transitionState = instance.getTransitionState(incomingTransition.getName());
            if (checkedNodes.contains(sourceNodeName) || transitionState != null && !transitionState.equals((Object)InternalProcessInstance.TransitionState.READY)) continue;
            boolean enable = false;
            InternalActivityDefinition sourceNode = instance.getRootExecution().getProcessDefinition().getActivity(sourceNodeName);
            if (transitionState != null) {
                instance.setTransitionState(incomingTransition.getName(), InternalProcessInstance.TransitionState.ABORTED);
                block1: for (TransitionDefinition tr : sourceNode.getOutgoingTransitions()) {
                    InternalProcessInstance.TransitionState ts = instance.getTransitionState(tr.getName());
                    if (ts != null && !ts.equals((Object)InternalProcessInstance.TransitionState.READY) || !currentNode.isInCycle()) continue;
                    InternalProcessDefinition process = EnvTool.getJournalQueriers().getProcess(instance.getProcessDefinitionUUID());
                    for (IterationDescriptor itDesc : process.getIterationDescriptors()) {
                        if (!itDesc.containsNode(tr.getTo())) continue;
                        enable = true;
                        break block1;
                    }
                }
            }
            if (enable) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(sourceNodeName + " has no more outgoing transitions enabled.");
            }
            List<Execution> execToAbortList = instance.getExecOnNode(sourceNodeName);
            for (Execution execToAbort : execToAbortList) {
                AbstractActivity.destroyTimers(execToAbort, sourceNodeName);
                if (!execToAbort.isActive()) continue;
                execToAbort.abort();
            }
            this.cancelJoinXORIncomingTransitions(instance, sourceNode, checkedNodes);
        }
    }

    protected void initializeActivityInstance(Execution internalExecution, Set<Variable> multiInstanceVariables) {
        InternalActivityDefinition activity = internalExecution.getNode();
        ProcessInstanceUUID instanceUUID = internalExecution.getInstance().getUUID();
        Recorder recorder = EnvTool.getRecorder();
        Map<String, Variable> initialVariables = ProcessUtil.createVariables(activity.getDataFields(), instanceUUID);
        if (multiInstanceVariables != null) {
            if (initialVariables == null) {
                initialVariables = new HashMap<String, Variable>();
            }
            for (Variable variable : multiInstanceVariables) {
                initialVariables.put(variable.getKey(), variable);
            }
        }
        String iterationId = internalExecution.getIterationId();
        String activityInstanceId = internalExecution.getActivityInstanceId();
        ActivityInstanceUUID activityUUID = new ActivityInstanceUUID(instanceUUID, activity.getName(), iterationId, activityInstanceId);
        InternalActivityInstance activityInstance = new InternalActivityInstance(activityUUID, activity, activity.getProcessDefinitionUUID(), instanceUUID, internalExecution.getInstance().getRootInstanceUUID(), internalExecution.getIterationId(), internalExecution.getActivityInstanceId());
        activityInstance.setActivityState(ActivityState.READY, "SYSTEM");
        activityInstance.setVariables(initialVariables);
        recorder.recordEnterActivity(activityInstance);
        if (activity.getDynamicDescription() != null) {
            try {
                Object dynamicDescription = GroovyUtil.evaluate(activity.getDynamicDescription(), null, activityUUID, false, false);
                if (dynamicDescription != null) {
                    activityInstance.setDynamicDescription(dynamicDescription.toString());
                }
            }
            catch (Exception e) {
                throw new BonitaWrapperException(new BonitaRuntimeException("Error while evaluating dynamic description: " + activity.getDynamicDescription(), e));
            }
        }
        if (activity.getDynamicLabel() != null) {
            try {
                Object dynamicLabel = GroovyUtil.evaluate(activity.getDynamicLabel(), null, activityUUID, false, false);
                if (dynamicLabel != null) {
                    activityInstance.setDynamicLabel(dynamicLabel.toString());
                }
            }
            catch (Exception e) {
                throw new BonitaWrapperException(new BonitaRuntimeException("Error while evaluating dynamic label: " + activity.getDynamicLabel(), e));
            }
        }
        internalExecution.setActivityInstance(activityInstance);
    }

    private void startActivityInstance(Execution internalExecution) {
        InternalActivityDefinition activity = internalExecution.getNode();
        ProcessInstanceUUID instanceUUID = internalExecution.getInstance().getProcessInstanceUUID();
        ActivityInstanceUUID activityUUID = internalExecution.getActivityInstanceUUID();
        try {
            this.initializeTimers(internalExecution);
        }
        catch (GroovyException e) {
            throw new BonitaWrapperException(new BonitaRuntimeException("Error while initializing timer: ", e));
        }
        if (activity.isAsynchronous()) {
            InternalActivityDefinition node = internalExecution.getNode();
            EventService eventService = EnvTool.getEventService();
            String uuid = UUID.randomUUID().toString();
            String processName = node.getProcessDefinitionUUID().getProcessName();
            String activityName = node.getName();
            String eventName = "**bonita_async**-" + activityUUID;
            long overdue = -1L;
            IncomingEventInstance incoming = new IncomingEventInstance(eventName, null, instanceUUID, node.getUUID(), activityUUID, processName, activityName, uuid, ASYNC_SIGNAL, System.currentTimeMillis(), true);
            OutgoingEventInstance outgoing = new OutgoingEventInstance(eventName, processName, activityName, null, instanceUUID, activityUUID, -1L);
            internalExecution.setEventUUID(uuid);
            eventService.fire(outgoing);
            eventService.subscribe(incoming);
            internalExecution.lock("async continuation " + eventName);
        } else {
            this.executeActivityInstance(internalExecution);
        }
    }

    protected void executeActivityInstance(Execution internalExecution) {
        boolean canContinue = this.executeBody(internalExecution);
        if (canContinue) {
            this.end(internalExecution);
        } else {
            internalExecution.waitForSignal();
        }
    }

    protected void end(Execution internalExecution) {
        EnvTool.getRecorder().recordBodyEnded(internalExecution.getActivityInstanceUUID());
        InternalActivityDefinition activity = internalExecution.getNode();
        if (activity.getMultiInstantiationDefinition() != null || activity.getMultipleInstancesInstantiator() != null) {
            this.endMultiInstantiation(internalExecution);
        } else if (activity.isInALoop()) {
            this.endLoop(internalExecution);
        } else {
            this.terminateInstanceIfNoOutgoingTransitions(internalExecution);
            this.executeSplit(internalExecution, true);
        }
    }

    protected void endMultiInstantiation(Execution internalExecution) {
        InternalActivityDefinition activity = internalExecution.getNode();
        Execution parent = internalExecution.getParent();
        MultiInstantiationDefinition joinChecker = activity.getMultipleInstancesJoinChecker();
        if (joinChecker != null) {
            boolean join = false;
            try {
                join = ConnectorExecutor.executeMultipleInstancesJoinChecker(joinChecker, internalExecution.getActivityInstance().getUUID());
            }
            catch (Exception e) {
                throw new BonitaRuntimeException(e.getMessage(), e);
            }
            if (join) {
                parent.setWaitingForActivityInstanceNb(1);
            } else if (parent.getWaitingForActivityInstanceNb() == 1) {
                parent.setWaitingForActivityInstanceNb(2);
            }
        }
        AbstractActivity.destroyTimers(internalExecution, internalExecution.getNodeName());
        internalExecution.end();
        parent.removeExecution(internalExecution);
        this.signal(parent, ACT_INSTANCE_FINISHED, null);
    }

    protected void endLoop(Execution internalExecution) {
        InternalActivityDefinition activity = internalExecution.getNode();
        Execution parent = internalExecution.getParent();
        int maxIterations = 0;
        String maxIterationsExpr = activity.getLoopMaximum();
        if (maxIterationsExpr != null) {
            try {
                if (Misc.isJustAGroovyExpression(maxIterationsExpr)) {
                    ProcessInstanceUUID instanceUUID = internalExecution.getInstance().getUUID();
                    Querier journal = EnvTool.getJournalQueriers();
                    InternalActivityInstance activityInstance = journal.getActivityInstance(instanceUUID, internalExecution.getNodeName(), internalExecution.getIterationId(), internalExecution.getActivityInstanceId());
                    maxIterations = (Integer)GroovyUtil.evaluate(maxIterationsExpr, null, activityInstance.getUUID(), false, false);
                } else {
                    maxIterations = Integer.parseInt(maxIterationsExpr);
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "The maximum number of loop iterations for activity " + this.activityName + " must be an integer or an expression that evaluates to an integer", e);
            }
        }
        parent.setWaitingForActivityInstanceNb(maxIterations);
        this.signal(parent, ACT_INSTANCE_FINISHED, null);
        if (!internalExecution.isFinished()) {
            boolean loop = true;
            if (!activity.evaluateLoopConditionBeforeExecution()) {
                loop = ActivityUtil.evaluateLoopCondition(activity, internalExecution);
            }
            if (loop) {
                parent.removeExecution(internalExecution);
                this.execute(parent, false);
            } else {
                this.terminateInstanceIfNoOutgoingTransitions(internalExecution);
                this.executeSplit(internalExecution, true);
            }
        }
    }

    private void terminateInstanceIfNoOutgoingTransitions(Execution internalExecution) {
        InternalActivityDefinition activity = internalExecution.getNode();
        if (!activity.hasOutgoingTransitions()) {
            InternalProcessInstance instance = internalExecution.getInstance();
            ProcessInstanceUUID instanceUUID = instance.getUUID();
            ProcessInstanceUUID parentInstanceUUID = instance.getParentInstanceUUID();
            ConnectorExecutor.executeConnectors(internalExecution, HookDefinition.Event.instanceOnFinish);
            Recorder recorder = EnvTool.getRecorder();
            recorder.recordInstanceEnded(instance.getUUID(), EnvTool.getUserId());
            ProcessUtil.removeInternalInstanceEvents(instance.getUUID());
            if (parentInstanceUUID != null) {
                HashMap<String, Object> signalParameters = new HashMap<String, Object>();
                signalParameters.put("childInstanceUUID", instanceUUID);
                InternalProcessInstance parentInstance = EnvTool.getJournalQueriers().getProcessInstance(parentInstanceUUID);
                Execution parentRootExecution = parentInstance.getRootExecution();
                Execution execToSignal = this.getSubflowExecution(parentRootExecution, instanceUUID);
                try {
                    execToSignal.getNode().getBehaviour().signal(execToSignal, "end_of_subflow", signalParameters);
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException(e.getMessage(), e);
                }
            } else {
                instance.finish();
            }
        }
    }

    private Execution getSubflowExecution(Execution exec, ProcessInstanceUUID subflowInstanceUUID) {
        if (exec.getActivityInstance() != null && exec.getActivityInstance().getSubflowProcessInstanceUUID() != null && exec.getActivityInstance().getSubflowProcessInstanceUUID().equals(subflowInstanceUUID)) {
            return exec;
        }
        for (Execution child : exec.getExecutions()) {
            Execution e = this.getSubflowExecution(child, subflowInstanceUUID);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    @Override
    public void signal(Execution execution, String signal, Map<String, Object> parameters) {
        Execution internalExecution = execution;
        InternalActivityDefinition activity = execution.getNode();
        if (BODY_FINISHED.equals(signal)) {
            this.end(internalExecution);
        } else if (ACT_INSTANCE_FINISHED.equals(signal)) {
            if (activity.getMultiInstantiationDefinition() != null || activity.getMultipleInstancesInstantiator() != null) {
                internalExecution.setWaitingForActivityInstanceNb(internalExecution.getWaitingForActivityInstanceNb() - 1);
                if (internalExecution.getWaitingForActivityInstanceNb() == 0) {
                    this.removeChildrenActivityInstances(internalExecution);
                    this.terminateInstanceIfNoOutgoingTransitions(internalExecution);
                    this.executeSplit(internalExecution, false);
                }
            } else {
                internalExecution.setActivityInstanceNb(internalExecution.getActivityInstanceNb() + 1);
                int maxIterations = internalExecution.getWaitingForActivityInstanceNb();
                if (0 < maxIterations && maxIterations <= internalExecution.getActivityInstanceNb()) {
                    this.endChildrenActivityInstances(internalExecution);
                    this.terminateInstanceIfNoOutgoingTransitions(internalExecution);
                    this.executeSplit(internalExecution, false);
                }
            }
        } else if (ASYNC_SIGNAL.equals(signal)) {
            Authentication.setUserId("SYSTEM");
            this.executeActivityInstance(internalExecution);
        } else if (DEADLINE_EVENT_SIGNAL.equals(signal)) {
            for (DeadlineDefinition deadline : activity.getDeadlines()) {
                String className = (String)parameters.get("className");
                if (!deadline.getClassName().equals(className)) continue;
                Authentication.setUserId("SYSTEM");
                internalExecution.waitForSignal();
                String activityId = internalExecution.getNode().getName();
                ConnectorExecutor.executeConnector(internalExecution, activityId, deadline);
                return;
            }
        }
    }

    private void removeChildrenActivityInstances(Execution execution) {
        if (execution.getExecutions() != null) {
            for (Execution execToAbort : new ArrayList<Execution>(execution.getExecutions())) {
                execToAbort.abort();
            }
        }
    }

    private void endChildrenActivityInstances(Execution execution) {
        if (execution.getExecutions() != null) {
            for (Execution execToEnd : new ArrayList<Execution>(execution.getExecutions())) {
                execToEnd.end();
                execution.removeExecution(execToEnd);
            }
        }
    }

    private void initializeTimers(Execution execution) throws GroovyException {
        InternalActivityDefinition node = execution.getNode();
        Set<DeadlineDefinition> deadlines = node.getDeadlines();
        if (!deadlines.isEmpty()) {
            ActivityInstanceUUID activityUUID = execution.getActivityInstanceUUID();
            String executionEventUUID = "timer-" + UUID.randomUUID().toString();
            execution.setEventUUID(executionEventUUID);
            EventService eventService = EnvTool.getEventService();
            String processName = node.getProcessDefinitionUUID().getProcessName();
            ProcessInstanceUUID instanceUUID = execution.getInstance().getProcessInstanceUUID();
            String activityName = node.getName();
            String eventName = "**bonita_deadline**-" + activityUUID;
            for (DeadlineDefinition deadline : deadlines) {
                String condition = deadline.getCondition();
                long enableTime = ProcessUtil.getTimerDate(condition, activityUUID, execution).getTime();
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("className", deadline.getClassName());
                IncomingEventInstance incoming = new IncomingEventInstance(eventName, "className.equals(\"" + deadline.getClassName() + "\")", instanceUUID, node.getUUID(), activityUUID, processName, activityName, executionEventUUID, DEADLINE_EVENT_SIGNAL, enableTime, false);
                OutgoingEventInstance outgoing = new OutgoingEventInstance(eventName, processName, activityName, parameters, instanceUUID, activityUUID, -1L);
                eventService.subscribe(incoming);
                eventService.fire(outgoing);
            }
        }
    }

    private static void destroyTimers(Execution execution, String activityName) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("destroying timers of " + execution.toString());
        }
        ProcessInstanceUUID instanceUUID = execution.getInstance().getUUID();
        ActivityInstanceUUID activityUUID = execution.getActivityInstanceUUID();
        String processName = instanceUUID.getProcessDefinitionUUID().getProcessName();
        if (activityUUID != null) {
            ActivityUtil.deleteEvents("**bonita_timer**-" + activityUUID, processName, activityName, activityUUID);
            ActivityUtil.deleteEvents("**bonita_deadline**-" + activityUUID, processName, activityName, activityUUID);
            ActivityUtil.deleteEvents("**bonita_async**-" + activityUUID, processName, activityName, activityUUID);
        }
    }

    private boolean executeBody(Execution internalExecution) {
        if (this.bodyStartAutomatically()) {
            EnvTool.getRecorder().recordBodyStarted(internalExecution.getActivityInstanceUUID());
        }
        return this.executeBusinessLogic(internalExecution);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append(": activtyName: " + this.getActivityName());
        return buffer.toString();
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void executeSplit(Execution execution, boolean removeScope) {
        Set<TransitionDefinition> transitions;
        InternalActivityDefinition activity = execution.getNode();
        Execution internalExecution = execution;
        InternalActivityDefinition currentNode = internalExecution.getNode();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("node = " + currentNode.getName() + " - splitType = " + (Object)((Object)activity.getSplitType()) + " - execution = " + execution.getName());
        }
        if ((transitions = currentNode.getOutgoingTransitions()) == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("node = " + currentNode.getName() + " - splitType = " + (Object)((Object)activity.getSplitType()) + " - execution = " + execution.getName() + " no transition available. Ending execution");
            }
            internalExecution.end();
            Execution parent = internalExecution.getParent();
            if (parent != null) {
                parent.removeExecution(internalExecution);
            }
        } else {
            InternalProcessInstance.TransitionState transitionState;
            TransitionDefinition defaultTransition = null;
            ArrayList<TransitionDefinition> transitionsToTake = new ArrayList<TransitionDefinition>();
            for (TransitionDefinition t : transitions) {
                InternalProcessInstance.TransitionState transitionState2;
                if (t.isDefault()) {
                    defaultTransition = t;
                    continue;
                }
                if (!ActivityUtil.evaluateTransition(t, internalExecution) || (transitionState2 = internalExecution.getInstance().getTransitionState(t.getName())) != null && !transitionState2.equals((Object)InternalProcessInstance.TransitionState.READY)) continue;
                internalExecution.getInstance().setTransitionState(t.getName(), InternalProcessInstance.TransitionState.TAKEN);
                transitionsToTake.add(t);
            }
            if (defaultTransition != null && transitionsToTake.size() == 0 && ((transitionState = internalExecution.getInstance().getTransitionState(defaultTransition.getName())) == null || transitionState.equals((Object)InternalProcessInstance.TransitionState.READY))) {
                internalExecution.getInstance().setTransitionState(defaultTransition.getName(), InternalProcessInstance.TransitionState.TAKEN);
                transitionsToTake.add(defaultTransition);
            }
            if (removeScope) {
                AbstractActivity.destroyTimers(internalExecution, this.activityName);
                internalExecution = internalExecution.backToParent();
            }
            internalExecution.setActivityInstance(null);
            if (transitionsToTake.size() == 0) {
                internalExecution.end();
                Execution parent = internalExecution.getParent();
                if (parent != null) {
                    parent.removeExecution(internalExecution);
                }
            } else {
                Set<IterationDescriptor> iterationDescriptors = null;
                if (activity.isInCycle()) {
                    InternalProcessDefinition process = EnvTool.getJournalQueriers().getProcess(activity.getProcessDefinitionUUID());
                    iterationDescriptors = process.getIterationDescriptors();
                    for (IterationDescriptor itD : iterationDescriptors) {
                        boolean isLeaving = false;
                        for (TransitionDefinition t : transitionsToTake) {
                            if (itD.containsNode(t.getTo()) || !itD.containsNode(t.getFrom())) continue;
                            isLeaving = true;
                        }
                        if (!isLeaving) continue;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine(activity.getName() + " is leaving a cycle, aborting other nodes in cycle.");
                        }
                        for (String nodeToAbort : itD.getCycleNodes()) {
                            if (nodeToAbort.equals(currentNode.getName())) continue;
                            List<Execution> execToAbortList = internalExecution.getInstance().getExecOnNode(nodeToAbort);
                            for (Execution execToAbort : execToAbortList) {
                                if (!execToAbort.isActive()) continue;
                                execToAbort.abort();
                            }
                        }
                    }
                }
                if (transitionsToTake.size() == 1 || ActivityDefinition.SplitType.XOR.equals((Object)activity.getSplitType())) {
                    TransitionDefinition t;
                    t = (TransitionDefinition)transitionsToTake.get(0);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Taking transition " + t);
                    }
                    internalExecution.take(t);
                } else {
                    int i;
                    if (activity.isInCycle()) {
                        for (IterationDescriptor itD : iterationDescriptors) {
                            boolean isLeaving = false;
                            boolean isStaying = false;
                            for (TransitionDefinition t : transitionsToTake) {
                                if (!itD.containsNode(t.getTo())) {
                                    isLeaving = true;
                                    continue;
                                }
                                isStaying = true;
                            }
                            if (!isStaying || !isLeaving) continue;
                            String message = ExceptionManager.getInstance().getFullMessage("be_AA_5", new Object[0]);
                            throw new BonitaWrapperException(new BonitaRuntimeException(message));
                        }
                    }
                    ArrayList<Execution> children = new ArrayList<Execution>();
                    for (i = 0; i < transitionsToTake.size(); ++i) {
                        TransitionDefinition t = (TransitionDefinition)transitionsToTake.get(i);
                        String name = t.getFrom() + "_to_" + t.getTo();
                        Execution childExecution = internalExecution.createChildExecution(name);
                        children.add(childExecution);
                    }
                    for (i = 0; i < transitionsToTake.size(); ++i) {
                        Execution childExecution = (Execution)children.get(i);
                        TransitionDefinition t = (TransitionDefinition)transitionsToTake.get(i);
                        if (childExecution.isFinished()) continue;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Execution " + childExecution.getName() + " is taking transition " + t);
                        }
                        childExecution.take(t);
                    }
                }
            }
        }
    }
}

