/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.Set;
import java.util.logging.Level;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.ConditionEvaluator;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.impl.IterationDescriptor;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public class ActivityUtil {
    static void deleteEvents(String eventName, String processName, String activityName, ActivityInstanceUUID activityUUID) {
        EventService eventService = EnvTool.getEventService();
        for (IncomingEventInstance incoming : eventService.getIncomingEvents(eventName, processName, activityName, activityUUID)) {
            eventService.removeEvent(incoming);
        }
        for (OutgoingEventInstance outgoing : eventService.getOutgoingEvents(eventName, processName, activityName, activityUUID)) {
            eventService.removeEvent(outgoing);
        }
    }

    static boolean evaluateTransition(TransitionDefinition t, Execution internalExecution) {
        String condition = t.getCondition();
        boolean conditionOK = true;
        if (condition != null && !(conditionOK = ConditionEvaluator.evaluate(condition, internalExecution)) && AbstractActivity.LOG.isLoggable(Level.FINE)) {
            AbstractActivity.LOG.fine("Unable to take transition: " + t.getName());
        }
        return conditionOK;
    }

    static boolean evaluateLoopCondition(ActivityDefinition activity, Execution internalExecution) {
        boolean execute = true;
        if (activity.isInALoop()) {
            String condition = activity.getLoopCondition();
            execute = ConditionEvaluator.evaluate(condition, internalExecution);
        }
        return execute;
    }

    static boolean isJoinOk(InternalProcessInstance instance, ActivityDefinition node) {
        if (!node.hasIncomingTransitions()) {
            return true;
        }
        if (node.getJoinType().equals((Object)ActivityDefinition.JoinType.XOR)) {
            for (TransitionDefinition transition : node.getIncomingTransitions()) {
                InternalProcessInstance.TransitionState ts = instance.getTransitionState(transition.getName());
                if (ts == null || !ts.equals((Object)InternalProcessInstance.TransitionState.TAKEN)) continue;
                return true;
            }
            return false;
        }
        for (TransitionDefinition transition : node.getIncomingTransitions()) {
            InternalProcessInstance.TransitionState ts = instance.getTransitionState(transition.getName());
            if (ts != null && ts.equals((Object)InternalProcessInstance.TransitionState.TAKEN)) continue;
            return false;
        }
        return true;
    }

    static void createNewIteration(Execution execution, ActivityDefinition activity) {
        if (activity.isInCycle() || activity.isInALoop()) {
            String iterationUUID = Misc.getUniqueId("it");
            execution.setIterationId(iterationUUID);
            InternalProcessInstance instance = execution.getInstance();
            InternalProcessDefinition process = EnvTool.getJournalQueriers().getProcess(instance.getProcessDefinitionUUID());
            Set<IterationDescriptor> iterationDescriptors = process.getIterationDescriptors();
            for (IterationDescriptor it : iterationDescriptors) {
                if (!it.getEntryNodes().contains(execution.getNode().getName())) continue;
                for (String joinNodeDescr : it.getCycleNodes()) {
                    ActivityDefinition joinNode = process.getActivity(joinNodeDescr);
                    for (TransitionDefinition tr : joinNode.getIncomingTransitions()) {
                        if (!it.containsNode(tr.getFrom())) continue;
                        instance.removeTransitionState(tr.getName());
                    }
                    if (!ActivityUtil.isJoinOk(instance, joinNode)) continue;
                    String message = ExceptionManager.getInstance().getFullMessage("be_AA_7", joinNode.getName());
                    throw new BonitaRuntimeException(message);
                }
            }
        }
    }
}

