/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.connector.core.Connector;
import org.ow2.bonita.connector.core.Filter;
import org.ow2.bonita.connector.core.MultiInstantiatorInstantiator;
import org.ow2.bonita.connector.core.MultiInstantiatorJoinChecker;
import org.ow2.bonita.connector.core.MultipleInstancesInstantiator;
import org.ow2.bonita.connector.core.MultipleInstancesJoinChecker;
import org.ow2.bonita.connector.core.PerformerAssignFilter;
import org.ow2.bonita.connector.core.ProcessConnector;
import org.ow2.bonita.connector.core.RoleResolver;
import org.ow2.bonita.connector.core.desc.Getter;
import org.ow2.bonita.connector.core.desc.Setter;
import org.ow2.bonita.definition.Hook;
import org.ow2.bonita.definition.MultiInstantiator;
import org.ow2.bonita.definition.MultiInstantiatorDescriptor;
import org.ow2.bonita.definition.PerformerAssign;
import org.ow2.bonita.definition.RoleMapper;
import org.ow2.bonita.definition.TxHook;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.ConnectorDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.MultiInstantiationDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.exception.BonitaWrapperException;
import org.ow2.bonita.facade.exception.HookInvocationException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.impl.StandardQueryAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.ClassDataLoader;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyExpression;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectorExecutor {
    private static final Logger LOG = Logger.getLogger(ConnectorExecutor.class.getName());

    private ConnectorExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeConnector(TxHook connector, Map<String, Object[]> connectorParameters, ProcessInstanceUUID instanceUUID, ActivityInstance activityInst, Map<String, Object> extraParameters) throws Exception {
        ProcessDefinitionUUID processUUID = instanceUUID.getProcessDefinitionUUID();
        ActivityInstanceUUID activityInstanceUUID = null;
        if (activityInst != null) {
            activityInstanceUUID = activityInst.getUUID();
        }
        Map<Object, Object> inputs = new HashMap();
        if (connectorParameters != null) {
            inputs = ConnectorExecutor.getInputs(connectorParameters);
        }
        if (connector instanceof ProcessConnector) {
            inputs.put("setProcessInstanceUUID", new Object[]{instanceUUID});
            inputs.put("setProcessDefinitionUUID", new Object[]{processUUID});
            if (activityInst != null) {
                inputs.put("setActivityInstanceUUID", new Object[]{activityInstanceUUID});
            }
        }
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader processClassLoader = ClassDataLoader.getProcessClassLoader(processUUID);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            if (!inputs.isEmpty()) {
                if (activityInst != null) {
                    ConnectorExecutor.setParameters(inputs, connector, activityInst.getUUID(), null, extraParameters);
                } else {
                    ConnectorExecutor.setParameters(inputs, connector, null, instanceUUID, extraParameters);
                }
            }
            connector.execute(new StandardAPIAccessorImpl(), activityInst);
            if (connectorParameters != null) {
                Map<String, Object[]> outputs = ConnectorExecutor.getOuputs(connectorParameters);
                if (activityInst != null) {
                    ConnectorExecutor.setProcessOrActivityVariables(outputs, connector, activityInstanceUUID, instanceUUID);
                } else {
                    ConnectorExecutor.setProcessOrActivityVariables(outputs, connector, null, instanceUUID);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }

    private static Map<String, Object> getGetterValues(Connector connector) {
        List<Getter> getters = connector.getGetters();
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (getters != null) {
            for (Getter getter : getters) {
                try {
                    String getterName = Connector.getGetterName(getter.getName());
                    Method m = connector.getClass().getMethod(getterName, new Class[0]);
                    Object variableValue = m.invoke((Object)connector, new Object[0]);
                    values.put(getter.getName(), variableValue);
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException(e.getMessage(), e);
                }
            }
        }
        return values;
    }

    private static void setProcessOrActivityVariables(Map<String, Object[]> outputs, Object connector, ActivityInstanceUUID activityInstanceUUID, ProcessInstanceUUID instanceUUID) throws BonitaException {
        if (connector instanceof Connector) {
            Map<String, Object> values = ConnectorExecutor.getGetterValues((Connector)connector);
            for (Map.Entry<String, Object[]> output : outputs.entrySet()) {
                Object variableValue;
                String expression = (String)output.getValue()[0];
                String variableName = output.getKey();
                StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
                RuntimeAPI runtime = accessor.getRuntimeAPI();
                Object newValue = null;
                if (activityInstanceUUID != null) {
                    variableValue = runtime.evaluateGroovyExpression(expression, activityInstanceUUID, values, false, true);
                    newValue = ConnectorExecutor.convertIfPossible(variableValue, ConnectorExecutor.getDataTypeClassName(variableName, instanceUUID, activityInstanceUUID));
                    runtime.setVariable(activityInstanceUUID, variableName, newValue);
                    continue;
                }
                variableValue = runtime.evaluateGroovyExpression(expression, instanceUUID, values, true);
                newValue = ConnectorExecutor.convertIfPossible(variableValue, ConnectorExecutor.getDataTypeClassName(variableName, instanceUUID, activityInstanceUUID));
                runtime.setProcessInstanceVariable(instanceUUID, variableName, newValue);
            }
        }
    }

    private static String getDataTypeClassName(String variableName, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID) {
        StandardQueryAPIAccessorImpl accessor = new StandardQueryAPIAccessorImpl();
        QueryDefinitionAPI queryDefinitionAPI = accessor.getQueryDefinitionAPI("journalQueryList");
        try {
            DataFieldDefinition data = queryDefinitionAPI.getActivityDataField(activityUUID.getActivityDefinitionUUID(), variableName);
            return data.getDataTypeClassName();
        }
        catch (Exception e) {
            try {
                DataFieldDefinition data = queryDefinitionAPI.getProcessDataField(instanceUUID.getProcessDefinitionUUID(), variableName);
                return data.getDataTypeClassName();
            }
            catch (Exception a) {
                throw new BonitaRuntimeException(a.getMessage(), a);
            }
        }
    }

    private static Map<String, Object[]> getOuputs(Map<String, Object[]> connectorParameters) {
        HashMap<String, Object[]> outputs = new HashMap<String, Object[]>();
        for (Map.Entry<String, Object[]> parameter : connectorParameters.entrySet()) {
            String methodName = parameter.getKey();
            if (Misc.isSetter(methodName)) continue;
            outputs.put(methodName, parameter.getValue());
        }
        return outputs;
    }

    private static Map<String, Object[]> getInputs(Map<String, Object[]> connectorParameters) {
        HashMap<String, Object[]> inputs = new HashMap<String, Object[]>();
        for (Map.Entry<String, Object[]> parameter : connectorParameters.entrySet()) {
            String methodName = parameter.getKey();
            if (!Misc.isSetter(methodName)) continue;
            inputs.put(methodName, parameter.getValue());
        }
        return inputs;
    }

    private static Setter getSetter(List<Setter> inputs, String parameterName) {
        if (inputs != null) {
            for (Setter setter : inputs) {
                if (!setter.getSetterName().equals(parameterName)) continue;
                return setter;
            }
        }
        return null;
    }

    private static Object convertIfPossible(Object variableValue, String dataTypeClassName) {
        try {
            return Misc.convertIfPossible("", variableValue, dataTypeClassName);
        }
        catch (Exception e) {
            return variableValue;
        }
    }

    private static void setParameters(Map<String, Object[]> parameters, Object connector, ActivityInstanceUUID activityInstanceUUID, ProcessInstanceUUID processInstanceUUID, Map<String, Object> extraParameters) throws BonitaException {
        if (parameters != null) {
            for (Map.Entry<String, Object[]> parameter : parameters.entrySet()) {
                int i;
                List<Setter> setters;
                String methodName = parameter.getKey();
                Object[] methodParameters = ConnectorExecutor.evaluateParametersWithGroovy(parameter.getValue(), activityInstanceUUID, processInstanceUUID, extraParameters);
                Setter setter = null;
                if (connector instanceof Connector && (setters = ((Connector)connector).getSetters()) != null && (setter = ConnectorExecutor.getSetter(setters, methodName)) != null) {
                    Object[] setterParameters = setter.getParameters();
                    for (i = 0; i < setterParameters.length; ++i) {
                        Object setterParameter = setterParameters[i];
                        Class<?> setterParameterClass = setterParameter.getClass();
                        if (setterParameterClass == null || methodParameters[i] == null || setterParameterClass.equals(methodParameters[i].getClass())) continue;
                        Class<?> methodParameterClass = methodParameters[i].getClass();
                        if (methodParameterClass.equals(BigDecimal.class) || methodParameterClass.equals(BigInteger.class)) {
                            methodParameters[i] = ConnectorExecutor.convertIfPossible(methodParameters[i].toString(), setterParameterClass.getName());
                            continue;
                        }
                        if (!methodParameterClass.equals(String.class)) continue;
                        methodParameters[i] = ConnectorExecutor.convertIfPossible(methodParameters[i], setterParameterClass.getName());
                    }
                }
                Object[] setterParameters = null;
                if (setter != null) {
                    setterParameters = setter.getParameters();
                }
                Class[] parameterClasses = new Class[methodParameters.length];
                for (i = 0; i < parameterClasses.length; ++i) {
                    parameterClasses[i] = methodParameters[i] == null ? setterParameters[i].getClass() : methodParameters[i].getClass();
                }
                try {
                    Method m = Connector.getMethod(connector.getClass(), methodName, parameterClasses);
                    if (m == null) {
                        StringBuilder builder = new StringBuilder();
                        if (parameterClasses != null) {
                            builder.append("[");
                            for (Class class1 : parameterClasses) {
                                builder.append(class1).append(",");
                            }
                            builder.insert(builder.length() - 1, "").append("]");
                        }
                        throw new BonitaRuntimeException("Unable to find a method with name: " + methodName + " and parameters: " + builder.toString() + " in connector: " + connector.getClass());
                    }
                    m.invoke(connector, methodParameters);
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException(e.getMessage(), e);
                }
            }
        }
    }

    private static Object[] evaluateParametersWithGroovy(Object[] parameters, ActivityInstanceUUID activityInstanceUUID, ProcessInstanceUUID processInstanceUUID, Map<String, Object> extraParameters) {
        Object[] methodParameters = parameters;
        for (int i = 0; i < parameters.length; ++i) {
            Object methodParameter = methodParameters[i];
            if (methodParameter instanceof List) {
                List temp = (List)methodParameter;
                for (int j = 0; j < temp.size(); ++j) {
                    Object tempRow = temp.get(j);
                    if (tempRow instanceof List) {
                        List row = (List)tempRow;
                        for (int k = 0; k < row.size(); ++k) {
                            row.set(k, ConnectorExecutor.getEvaluatedExpression(row.get(k), activityInstanceUUID, processInstanceUUID, extraParameters));
                        }
                        temp.set(j, row);
                        continue;
                    }
                    temp.set(j, ConnectorExecutor.getEvaluatedExpression(temp.get(j), activityInstanceUUID, processInstanceUUID, extraParameters));
                }
                methodParameters[i] = temp;
                continue;
            }
            methodParameters[i] = ConnectorExecutor.getEvaluatedExpression(methodParameter, activityInstanceUUID, processInstanceUUID, extraParameters);
        }
        return methodParameters;
    }

    private static Object getEvaluatedExpression(Object parameterMethod, ActivityInstanceUUID activityUUID, ProcessInstanceUUID processUUID, Map<String, Object> extraParameters) {
        String expression;
        if (parameterMethod instanceof String && GroovyExpression.isGroovyExpression(expression = (String)parameterMethod)) {
            try {
                StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
                RuntimeAPI runtime = accessor.getRuntimeAPI();
                if (activityUUID != null) {
                    return runtime.evaluateGroovyExpression(expression, activityUUID, extraParameters, false, true);
                }
                if (processUUID != null) {
                    return runtime.evaluateGroovyExpression(expression, processUUID, extraParameters, true);
                }
                return GroovyUtil.evaluate(expression, extraParameters);
            }
            catch (Exception e) {
                throw new BonitaRuntimeException(e.getMessage(), e);
            }
        }
        return parameterMethod;
    }

    public static void executeConnector(Execution execution, String activityName, ConnectorDefinition connector, Map<String, Object> parameters) {
        block14: {
            if (connector != null) {
                InternalProcessInstance instance = execution.getInstance();
                ProcessInstanceUUID instanceUUID = instance.getUUID();
                ActivityInstanceUUID activityInstanceUUID = execution.getActivityInstanceUUID();
                ProcessDefinitionUUID processUUID = instance.getProcessDefinitionUUID();
                boolean inTransaction = connector.isThrowingException();
                try {
                    Hook hookInstance = ClassDataLoader.getInstance(Hook.class, instance.getProcessDefinitionUUID(), connector);
                    if (LOG.isLoggable(Level.FINE)) {
                        if (activityInstanceUUID != null) {
                            LOG.fine("Starting connector (instance=" + instanceUUID + ", process=" + processUUID + ", activityId=" + activityName + ") : " + connector);
                        } else {
                            LOG.fine("Starting connector (instance=" + instanceUUID + ", process=" + processUUID + ") : " + connector);
                        }
                    }
                    if (activityInstanceUUID == null) {
                        ConnectorExecutor.executeConnector((TxHook)((Object)hookInstance), connector.getParameters(), instanceUUID, null, parameters);
                    } else {
                        InternalActivityInstance activityInst = EnvTool.getJournalQueriers().getActivityInstance(activityInstanceUUID);
                        if (hookInstance instanceof Hook) {
                            Hook hook = hookInstance;
                            hook.execute(new StandardQueryAPIAccessorImpl(), activityInst);
                        } else if (hookInstance instanceof TxHook) {
                            TxHook txHook = (TxHook)((Object)hookInstance);
                            ConnectorExecutor.executeConnector(txHook, connector.getParameters(), instanceUUID, activityInst, parameters);
                        } else {
                            String message = ExceptionManager.getInstance().getFullMessage("bsi_HEI_2", Hook.class.getName(), TxHook.class.getName());
                            throw new BonitaRuntimeException(message);
                        }
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Finished connector (instance=" + instanceUUID + ", process=" + processUUID + ", activityId=" + activityName + ") : " + connector);
                        }
                    }
                }
                catch (Exception e) {
                    String message;
                    String string = message = e == null ? "null" : e.getMessage();
                    if (inTransaction) {
                        throw new BonitaWrapperException(new HookInvocationException("bsi_HEI_3", connector.getClassName() + " because " + message, e));
                    }
                    if (!LOG.isLoggable(Level.SEVERE)) break block14;
                    LOG.severe("Exception caught while executing connector (instance=" + instanceUUID + ", process=" + processUUID + ", activityId=" + activityName + ") : " + connector.getClassName() + " - Exception : " + message + " " + Misc.getStackTraceFrom(e));
                }
            }
        }
    }

    public static void executeConnectors(ActivityDefinition activityDef, Execution execution, HookDefinition.Event event, Map<String, Object> parameters) {
        List<HookDefinition> hooks = activityDef.getConnectors();
        if (hooks != null) {
            for (HookDefinition hook : hooks) {
                if (hook.getEvent() == null || !hook.getEvent().equals((Object)event)) continue;
                ConnectorExecutor.executeConnector(execution, activityDef.getName(), hook, parameters);
            }
        }
    }

    public static void executeConnector(Execution execution, String activityName, ConnectorDefinition connector) {
        ConnectorExecutor.executeConnector(execution, activityName, connector, null);
    }

    public static void executeConnectors(Execution execution, HookDefinition.Event event) {
        InternalProcessInstance instance = execution.getInstance();
        ProcessDefinitionUUID processUUID = instance.getProcessDefinitionUUID();
        InternalProcessDefinition definition = EnvTool.getJournalQueriers().getProcess(processUUID);
        List<HookDefinition> connectors = definition.getConnectors();
        if (connectors != null) {
            for (HookDefinition connector : connectors) {
                if (connector.getEvent() == null || !event.equals((Object)connector.getEvent())) continue;
                ConnectorExecutor.executeConnector(execution, null, connector);
            }
        }
    }

    private static Map<String, Object[]> formatParameters(Map<String, Object[]> parameters) {
        HashMap<String, Object[]> formattedParameters = new HashMap<String, Object[]>();
        if (parameters != null) {
            for (Map.Entry<String, Object[]> parameter : parameters.entrySet()) {
                String parameterName = parameter.getKey();
                if (!parameterName.startsWith("set")) {
                    StringBuilder builder = new StringBuilder("set");
                    builder.append(String.valueOf(parameterName.charAt(0)).toUpperCase());
                    builder.append(parameterName.substring(1));
                    parameterName = builder.toString();
                }
                formattedParameters.put(parameterName, parameter.getValue());
            }
        }
        return formattedParameters;
    }

    public static Map<String, Object> executeConnector(Connector connector, Map<String, Object[]> parameters) throws Exception {
        ConnectorExecutor.setParameters(ConnectorExecutor.formatParameters(parameters), connector, null, null, null);
        connector.execute();
        Map<String, Object> results = ConnectorExecutor.getGetterValues(connector);
        return results;
    }

    public static Set<String> executeFilter(Filter filter, Map<String, Object[]> parameters, Set<String> members) throws Exception {
        Misc.checkArgsNotNull(members);
        if (parameters == null) {
            parameters = new HashMap<String, Object[]>();
        }
        parameters.put("setMembers", new Object[]{members});
        ConnectorExecutor.setParameters(ConnectorExecutor.formatParameters(parameters), filter, null, null, null);
        filter.execute();
        return filter.getCandidates();
    }

    public static Set<String> executeRoleResolver(RoleResolver resolver, Map<String, Object[]> parameters) throws Exception {
        ConnectorExecutor.setParameters(ConnectorExecutor.formatParameters(parameters), resolver, null, null, null);
        return resolver.searchMembers(null, null, "test");
    }

    public static void executeConnectors(ActivityDefinition activityDef, Execution execution, HookDefinition.Event event) {
        ConnectorExecutor.executeConnectors(activityDef, execution, event, null);
    }

    public static MultiInstantiatorDescriptor executeMultiInstantiator(Execution execution, String activityId, MultiInstantiator actInstantiator, Map<String, Object[]> parameters) throws Exception {
        ProcessInstanceUUID instanceUUID = execution.getInstance().getUUID();
        if (parameters != null) {
            Map<String, Object[]> inputs = ConnectorExecutor.getInputs(parameters);
            ConnectorExecutor.setParameters(inputs, actInstantiator, null, instanceUUID, null);
        }
        return actInstantiator.execute(new StandardQueryAPIAccessorImpl(), instanceUUID, activityId, execution.getIterationId());
    }

    public static Set<String> executeRoleMapper(RoleMapper roleMapper, ProcessInstanceUUID instanceUUID, String roleId, Map<String, Object[]> parameters) throws Exception {
        if (parameters != null) {
            Map<String, Object[]> inputs = ConnectorExecutor.getInputs(parameters);
            ConnectorExecutor.setParameters(inputs, roleMapper, null, instanceUUID, null);
        }
        return roleMapper.searchMembers(new StandardQueryAPIAccessorImpl(), instanceUUID, roleId);
    }

    public static Set<String> executeFilter(Filter filter, PerformerAssign performerAssign, ActivityInstance activityInstance, Set<String> candidates, Map<String, Object[]> parameters) throws Exception {
        Map<Object, Object> inputs = new HashMap<String, Object[]>();
        if (filter instanceof PerformerAssignFilter) {
            inputs.put("setPerformerAssign", new Object[]{performerAssign});
            if (parameters != null) {
                ConnectorExecutor.setParameters(parameters, performerAssign, activityInstance.getUUID(), null, null);
            }
            inputs.put("setClassName", new Object[]{performerAssign.getClass().getName()});
        } else if (parameters != null) {
            inputs = ConnectorExecutor.getInputs(parameters);
        }
        inputs.put("setMembers", new Object[]{candidates});
        inputs.put("setActivityInstanceUUID", new Object[]{activityInstance.getUUID()});
        inputs.put("setProcessInstanceUUID", new Object[]{activityInstance.getProcessInstanceUUID()});
        inputs.put("setProcessDefinitionUUID", new Object[]{activityInstance.getProcessDefinitionUUID()});
        if (!inputs.isEmpty()) {
            ConnectorExecutor.setParameters(inputs, filter, activityInstance.getUUID(), null, null);
        }
        filter.execute();
        return filter.getCandidates();
    }

    public static List<Map<String, Object>> executeMultipleInstancesInstantiatior(MultiInstantiationDefinition instantiator, ProcessInstanceUUID instanceUUID, String activityName, String iterationId) throws Exception {
        ProcessDefinitionUUID definitionUUID = instanceUUID.getProcessDefinitionUUID();
        MultipleInstancesInstantiator activityinstantiator = ClassDataLoader.getInstance(MultipleInstancesInstantiator.class, definitionUUID, instantiator);
        Map<String, Object[]> parameters = instantiator.getParameters();
        Map<Object, Object> inputs = new HashMap<String, Object[]>();
        if (parameters != null) {
            inputs = ConnectorExecutor.getInputs(parameters);
        }
        inputs.put("setActivityName", new Object[]{activityName});
        inputs.put("setIterationId", new Object[]{iterationId});
        inputs.put("setProcessInstanceUUID", new Object[]{instanceUUID});
        inputs.put("setProcessDefinitionUUID", new Object[]{definitionUUID});
        ConnectorExecutor.setParameters(inputs, activityinstantiator, null, instanceUUID, null);
        if (activityinstantiator.getClass().getName().equals(MultiInstantiatorInstantiator.class.getName())) {
            Method method = activityinstantiator.getClass().getMethod("getClassName", null);
            String className = (String)method.invoke((Object)activityinstantiator, (Object[])null);
            org.ow2.bonita.connector.core.MultiInstantiator multiInstantiator = (org.ow2.bonita.connector.core.MultiInstantiator)ClassDataLoader.getInstance(definitionUUID, className);
            method = activityinstantiator.getClass().getMethod("getInstantiatorParameters", null);
            Map temp = (Map)method.invoke((Object)activityinstantiator, (Object[])null);
            if (temp != null) {
                temp.put("setActivityId", new Object[]{activityName});
                temp.put("setIterationId", new Object[]{iterationId});
                temp.put("setProcessInstanceUUID", new Object[]{instanceUUID});
                ConnectorExecutor.setParameters(temp, multiInstantiator, null, instanceUUID, null);
            }
            method = activityinstantiator.getClass().getMethod("setInstantiator", org.ow2.bonita.connector.core.MultiInstantiator.class);
            method.invoke((Object)activityinstantiator, multiInstantiator);
        }
        activityinstantiator.execute();
        return activityinstantiator.getActivitiesContext();
    }

    public static boolean executeMultipleInstancesJoinChecker(MultiInstantiationDefinition joinChecker, ActivityInstanceUUID activityUUID) throws Exception {
        ProcessInstanceUUID instanceUUID = activityUUID.getProcessInstanceUUID();
        ProcessDefinitionUUID definitionUUID = instanceUUID.getProcessDefinitionUUID();
        MultipleInstancesJoinChecker checker = ClassDataLoader.getInstance(MultipleInstancesJoinChecker.class, definitionUUID, joinChecker);
        Map<String, Object[]> parameters = joinChecker.getParameters();
        Map<Object, Object> inputs = new HashMap<String, Object[]>();
        if (parameters != null) {
            inputs = ConnectorExecutor.getInputs(parameters);
        }
        inputs.put("setActivityInstanceUUID", new Object[]{activityUUID});
        inputs.put("setActivityName", new Object[]{activityUUID.getActivityName()});
        inputs.put("setIterationId", new Object[]{activityUUID.getIterationId()});
        inputs.put("setProcessInstanceUUID", new Object[]{instanceUUID});
        inputs.put("setProcessDefinitionUUID", new Object[]{definitionUUID});
        ConnectorExecutor.setParameters(inputs, checker, null, instanceUUID, null);
        if (checker.getClass().getName().equals(MultiInstantiatorJoinChecker.class.getName())) {
            Method method = checker.getClass().getMethod("getClassName", null);
            String className = (String)method.invoke((Object)checker, (Object[])null);
            org.ow2.bonita.connector.core.MultiInstantiator multiInstantiator = (org.ow2.bonita.connector.core.MultiInstantiator)ClassDataLoader.getInstance(definitionUUID, className);
            method = checker.getClass().getMethod("getInstantiatorParameters", null);
            Map temp = (Map)method.invoke((Object)checker, (Object[])null);
            if (temp != null) {
                temp.put("setActivityId", new Object[]{activityUUID.getActivityName()});
                temp.put("setIterationId", new Object[]{activityUUID.getIterationId()});
                temp.put("setProcessInstanceUUID", new Object[]{instanceUUID});
                ConnectorExecutor.setParameters(temp, multiInstantiator, null, instanceUUID, null);
            }
            method = checker.getClass().getMethod("setInstantiator", org.ow2.bonita.connector.core.MultiInstantiator.class);
            method.invoke((Object)checker, multiInstantiator);
        }
        checker.execute();
        return checker.isJoinable();
    }
}

