/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.IncomingEventDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveEvent
extends AbstractActivity {
    private static final long serialVersionUID = 477565487347215726L;
    protected static final Logger LOG = Logger.getLogger(ReceiveEvent.class.getName());
    public static final String RECEIVE_EVENT_SIGNAL = "receive_event";

    protected ReceiveEvent() {
    }

    public ReceiveEvent(String activityName) {
        super(activityName);
    }

    @Override
    protected boolean bodyStartAutomatically() {
        return true;
    }

    @Override
    protected boolean executeBusinessLogic(Execution execution) {
        IncomingEventDefinition event;
        InternalActivityDefinition activity = execution.getNode();
        ActivityInstanceUUID activityUUID = execution.getActivityInstanceUUID();
        EventService eventService = EnvTool.getEventService();
        IncomingEventDefinition incomingEvent = activity.getIncomingEvent();
        String eventUUID = UUID.randomUUID().toString();
        IncomingEventInstance incomingEventInstance = new IncomingEventInstance(incomingEvent.getName(), incomingEvent.getExpression(), activityUUID.getProcessInstanceUUID(), activity.getUUID(), activityUUID, activity.getProcessDefinitionUUID().getProcessName(), this.activityName, eventUUID, RECEIVE_EVENT_SIGNAL, System.currentTimeMillis(), true);
        if (activity.getType().equals((Object)ActivityDefinition.Type.ReceiveEvent) && activity.getIncomingTransitions().isEmpty() && (event = activity.getIncomingEvent()) != null) {
            incomingEventInstance.setLockOwner(activityUUID.getProcessInstanceUUID().toString());
        }
        execution.setEventUUID(eventUUID);
        execution.lock("Incoming event " + eventUUID);
        eventService.subscribe(incomingEventInstance);
        return false;
    }

    @Override
    public void signal(Execution execution, String signal, Map<String, Object> signalParameters) {
        if (RECEIVE_EVENT_SIGNAL.equals(signal)) {
            Authentication.setUserId("SYSTEM");
            ConnectorExecutor.executeConnectors(execution.getNode(), execution, HookDefinition.Event.onEvent, signalParameters);
            super.signal(execution, "bodyFinished", null);
        } else {
            super.signal(execution, signal, signalParameters);
        }
    }
}

