/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.element.OutgoingEventDefinition;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;

public class SendEvents
extends AbstractActivity {
    private static final long serialVersionUID = 477565487347215726L;
    protected static final Logger LOG = Logger.getLogger(SendEvents.class.getName());

    protected SendEvents() {
    }

    public SendEvents(String activityName) {
        super(activityName);
    }

    protected boolean bodyStartAutomatically() {
        return true;
    }

    protected boolean executeBusinessLogic(Execution execution) {
        InternalActivityDefinition activity = execution.getNode();
        ProcessInstanceUUID instanceUUID = execution.getInstance().getUUID();
        ActivityInstanceUUID activityUUID = execution.getActivityInstanceUUID();
        EventService eventService = EnvTool.getEventService();
        for (OutgoingEventDefinition outgoingEvent : activity.getOutgoingEvents()) {
            Map<String, Object> parameters = outgoingEvent.getParameters();
            HashMap<String, Object> evaluatedParameters = null;
            if (parameters != null) {
                evaluatedParameters = new HashMap<String, Object>();
                for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                    Object newValue = parameter.getValue();
                    if (newValue != null && newValue instanceof String && Misc.isJustAGroovyExpression((String)newValue)) {
                        try {
                            newValue = GroovyUtil.evaluate((String)newValue, null, activityUUID, false, false);
                        }
                        catch (GroovyException e) {
                            throw new BonitaRuntimeException(e);
                        }
                    }
                    evaluatedParameters.put(parameter.getKey(), newValue);
                }
            }
            long overdue = -1L;
            if (outgoingEvent.getTimeToLive() >= 0L) {
                overdue = System.currentTimeMillis() + outgoingEvent.getTimeToLive();
            }
            OutgoingEventInstance eventInstance = new OutgoingEventInstance(outgoingEvent.getName(), outgoingEvent.getToProcessName(), outgoingEvent.getToActivityName(), evaluatedParameters, instanceUUID, activityUUID, overdue);
            eventService.fire(eventInstance);
        }
        return true;
    }
}

