/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.SubflowParameterDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.impl.StandardQueryAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.runtime.impl.InitialAttachmentImpl;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubFlow
extends AbstractActivity {
    private static final long serialVersionUID = 477565487347215726L;
    protected static final Logger LOG = Logger.getLogger(SubFlow.class.getName());
    public static final String SUBFLOW_SIGNAL = "end_of_subflow";

    protected SubFlow() {
    }

    public SubFlow(String activityName) {
        super(activityName);
    }

    @Override
    protected boolean bodyStartAutomatically() {
        return true;
    }

    @Override
    protected boolean executeBusinessLogic(Execution execution) {
        InternalActivityDefinition activityDefinition = execution.getNode();
        ConnectorExecutor.executeConnectors(activityDefinition, execution, HookDefinition.Event.automaticOnEnter);
        String subflowProcessName = activityDefinition.getSubflowProcessName();
        String subflowProcessVersion = activityDefinition.getSubflowProcessVersion();
        if (Misc.isJustAGroovyExpression(subflowProcessName)) {
            try {
                subflowProcessName = (String)GroovyUtil.evaluate(subflowProcessName, null, execution.getActivityInstanceUUID(), false, false);
            }
            catch (GroovyException e) {
                // empty catch block
            }
        }
        if (subflowProcessVersion != null && Misc.isJustAGroovyExpression(subflowProcessVersion)) {
            try {
                subflowProcessVersion = (String)GroovyUtil.evaluate(subflowProcessVersion, null, execution.getActivityInstanceUUID(), false, false);
            }
            catch (GroovyException e) {
                // empty catch block
            }
        }
        InternalProcessDefinition subProcess = null;
        subProcess = subflowProcessVersion == null ? EnvTool.getJournalQueriers().getLastDeployedProcess(subflowProcessName, ProcessDefinition.ProcessState.ENABLED) : EnvTool.getJournalQueriers().getProcess(subflowProcessName, subflowProcessVersion);
        if (subProcess == null) {
            String message = ExceptionManager.getInstance().getFullMessage("be_SF_1", subflowProcessName);
            throw new BonitaRuntimeException(message);
        }
        if (!ProcessDefinition.ProcessState.ENABLED.equals((Object)subProcess.getState())) {
            throw new BonitaRuntimeException("Subprocess: " + subProcess.getUUID() + " is not enabled. Can not use it as a subflow.");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting a new instance of process (as a subProcess) : " + subflowProcessName);
        }
        InternalProcessInstance instance = execution.getInstance();
        ProcessInstanceUUID instanceUUID = instance.getUUID();
        ActivityInstanceUUID activityUUID = execution.getActivityInstanceUUID();
        try {
            HashMap<String, Object> parameterValues = new HashMap<String, Object>();
            HashSet<InitialAttachment> attachments = new HashSet<InitialAttachment>();
            Set<SubflowParameterDefinition> inParameters = activityDefinition.getSubflowInParameters();
            if (inParameters != null) {
                StandardQueryAPIAccessorImpl accessor = new StandardQueryAPIAccessorImpl();
                QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI("journalQueryList");
                Map<String, Object> variables = queryRuntimeAPI.getVariables(activityUUID);
                Set<String> attachmentNames = queryRuntimeAPI.getAttachmentNames(instanceUUID);
                for (SubflowParameterDefinition parameter : inParameters) {
                    String source = parameter.getSource();
                    String destination = parameter.getDestination();
                    if (variables.containsKey(source)) {
                        parameterValues.put(destination, variables.get(source));
                        continue;
                    }
                    if (!attachmentNames.contains(source)) continue;
                    AttachmentInstance attachmentInstance = queryRuntimeAPI.getLastAttachment(instanceUUID, source, activityUUID);
                    byte[] attachmentValue = queryRuntimeAPI.getAttachmentValue(attachmentInstance);
                    InitialAttachmentImpl initialAttachment = new InitialAttachmentImpl(destination, attachmentValue);
                    initialAttachment.setDescription(attachmentInstance.getDescription());
                    initialAttachment.setFileName(attachmentInstance.getFileName());
                    initialAttachment.setLabel(attachmentInstance.getLabel());
                    initialAttachment.setMetaData(attachmentInstance.getMetaData());
                    attachments.add(initialAttachment);
                }
            }
            ProcessInstanceUUID rootInstanceUUID = instance.getRootInstanceUUID();
            ProcessDefinitionUUID subProcessUUID = subProcess.getUUID();
            Execution subflowRootExecution = ProcessUtil.createProcessInstance(subProcessUUID, parameterValues, attachments, instanceUUID, rootInstanceUUID);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Started subprocess instance : " + instance);
            }
            execution.getActivityInstance().setSubflowProcessInstanceUUID(subflowRootExecution.getInstance().getProcessInstanceUUID());
            subflowRootExecution.getInstance().begin();
        }
        catch (ProcessNotFoundException e) {
            throw new BonitaRuntimeException(e);
        }
        catch (ActivityNotFoundException e2) {
            throw new BonitaRuntimeException(e2);
        }
        catch (InstanceNotFoundException e3) {
            throw new BonitaRuntimeException(e3);
        }
        return false;
    }

    @Override
    public void signal(Execution execution, String signal, Map<String, Object> signalParameters) {
        if (SUBFLOW_SIGNAL.equals(signal)) {
            InternalActivityDefinition activityDefinition = execution.getNode();
            Set<SubflowParameterDefinition> outParameters = activityDefinition.getSubflowOutParameters();
            if (outParameters != null) {
                Recorder recorder = EnvTool.getRecorder();
                ProcessInstanceUUID childInstanceUUID = (ProcessInstanceUUID)signalParameters.get("childInstanceUUID");
                StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
                QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI("journalQueryList");
                Map<String, Object> childInstanceVariables = null;
                try {
                    childInstanceVariables = queryRuntimeAPI.getProcessInstanceVariables(childInstanceUUID);
                }
                catch (InstanceNotFoundException e) {
                    throw new BonitaRuntimeException(e);
                }
                ActivityInstanceUUID activityUUID = execution.getActivityInstanceUUID();
                ProcessInstanceUUID instanceUUID = activityUUID.getProcessInstanceUUID();
                HashSet<String> activityVariableNames = new HashSet<String>();
                if (activityDefinition.getDataFields() != null) {
                    for (DataFieldDefinition df : activityDefinition.getDataFields()) {
                        activityVariableNames.add(df.getName());
                    }
                }
                Set<String> childInstanceAttachmentNames = queryRuntimeAPI.getAttachmentNames(childInstanceUUID);
                for (SubflowParameterDefinition parameter : outParameters) {
                    String source = parameter.getSource();
                    String destination = parameter.getDestination();
                    Object variableValue = childInstanceVariables.get(source);
                    if (activityVariableNames.contains(destination)) {
                        recorder.recordActivityVariableUpdated(destination, variableValue, activityUUID, EnvTool.getUserId());
                        continue;
                    }
                    if (childInstanceAttachmentNames.contains(source)) {
                        AttachmentInstance childAttachment = queryRuntimeAPI.getLastAttachment(childInstanceUUID, source);
                        byte[] childAttachmentValue = queryRuntimeAPI.getAttachmentValue(childAttachment);
                        accessor.getRuntimeAPI().addAttachment(instanceUUID, destination, childAttachment.getLabel(), childAttachment.getDescription(), childAttachment.getFileName(), childAttachment.getMetaData(), childAttachmentValue);
                        continue;
                    }
                    recorder.recordInstanceVariableUpdated(destination, variableValue, instanceUUID, EnvTool.getUserId());
                }
            }
            ConnectorExecutor.executeConnectors(activityDefinition, execution, HookDefinition.Event.automaticOnExit);
            super.signal(execution, "bodyFinished", null);
        } else {
            super.signal(execution, signal, signalParameters);
        }
    }
}

