/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.ProcessUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timer
extends AbstractActivity {
    private static final long serialVersionUID = 477565487347215726L;
    protected static final Logger LOG = Logger.getLogger(Timer.class.getName());
    public static final String TIMER_SIGNAL = "end_of_timer";

    protected Timer() {
    }

    public Timer(String activityName) {
        super(activityName);
    }

    @Override
    protected boolean bodyStartAutomatically() {
        return false;
    }

    @Override
    protected boolean executeBusinessLogic(Execution execution) {
        long enableTime;
        String condition = execution.getNode().getTimerCondition();
        ActivityInstanceUUID activityUUID = execution.getActivityInstanceUUID();
        EventService eventService = EnvTool.getEventService();
        InternalActivityDefinition node = execution.getNode();
        try {
            enableTime = ProcessUtil.getTimerDate(condition, activityUUID, execution).getTime();
        }
        catch (GroovyException e) {
            throw new BonitaRuntimeException(e);
        }
        String executionEventUUID = "timer-" + UUID.randomUUID().toString();
        String eventName = "**bonita_timer**-" + activityUUID;
        String processName = node.getProcessDefinitionUUID().getProcessName();
        String activityName = node.getName();
        ProcessInstanceUUID instanceUUID = execution.getInstance().getProcessInstanceUUID();
        IncomingEventInstance incoming = new IncomingEventInstance(eventName, null, instanceUUID, node.getUUID(), activityUUID, processName, activityName, executionEventUUID, TIMER_SIGNAL, enableTime, true);
        OutgoingEventInstance outgoing = new OutgoingEventInstance(eventName, processName, activityName, null, instanceUUID, activityUUID, -1L);
        execution.setEventUUID(executionEventUUID);
        eventService.subscribe(incoming);
        eventService.fire(outgoing);
        execution.lock("Timer event " + executionEventUUID);
        return false;
    }

    @Override
    public void signal(Execution execution, String signal, Map<String, Object> signalParameters) {
        if (TIMER_SIGNAL.equals(signal)) {
            Authentication.setUserId("SYSTEM");
            ConnectorExecutor.executeConnectors(execution.getNode(), execution, HookDefinition.Event.onTimer);
            super.signal(execution, "bodyFinished", null);
        } else {
            super.signal(execution, signal, signalParameters);
        }
    }
}

