/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.deployment;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.deployment.DeploymentRuntimeException;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.element.IncomingEventDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessDefinitionImpl;
import org.ow2.bonita.facade.exception.DeploymentException;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.runtime.ClassDataLoader;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.ArchiveTool;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public final class Deployer {
    private static final Logger LOG = Logger.getLogger(Deployer.class.getName());
    public static final String START_INSTANCE_SIGNAL = "start_event";

    private Deployer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessDefinition deploy(BusinessArchive businessArchive) throws DeploymentException {
        Recorder recorder = EnvTool.getRecorder();
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        ProcessDefinitionUUID processUUID = businessArchive.getProcessUUID();
        if (processUUID == null) {
            throw new DeploymentException("The given businessArchive does not contain any process.");
        }
        for (Map.Entry<String, byte[]> resource : businessArchive.getResources().entrySet()) {
            ldr.storeData(Misc.getBusinessArchiveCategories(processUUID), resource.getKey(), (Serializable)resource.getValue(), true);
        }
        boolean removeDeps = true;
        try {
            ProcessDefinition process = null;
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader processClassloader = ClassDataLoader.getProcessClassLoader(processUUID);
                Thread.currentThread().setContextClassLoader(processClassloader);
                process = businessArchive.getProcessDefinition();
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
            if (process == null) {
                throw new DeploymentRuntimeException("The given bar archive does not contain any process file");
            }
            String lastProcessVersion = EnvTool.getAllQueriers().getLastProcessVersion(process.getName());
            if (lastProcessVersion != null && lastProcessVersion.compareTo(process.getVersion()) >= 0) {
                if (lastProcessVersion.equals(process.getVersion())) {
                    removeDeps = false;
                }
                String message = ExceptionManager.getInstance().getFullMessage("bd_D_3", process.getName(), lastProcessVersion, process.getVersion(), lastProcessVersion);
                throw new DeploymentRuntimeException(message);
            }
            if (process.getClassDependencies() != null) {
                for (String className : process.getClassDependencies()) {
                    try {
                        ClassDataLoader.getClass(process.getUUID(), className);
                    }
                    catch (ClassNotFoundException e) {
                        String message = ExceptionManager.getInstance().getFullMessage("bd_D_7", process.getName(), className);
                        throw new DeploymentRuntimeException(message);
                    }
                }
            }
            for (AttachmentDefinition attachment : process.getAttachments().values()) {
                if (attachment.getFilePath() == null) continue;
                ldr.storeData(Misc.getAttachmentCategories(processUUID), attachment.getFilePath(), (Serializable)businessArchive.getResource(attachment.getFilePath()), true);
            }
            InternalProcessDefinition internalProcess = null;
            try {
                Thread.currentThread().setContextClassLoader(ClassDataLoader.getProcessClassLoader(processUUID));
                internalProcess = InternalProcessDefinition.buildFromClientProcess(process);
                recorder.recordProcessDeployed(internalProcess, EnvTool.getUserId());
                Deployer.addStartEvents(internalProcess);
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
            return new ProcessDefinitionImpl(internalProcess);
        }
        catch (RuntimeException re) {
            if (processUUID != null) {
                ClassDataLoader.removeProcessClassLoader(processUUID);
                if (removeDeps) {
                    ldr.deleteData(Misc.getBusinessArchiveCategories(processUUID));
                    ldr.deleteData(Misc.getAttachmentCategories(processUUID));
                }
            }
            throw re;
        }
    }

    public static boolean enableProcess(ProcessDefinitionUUID processUUID) {
        Misc.badStateIfNull(processUUID, "Impossible to enable a processUUID from a null uuid");
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessDefinition processDef = journal.getProcess(processUUID);
        if (processDef == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_8", processUUID);
            throw new DeploymentRuntimeException(message);
        }
        if (!processDef.getState().equals((Object)ProcessDefinition.ProcessState.DISABLED)) {
            throw new DeploymentRuntimeException("Impossible to enable a process which is state is not disable");
        }
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordProcessEnable(processDef);
        Deployer.addStartEvents(processDef);
        if (LOG.isLoggable(Level.INFO)) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("Process ").append(processDef.getName()).append(" enable (UUID: ").append(processDef.getUUID()).append(").");
            LOG.info(logMsg.toString());
        }
        return true;
    }

    public static boolean disableProcess(ProcessDefinitionUUID processUUID) {
        Misc.badStateIfNull(processUUID, "Impossible to disable a processUUID from a null uuid");
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessDefinition processDef = journal.getProcess(processUUID);
        if (processDef == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_8", processUUID);
            throw new DeploymentRuntimeException(message);
        }
        if (!processDef.getState().equals((Object)ProcessDefinition.ProcessState.ENABLED)) {
            throw new DeploymentRuntimeException("Impossible to disable a process which is state is not enable");
        }
        Set<InternalProcessInstance> instances = EnvTool.getJournalQueriers().getProcessInstances(processDef.getUUID(), InstanceState.STARTED);
        if (instances != null && !instances.isEmpty()) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_9", new Object[0]);
            throw new DeploymentRuntimeException(message);
        }
        Deployer.removeStartEvents(processDef);
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordProcessDisable(processDef);
        if (LOG.isLoggable(Level.INFO)) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("Process ").append(processDef.getName()).append(" disable (UUID: ").append(processDef.getUUID()).append(").");
            LOG.info(logMsg.toString());
        }
        return true;
    }

    public static boolean archiveProcess(ProcessDefinitionUUID processUUID, String userId) {
        Misc.badStateIfNull(processUUID, "Impossible to archive a processUUID from a null uuid");
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessDefinition processDef = journal.getProcess(processUUID);
        if (processDef == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_8", processUUID);
            throw new DeploymentRuntimeException(message);
        }
        if (!processDef.getState().equals((Object)ProcessDefinition.ProcessState.DISABLED)) {
            throw new DeploymentRuntimeException("Impossible to archive a process which its state is not disable");
        }
        Deployer.removeStartEvents(processDef);
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordProcessArchive(processDef, userId);
        ArchiveTool.atomicArchive(processDef);
        if (LOG.isLoggable(Level.INFO)) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("Process ").append(processDef.getName()).append(" archive (UUID: ").append(processDef.getUUID()).append(").");
            LOG.info(logMsg.toString());
        }
        ClassDataLoader.removeProcessClassLoader(processDef.getUUID());
        EnvTool.getUUIDService().disableProcess(processUUID);
        return true;
    }

    private static void addStartEvents(ProcessDefinition processDef) {
        for (ActivityDefinition activity : processDef.getActivities()) {
            IncomingEventDefinition event;
            if (!activity.getType().equals((Object)ActivityDefinition.Type.ReceiveEvent) || !activity.getIncomingTransitions().isEmpty() || (event = activity.getIncomingEvent()) == null) continue;
            EventService eventService = EnvTool.getEventService();
            IncomingEventInstance incomingEventInstance = new IncomingEventInstance(event.getName(), event.getExpression(), null, activity.getUUID(), null, processDef.getName(), activity.getName(), null, START_INSTANCE_SIGNAL, System.currentTimeMillis(), false);
            incomingEventInstance.setPermanent(true);
            eventService.subscribe(incomingEventInstance);
        }
    }

    public static void removeStartEvents(ProcessDefinition processDef) {
        for (ActivityDefinition activity : processDef.getActivities()) {
            IncomingEventDefinition event;
            if (!activity.getOutgoingTransitions().isEmpty() || (event = activity.getIncomingEvent()) == null) continue;
            EventService eventService = EnvTool.getEventService();
            eventService.removeSubscriptions(activity.getUUID());
        }
    }
}

