/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.env.Context;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.BonitaApplicationAccessContext;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicEnvironment
extends Environment {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(BasicEnvironment.class.getName());
    protected String userId;
    protected Map<String, Context> contexts = new HashMap<String, Context>();
    protected ArrayList<String> defaultSearchOrderList = new ArrayList();
    protected String[] defaultSearchOrder = null;
    protected Throwable exception;
    protected boolean restrictedAccess;
    protected transient ClassLoader classLoader;

    public BasicEnvironment() {
        BasicEnvironment.pushEnvironment(this);
    }

    @Override
    public Context getContext(String contextName) {
        return this.contexts.get(contextName);
    }

    @Override
    public void addContext(Context context) {
        String key = context.getName();
        this.contexts.put(key, context);
        this.defaultSearchOrderList.add(key);
        this.defaultSearchOrder = null;
    }

    @Override
    public void removeContext(Context context) {
        String contextName = context.getName();
        Context removedContext = this.contexts.remove(contextName);
        if (removedContext != null) {
            this.defaultSearchOrderList.remove(contextName);
            this.defaultSearchOrder = null;
        }
    }

    public Context getEnvironmentFactoryContext() {
        return this.getContext("environment-factory");
    }

    public Context getEnvironmentContext() {
        return this.getContext("environment");
    }

    @Override
    public String getUserId() {
        if (this.userId != null) {
            return this.userId;
        }
        Authentication authentication = this.get(Authentication.class);
        if (authentication != null) {
            return authentication.getUserId();
        }
        return null;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Object get(String name) {
        return this.get(name, null);
    }

    @Override
    public Object get(String name, String[] searchOrder) {
        if (searchOrder == null) {
            searchOrder = this.getDefaultSearchOrder();
        }
        for (int i = 0; i < searchOrder.length; ++i) {
            Context context = this.contexts.get(searchOrder[i]);
            if (!context.has(name)) continue;
            return context.get(name);
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.get(type, null);
    }

    @Override
    public <T> T get(Class<T> type, String[] searchOrder) {
        if (searchOrder == null) {
            searchOrder = this.getDefaultSearchOrder();
        }
        for (int i = 0; i < searchOrder.length; ++i) {
            Context context = this.contexts.get(searchOrder[i]);
            T o = context.get(type);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public void close() {
        Environment popped;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("closing " + this);
        }
        if (this != (popped = Environment.popEnvironment())) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_BE_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
    }

    protected String[] getDefaultSearchOrder() {
        if (this.defaultSearchOrder == null) {
            int size = this.defaultSearchOrderList.size();
            this.defaultSearchOrder = new String[size];
            for (int i = 0; i < size; ++i) {
                this.defaultSearchOrder[i] = this.defaultSearchOrderList.get(size - 1 - i);
            }
        }
        return this.defaultSearchOrder;
    }

    @Override
    public String getApplicationAccessName() {
        BonitaApplicationAccessContext access = this.get(BonitaApplicationAccessContext.class);
        return access.getApplicationName();
    }

    @Override
    public boolean isRestrictedApplicationAcces() {
        BonitaApplicationAccessContext access = this.get(BonitaApplicationAccessContext.class);
        return access != null;
    }
}

